/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.common;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.workflow.http.common.BpmOpenProperties;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(GetTokenUtil.class);
    private static final String CLIENT_TOKEN_API = "/oauth2/client_token";
    private static final String T_CODE = "tcode";
    private static final ConcurrentHashMap<String, HashMap<String, Object>> TOKEN_CACHE = new ConcurrentHashMap(16);

    public static void removeTokenCache() {
        TOKEN_CACHE.remove(BpmOpenProperties.getScope());
    }

    private static HashMap<String, Object> buildTokenRequestParams(String scope) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("grant_type", "client_credentials");
        params.put("scope", scope);
        return params;
    }

    public static String getServer() {
        return BpmOpenProperties.getServer();
    }

    public static String getTCode() {
        return BpmOpenProperties.gettCode();
    }

    public static String getToken() {
        String server = BpmOpenProperties.getServer();
        String scope = BpmOpenProperties.getScope();
        String clientId = BpmOpenProperties.getClientId();
        String clientSecret = BpmOpenProperties.getClientSecret();
        String tcode = BpmOpenProperties.gettCode();
        String token = GetTokenUtil.getIfValidCache(scope);
        return token != null ? token : GetTokenUtil.requestToken(server, scope, clientId, clientSecret, tcode);
    }

    public static String getClientId() {
        return BpmOpenProperties.getClientId();
    }

    private static String getIfValidCache(String cacheKey) {
        String token = null;
        HashMap<String, Object> cacheToken = TOKEN_CACHE.get(cacheKey);
        if (cacheToken != null) {
            String validTime = (String)cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            if (validTime != null && timeInMillis < Long.parseLong(validTime) - 60L) {
                token = (String)cacheToken.get("client-token");
            }
        }
        return token;
    }

    private static synchronized String requestToken(String server, String scope, String clientId, String clientSecret, String tcode) {
        String token = GetTokenUtil.getIfValidCache(scope);
        if (token != null) {
            return token;
        }
        logger.info("requestToken\u65b9\u6cd5\u4e2d\u4e8c\u6b21\u5224\u65ad token\u4e3a\u7a7a\uff0c\u9700\u8981\u91cd\u65b0\u83b7\u53d6");
        HashMap<String, String> headerMap = new HashMap<String, String>(4);
        headerMap.put("client-id", clientId);
        headerMap.put("client-secret", clientSecret);
        headerMap.put(T_CODE, tcode);
        HashMap<String, Object> params = GetTokenUtil.buildTokenRequestParams(scope);
        StringBuilder param = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (param.toString().isEmpty()) {
                    param.append(entry.getKey()).append("=").append(entry.getValue());
                    continue;
                }
                param.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        server = server + CLIENT_TOKEN_API;
        server = param.toString().isEmpty() ? server : server + "?" + param;
        String result = HttpClientUtil.httpPost(server, headerMap);
        if (result == null || result == "") {
            throw new RuntimeException("\u83b7\u53d6token\u5f02\u5e38: \u54cd\u5e94\u4e3a\u7a7a url: " + server);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String data = jsonObject.getString("data");
        HashMap cacheToken = (HashMap)JSONObject.parseObject((String)data, HashMap.class);
        token = (String)cacheToken.get("client-token");
        if (token == null || token == "") {
            throw new RuntimeException("\u83b7\u53d6token\u5f02\u5e38: " + jsonObject.getString("msg"));
        }
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(cacheToken.get("expires-in").toString()));
        cacheToken.put("validTime", timeInMillis);
        TOKEN_CACHE.put(scope, cacheToken);
        return token;
    }
}

