/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.common;

import com.jxdinfo.hussar.workflow.http.common.GetTenantTokenUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(GetTokenUtil.class);
    private static final String CLIENT_TOKEN_API = "/oauth2/client_token";
    private static final Properties PROPERTIES = new Properties();
    private static final String T_CODE = "tcode";
    private static final String SERVER = "server";

    public static void removeTokenCache() {
        GetTenantTokenUtil.removeTokenCache(GetTokenUtil.getTCode());
    }

    public static String getServer() {
        return PROPERTIES.getProperty(SERVER);
    }

    public static String getTCode() {
        return PROPERTIES.getProperty(T_CODE);
    }

    public static String getToken() {
        String server = PROPERTIES.getProperty(SERVER);
        String scope = PROPERTIES.getProperty("scope");
        String clientId = PROPERTIES.getProperty("clientId");
        String clientSecret = PROPERTIES.getProperty("clientSecret");
        String tcode = PROPERTIES.getProperty(T_CODE);
        String token = GetTenantTokenUtil.getCacheToken(tcode);
        if (token == null) {
            try {
                token = GetTenantTokenUtil.requestToken(server, scope, clientId, clientSecret, tcode);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return token;
    }

    static {
        InputStream is = GetTokenUtil.class.getResourceAsStream("/bpm_open.setting");
        try {
            PROPERTIES.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

