/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.http.common;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.workflow.http.common.GetTokenUtil;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import com.jxdinfo.hussar.workflow.http.service.GetTenantTokenService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTenantTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(GetTenantTokenUtil.class);
    private static final String CLIENT_TOKEN_API = "/oauth2/client_token";
    private static final String T_CODE = "tcode";
    private static final String SERVER = "server";
    private static final String SCOPE = "scope";
    private static final GetTenantTokenService getTenantTokenService = (GetTenantTokenService)SpringContextUtil.getBean(GetTenantTokenService.class);
    private static final Properties PROPERTIES = new Properties();
    private static final ConcurrentHashMap<String, HashMap<String, Object>> TOKEN_CACHE;

    public static String getServer() {
        return PROPERTIES.getProperty(SERVER);
    }

    public static String getScope() {
        return PROPERTIES.getProperty(SCOPE);
    }

    public static String getTCode() {
        return PROPERTIES.getProperty(T_CODE);
    }

    public static String getClientId(String tenantCode) {
        HashMap<String, Object> cacheToken = TOKEN_CACHE.get(tenantCode);
        if (cacheToken == null) {
            GetTenantTokenUtil.removeTokenCache(tenantCode);
            throw new RuntimeException("\u83b7\u53d6ClientId\u5931\u8d25\uff01");
        }
        String clientId = (String)cacheToken.get("client-id");
        if (HussarUtils.isEmpty((Object)clientId)) {
            GetTenantTokenUtil.removeTokenCache(tenantCode);
            throw new RuntimeException("\u83b7\u53d6ClientId\u5931\u8d25\uff01");
        }
        return clientId;
    }

    public static String getToken(String tenantCode) {
        String token = GetTenantTokenUtil.getCache(tenantCode);
        if (HussarUtils.isEmpty((Object)token)) {
            token = getTenantTokenService.getToken(tenantCode);
        }
        return token;
    }

    public static String getCacheToken(String tenantCode) {
        return GetTenantTokenUtil.getCache(tenantCode);
    }

    private static HashMap<String, Object> buildTokenRequestParams(String scope) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("grant_type", "client_credentials");
        params.put(SCOPE, scope);
        return params;
    }

    public static void removeTokenCache(String tenantCode) {
        TOKEN_CACHE.remove(tenantCode);
    }

    static void saveCache(String tenantCode, HashMap<String, Object> token) {
        TOKEN_CACHE.put(tenantCode, token);
    }

    private static String getCache(String tenantCode) {
        String token = null;
        HashMap<String, Object> cacheToken = TOKEN_CACHE.get(tenantCode);
        if (cacheToken != null) {
            String validTime = (String)cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            if (validTime != null && timeInMillis < Long.parseLong(validTime) - 60L) {
                token = (String)cacheToken.get("client-token");
            }
        }
        return token;
    }

    public static synchronized String requestToken(String server, String scope, String clientId, String clientSecret, String tcode) {
        logger.info("\u83b7\u53d6token");
        HashMap<String, String> headerMap = new HashMap<String, String>(4);
        headerMap.put("client-id", clientId);
        headerMap.put("client-secret", clientSecret);
        headerMap.put(T_CODE, tcode);
        HashMap<String, Object> params = GetTenantTokenUtil.buildTokenRequestParams(scope);
        StringBuilder param = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (param.toString().isEmpty()) {
                    param.append(entry.getKey()).append("=").append(entry.getValue());
                    continue;
                }
                param.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        server = server + CLIENT_TOKEN_API;
        server = param.toString().isEmpty() ? server : server + "?" + param;
        String result = HttpClientUtil.httpPost(server, headerMap);
        if (result == null || "".equals(result)) {
            logger.error("\u83b7\u53d6token\u5f02\u5e38: \u54cd\u5e94\u4e3a\u7a7a url: " + server);
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String data = jsonObject.getString("data");
        HashMap cacheToken = (HashMap)JSONObject.parseObject((String)data, HashMap.class);
        String token = (String)cacheToken.get("client-token");
        if (token == null || "".equals(token)) {
            logger.error("\u83b7\u53d6token\u5f02\u5e38: " + jsonObject.getString("msg"));
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(cacheToken.get("expires-in").toString()));
        cacheToken.put("validTime", timeInMillis);
        GetTenantTokenUtil.saveCache(tcode, cacheToken);
        return token;
    }

    static {
        InputStream is = GetTokenUtil.class.getResourceAsStream("/bpm_open.setting");
        try {
            PROPERTIES.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TOKEN_CACHE = new ConcurrentHashMap(16);
    }
}

