/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.http.service;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskEntrustDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.TaskRevokeDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.processtest.api.ProcessTestingApiService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessTestingParamDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ReceiveTaskReleaseDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.TestStartProcessInsDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.TestTaskCompleteDto;
import com.jxdinfo.hussar.workflow.http.common.HttpClientUtil;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class RestProcessTestingWorkflowTestApiService
implements ProcessTestingApiService {
    public ApiResponse<?> testProcess(ProcessTestingParamDto processTestingParam) {
        return HttpClientUtil.httpPostApiHandler((String)"/bpm/processTesting/testProcess", (Object)processTestingParam);
    }

    public ApiResponse<?> getTodoList(String businessId, String procInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("procInsId", procInsId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/processTesting/getTodoList", map);
    }

    public ApiResponse<?> getDoneList(String businessId, String procInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("businessId", businessId);
        map.put("procInsId", procInsId);
        return HttpClientUtil.httpGetApiHandler((String)"/bpm/processTesting/getDoneList", map);
    }

    public BpmResponseResult completeTask(TestTaskCompleteDto testTaskCompleteDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/processTesting/completeTask", (Object)testTaskCompleteDto);
    }

    public BpmResponseResult startProcessInstance(TestStartProcessInsDto testStartProcessInsDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/processTesting/startProcessInstance", (Object)testStartProcessInsDto);
    }

    public BpmResponseResult rejectToFirstTask(TaskRejectDto taskRejectDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/processTesting/rejectToFirstTask", (Object)taskRejectDto);
    }

    public BpmResponseResult rejectToLastTask(TaskRejectDto taskRejectDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/processTesting/rejectToLastTask", (Object)taskRejectDto);
    }

    public BpmResponseResult rejectToAnyTask(TaskRejectDto taskRejectDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/processTesting/rejectToAnyTask", (Object)taskRejectDto);
    }

    public BpmResponseResult revokeTask(TaskRevokeDto taskRevokeDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/processTesting/revokeTask", (Object)taskRevokeDto);
    }

    public BpmResponseResult entrustTask(TaskEntrustDto taskEntrustDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/processTesting/entrustTask", (Object)taskEntrustDto);
    }

    public BpmResponseResult checkProcessPublished(String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/processTesting/checkProcessPublished", map);
    }

    public BpmResponseResult checkProcessPublished(String processKey, String organId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processKey", processKey);
        map.put("organId", organId);
        return HttpClientUtil.httpGetBpmHandler((String)"/bpm/processTesting/checkProcessPublished", map);
    }

    public BpmResponseResult receiveTaskSignal(ReceiveTaskReleaseDto receiveTaskReleaseDto) {
        return HttpClientUtil.httpPostBpmHandler((String)"/bpm/processTesting/receiveTaskSignal", (Object)receiveTaskReleaseDto);
    }

    private static final class Api {
        public static final String TEST_PROCESS = "/bpm/processTesting/testProcess";
        public static final String GET_TODO_LIST = "/bpm/processTesting/getTodoList";
        public static final String GET_DONE_LIST = "/bpm/processTesting/getDoneList";
        public static final String COMPLETE_TASK = "/bpm/processTesting/completeTask";
        public static final String START_PROCESS_INSTANCE = "/bpm/processTesting/startProcessInstance";
        public static final String CHECK_PROCESS_PUBLISHED = "/bpm/processTesting/checkProcessPublished";
        public static final String REJECT_TO_FIRST_TASK = "/bpm/processTesting/rejectToFirstTask";
        public static final String REJECT_TO_LAST_TASK = "/bpm/processTesting/rejectToLastTask";
        public static final String REJECT_TO_ANY_TASK = "/bpm/processTesting/rejectToAnyTask";
        public static final String REVOKE_TASK = "/bpm/processTesting/revokeTask";
        public static final String ENTRUST_TASK = "/bpm/processTesting/entrustTask";
        public static final String RECEIVE_TASK_SIGNAL = "/bpm/processTesting/receiveTaskSignal";

        private Api() {
        }
    }
}

