/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.feign.assignee;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserAccountModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remoteAssignee"})
public class RemoteAssigneeController {
    @Autowired
    private IWorkflowAssigneeChooseService workflowAssigneeChooseService;

    @GetMapping(value={"/user"})
    public List<BpmTreeModel> userTree(@RequestParam(value="id", defaultValue="11") String id, @RequestParam(value="isMainPost") boolean isMainPost) {
        return this.workflowAssigneeChooseService.userTree(id, isMainPost, true);
    }

    @GetMapping(value={"/dept"})
    public List<BpmTreeModel> deptTree(@RequestParam String id) {
        return this.workflowAssigneeChooseService.deptTree(id, null, true);
    }

    @GetMapping(value={"/role"})
    public List<BpmTreeModel> roleTree() {
        return this.workflowAssigneeChooseService.roleTree();
    }

    @GetMapping(value={"/roleTree"})
    public List<BpmTreeModel> roleTree(@RequestParam(value="id") String id) {
        return this.workflowAssigneeChooseService.roleTree(id, null, true);
    }

    @GetMapping(value={"/userDetail"})
    public List<BpmTreeModel> userDetail(@RequestParam(value="userIds") String userIds) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.workflowAssigneeChooseService.userDetail(Arrays.asList(userIds.split(",")), true);
    }

    @GetMapping(value={"/userDeptDetail"})
    public List<BpmTreeModel> userDeptDetail(@RequestParam(value="userId") String userId) {
        if (StringUtils.isEmpty((Object)userId)) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.workflowAssigneeChooseService.userDeptDetail(userId, true);
    }

    @GetMapping(value={"/getCandidateUser"})
    public List<String> getCandidateUser(@RequestParam(value="condition") String condition, @RequestParam(value="securityLevel", required=false) Integer securityLevel, @RequestParam(value="isConditionFullSql") boolean isConditionFullSql) {
        return this.workflowAssigneeChooseService.getCandidateUser(condition, securityLevel);
    }

    @GetMapping(value={"/getCandidateUserWithParent"})
    public List<BpmTreeModel> getCandidateUserWithParent(@RequestParam(value="condition") String condition, @RequestParam(value="securityLevel", required=false) Integer securityLevel, @RequestParam(value="isConditionFullSql") boolean isConditionFullSql) {
        return this.workflowAssigneeChooseService.getCandidateUserWithParent(condition, securityLevel);
    }

    @GetMapping(value={"/getRealCondition"})
    public String getRealCondition(@RequestParam(value="condition") String condition) {
        return this.workflowAssigneeChooseService.getRealCondition(condition);
    }

    @GetMapping(value={"/getSecurityLevel"})
    public String getSecurityLevel(@RequestParam(value="userId") String userId) {
        return String.valueOf(this.workflowAssigneeChooseService.getSecurityLevel(userId, true));
    }

    @PostMapping(value={"/queryDeptTreeByDeptName"})
    public List<BpmTreeModel> queryDeptTreeByDeptName(@RequestParam(value="organName") String organName) {
        return this.workflowAssigneeChooseService.queryDeptTreeByDeptName(organName, true);
    }

    @PostMapping(value={"/queryUserTreeByUserName"})
    public List<BpmTreeModel> queryUserTreeByUserName(@RequestParam(value="organName") String organName) {
        return this.workflowAssigneeChooseService.queryUserTreeByUserName(organName);
    }

    @PostMapping(value={"/queryUserListByUserName"})
    public List<BpmTreeModel> queryUserListByUserName(@RequestParam(value="organName") String organName) {
        return this.workflowAssigneeChooseService.queryUserListByUserName(organName);
    }

    @PostMapping(value={"/queryUserTree"})
    public List<BpmTreeModel> queryUserTree(@RequestParam(value="organName") String organName) {
        return this.workflowAssigneeChooseService.queryUserTree(organName);
    }

    @PostMapping(value={"/queryRoleTreeByRoleName"})
    public List<BpmTreeModel> queryRoleTreeByRoleName(@RequestParam(value="roleName") String roleName) {
        return this.workflowAssigneeChooseService.queryRoleTreeByRoleName(roleName, true);
    }

    @PostMapping(value={"/queryUserListByPage"})
    public Page<BpmTreeModel> queryUserListByPage(@RequestBody Page<BpmTreeModel> pages, @RequestParam(value="organId") String organId, @RequestParam(value="type") String type) {
        return this.workflowAssigneeChooseService.queryUserListByPage(pages, organId, type, true);
    }

    @PostMapping(value={"/queryAssigneeAndDept"})
    public List<BpmTreeModel> queryAssigneeAndDept(@RequestBody List<String> users, @RequestParam(value="organName", required=false) String organName) {
        return this.workflowAssigneeChooseService.queryAssigneeAndDept(users, organName, true);
    }

    @PostMapping(value={"/queryNodeAssigneeListByPage"})
    Page<BpmTreeModel> queryNodeAssigneeListByPage(@RequestBody Page<BpmTreeModel> pages, @RequestParam(value="users") String users, @RequestParam(value="type") String type, @RequestParam(value="organId") String organId) {
        return this.workflowAssigneeChooseService.queryNodeAssigneeListByPage(pages, Arrays.asList(users.split(",")), organId, type, true);
    }

    @PostMapping(value={"/queryNodeAssigneeListWithParentByPage"})
    Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(@RequestBody Page<BpmTreeModel> pages, @RequestParam(value="users") String users, @RequestParam(value="type") String type, @RequestParam(value="organId") String organId) {
        return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, JSONArray.parseArray((String)users, BpmTreeModel.class), organId, type, true);
    }

    @PostMapping(value={"/getSameLevelDeptIdByUserId"})
    public String getSameLevelDeptIdByUserId(@RequestParam(value="userId") String userId) {
        return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserId(userId, true);
    }

    @PostMapping(value={"/getParentDeptIdByUserId"})
    public String getParentDeptIdByUserId(@RequestParam(value="userId") String userId) {
        return this.workflowAssigneeChooseService.getParentDeptIdByUserId(userId, true);
    }

    @PostMapping(value={"/getDeptIdByUserIds"})
    public String getDeptIdByUserIds(@RequestParam(value="userId") String userId) {
        return this.workflowAssigneeChooseService.getDeptIdByUserIds(userId, true);
    }

    @PostMapping(value={"/getSameLevelDeptIdByUserIds"})
    public String getSameLevelDeptIdByUserIds(@RequestParam(value="userId") String userId) {
        return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserIds(userId, true);
    }

    @PostMapping(value={"/getParentDeptIdByUserIds"})
    public String getParentDeptIdByUserIds(@RequestParam(value="userId") String userId) {
        return this.workflowAssigneeChooseService.getParentDeptIdByUserIds(userId, true);
    }

    @PostMapping(value={"/list"})
    public Page<BpmUserInfoVo> queryList(@RequestParam(value="size") Long size, @RequestParam(value="current") Long current, @RequestBody GetListInfoVo getListInfoVo) {
        Page page = new Page();
        page.setCurrent(current.longValue());
        page.setSize(size.longValue());
        return this.workflowAssigneeChooseService.queryList(page, getListInfoVo, true);
    }

    @PostMapping(value={"/queryDept"})
    public List<AssigneeManageInfoVo> queryDept(@RequestParam(value="name") String name) {
        return this.workflowAssigneeChooseService.queryDept(name);
    }

    @PostMapping(value={"/queryRole"})
    public List<AssigneeManageInfoVo> queryRole(@RequestParam(value="name") String name) {
        return this.workflowAssigneeChooseService.queryRole(name);
    }

    @RequestMapping(value={"/getUserAccount"})
    public List<BpmUserAccountModel> getUserAccount(String userIds) {
        return this.workflowAssigneeChooseService.getUserAccount(Arrays.asList(userIds.split(",")));
    }
}

