/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.godaxe.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.application.application.dto.AppGroupInfoTreeDto;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExtService;
import com.jxdinfo.hussar.formdesign.application.canvas.service.ICanvasExternalService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.BaseFileOutService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileTreeOutService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.theme.config.model.vo.ThemeVO;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomForm;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.form.GodAxeFormService;
import com.jxdinfo.hussar.workflow.godaxe.service.GodAxeCustomCategoryApiService;
import com.jxdinfo.hussar.workflow.godaxe.service.GodAxeCustomFormApiService;
import com.jxdinfo.hussar.workflow.godaxe.service.SysActFormAuthApiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GodAxeFormServiceImpl
implements GodAxeFormService {
    @Autowired(required=false)
    private FileTreeOutService fileTreeService;
    @Autowired(required=false)
    private BaseFileOutService baseFileService;
    @Autowired(required=false)
    private ICanvasExternalService canvasExternalService;
    @Autowired(required=false)
    private ISysApplicationExtService sysApplicationExtService;
    @Autowired
    private SysActFormAuthApiService sysActFormAuthService;
    @Autowired
    private GodAxeCustomFormApiService customFormService;
    @Autowired
    private GodAxeCustomCategoryApiService customCategoryService;
    @Autowired(required=false)
    private IHussarThemeConfigService hussarThemeConfigService;
    private static final String ROOT_ID = "#";
    private static final String FULL_FORM_URL = "fullFormURL";

    public ApiResponse<List<JSONObject>> getLowForm() {
        if (this.fileTreeService == null) {
            return ApiResponse.success(new ArrayList());
        }
        List fileTreeList = this.fileTreeService.getFileTreeCrossApp(ROOT_ID);
        List fileTree = fileTreeList.stream().map(JSONObject::new).collect(Collectors.toList());
        ArrayList list = new ArrayList();
        list.addAll(fileTree);
        return ApiResponse.success(list);
    }

    public ApiResponse<JSONObject> getLowFormInfo(String appId, String formId) {
        if (this.baseFileService == null) {
            return ApiResponse.success((Object)new JSONObject());
        }
        JSONObject jsonObject = this.baseFileService.getCrossApp(appId, formId);
        jsonObject.put(FULL_FORM_URL, (Object)this.baseFileService.getFormAddress(formId));
        return ApiResponse.success((Object)jsonObject);
    }

    public ApiResponse<List<JSONObject>> getNoCodeForm() {
        if (this.sysApplicationExtService == null) {
            return ApiResponse.success(new ArrayList());
        }
        List result = (List)this.sysApplicationExtService.groupInfoTree().getData();
        List formList = result.stream().map(obj -> GodAxeFormServiceImpl.treeToJSON(obj)).collect(Collectors.toList());
        return ApiResponse.success(formList);
    }

    public ApiResponse<JSONArray> getNoCodeFormInfo(String formId) {
        if (this.canvasExternalService == null) {
            return ApiResponse.success((Object)new JSONArray());
        }
        ApiResponse formInfoResult = this.canvasExternalService.widgets(formId, true);
        List formInfoList = (List)formInfoResult.getData();
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll((Collection)formInfoList);
        return ApiResponse.success((Object)jsonArray);
    }

    public ApiResponse<List<JSONObject>> getThirdSystemForm() {
        BpmResponseResult allOtherSystem = this.sysActFormAuthService.getAllOtherSystem();
        List categoryList = this.customCategoryService.list();
        List allFormList = this.customFormService.list();
        JSONArray result = allOtherSystem.getResult();
        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
        if (HussarUtils.isNotEmpty((Object)result)) {
            JSONArray jsonArray = result.getJSONArray(0);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                JSONArray customFormTypeList = jsonObject.getJSONArray("customFormTypeList");
                for (Object customFormType : customFormTypeList) {
                    Long serviceId = Long.valueOf(((JSONObject)customFormType).get((Object)"serviceId").toString());
                    String formTypeName = String.valueOf(((JSONObject)customFormType).get((Object)"formTypeName"));
                    Stream<CustomForm> customFormStream = allFormList.stream().filter(customForm -> serviceId.equals(customForm.getSystemId()));
                    String systemType = jsonObject.getString("systemType");
                    customFormStream = "0".equals(systemType) ? ("web".equals(formTypeName) ? customFormStream.filter(customForm -> formTypeName.equals(customForm.getFormType()) || "Web".equals(customForm.getFormType())) : ("mobile".equals(formTypeName) ? customFormStream.filter(customForm -> formTypeName.equals(customForm.getFormType()) || "Uni".equals(customForm.getFormType())) : customFormStream.filter(customForm -> formTypeName.equals(customForm.getFormType())))) : customFormStream.filter(customForm -> formTypeName.equals(customForm.getFormType()));
                    List formList = customFormStream.collect(Collectors.toList());
                    ArrayList list = new ArrayList();
                    if (HussarUtils.isNotEmpty(formList)) {
                        list.addAll(categoryList);
                        list.addAll(formList);
                    }
                    ((JSONObject)customFormType).put("formInfo", list);
                }
                jsonObjectList.add(jsonObject);
            }
            return ApiResponse.success(jsonObjectList);
        }
        return null;
    }

    public ApiResponse<String> getThemeConfigRule() {
        if (this.hussarThemeConfigService == null) {
            return ApiResponse.success();
        }
        return this.hussarThemeConfigService.getThemeConfigRole();
    }

    public ApiResponse<JSONObject> getCurrentApplicationTheme() {
        if (this.hussarThemeConfigService == null) {
            return ApiResponse.success();
        }
        ThemeVO themeVO = (ThemeVO)this.hussarThemeConfigService.getCurrentApplicationTheme().getData();
        JSONObject themeObject = new JSONObject();
        themeObject.put("themeId", (Object)themeVO.getThemeId());
        themeObject.put("scheme", (Object)themeVO.getScheme());
        return ApiResponse.success((Object)themeObject);
    }

    public static JSONObject treeToJSON(AppGroupInfoTreeDto appGroupInfoTreeDto) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fieldId", (Object)appGroupInfoTreeDto.getFieldId());
        jsonObject.put("fieldName", (Object)appGroupInfoTreeDto.getFieldName());
        jsonObject.put("parentId", (Object)appGroupInfoTreeDto.getParentId());
        jsonObject.put("parentName", (Object)appGroupInfoTreeDto.getParentName());
        jsonObject.put("fieldType", (Object)appGroupInfoTreeDto.getFieldType());
        jsonObject.put("parentType", (Object)appGroupInfoTreeDto.getParentType());
        jsonObject.put("isLeaf", (Object)appGroupInfoTreeDto.isLeaf());
        JSONArray childList = new JSONArray();
        if (HussarUtils.isNotEmpty((Object)appGroupInfoTreeDto.getChildren())) {
            for (AppGroupInfoTreeDto treeDto : appGroupInfoTreeDto.getChildren()) {
                childList.add((Object)GodAxeFormServiceImpl.treeToJSON(treeDto));
            }
        }
        jsonObject.put("children", (Object)childList);
        return jsonObject;
    }
}

