/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.DownloadFilesDto;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.Bpm2XMLMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.dao.UpdateByteArrayModelMapper;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.model.UpdateByteArrayModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ModelServiceImpl
extends ServiceImpl<ModelMapper, ModelBuild>
implements ModelService {
    private static Logger logger = LoggerFactory.getLogger(ModelServiceImpl.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private ModelMapper modelMapper;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Resource
    private Bpm2XMLMapper bpm2XMLMapper;
    @Resource
    private UpdateByteArrayModelMapper updateByteArrayModelMapper;
    private static final String SUFFIX = ".bpmn20.xml";

    public String deployModel(Long modelId) {
        try {
            Model modelData = this.repositoryService.getModel(String.valueOf(modelId));
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                logger.error("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
                return null;
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + SUFFIX;
            Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(true);
            modelData.setDeploymentId(deployment.getId());
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelData.getKey(), Integer.valueOf(0));
            modelData.setCategory(workFlow.getCategory());
            this.repositoryService.saveModel(modelData);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).latestVersion().singleResult();
            this.saveModelExtendProperties(bpmnModel, processDefinition);
            workFlow.setProcDefId(processDefinition.getId());
            this.sysActProcessFileService.addFile(workFlow, null);
            this.processDefinitionsService.setNotMain(processDefinition.getKey());
            return processDefinition.getId();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String deployModel(String modelId) {
        return this.deployModel(Long.parseLong(modelId));
    }

    public ModelBuild queryModel(Long modelId) {
        return this.modelMapper.queryModel(modelId);
    }

    public ModelBuild queryModel(String modelId) {
        return this.modelMapper.queryModel(Long.parseLong(modelId));
    }

    public void addNodeSaveModelExtendProperties(BpmnModel bpmnModel, String defId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(defId);
        this.saveModelExtendProperties(bpmnModel, processDefinition);
    }

    public void deployModelByWorkFlowXml(WorkFlow workFlow, BpmnModel bpmnModel, String modelId, String processInsId, String version) {
        Model modelData = this.repositoryService.getModel(modelId);
        String processName = modelData.getName() + SUFFIX;
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(false);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        this.saveModelExtendProperties(bpmnModel, processDefinition);
        workFlow.setProcDefId(processDefinition.getId());
        this.sysActProcessFileService.addFile(workFlow, null);
        this.processDefinitionsService.setVersionTemporary(processDefinition.getId());
        this.processDefinitionsService.editTemporaryDefId(processDefinition.getId(), processInsId, version);
        this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinition.getId()));
    }

    private void saveModelExtendProperties(BpmnModel model, ProcessDefinition processDefinition) {
        ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
        String procDefId = processDefinition.getId();
        if (model != null) {
            Collection flowElements = model.getMainProcess().getFlowElements();
            for (FlowElement node : flowElements) {
                if (node instanceof UserTask) {
                    JSONObject jsonObject;
                    JSONObject jsonObject2;
                    JSONObject jsonObject3;
                    String ccFormDetailKey;
                    String assistFormDetailKey;
                    UserTask userTask = (UserTask)node;
                    String formDetailKey = this.getFormDetailKey(userTask);
                    if (HussarUtils.isAllEmpty((Object[])new Object[]{formDetailKey, assistFormDetailKey = this.getAssistFormDetailKey(userTask), ccFormDetailKey = this.getCcFormDetailKey(userTask)})) continue;
                    JSONObject formDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)formDetailKey) && (jsonObject3 = JSON.parseObject((String)formDetailKey)) != null) {
                        for (Object key : jsonObject3.keySet()) {
                            formDetailKeyObject.put((String)key, jsonObject3.getJSONObject((String)key).get((Object)"url"));
                        }
                    }
                    JSONObject assistFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)assistFormDetailKey) && (jsonObject2 = JSON.parseObject((String)assistFormDetailKey)) != null) {
                        Object key;
                        key = jsonObject2.keySet().iterator();
                        while (key.hasNext()) {
                            String key2 = (String)key.next();
                            assistFormDetailKeyObject.put(key2, jsonObject2.getJSONObject(key2).get((Object)"url"));
                        }
                    }
                    JSONObject ccFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)ccFormDetailKey) && (jsonObject = JSON.parseObject((String)ccFormDetailKey)) != null) {
                        for (Object key : jsonObject.keySet()) {
                            ccFormDetailKeyObject.put((String)key, jsonObject.getJSONObject((String)key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)formDetailKeyObject));
                    asep.setAssistFormDetailKey(JSON.toJSONString((Object)assistFormDetailKeyObject));
                    asep.setCcFormDetailKey(JSON.toJSONString((Object)ccFormDetailKeyObject));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    sysActExtendProperties.add(asep);
                    continue;
                }
                if (!(node instanceof SubProcess)) continue;
                SubProcess subProcess = (SubProcess)node;
                for (FlowElement element : subProcess.getFlowElements()) {
                    JSONObject jsonObject;
                    JSONObject jsonObject4;
                    JSONObject jsonObject5;
                    String ccFormDetailKey;
                    String assistFormDetailKey;
                    UserTask userTask;
                    String formDetailKey;
                    if (!(element instanceof UserTask) || HussarUtils.isAllEmpty((Object[])new Object[]{formDetailKey = this.getFormDetailKey(userTask = (UserTask)element), assistFormDetailKey = this.getAssistFormDetailKey(userTask), ccFormDetailKey = this.getCcFormDetailKey(userTask)})) continue;
                    JSONObject formDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)formDetailKey) && (jsonObject5 = JSON.parseObject((String)formDetailKey)) != null) {
                        Object key;
                        key = jsonObject5.keySet().iterator();
                        while (key.hasNext()) {
                            String key3 = (String)key.next();
                            formDetailKeyObject.put(key3, jsonObject5.getJSONObject(key3).get((Object)"url"));
                        }
                    }
                    JSONObject assistFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)assistFormDetailKey) && (jsonObject4 = JSON.parseObject((String)assistFormDetailKey)) != null) {
                        for (String key : jsonObject4.keySet()) {
                            assistFormDetailKeyObject.put(key, jsonObject4.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    JSONObject ccFormDetailKeyObject = new JSONObject();
                    if (HussarUtils.isNotEmpty((Object)ccFormDetailKey) && (jsonObject = JSON.parseObject((String)ccFormDetailKey)) != null) {
                        for (String key : jsonObject.keySet()) {
                            ccFormDetailKeyObject.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                        }
                    }
                    SysActExtendProperties asep = new SysActExtendProperties();
                    asep.setTaskDefKey(userTask.getId());
                    asep.setFormDetailKey(JSON.toJSONString((Object)formDetailKeyObject));
                    asep.setAssistFormDetailKey(JSON.toJSONString((Object)assistFormDetailKeyObject));
                    asep.setCcFormDetailKey(JSON.toJSONString((Object)ccFormDetailKeyObject));
                    asep.setTaskDefName(userTask.getName());
                    asep.setProcDefId(procDefId);
                    sysActExtendProperties.add(asep);
                }
            }
        }
        if (!sysActExtendProperties.isEmpty()) {
            ArrayList<SysActExtendProperties> addList = new ArrayList<SysActExtendProperties>();
            ArrayList<SysActExtendProperties> updateList = new ArrayList<SysActExtendProperties>();
            QueryChainWrapper queryWrapper = this.iSysActExtendPropertiesService.query();
            for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                String getProcDefId = sysActExtendProperty.getProcDefId();
                String taskDefKey = sysActExtendProperty.getTaskDefKey();
                queryWrapper = (QueryChainWrapper)queryWrapper.or();
                queryWrapper = (QueryChainWrapper)((QueryChainWrapper)queryWrapper.eq((Object)"PROC_DEF_ID", (Object)getProcDefId)).eq((Object)"TASK_DEF_KEY", (Object)taskDefKey);
            }
            List sameList = queryWrapper.list();
            for (SysActExtendProperties sysActExtendProperty : sysActExtendProperties) {
                boolean isadd = true;
                for (SysActExtendProperties actExtendProperties : sameList) {
                    if (!sysActExtendProperty.getProcDefId().equals(actExtendProperties.getProcDefId()) || !sysActExtendProperty.getTaskDefKey().equals(actExtendProperties.getTaskDefKey())) continue;
                    sysActExtendProperty.setId(actExtendProperties.getId());
                    updateList.add(sysActExtendProperty);
                    isadd = false;
                    break;
                }
                if (!isadd) continue;
                addList.add(sysActExtendProperty);
            }
            this.iSysActExtendPropertiesService.saveBatch(addList);
            this.iSysActExtendPropertiesService.updateBatchById(updateList);
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }

    private String getAssistFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("assistFlowFormDetailKey")).get(0)).getAttributes().get("assistFlowFormDetailKey")).get(0)).getValue();
    }

    private String getCcFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("ccFlowFormDetailKey")).get(0)).getAttributes().get("ccFlowFormDetailKey")).get(0)).getValue();
    }

    public IPage<ModelBuild> queryModelList(String modelName, Page<ModelBuild> page) {
        try {
            List<ModelBuild> list = this.modelMapper.queryModelList(page, modelName);
            page.setRecords(list);
            return page;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public ApiResponse<String> deleteModel(Long modelId) {
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(modelId, null))) {
            String processKey = this.modelMapper.getIdentityById(modelId);
            this.repositoryService.deleteModel(String.valueOf(modelId));
            this.sysActAssigneeService.delAssignee(processKey);
            this.modelMapper.deleteModelDef(modelId, null);
            this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getModelId, (Object)modelId));
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        throw new PublicClientException(BpmEnum.DELETE_RUNNING_FAIL.getMessage());
    }

    public ApiResponse<String> deleteModel(String modelId) {
        return this.deleteModel(Long.parseLong(modelId));
    }

    public ApiResponse<String> deleteModelWithVersion(String processDefId) {
        String procDefKey = processDefId.split(":")[0];
        this.processDefinitionsService.canModelDeleteWithVersion(procDefKey);
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefId))) {
            String oldMainProcDefId = this.processDefinitionsService.getStartProcessDefinitionId(procDefKey);
            this.modelMapper.deleteModelDef(null, processDefId);
            this.sysActProcessFileService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getProcessId, (Object)processDefId));
            if (processDefId.equals(oldMainProcDefId)) {
                this.processDefinitionsService.setNotMain(procDefKey);
                this.sysActProcessFileService.copyFiles(procDefKey, null);
            }
            return ApiResponse.success((String)BpmEnum.DELETE_SUCCESS.getMessage());
        }
        throw new PublicClientException(BpmEnum.DELETE_RUNNING_FAIL.getMessage());
    }

    public String getIdByIdentity(String identity) {
        return this.modelMapper.getIdByIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unZipFile(String zipFile, String filePath, HttpServletRequest request) {
        String clientChartSet = request.getCharacterEncoding();
        ArrayList<String> resultList = new ArrayList<String>();
        InputStream in = null;
        OutputStream out = null;
        try {
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            long time = System.currentTimeMillis();
            ZipFile zip = new ZipFile(zipFile, "UTF-8");
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                in = zip.getInputStream(entry);
                String outPath = (filePath + time + File.separator + new String(zipEntryName.getBytes(clientChartSet))).replaceAll("\\*", File.separator);
                File file = new File(outPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                resultList.add(outPath);
                out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    out.write(buf1, 0, len);
                }
                in.close();
                out.close();
            }
            zip.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return resultList;
    }

    private List<String> getAllFile(File file) {
        if (file == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!file.exists()) {
            return list;
        }
        for (File f : file.listFiles()) {
            String suffix;
            if (f.isDirectory()) {
                list.addAll(this.getAllFile(f));
                continue;
            }
            if (f.getPath().lastIndexOf(46) <= 0 || !"xml".equals(suffix = f.getPath().substring(f.getPath().lastIndexOf(46) + 1)) && !"lcdpbpm".equals(suffix)) continue;
            list.add(f.getPath());
        }
        return list;
    }

    public List<ModelBuild> getAllModel() {
        return this.modelMapper.getAllModel();
    }

    public ApiResponse<String> importModel(MultipartFile file, HttpServletRequest request) {
        InputStream in = null;
        FileOutputStream out = null;
        String fileName = System.currentTimeMillis() + ".zip";
        try {
            in = file.getInputStream();
            File files = new File(this.hussarConfig.getFileUploadPath() + File.separator + fileName);
            if (!files.getParentFile().exists()) {
                files.getParentFile().mkdirs();
            }
            try {
                boolean isCreateNewFile = files.createNewFile();
                if (!isCreateNewFile) {
                    logger.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
                    throw new PublicClientException(BpmEnum.UPLOAD_PATH_ERROR.getMessage());
                }
            }
            catch (IOException e) {
                throw new PublicClientException(BpmEnum.UPLOAD_PATH_ERROR.getMessage());
            }
            out = new FileOutputStream(files);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            in.close();
            List<String> fileList = this.unZipFile(this.hussarConfig.getFileUploadPath() + File.separator + fileName, this.hussarConfig.getFileUploadPath(), request);
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                files = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)files, (String)"UTF-8"), Map.class);
                if (!HussarUtils.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u538b\u7f29\u6587\u4ef6");
                    throw new PublicClientException(BpmEnum.ERROR_IMPORT.getMessage());
                }
                JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey())).eq(SysActProcessFile::getType, (Object)sysActProcessFile.getType()));
                    if (HussarUtils.isNotEmpty((Object)oldSysActProcessFile)) {
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                    } else {
                        sysActProcessFile.setId(null);
                    }
                    sysActProcessFile.setVersion(Integer.valueOf(0));
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                XMLStreamReader xtr = xif.createXMLStreamReader(in);
                BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                String identityId = this.modelMapper.getIdByIdentity(modelKey);
                Model modelData = null;
                if (HussarUtils.isEmpty((Object)identityId)) {
                    modelData = this.repositoryService.newModel();
                    ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                    modelObjectNode.put("name", impModelName);
                    modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                    modelObjectNode.put("revision", 1);
                    modelData.setMetaInfo(modelObjectNode.toString());
                    modelData.setName(impModelName);
                    modelData.setKey(modelKey);
                    this.repositoryService.saveModel(modelData);
                }
                ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                jsonConverter.updateConvertersToBpmnMap();
                jsonConverter.updateConvertersToJsonMap();
                ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                identityId = identityId == null ? modelData.getId() : identityId;
                this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, Integer.valueOf(0));
                workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                this.sysActProcessFileService.updateFile(workFlow);
                this.deployModel(Long.parseLong(identityId));
            }
            ApiResponse apiResponse = ApiResponse.success((String)BpmEnum.IMPORT_SUCCESS.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new PublicClientException(BpmEnum.ERROR_IMPORT.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean importModel(File file, List<String> coverList, String serverName) {
        InputStream in = null;
        try {
            File f = null;
            List<String> fileList = this.getAllFile(file);
            if (fileList == null) {
                logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                throw new NullPointerException("\u9519\u8bef\u6587\u4ef6\u5939");
            }
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                f = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)f, (String)"UTF-8"), Map.class);
                if (!HussarUtils.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                    Boolean bl = false;
                    return bl;
                }
                JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                if (!HussarUtils.isNotEmpty((Object)jsonArray)) continue;
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActProcessFile::getVersion, (Object)0)).eq(SysActProcessFile::getProcessKey, (Object)sysActProcessFile.getProcessKey())).eq(SysActProcessFile::getType, (Object)sysActProcessFile.getType()));
                    if (HussarUtils.isNotEmpty((Object)oldSysActProcessFile)) {
                        sysActProcessFile.setId(oldSysActProcessFile.getId());
                    } else {
                        sysActProcessFile.setId(null);
                    }
                    sysActProcessFile.setVersion(Integer.valueOf(0));
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                try {
                    XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                    XMLStreamReader xtr = xif.createXMLStreamReader(in);
                    BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                    String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                    String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                    String identityId = this.modelMapper.getIdByIdentity(modelKey);
                    if (HussarUtils.isNotEmpty((Object)identityId)) {
                        if (HussarUtils.isNotEmpty(coverList.stream().filter(modelKey::equals).findFirst().orElse(null))) {
                            UpdateByteArrayModel updateByteArrayModel = new UpdateByteArrayModel();
                            updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
                            updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)));
                            this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
                            continue;
                        }
                    }
                    if (HussarUtils.isEmpty((Object)identityId)) {
                        Model modelData = this.repositoryService.newModel();
                        ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                        modelObjectNode.put("name", impModelName);
                        modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                        modelObjectNode.put("revision", 1);
                        modelData.setMetaInfo(modelObjectNode.toString());
                        modelData.setName(impModelName);
                        modelData.setKey(modelKey);
                        modelData.setCategory(serverName);
                        this.repositoryService.saveModel(modelData);
                        identityId = modelData.getId();
                    }
                    ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                    jsonConverter.updateConvertersToBpmnMap();
                    jsonConverter.updateConvertersToJsonMap();
                    ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                    this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                    WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, Integer.valueOf(0));
                    if (workFlow == null) {
                        logger.error("{} \u6570\u636e\u7f3a\u5931", (Object)modelKey);
                        throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
                    }
                    workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                    this.sysActProcessFileService.updateFile(workFlow);
                    this.deployModel(Long.parseLong(identityId));
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public String exportAllFileModel(String keys, File file) {
        ByteArrayInputStream in = null;
        List<ExportModel> models = this.modelMapper.getModelWithKey(Arrays.asList(keys.split(",")));
        if (HussarUtils.isEmpty(models)) {
            return file.getPath();
        }
        try {
            HashMap fileMap = new HashMap();
            for (ExportModel model : models) {
                if (HussarUtils.isEmpty((Object)model.getDeploymentId())) continue;
                ArrayList files = new ArrayList();
                if (HussarUtils.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                File xmlFile = new File(file, filename);
                FileUtils.copyInputStreamToFile((InputStream)in, (File)xmlFile);
                in.close();
            }
            List list = null;
            list = this.sysActProcessFileService.exportFileListByKeys(Arrays.asList(keys.split(",")));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("file", list);
            data.put("export_type", "lcdpbpm");
            File lcdpbpm = new File(file, "workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss_SSS") + ".lcdpbpm");
            if (!lcdpbpm.isFile()) {
                try {
                    FileUtils.write((File)lcdpbpm, (CharSequence)JSON.toJSONString(data), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return file.getPath();
    }

    public void exportAllFileModel(String modelId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        ZipOutputStream zipOutputStream = null;
        ByteArrayInputStream in = null;
        List<String> str = Arrays.asList(modelId.split(","));
        List<Long> cdids = str.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List<ExportModel> models = this.modelMapper.getModelWithVersion(cdids);
        try {
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
            response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
            HashMap fileMap = new HashMap();
            zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (ExportModel model : models) {
                ArrayList files = new ArrayList();
                if (HussarUtils.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                ZipEntry zipEntry = new ZipEntry(filename);
                zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
                IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                in.close();
            }
            this.toFileZip(modelId, null, zipOutputStream);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFileZip(String modelId, String procId, ZipOutputStream out) {
        List list;
        ZipOutputStream zipOutputStream = null;
        if (HussarUtils.isNotEmpty((Object)modelId)) {
            List<String> models = Arrays.asList(modelId.split(","));
            list = this.sysActProcessFileService.exportFileList(models);
        } else {
            list = this.sysActProcessFileService.exportFile(procId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", list);
        data.put("export_type", "lcdpbpm");
        zipOutputStream = out;
        try {
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)new ZipEntry("workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".lcdpbpm"));
            ByteArrayInputStream in = new ByteArrayInputStream(JSON.toJSONBytes(data, (SerializerFeature[])new SerializerFeature[0]));
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            in.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public ApiResponse<String> validationProcess(String processKey, String businessId, String userId, Map<String, Object> variables) {
        return ApiResponse.success((Object)"", (String)"");
    }

    public ApiResponse<JSONArray> doneList(String businessId) {
        BpmResponseResult bpmResponseResult = this.instanceEngineService.getDoneProcessTrace(businessId);
        if (HussarUtils.equals((Object)bpmResponseResult.getCode(), (Object)"1")) {
            return ApiResponse.success((Object)bpmResponseResult.getResult());
        }
        throw new PublicClientException(bpmResponseResult.getMsg());
    }

    public String getRealVersion(String processDefId) {
        return this.modelMapper.getRealVersion(processDefId);
    }

    public String getServiceName(String processKey) {
        return this.modelMapper.getServiceName(processKey);
    }

    public int updateCategory(String identity, String category) {
        return this.modelMapper.updateCategory(identity, category);
    }

    public void downloadFiles(DownloadFilesDto downloadFilesDto, HttpServletResponse response) {
        String deploymentId = downloadFilesDto.getDeploymentId() == null ? "" : downloadFilesDto.getDeploymentId();
        String resourceName = downloadFilesDto.getResourceName() == null ? "" : downloadFilesDto.getResourceName();
        DefinitionModel processDefinitionModel = this.processDefinitionsMapper.getById(deploymentId);
        String key = processDefinitionModel.getId();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
        response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
        HashMap fileMap = new HashMap();
        ArrayList files = new ArrayList();
        fileMap.put(processDefinitionModel.getName(), files);
        String filename = processDefinitionModel.getName() + "_" + key.split(":")[0] + "/" + key.replace(":", "_") + SUFFIX;
        ZipEntry zipEntry = new ZipEntry(filename);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
             ByteArrayInputStream in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(deploymentId, resourceName);){
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            this.toFileZip(null, key, zipOutputStream);
        }
        catch (IOException e) {
            throw new PublicClientException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
    }

    public Map<String, String> selectModelNames(List<String> processKey) {
        List<ExportModel> nameList = this.modelMapper.selectModelNames(processKey);
        HashMap<String, String> modelNames = new HashMap<String, String>();
        for (ExportModel exportModel : nameList) {
            modelNames.put(exportModel.getBusinessId(), exportModel.getName());
        }
        return modelNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Boolean importModelByEryuan(String tenantId, File file, List<String> coverList) {
        in = null;
        try {
            f = null;
            fileList = this.getAllFile(file);
            if (fileList == null) {
                ModelServiceImpl.logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                throw new NullPointerException("\u9519\u8bef\u6587\u4ef6\u5939");
            }
            processFiles = new HashMap<String, JSONArray>();
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                f = new File(s);
                map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)f, (String)"UTF-8"), Map.class);
                if (!ToolUtil.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    ModelServiceImpl.logger.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u6587\u4ef6");
                    var11_15 = false;
                    return var11_15;
                }
                jsonArray = JSONArray.parseArray((String)JSON.toJSONString(map.get("file")));
                if (!ToolUtil.isNotEmpty((Object)jsonArray)) continue;
                sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)jsonArray.getJSONObject(0), SysActProcessFile.class);
                processFiles.put(sysActProcessFile.getProcessKey(), jsonArray);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                try {
                    xif = XmlUtil.createSafeXmlInputFactory();
                    xtr = xif.createXMLStreamReader(in);
                    bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                    impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                    modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                    identityId = this.modelMapper.getIdByIdentity(modelKey);
                    if (!ToolUtil.isNotEmpty((Object)identityId)) ** GOTO lbl-1000
                    if (ToolUtil.isNotEmpty(coverList.stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)modelKey)).findFirst().orElse(null))) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = isOverride = false;
                    }
                    if (isOverride) {
                        overVersion = Integer.parseInt(this.processDefinitionsService.getMainOrNew(modelKey).getVersion());
                        wfdList = new ArrayList<SysActProcessFile>();
                        metaList = new ArrayList<E>();
                        if (ToolUtil.isNotEmpty(processFiles.get(modelKey))) {
                            for (Object o : (JSONArray)processFiles.get(modelKey)) {
                                sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                                oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILE_VERSION", (Object)0)).eq((Object)"PROCESS_KEY", (Object)sysActProcessFile.getProcessKey())).eq((Object)"FILE_TYPE", (Object)sysActProcessFile.getType()));
                                if (ToolUtil.isNotEmpty((Object)oldSysActProcessFile)) {
                                    sysActProcessFile.setId(oldSysActProcessFile.getId());
                                } else {
                                    sysActProcessFile.setId(null);
                                }
                                sysActProcessFile.setVersion(Integer.valueOf(0));
                                sysActProcessFile.setTenantId(tenantId);
                                if ("wfd".equals(sysActProcessFile.getType())) {
                                    wfdList.add(sysActProcessFile);
                                    continue;
                                }
                                metaList.add(sysActProcessFile);
                            }
                            for (Object o : (JSONArray)processFiles.get(modelKey)) {
                                sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                                oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILE_VERSION", (Object)overVersion)).eq((Object)"PROCESS_KEY", (Object)sysActProcessFile.getProcessKey())).eq((Object)"FILE_TYPE", (Object)sysActProcessFile.getType()));
                                if (ToolUtil.isNotEmpty((Object)oldSysActProcessFile)) {
                                    sysActProcessFile.setId(oldSysActProcessFile.getId());
                                } else {
                                    sysActProcessFile.setId(null);
                                }
                                sysActProcessFile.setVersion(Integer.valueOf(overVersion));
                                sysActProcessFile.setTenantId(tenantId);
                                if ("wfd".equals(sysActProcessFile.getType())) {
                                    wfdList.add(sysActProcessFile);
                                    continue;
                                }
                                metaList.add(sysActProcessFile);
                            }
                            addList = new ArrayList<SysActProcessFile>();
                            addList.addAll(wfdList);
                            o = metaList.iterator();
                            while (o.hasNext()) {
                                sysActProcessFile = (SysActProcessFile)o.next();
                                workFlow = (WorkFlow)JSON.parseObject((String)new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8), WorkFlow.class);
                                workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                                sysActProcessFile.setContent(JSONObject.toJSONString((Object)workFlow).getBytes(StandardCharsets.UTF_8));
                            }
                            addList.addAll(metaList);
                            this.sysActProcessFileService.saveOrUpdateBatch(addList);
                        }
                        updateByteArrayModel = new UpdateByteArrayModel();
                        updateByteArrayModel.setBytes(new BpmnXMLConverter().convertToXML(bpmnModel));
                        updateByteArrayModel.setId(this.bpm2XMLMapper.getUpdateModelId(Long.parseLong(identityId)));
                        this.updateByteArrayModelMapper.updateById(updateByteArrayModel);
                        this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(this.bpm2XMLMapper.getActDefIdByModelId(Long.parseLong(identityId))));
                        continue;
                    }
                    wfdList = new ArrayList<SysActProcessFile>();
                    metaList = new ArrayList<SysActProcessFile>();
                    if (ToolUtil.isNotEmpty(processFiles.get(modelKey))) {
                        for (E o : (JSONArray)processFiles.get(modelKey)) {
                            sysActProcessFile = (SysActProcessFile)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class);
                            oldSysActProcessFile = (SysActProcessFile)this.sysActProcessFileService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"FILE_VERSION", (Object)0)).eq((Object)"PROCESS_KEY", (Object)sysActProcessFile.getProcessKey())).eq((Object)"FILE_TYPE", (Object)sysActProcessFile.getType()));
                            if (ToolUtil.isNotEmpty((Object)oldSysActProcessFile)) {
                                sysActProcessFile.setId(oldSysActProcessFile.getId());
                            } else {
                                sysActProcessFile.setId(null);
                            }
                            sysActProcessFile.setVersion(Integer.valueOf(0));
                            sysActProcessFile.setTenantId(tenantId);
                            if ("wfd".equals(sysActProcessFile.getType())) {
                                wfdList.add(sysActProcessFile);
                                continue;
                            }
                            metaList.add(sysActProcessFile);
                        }
                        addList = new ArrayList<SysActProcessFile>();
                        addList.addAll(wfdList);
                        addList.addAll(metaList);
                        this.sysActProcessFileService.saveOrUpdateBatch(addList);
                    }
                    modelData = null;
                    if (ToolUtil.isEmpty((Object)identityId)) {
                        modelData = this.repositoryService.newModel();
                        modelObjectNode = new ObjectMapper().createObjectNode();
                        modelObjectNode.put("name", impModelName);
                        modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                        modelObjectNode.put("revision", 1);
                        modelData.setMetaInfo(modelObjectNode.toString());
                        modelData.setName(impModelName);
                        modelData.setKey(modelKey);
                        this.repositoryService.saveModel(modelData);
                    }
                    jsonConverter = new ExtendBpmnJsonConverter();
                    jsonConverter.updateConvertersToBpmnMap();
                    jsonConverter.updateConvertersToJsonMap();
                    editorNode = jsonConverter.convertToJson(bpmnModel);
                    identityId = identityId == null ? modelData.getId() : identityId;
                    this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                    workFlow = this.sysActProcessFileService.getFileByProcessKeyByEryuan(modelKey, tenantId, Integer.valueOf(0));
                    if (workFlow == null) {
                        ModelServiceImpl.logger.error(modelKey + "\u6570\u636e\u7f3a\u5931");
                        throw new NullPointerException(modelKey + "\u6570\u636e\u7f3a\u5931");
                    }
                    workFlow.setModelId(Long.valueOf(Long.parseLong(identityId)));
                    this.sysActProcessFileService.updateFileByEryuan(workFlow, tenantId);
                    this.deployModelByEryuan(identityId, tenantId);
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            var8_10 = true;
            return var8_10;
        }
        catch (Exception e) {
            e.printStackTrace();
            var6_7 = false;
            return var6_7;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String deployModelByEryuan(String modelId, String tenantId) {
        try {
            Model modelData = this.repositoryService.getModel(modelId);
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                logger.error("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
                return null;
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + SUFFIX;
            Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).tenantId(tenantId).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(true);
            modelData.setDeploymentId(deployment.getId());
            this.repositoryService.saveModel(modelData);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).latestVersion().singleResult();
            this.saveModelExtendProperties(bpmnModel, processDefinition);
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKeyByEryuan(processDefinition.getKey(), tenantId, Integer.valueOf(0));
            workFlow.setProcDefId(processDefinition.getId());
            Integer version = null;
            if (HussarUtils.isNotEmpty((Object)processDefinition.getVersion())) {
                version = processDefinition.getVersion();
            }
            this.sysActProcessFileService.addFileByEryuan(workFlow, tenantId, version);
            this.processDefinitionsService.cancelMain(processDefinition.getKey(), null);
            return processDefinition.getId();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String exportAllFileModelByEryuan(String tenantId, String keys, File file) {
        ByteArrayInputStream in = null;
        List<ExportModel> models = this.modelMapper.getModelWithKey(Arrays.asList(keys.split(",")));
        if (ToolUtil.isEmpty(models)) {
            return file.getPath();
        }
        try {
            HashMap fileMap = new HashMap();
            for (ExportModel model : models) {
                if (ToolUtil.isEmpty((Object)model.getDeploymentId())) continue;
                ArrayList files = new ArrayList();
                if (ToolUtil.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessId() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                File xmlFile = new File(file, filename);
                FileUtils.copyInputStreamToFile((InputStream)in, (File)xmlFile);
                in.close();
            }
            List list = null;
            list = this.sysActProcessFileService.exportFileListByKeysByEryuan(Arrays.asList(keys.split(",")), tenantId);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("file", list);
            data.put("export_type", "lcdpbpm");
            File lcdpbpm = new File(file, "workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss_SSS") + ".lcdpbpm");
            if (!lcdpbpm.isFile()) {
                try {
                    FileUtils.write((File)lcdpbpm, (CharSequence)JSONObject.toJSONString(data), (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file.getPath();
    }
}

