/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.identity.organ.model.BpmUserMsg;
import com.jxdinfo.hussar.identity.organ.service.IAssigneeChooseEyService;
import com.jxdinfo.hussar.msg.push.dto.AppServiceDto;
import com.jxdinfo.hussar.msg.push.service.PushMsgService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActUserMsg;
import com.jxdinfo.hussar.workflow.engine.bpm.message.push.config.BpmMsgProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.message.push.unifiedinterface.PushMsgHandlerService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmActUserMsgService;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class BpmMsgPushServiceImpl
implements BpmMsgPushService {
    private static final Logger logger = LoggerFactory.getLogger(BpmMsgPushServiceImpl.class);
    @Autowired
    private SysActAssigneeService sysActAssigneeService;
    @Autowired
    private IAssigneeChooseEyService iAssigneeChooseService;
    @Autowired
    private List<PushMsgHandlerService> pushMsgHandlerServices;
    @Autowired
    private BpmActUserMsgService bpmActUserMsgService;
    @Autowired
    private BpmMsgProperties bpmMsgProperties;
    @Autowired(required=false)
    private PushMsgService pushMsgService;

    @Async(value="pushMsgExecutor")
    public void pushMessage(List<BpmActMsgDetail> bpmActMsgDetailList) {
        this.setAppIdAndAppSecret(bpmActMsgDetailList);
        for (BpmActMsgDetail bpmActMsgDetail : bpmActMsgDetailList) {
            String[] channelTypes;
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) {
                this.setChannelType(bpmActMsgDetail);
                if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) break;
            }
            if (!this.verifyInputMessage(bpmActMsgDetail)) break;
            this.setMessageData(bpmActMsgDetail);
            this.setUserMsg(bpmActMsgDetail);
            for (String channelType : channelTypes = bpmActMsgDetail.getChannelType().split(",")) {
                bpmActMsgDetail.setChannelType(channelType);
                this.addMessageOtherContent(bpmActMsgDetail);
            }
        }
    }

    private void addMessageOtherContent(BpmActMsgDetail bpmActMsgDetail) {
        List receive = bpmActMsgDetail.getReceive();
        for (int i = 0; i < bpmActMsgDetail.getReceive().size(); i += 10) {
            BpmActMsgDetail subBpmActMsgDetail = bpmActMsgDetail.clone();
            if (subBpmActMsgDetail == null) continue;
            ArrayList receiveChild = new ArrayList();
            for (int j = i; j < i + 10 && j < bpmActMsgDetail.getReceive().size(); ++j) {
                receiveChild.add(receive.get(j));
            }
            subBpmActMsgDetail.setReceive(receiveChild);
            this.distributeMessage(subBpmActMsgDetail);
        }
    }

    private void distributeMessage(BpmActMsgDetail bpmActMsgDetail) {
        switch (bpmActMsgDetail.getChannelType()) {
            case "mail": {
                this.publishEmailMessage(bpmActMsgDetail);
                break;
            }
            case "sms": {
                this.publishSmsMessage(bpmActMsgDetail);
                break;
            }
            case "wx_account": {
                this.publishMpMessage(bpmActMsgDetail);
                break;
            }
            case "app_im": {
                this.publishAppImMessage(bpmActMsgDetail);
                break;
            }
            case "app_push": {
                this.publishAppMessage(bpmActMsgDetail);
                break;
            }
            case "cp": {
                this.publishCpMessage(bpmActMsgDetail);
                break;
            }
        }
    }

    private void setAppIdAndAppSecret(List<BpmActMsgDetail> bpmActMsgDetailList) {
        if (HussarUtils.isNotEmpty(bpmActMsgDetailList)) {
            String appId = this.bpmMsgProperties.getAppId();
            String appSecret = this.bpmMsgProperties.getAppSecret();
            for (BpmActMsgDetail bpmActMsgDetail : bpmActMsgDetailList) {
                bpmActMsgDetail.setAppId(appId);
                bpmActMsgDetail.setAppSecret(appSecret);
            }
        }
    }

    private boolean verifyInputMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getSceneCode())) {
            logger.error("\u7f3a\u5c11\u573a\u666f\u7c7b\u578b\uff01");
            return false;
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getProcessKey())) {
            logger.error("\u7f3a\u5c11\u6d41\u7a0b\u6807\u8bc6\uff01");
            return false;
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getReceive())) {
            logger.error("\u6d41\u7a0b[{}],{},\u7f3a\u5c11\u7528\u6237id\uff01", (Object)bpmActMsgDetail.getProcessKey(), (Object)bpmActMsgDetail.getSceneCode());
            return false;
        }
        return true;
    }

    private void setUserMsg(BpmActMsgDetail bpmActMsgDetail) {
        List bpmUserMsgs = this.iAssigneeChooseService.getUserMsgByUserIds(bpmActMsgDetail.getReceive());
        HashMap<String, Object> userMsg = new HashMap<String, Object>();
        for (BpmUserMsg bpmUserMsg : bpmUserMsgs) {
            userMsg.put(bpmUserMsg.getId(), JSON.parseObject((String)JSON.toJSONString((Object)bpmUserMsg), Map.class));
        }
        bpmActMsgDetail.setUserMsg(userMsg);
        this.setOtherUserMsg(bpmActMsgDetail);
    }

    private List<BpmActUserMsg> getOtherUserMsg(List<String> receiveList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(BpmActUserMsg::getUserId, receiveList);
        List bpmActUserMsgs = this.bpmActUserMsgService.list((Wrapper)queryWrapper);
        return HussarUtils.isNotEmpty((Object)bpmActUserMsgs) ? bpmActUserMsgs : new ArrayList();
    }

    private void setOtherUserMsg(BpmActMsgDetail bpmActMsgDetail) {
        List<BpmActUserMsg> bpmActUserMsgs = this.getOtherUserMsg(bpmActMsgDetail.getReceive());
        if (HussarUtils.isEmpty(bpmActUserMsgs)) {
            return;
        }
        HashMap userMsgs = new HashMap();
        for (Map map : bpmActMsgDetail.getUserMsg().values()) {
            for (BpmActUserMsg bpmActUserMsg : bpmActUserMsgs) {
                if (!((String)map.get("id")).equals(bpmActUserMsg.getUserId())) continue;
                String msgName = null;
                switch (bpmActUserMsg.getMessageType()) {
                    case "wx_account": {
                        msgName = "openId";
                        break;
                    }
                    case "app_push": {
                        msgName = "appToken";
                        break;
                    }
                    case "app_im": {
                        msgName = "appImUserId";
                        break;
                    }
                    case "cp": {
                        msgName = "cpUserId";
                        break;
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)msgName)) continue;
                map.put(msgName, bpmActUserMsg.getOtherUserId());
            }
            userMsgs.put(map.get("id"), map);
        }
        bpmActMsgDetail.setUserMsg(userMsgs);
    }

    private void setMessageData(BpmActMsgDetail bpmActMsgDetail) {
        HashMap<String, String> messageData = new HashMap<String, String>();
        switch (bpmActMsgDetail.getSceneCode()) {
            case "todo": {
                bpmActMsgDetail.setMessage("\u60a8\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u5f85\u529e\u4efb\u52a1\uff0c\u8bf7\u5728\u3010\u4e2a\u4eba\u4e8b\u9879\u3011-\u3010\u5f85\u529e\u4efb\u52a1\u3011\u83dc\u5355\u4e0b\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u5f85\u529e\u63d0\u9192");
                messageData.put("processName", bpmActMsgDetail.getProcessName());
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getTodoSceneCode());
                break;
            }
            case "reject": {
                bpmActMsgDetail.setMessage("\u60a8\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u9a73\u56de\u4efb\u52a1\uff0c\u8bf7\u5728\u3010\u4e2a\u4eba\u4e8b\u9879\u3011-\u3010\u5f85\u529e\u4efb\u52a1\u3011\u83dc\u5355\u4e0b\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u9a73\u56de\u63d0\u9192");
                messageData.put("processName", bpmActMsgDetail.getProcessName());
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getRejectSceneCode());
                break;
            }
            case "reminders": {
                bpmActMsgDetail.setMessage("\u60a8\u6536\u5230#{processName}\u6d41\u7a0b\uff0c#{taskName}\u4efb\u52a1\u7684\u50ac\u529e\u6d88\u606f\uff0c\u8bf7\u5728\u3010\u4e2a\u4eba\u4e8b\u9879\u3011-\u3010\u5f85\u529e\u4efb\u52a1\u3011\u83dc\u5355\u4e0b\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u50ac\u529e\u63d0\u9192");
                messageData.put("processName", bpmActMsgDetail.getProcessName());
                messageData.put("taskName", bpmActMsgDetail.getTaskDefName());
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getRemindersSceneCode());
                break;
            }
            case "entrust": {
                bpmActMsgDetail.setMessage("\u60a8\u6536\u5230#{processName}\u6d41\u7a0b\u7684\u59d4\u6258\uff0c\u59d4\u6258\u65f6\u95f4#{startTime}\u81f3#{endTime}\uff0c\u540e\u7eed\u76f8\u5173\u4efb\u52a1\u8bf7\u5728\u3010\u4e2a\u4eba\u4e8b\u9879\u3011-\u3010\u5f85\u529e\u4efb\u52a1\u3011\u83dc\u5355\u4e0b\u53ca\u65f6\u5904\u7406\u3002");
                bpmActMsgDetail.setMessageType("\u59d4\u6258\u63d0\u9192");
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getEntrustSceneCode());
                break;
            }
            case "complete": {
                bpmActMsgDetail.setMessage("\u60a8\u63d0\u4ea4\u7684#{processName}\u6d41\u7a0b\u5df2\u5ba1\u6279\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u6d41\u7a0b\u7ed3\u679c\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u5b8c\u6210\u63d0\u9192");
                messageData.put("processName", bpmActMsgDetail.getProcessName());
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getCompleteSceneCode());
                break;
            }
            case "terminated": {
                bpmActMsgDetail.setMessage("\u60a8\u63d0\u4ea4\u7684#{processName}\u6d41\u7a0b\u5df2\u7ec8\u6b62\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\u6d41\u7a0b\u7ed3\u679c\u3002");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u7ec8\u6b62\u63d0\u9192");
                messageData.put("processName", bpmActMsgDetail.getProcessName());
                bpmActMsgDetail.setMessageData(messageData);
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getTerminatedSceneCode());
                break;
            }
            case "exception": {
                bpmActMsgDetail.setMessage("#{processName}\u6d41\u7a0b\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff0c#{exceptionMsg}");
                bpmActMsgDetail.setMessageType("\u6d41\u7a0b\u5f02\u5e38\u63d0\u9192");
                bpmActMsgDetail.setSceneCode(this.bpmMsgProperties.getEntrustSceneCode());
                break;
            }
        }
    }

    private void setChannelType(BpmActMsgDetail bpmActMsgDetail) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)bpmActMsgDetail.getProcessKey());
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getTaskDefKey())) {
            queryWrapper.isNull(SysActAssignee::getTaskDefKey);
        } else {
            queryWrapper.eq(SysActAssignee::getTaskDefKey, (Object)bpmActMsgDetail.getTaskDefKey());
        }
        queryWrapper.eq(SysActAssignee::getContentType, (Object)"defaultAssign");
        SysActAssignee sysActAssignee = (SysActAssignee)this.sysActAssigneeService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)sysActAssignee)) {
            bpmActMsgDetail.setChannelType(sysActAssignee.getMessageType());
        } else {
            bpmActMsgDetail.setChannelType(null);
        }
        if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getChannelType())) {
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getProcessDefinitionId())) {
                logger.error("\u6d88\u606f\u63a8\u9001\uff0c\u7f3a\u5c11\u6d41\u7a0b\u5b9a\u4e49id\uff01");
                return;
            }
            RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
            BpmnModel bm = repositoryService.getBpmnModel(bpmActMsgDetail.getProcessDefinitionId());
            if (HussarUtils.isEmpty((Object)bpmActMsgDetail.getTaskDefKey())) {
                String target = "";
                for (FlowElement flowElement : ((Process)bm.getProcesses().get(0)).getFlowElements()) {
                    if (!(flowElement instanceof StartEvent)) continue;
                    target = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
                    break;
                }
                for (FlowElement flowElement : ((Process)bm.getProcesses().get(0)).getFlowElements()) {
                    if (!flowElement.getId().equals(target) || flowElement.getExtensionElements().get("messageType") == null) continue;
                    List list = (List)((ExtensionElement)((List)flowElement.getExtensionElements().get("messageType")).get(0)).getAttributes().get("messageType");
                    bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : null);
                    break;
                }
            } else {
                Map extensionElementsNode = bm.getFlowElement(bpmActMsgDetail.getTaskDefKey()).getExtensionElements();
                if (extensionElementsNode.get("messageType") != null) {
                    List list = (List)((ExtensionElement)((List)extensionElementsNode.get("messageType")).get(0)).getAttributes().get("messageType");
                    bpmActMsgDetail.setChannelType(HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : null);
                }
            }
        }
    }

    private void publishEmailMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "email")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgEmail(bpmActMsgDetail);
            }
        }
    }

    private void publishSmsMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "mobile")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgSms(bpmActMsgDetail);
            }
        }
    }

    private void publishMpMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "openId")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgMp(bpmActMsgDetail);
            }
        }
    }

    private void publishCpMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "cpUserId")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgCp(bpmActMsgDetail);
            }
        }
    }

    private void publishAppImMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "appImUserId")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgAppIm(bpmActMsgDetail);
            }
        }
    }

    private void publishAppMessage(BpmActMsgDetail bpmActMsgDetail) {
        if (this.verifyMessage(bpmActMsgDetail, "appToken")) {
            for (PushMsgHandlerService pushMsgHandlerService : this.pushMsgHandlerServices) {
                pushMsgHandlerService.pushMsgApp(bpmActMsgDetail);
            }
        }
    }

    private boolean verifyMessage(BpmActMsgDetail bpmActMsgDetail, String elem) {
        HashMap userMsg = new HashMap(bpmActMsgDetail.getUserMsg());
        ArrayList receiveList = new ArrayList(bpmActMsgDetail.getReceive());
        for (String receive : bpmActMsgDetail.getReceive()) {
            if (!HussarUtils.isEmpty(userMsg.get(receive)) && !HussarUtils.isEmpty(((Map)userMsg.get(receive)).get(elem))) continue;
            logger.error("\u6d41\u7a0b[{}]\uff0c\u7528\u6237id[{}]\uff0c\u7f3a\u5c11[{}]\u4fe1\u606f\uff01", new Object[]{bpmActMsgDetail.getProcessKey(), receive, elem});
            userMsg.remove(receive);
            receiveList.remove(receive);
        }
        bpmActMsgDetail.setReceive(receiveList);
        bpmActMsgDetail.setUserMsg(userMsg);
        return HussarUtils.isNotEmpty((Object)bpmActMsgDetail.getReceive());
    }

    public BpmResponseResult getBpmActChannel() {
        if (HussarUtils.isEmpty((Object)this.pushMsgService)) {
            return InstallResult.success();
        }
        AppServiceDto appServiceDto = new AppServiceDto();
        appServiceDto.setAppId(this.bpmMsgProperties.getAppId());
        appServiceDto.setAppSecret(this.bpmMsgProperties.getAppSecret());
        try {
            return InstallResult.success((JSONArray)JSON.parseArray((String)JSON.toJSONString((Object)this.pushMsgService.getAppService(appServiceDto))));
        }
        catch (HussarException e) {
            return InstallResult.fail((String)("\u67e5\u8be2\u6d88\u606f\u63d0\u9192\u65b9\u5f0f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

