/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.user.PluginUser;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkflowListenerService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudServiceTaskListener")
public class DefaultServiceTaskListener
implements JavaDelegate {
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public void execute(DelegateExecution delegateExecution) throws Exception {
        String beanId = (String)delegateExecution.getVariableLocal("beanId");
        delegateExecution.removeVariableLocal("beanId");
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, String> map = new HashMap<String, String>();
        ExecutionEntity entity = (ExecutionEntity)delegateExecution;
        map.put("nodeId", delegateExecution.getCurrentActivityId());
        map.put("nodeName", delegateExecution.getCurrentActivityName());
        map.put("businessId", delegateExecution.getProcessBusinessKey());
        map.put("processInsId", delegateExecution.getProcessInstanceId());
        map.put("processDefinitionId", delegateExecution.getProcessDefinitionId());
        map.put("processKey", entity.getProcessDefinitionKey());
        for (IdentityLinkEntity identityLinkEntity : ((ExecutionEntity)delegateExecution).getProcessInstance().getIdentityLinks()) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("createTime", simpleDateFormat.format(new Date()));
        map.put("processName", ((ExecutionEntity)delegateExecution).getProcessDefinition().getName());
        if (beanId != null) {
            try {
                if (!this.lcdpBpmProperties.isStartAlone()) {
                    HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)SpringContextHolder.getBean((String)beanId);
                    workflowListenerVisitor.notify(map);
                    return;
                }
                map.put("beanId", beanId);
                String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
                WorkflowListenerService workflowListenerService = (WorkflowListenerService)SpringContextHolder.getBean(WorkflowListenerService.class);
                workflowListenerService.executeListener(map, serviceName);
            }
            catch (Exception e) {
                PluginUser pluginUser = (PluginUser)SpringContextUtil.getBean(PluginUser.class);
                if (pluginUser.getBean(beanId) != null) {
                    HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)pluginUser.getBean(beanId);
                    workflowListenerVisitor.notify(map);
                    return;
                }
                throw new PublicClientException(this.bpmConstantProperties.getErrorServiceTaskListener());
            }
        }
    }
}

