/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.user.PluginUser;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowListener;
import com.jxdinfo.hussar.workflow.outside.listener.service.WorkflowListenerService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudExecutionListener")
public class DefaultExecutionListener
implements ExecutionListener {
    private static ModelService modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    public void notify(DelegateExecution delegateExecution) throws Exception {
        VariableInstance loopCounter = delegateExecution.getVariableInstanceLocal("loopCounter");
        if (loopCounter != null || ((ExecutionEntity)delegateExecution).getActivity() == null) {
            return;
        }
        Object subProcessKey = delegateExecution.getVariableLocal("sub_process_key");
        if (subProcessKey != null && ((String)subProcessKey).startsWith(((ExecutionEntity)delegateExecution).getActivityId() + ":")) {
            return;
        }
        String beanId = (String)delegateExecution.getVariableLocal("beanId");
        delegateExecution.removeVariableLocal("beanId");
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, String> map = new HashMap<String, String>();
        ExecutionEntity entity = (ExecutionEntity)delegateExecution;
        map.put("nodeId", delegateExecution.getCurrentActivityId());
        String nodeName = delegateExecution.getCurrentActivityName();
        ActivityImpl activity = ((ExecutionEntity)delegateExecution).getActivity();
        if (HussarUtils.isEmpty((Object)nodeName) && HussarUtils.isNotEmpty((Object)activity) && HussarUtils.isNotEmpty((Object)activity.getProperties()) && HussarUtils.isNotEmpty(activity.getProperties().get("name"))) {
            nodeName = String.valueOf(activity.getProperties().get("name"));
        }
        map.put("nodeName", nodeName);
        map.put("businessId", delegateExecution.getProcessBusinessKey());
        map.put("processInsId", delegateExecution.getProcessInstanceId());
        map.put("processDefinitionId", delegateExecution.getProcessDefinitionId());
        map.put("processKey", entity.getProcessDefinitionKey());
        Object listenerType = Context.getCommandContext().getAttribute("listenerType");
        String eventName = null;
        if (HussarUtils.isEmpty((Object)delegateExecution.getEventName()) && HussarUtils.isNotEmpty((Object)listenerType)) {
            eventName = listenerType.toString();
        }
        if (HussarUtils.isNotEmpty((Object)activity) && HussarUtils.isNotEmpty((Object)activity.getProperties()) && HussarUtils.isNotEmpty(activity.getProperties().get("type"))) {
            String type = String.valueOf(activity.getProperties().get("type"));
            map.put("activityType", type);
        }
        Object taskSourceFlag = null;
        for (IdentityLinkEntity identityLinkEntity : ((ExecutionEntity)delegateExecution).getProcessInstance().getIdentityLinks()) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("processName", ((ExecutionEntity)delegateExecution).getProcessDefinition().getName());
        Object info = Context.getCommandContext().getAttribute("listenerParam");
        ParamModel paramModel = (ParamModel)info;
        if (HussarUtils.isNotEmpty((Object)eventName) && "end".equals(eventName) || "end".equals(delegateExecution.getEventName())) {
            if (HussarUtils.isNotEmpty((Object)paramModel)) {
                map.put("endTime", paramModel.getEndTime());
                map.put("endType", paramModel.getCompleteType());
            }
        } else if (HussarUtils.isNotEmpty((Object)eventName) && "start".equals(eventName) || "start".equals(delegateExecution.getEventName())) {
            taskSourceFlag = Context.getCommandContext().getAttribute("taskSourceFlag");
            map.put("createTime", simpleDateFormat.format(new Date()));
            if (HussarUtils.isNotEmpty((Object)paramModel)) {
                if (!map.containsKey("starter")) {
                    map.put("starter", paramModel.getStarter());
                }
                map.put("lastNodeId", paramModel.getLastNodeId());
                map.put("lastNodeName", paramModel.getLastNodeName());
                map.put("lastNodeAssignee", paramModel.getLastNodeHandler());
                map.put("createType", paramModel.getCreateReason());
            } else if (HussarUtils.isNotEmpty((Object)taskSourceFlag)) {
                map.put("createType", taskSourceFlag.toString());
            }
        }
        if (beanId != null) {
            try {
                if (!this.lcdpBpmProperties.isStartAlone()) {
                    HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)SpringContextHolder.getBean((String)beanId);
                    workflowListenerVisitor.notify(map);
                    return;
                }
                map.put("beanId", beanId);
                String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
                WorkflowListenerService workflowListenerService = (WorkflowListenerService)SpringContextHolder.getBean(WorkflowListenerService.class);
                workflowListenerService.executeListener(map, serviceName);
            }
            catch (Exception e) {
                PluginUser pluginUser = (PluginUser)SpringContextUtil.getBean(PluginUser.class);
                if (pluginUser.getBean(beanId) != null) {
                    HussarWorkflowListener workflowListenerVisitor = (HussarWorkflowListener)pluginUser.getBean(beanId);
                    workflowListenerVisitor.notify(map);
                    return;
                }
                throw new PublicClientException(this.bpmConstantProperties.getErrorExecutionListener());
            }
        }
    }
}

