/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formerlycommon.util.datasource.DataSourceUtil;
import com.jxdinfo.hussar.identity.organ.service.IAssigneeChooseEyService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEventsServiceImpl
implements FlowEventsService {
    private final TaskService taskService;
    private final ITaskEngineService taskEngineService;
    private final RepositoryService repositoryService;
    private final IFlowTaskService flowTaskService;
    private LcdpBpmProperties lcdpBpmProperties;
    private final IAssigneeChooseEyService assigneeChooseEyService;
    private final FlowEventsServiceMapper flowEventsServiceMapper;
    private final DruidProperties druidProperties;
    private final ISysActExtendPropertiesService iSysActExtendPropertiesService;
    private static final Logger logger = LoggerFactory.getLogger(FlowEventsServiceImpl.class);
    @Autowired
    private ISysActUrgeTaskService urgeTaskService;

    public FlowEventsServiceImpl(TaskService taskService, ITaskEngineService iTaskEngineService, RuntimeService runtimeService, RepositoryService repositoryService, IFlowTaskService flowTaskService, IAssigneeChooseEyService assigneeChooseEyService, LcdpBpmProperties lcdpBpmProperties, FlowEventsServiceMapper flowEventsServiceMapper, ISysActExtendPropertiesService iSysActExtendPropertiesService, DruidProperties druidProperties) {
        this.taskService = taskService;
        this.taskEngineService = iTaskEngineService;
        this.repositoryService = repositoryService;
        this.flowTaskService = flowTaskService;
        this.lcdpBpmProperties = lcdpBpmProperties;
        this.assigneeChooseEyService = assigneeChooseEyService;
        this.flowEventsServiceMapper = flowEventsServiceMapper;
        this.iSysActExtendPropertiesService = iSysActExtendPropertiesService;
        this.druidProperties = druidProperties;
    }

    public ApiResponse<Page<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.todoList(pages, flowTaskQueryModel);
    }

    public ApiResponse<Page<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = HussarUtils.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = HussarUtils.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.doneList(pages, flowTaskQueryModel);
    }

    public JSONArray flowType() {
        List definitions = this.repositoryService.createProcessDefinitionQuery().latestVersion().active().list();
        JSONArray jsonArray = new JSONArray();
        if (definitions != null) {
            for (ProcessDefinition tmp : definitions) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", tmp.getKey());
                tmpMap.put("name", tmp.getName());
                jsonArray.add(tmpMap);
            }
        }
        return jsonArray;
    }

    public ApiResponse<String> revokeTask(String historicTaskId, String userId) {
        BpmResponseResult check = this.taskEngineService.withdrawState(historicTaskId);
        if (check.getCode().equals("0")) {
            throw new PublicClientException(check.getMsg());
        }
        if (!((Boolean)check.getResult().get(0)).booleanValue()) {
            throw new PublicClientException((String)check.getResult().get(1));
        }
        BpmResponseResult bpmResponseResult = this.taskEngineService.revokeTask(historicTaskId, userId, "", true, null);
        if (bpmResponseResult.getCode().equals("0")) {
            throw new PublicClientException(bpmResponseResult.getMsg());
        }
        return ApiResponse.success((String)bpmResponseResult.getMsg());
    }

    public ApiResponse<String> urgeTask(String processInsId, String userId) {
        return ApiResponse.success((String)this.urgeTaskService.urgeTask(processInsId, null, userId));
    }

    public BpmResponseResult doneNonCompleteList(String userId, String processDefinitionKey, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit, String type, String serverCode, String securityLevel) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("sendUserId", sendUserId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("state", "0");
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            map.put("securityLevel", this.assigneeChooseEyService.getSecurityLevel(userId, ""));
            map.put("useSecurityLevel", null);
        } else {
            map.put("securityLevel", null);
            map.put("useSecurityLevel", null);
        }
        String dbType = this.druidProperties.getUrl().split(":")[1];
        map.put("dbType", dbType);
        List<FlowTask> doneList = this.flowEventsServiceMapper.doneNonCompleteList(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInsId());
        }
        List<Object> allVariables = new ArrayList();
        if (doneList.size() > 0) {
            instIds = new ArrayList(new HashSet(instIds));
            instIds.remove(null);
            if (instIds.size() == 0) {
                instIds = null;
            }
            allVariables = this.flowEventsServiceMapper.getAllVariables(taskIds, instIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", this.hisTasksToMap(doneList, serverCode));
        data.put("count", pages.getTotal());
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult completeList(String userId, String processDefinitionKey, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit, String type, String serverCode, String securityLevel) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("sendUserId", sendUserId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("state", "0");
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            map.put("securityLevel", this.assigneeChooseEyService.getSecurityLevel(userId, ""));
            map.put("useSecurityLevel", null);
        } else {
            map.put("securityLevel", null);
            map.put("useSecurityLevel", null);
        }
        String dbType = this.druidProperties.getUrl().split(":")[1];
        map.put("dbType", dbType);
        List<FlowTask> doneList = this.flowEventsServiceMapper.completeList(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInsId());
        }
        List<Object> allVariables = new ArrayList();
        if (doneList.size() > 0) {
            instIds = new ArrayList(new HashSet(instIds));
            instIds.remove(null);
            if (instIds.size() == 0) {
                instIds = null;
            }
            allVariables = this.flowEventsServiceMapper.getAllVariables(taskIds, instIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", this.hisTasksToMap(doneList, serverCode));
        data.put("count", pages.getTotal());
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult masterDoneNonCompleteList(String userId, String processDefinitionKey, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit, String type, String serverCode) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("sendUserId", sendUserId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("state", "0");
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            DataSourceUtil.changeTempDs((String)"master");
            Integer securityLevel = this.assigneeChooseEyService.getSecurityLevel(userId, "");
            DataSourceUtil.poll();
            map.put("securityLevel", securityLevel);
            map.put("useSecurityLevel", null);
        } else {
            map.put("securityLevel", null);
            map.put("useSecurityLevel", null);
        }
        String dbType = this.druidProperties.getUrl().split(":")[1];
        map.put("dbType", dbType);
        List<FlowTask> doneList = this.flowEventsServiceMapper.doneNonCompleteList(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInsId());
        }
        List<Object> allVariables = new ArrayList();
        if (doneList.size() > 0) {
            instIds = new ArrayList(new HashSet(instIds));
            instIds.remove(null);
            if (instIds.size() == 0) {
                instIds = null;
            }
            allVariables = this.flowEventsServiceMapper.getAllVariables(taskIds, instIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", this.hisTasksToMap(doneList, serverCode));
        data.put("count", pages.getTotal());
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult masterCompleteList(String userId, String processDefinitionKey, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit, String type, String serverCode) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("sendUserId", sendUserId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("state", "0");
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            DataSourceUtil.changeTempDs((String)"master");
            Integer securityLevel = this.assigneeChooseEyService.getSecurityLevel(userId, "");
            DataSourceUtil.poll();
            map.put("securityLevel", securityLevel);
            map.put("useSecurityLevel", null);
        } else {
            map.put("securityLevel", null);
            map.put("useSecurityLevel", null);
        }
        String dbType = this.druidProperties.getUrl().split(":")[1];
        map.put("dbType", dbType);
        List<FlowTask> doneList = this.flowEventsServiceMapper.completeList(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInsId());
        }
        List<Object> allVariables = new ArrayList();
        if (doneList.size() > 0) {
            instIds = new ArrayList(new HashSet(instIds));
            instIds.remove(null);
            if (instIds.size() == 0) {
                instIds = null;
            }
            allVariables = this.flowEventsServiceMapper.getAllVariables(taskIds, instIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", this.hisTasksToMap(doneList, serverCode));
        data.put("count", pages.getTotal());
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private List<Map<String, Object>> hisTasksToMap(List<FlowTask> lists, String serverCode) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        Map propertiesMap = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (ToolUtil.isNotEmpty(taskVariables.get("sendUser"))) {
                    userIds.add(String.valueOf(taskVariables.get("sendUser")));
                }
                userIds.add(flowTask.getUserId());
                userIds.add(flowTask.getProcessStartUserId());
                ids.add(flowTask.getProcessDefinitionId() + "," + flowTask.getTaskDefinitionKey());
            }
            propertiesMap = this.iSysActExtendPropertiesService.queryListByIds(ids);
            DataSourceUtil.changeTempDs((String)"master");
            finalUsers = this.assigneeChooseEyService.getUserListByUserId(userIds);
            DataSourceUtil.poll();
        }
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                JSONObject object;
                String message;
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                map.put("taskId", flowTask.getTaskId());
                map.put("isNoticeTask", flowTask.getIsNoticeTask());
                map.put("name", flowTask.getName());
                map.put("assigneeId", flowTask.getUserId());
                map.put("assigneeName", finalUsers.get(flowTask.getUserId()));
                map.put("startUserId", flowTask.getProcessStartUserId());
                map.put("startUserName", finalUsers.get(flowTask.getProcessStartUserId()));
                map.put("processDefinitionId", flowTask.getProcessDefinitionId());
                map.put("processDefinitionKey", flowTask.getProcessKey());
                map.put("processDefinitionName", flowTask.getProcessDefinitionName());
                map.put("taskDefinitionKey", flowTask.getTaskDefinitionKey());
                map.put("processInsId", flowTask.getProcessInsId());
                map.put("startTime", flowTask.getStartTime());
                map.put("endTime", flowTask.getEndTime());
                map.put("processStartTime", flowTask.getProcessStartTime());
                map.put("processEndTime", flowTask.getProcessEndTime());
                map.put("businessId", flowTask.getBusinessId());
                map.put("variables", variables);
                map.put("taskVariables", taskVariables);
                map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                String scope = String.valueOf(taskVariables.get("taskSourceFlag"));
                scope = "reject".equals(scope) ? "\u5df2\u9a73\u56de" : (ToolUtil.isNotEmpty((Object)flowTask.getEndTime()) ? "\u5df2\u5b8c\u6210" : "\u672a\u5b8c\u6210");
                map.put("state", scope);
                map.put("sendUser", taskVariables.get("sendUser"));
                map.put("sendUserName", finalUsers.get(taskVariables.get("sendUser")));
                if (ToolUtil.isNotEmpty((Object)flowTask.getTodoConfiguration())) {
                    message = flowTask.getTodoConfiguration();
                } else {
                    String string = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
                }
                if (ToolUtil.isNotEmpty((Object)message)) {
                    map.put("message", message);
                }
                map.put("formKey", flowTask.getFormKey());
                String formDetail = (String)propertiesMap.get(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
                if (ToolUtil.isNotEmpty((Object)formDetail) && ToolUtil.isNotEmpty((Object)(object = JSON.parseObject((String)formDetail)))) {
                    for (String key : object.keySet()) {
                        map.put(key, object.getString(key));
                    }
                }
                map.put("formDetailKey", formDetail);
                if (HussarUtils.isNotEmpty((Object)formDetail)) {
                    object = JSON.parseObject((String)formDetail);
                    map.put("web", object.getString("web"));
                    map.put("mobile", object.getString("mobile"));
                }
                list.add(map);
            }
        }
        return list;
    }
}

