/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.definition.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    ProcessEngine processEngine;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    RepositoryService repositoryService;

    public IPage<DefinitionModel> queryProcessDefinitionsList(String definitionName, Page<DefinitionModel> page) {
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName);
        page.setRecords(instList);
        return page;
    }

    public DefinitionModel getMainOrNew(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError(), Boolean.valueOf(false));
    }

    public String getStartProcessDefinitionId(String processKey) {
        List<String> list = this.processDefinitionsMapper.getProcessDefinitionIdList(processKey);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError(), Boolean.valueOf(false));
    }

    public List<String> getProcessDefinitionId(String processKey, Integer version) {
        return this.processDefinitionsMapper.getProcessDefinitionId(processKey, version);
    }

    public ApiResponse<String> setMain(String processKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0) + this.processDefinitionsMapper.setMain(id, 1);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        if ((num += this.processDefinitionsMapper.setModelMain(id)) != 0) {
            if (this.sysActProcessFileService.copyFiles(processKey, id)) {
                return ApiResponse.success((String)BpmEnum.SET_SUCCESS.getMessage());
            }
            throw new PublicClientException(BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        throw new PublicClientException(BpmEnum.SET_FAIL.getMessage());
    }

    public void canModelDeleteWithVersion(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list.size() == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getNotDeleteTheOnlyProcessDefinition(), Boolean.valueOf(false));
        }
    }

    public int setNotMain(String processKey) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null, 0);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        return num;
    }

    public ApiResponse<String> cancelMain(String processKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, id, 0);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        Long deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processKey, processDefinition.getId())) {
                return ApiResponse.success((String)BpmEnum.SUCCESS_UPDATE.getMessage());
            }
            throw new PublicClientException(BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        throw new PublicClientException(BpmEnum.ERROR_UPDATE.getMessage());
    }

    public int updateProcessName(String id, String processName) {
        return this.processDefinitionsMapper.updateProcessName(id, processName);
    }

    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        for (ProcessDefinitionModel oldPro : list) {
            boolean flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!HussarUtils.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    public List<ProcessDefinitionModel> getProcessMainOrNew(String processKey) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.getProcessMainOrNew(processKey);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        newList.add(list.get(0));
        return newList;
    }

    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    public void editTemporaryDefId(String defId, Long processInsId, String version) {
        this.processDefinitionsMapper.updateActInst(defId, processInsId);
        this.processDefinitionsMapper.updateExecution(defId, processInsId);
        this.processDefinitionsMapper.updateProcDef(defId, processInsId, Long.parseLong(version));
        this.processDefinitionsMapper.updateTask(defId, processInsId);
        this.processDefinitionsMapper.updateTaskInst(defId, processInsId);
        this.processDefinitionsMapper.updateProcInst(defId, processInsId);
    }

    public void editTemporaryDefId(String defId, String processInsId, String version) {
        this.editTemporaryDefId(defId, Long.parseLong(processInsId), version);
    }

    public int queryLatestVersion(String processKey) {
        List processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().list();
        if (HussarUtils.isNotEmpty((Object)processDefinition)) {
            return ((ProcessDefinition)processDefinition.get(0)).getVersion();
        }
        return 0;
    }

    public BpmResponseResult getNewVersion(String processDefKeys) {
        List<String> processDefKey = Arrays.asList(processDefKeys.split(","));
        List<Map<String, Object>> list = this.processDefinitionsMapper.getNewVersion(processDefKey);
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString(list));
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public Map<String, String> getProcessNewVersion(String processDefKeys) {
        List<String> processDefKey = Arrays.asList(processDefKeys.split(","));
        List<Map<String, Object>> list = this.processDefinitionsMapper.getNewVersion(processDefKey);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map<String, Object> m : list) {
            map.put(m.get("PROCDEFKEY").toString(), m.get("VERSION").toString());
        }
        return map;
    }

    public BpmResponseResult queryProcessMaxVersion(String processDefinitionKeys) {
        List<String> processDefKey = Arrays.asList(processDefinitionKeys.split(","));
        List<Map<String, Object>> list = this.processDefinitionsMapper.getNewVersion(processDefKey);
        JSONArray jsonArray = new JSONArray();
        JSONObject object = new JSONObject();
        for (Map<String, Object> m : list) {
            object.put(m.get("PROCDEFKEY").toString(), (Object)m.get("VERSION").toString());
        }
        jsonArray.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryMaxProcessVersionInfo(String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        if (processDefinition != null) {
            jsonObject.put("processDefinitionId", (Object)processDefinition.getId());
            jsonObject.put("processDefinitionVersion", (Object)processDefinition.getVersion());
            jsonObject.put("processKey", (Object)processDefinition.getKey());
            jsonArray.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }
}

