/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.formdesign.visitor.AssemblyVariablesVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;

public class CommonCodeUtil {
    private static Boolean isStartAlone;
    private static ModelService modelService;
    private static SysActProcessFileService sysActProcessFileService;
    private static RepositoryService repositoryService;
    private static ActivityRedisTimerService activityRedisTimerService;
    private static final Pattern regex;

    public static Map<String, Object> getGodAxeResult(String nodeId, String businessId, String procDefId) {
        Map<String, Object> variable;
        AssemblyVariablesVisitor assemblyVariablesVisitor;
        if (isStartAlone == null) {
            LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
            isStartAlone = lcdpBpmProperties.isStartAlone();
        }
        String procDefKey = procDefId.split(":")[0];
        String realVersion = String.valueOf(modelService.getRealVersion(procDefId));
        BpmnModel bm = repositoryService.getBpmnModel(procDefId);
        String beanId = procDefKey + ":" + realVersion + CommonCodeUtil.getVisitorNodeId(nodeId, bm);
        try {
            assemblyVariablesVisitor = (AssemblyVariablesVisitor)SpringContextHolder.getBean(AssemblyVariablesVisitor.class);
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
        try {
            variable = assemblyVariablesVisitor.assemblyVariables(beanId, businessId);
        }
        catch (Exception e) {
            return new HashMap<String, Object>();
        }
        variable = CommonCodeUtil.getRealVaribles(variable, nodeId, procDefKey, Integer.parseInt(realVersion), procDefId);
        CommonCodeUtil.handleVariables(variable);
        return variable;
    }

    public static void handleVariables(Map<String, Object> variable) {
        for (Map.Entry<String, Object> k : variable.entrySet()) {
            Object date;
            if (k.getValue() == null) continue;
            String className = k.getValue().getClass().getName();
            if ("java.lang.String".equals(className) && HussarUtils.isNotEmpty((Object)(date = CommonCodeUtil.isValidDate(k.getValue().toString())))) {
                variable.put(k.getKey(), date);
            }
            if (!"java.math.BigDecimal".equals(className)) continue;
            BigDecimal bigDecimal = (BigDecimal)k.getValue();
            if (new BigDecimal(bigDecimal.longValue()).compareTo(bigDecimal) == 0) {
                variable.put(k.getKey(), bigDecimal.longValue());
                continue;
            }
            variable.put(k.getKey(), bigDecimal.doubleValue());
        }
    }

    private static Object isValidDate(String str) {
        SimpleDateFormat format;
        String yMdhmsRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0[1-9]|1[0-2])([-/]?)(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        String yMdRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0?[1-9]|1[0-2])\\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\\1(?:29|30)|(?:0?[13578]|1[02])\\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/]?)0?2\\2(?:29))$";
        String yMRegex = "^\\d{4}([-/]?)(0[1-9]|1[0-2])$";
        String hmsRegex = "([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (str.length() == 7) {
            if (!str.matches(yMRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM");
        } else if (str.length() == 10) {
            if (!str.matches(yMdRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd");
        } else if (str.length() == 8) {
            if (!str.matches(hmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            if (!str.matches(yMdhmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            format.setLenient(false);
            return format.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String getVisitorNodeId(String id, BpmnModel bm) {
        Process process = (Process)bm.getProcesses().get(0);
        int num = process.getFlowElements().size();
        while (id.startsWith("jxd_bpm_custom_node")) {
            id = id.contains("parallel_node") ? id.split("parallel_node")[1] : ((SequenceFlow)((FlowNode)bm.getFlowElement(id)).getIncomingFlows().get(0)).getSourceRef();
            if (--num >= 0) continue;
            throw new PublicClientException("\u6d41\u7a0b\u56fe\u5f02\u5e38");
        }
        return id;
    }

    public static void triggerEventHandleClass(Map<String, Object> map) {
        BpmnModel bm = repositoryService.getBpmnModel((String)map.get("processDefinitionId"));
        String type = "";
        Object tType = map.get("type");
        if (HussarUtils.isNotEmpty((Object)tType)) {
            type = tType.toString();
        }
        if ("processCreateEnd".equals(type)) {
            activityRedisTimerService.addGlobalTimeOutModel(bm, map);
        } else if ("processCompleteEnd".equals(type)) {
            activityRedisTimerService.delGlobalTimeOutModel(map);
        }
    }

    private CommonCodeUtil() {
    }

    public static Map<String, Object> getRealVaribles(Map<String, Object> varibles, String nodeId, String procDefKey, Integer version, String procDefId) {
        List sequenceFlowList;
        String targetRef;
        FlowElement flowElement;
        HashMap<String, Object> realVaribles = new HashMap<String, Object>();
        WorkFlow workFlow = sysActProcessFileService.getFileByProcessKey(procDefKey, version);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        String taskDefinitionKey = "";
        BpmnModel bpmnModel = repositoryService.getBpmnModel(procDefId);
        if (bpmnModel == null) {
            return null;
        }
        Process process = bpmnModel.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement2 : flowElements) {
            if (!(flowElement2 instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement2;
            break;
        }
        if ((flowElement = process.getFlowElement(targetRef = ((SequenceFlow)(sequenceFlowList = startEvent.getOutgoingFlows()).get(0)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = flowElement.getId();
        }
        if (flowElement instanceof ExclusiveGateway) {
            taskDefinitionKey = null;
        }
        if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
            return null;
        }
        List elements = flowModel.getSlots().getElement();
        ArrayList useVariables = new ArrayList();
        for (FlowObject flowObject : elements) {
            FlowRecipients flowRecipients;
            if (taskDefinitionKey.equals(nodeId) && "com.jxdinfo.workflow.Annotation".equals(flowObject.getName()) && ToolUtil.isNotEmpty((Object)flowObject.getProps().getUseVariables())) {
                useVariables.addAll(flowObject.getProps().getUseVariables());
            }
            if (flowObject.getId().equals(nodeId)) {
                if ("com.jxdinfo.workflow.CallActivity".equals(flowObject.getName())) {
                    realVaribles.put("call_activity_info", varibles.get("call_activity_info"));
                }
                if (ToolUtil.isNotEmpty((Object)flowObject.getProps().getUseVariables())) {
                    useVariables.addAll(flowObject.getProps().getUseVariables());
                }
            }
            if (flowModel.getProps().getUseVariables() != null) {
                useVariables.addAll(flowModel.getProps().getUseVariables());
            }
            HashSet<String> functionIds = new HashSet<String>();
            FlowAssignment flowAssignment = flowObject.getProps().getFlowAssignment();
            if (ToolUtil.isNotEmpty((Object)flowAssignment)) {
                CommonCodeUtil.getFunctionIds(flowAssignment.getDefaultBackCondtion(), functionIds);
                if (ToolUtil.isNotEmpty((Object)flowAssignment.getJudgeBackCondition())) {
                    for (Object judgeBackCondition : flowAssignment.getJudgeBackCondition()) {
                        CommonCodeUtil.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)(flowRecipients = flowObject.getProps().getFlowRecipients()))) {
                CommonCodeUtil.getFunctionIds(flowRecipients.getDefaultCcCondtion(), functionIds);
                if (ToolUtil.isNotEmpty((Object)flowRecipients.getJudgeCcCondition())) {
                    Object judgeBackCondition;
                    judgeBackCondition = flowRecipients.getJudgeCcCondition().iterator();
                    while (judgeBackCondition.hasNext()) {
                        JudgeBackCondition judgeBackCondition2 = (JudgeBackCondition)judgeBackCondition.next();
                        CommonCodeUtil.getFunctionIds(judgeBackCondition2.getJudgeSpellCondition(), functionIds);
                    }
                }
            }
            List flowFunctionConfigs = flowObject.getProps().getFlowFunctionConfig();
            ArrayList functionUserVariables = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)flowFunctionConfigs)) {
                for (FlowFunctionConfig flowFunctionConfig : flowFunctionConfigs) {
                    if (!functionIds.contains(flowFunctionConfig.getId()) || !ToolUtil.isNotEmpty((Object)flowFunctionConfig.getUseVariables())) continue;
                    functionUserVariables.addAll(flowFunctionConfig.getUseVariables());
                }
            }
            if (!ToolUtil.isNotEmpty(functionUserVariables)) continue;
            useVariables.addAll(functionUserVariables);
        }
        for (FlowVariables useVariable : useVariables) {
            String key = useVariable.getVariable();
            if ("bpm_next_node".equals(key) || !varibles.containsKey(key)) continue;
            realVaribles.put(key, varibles.get(key));
        }
        return realVaribles;
    }

    private static void getFunctionIds(String assignee, Set<String> functionsIds) {
        if (ToolUtil.isNotEmpty((Object)assignee) && assignee.contains("@")) {
            Matcher matcher = regex.matcher(assignee);
            while (matcher.find()) {
                functionsIds.add(matcher.group().substring(2, matcher.group().length() - 2));
            }
        }
    }

    static {
        modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
        sysActProcessFileService = (SysActProcessFileService)SpringContextHolder.getBean(SysActProcessFileService.class);
        repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
        activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
        regex = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    }
}

