/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formerlycommon.util.datasource.DataSourceUtil;
import com.jxdinfo.hussar.identity.organ.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.identity.organ.model.BpmTreeModel;
import com.jxdinfo.hussar.identity.organ.service.AssigneeFunctionEyService;
import com.jxdinfo.hussar.identity.organ.service.IAssigneeChooseEyService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.identity.Authentication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    AssigneeChooseMapper assigneeChooseMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private HistoryService historyService;
    @Resource
    private ModelMapper modelMapper;
    private static final String DEFAULT_ORGAN_PARENTID = "1";
    public static final String ORGAN = "organ";
    public static final String USER = "user";
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final Pattern ORGAN_CONTAINS_CHILD_REGEX = Pattern.compile("O.PARENT_ID( NOT)? CONTAINSCHILD \\('([^)])*\\)");
    private static final Pattern RoleRegex = Pattern.compile("R.GRANTED_ROLE (NOT )?IN \\(([^)])*\\)");

    public List<BpmTreeModel> roleTree(boolean isInterface) {
        try {
            List<BpmTreeModel> result = this.assigneeChooseMapper.roleTree(null);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIds.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
        }
    }

    public List<BpmTreeModel> roleTree(String id, boolean isInterface) {
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_ORGAN_PARENTID : id;
        try {
            List<BpmTreeModel> result = this.assigneeChooseMapper.roleTree(Long.parseLong(newId));
            ArrayList<Long> parentIds = new ArrayList<Long>();
            for (BpmTreeModel bpmTreeModel : result) {
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
            }
            if (!parentIds.isEmpty()) {
                HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeChooseMapper.getNotLeafRoleParentIds(this.getInListSqlCondition(parentIds)));
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
        }
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        if (HussarUtils.isEmpty((Object)roleName)) {
            return new ArrayList<BpmTreeModel>();
        }
        roleName = roleName.replace("%", "\\%").replace("_", "\\_");
        List<BpmTreeModel> result = this.assigneeChooseMapper.queryRoleTreeByRoleName(roleName);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (BpmTreeModel bpmTreeModel : result) {
            parentIds.add(Long.valueOf(bpmTreeModel.getId()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<Long> parentIdList = new HashSet<Long>(this.assigneeChooseMapper.getNotLeafRoleParentIds(this.getInListSqlCondition(parentIds)));
            for (BpmTreeModel bpmTreeModel : result) {
                if (!parentIdList.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                bpmTreeModel.setIsLeaf("false");
            }
        }
        return this.queryAllTreeByChildrenNode(result, 1);
    }

    public List<String> getCandidateUser(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        String serviceName = null;
        if (this.lcdpBpmProperties.isStartAlone()) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        condition = this.getRealCondition(condition);
        condition = this.getRoleResultCondition(condition);
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT O.ORGAN_ID AS userId ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append("LEFT JOIN V_USER_INFO U ON O.ORGAN_ID = U.USER_ID").append("  WHERE O.ORGAN_TYPE = 'user' AND  U.ACCOUNT_STATUS <> '2'  ");
                sb.append(condition);
                String sql = sb.toString().replace("''", "'0'");
                DataSourceUtil.changeTempDs((String)"master");
                ArrayList<String> result = new ArrayList<String>(new HashSet<String>(this.assigneeChooseMapper.getCandidateUsers(sql, securityLevel)));
                DataSourceUtil.poll();
                return result;
            }
            catch (Exception e) {
                throw new PublicClientException(this.bpmConstantProperties.getErrorGetAssignee());
            }
        }
        try {
            IAssigneeChooseEyService assigneeChooseEyService = (IAssigneeChooseEyService)SpringContextHolder.getBean(IAssigneeChooseEyService.class);
            return assigneeChooseEyService.getCandidateUser(condition, securityLevel, false);
        }
        catch (Exception e) {
            throw new PublicClientException("\u83b7\u53d6\u53c2\u4e0e\u8005\u5f02\u5e38");
        }
    }

    private String getFunctionCondition(String realCondition, Map<String, String> processInfo, String serviceName) {
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSON.parse((String)message), processInfo, serviceName);
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    private List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo, String serviceName) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        if (beanId == null) {
            return new ArrayList<String>();
        }
        Map map = (Map)message.get(beanId);
        map.putAll(processInfo);
        if (!this.lcdpBpmProperties.isStartAlone()) {
            AssigneeVisitor hussarBpmVariablesVisitor;
            try {
                hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((String)beanId);
            }
            catch (NoSuchBeanDefinitionException e) {
                return new ArrayList<String>();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new ArrayList<String>();
            }
            return hussarBpmVariablesVisitor.visit(map);
        }
        try {
            AssigneeFunctionEyService assigneeFunctionService = (AssigneeFunctionEyService)SpringContextHolder.getBean(AssigneeFunctionEyService.class);
            return assigneeFunctionService.executeListener(beanId, map, serviceName);
        }
        catch (NoSuchBeanDefinitionException e) {
            return new ArrayList<String>();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private String getRealCondition(String realCondition) {
        if (realCondition.contains("CONTAINSCHILD")) {
            DataSourceUtil.changeTempDs((String)"master");
            List<AssigneeChooseDto> allOrgans = this.assigneeChooseMapper.getAllOrgans();
            DataSourceUtil.poll();
            HashMap<String, ArrayList<String>> maps = new HashMap<String, ArrayList<String>>();
            for (AssigneeChooseDto assigneeChooseDto : allOrgans) {
                String organId = assigneeChooseDto.getUserId();
                String parentId = assigneeChooseDto.getParentId();
                ArrayList<String> list = (ArrayList<String>)maps.get(parentId);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(organId);
                maps.put(parentId, list);
            }
            Matcher organMatcher = ORGAN_CONTAINS_CHILD_REGEX.matcher(realCondition);
            while (organMatcher.find()) {
                int i;
                String organCondition = organMatcher.group();
                String[] organConditions = organCondition.split("'");
                ArrayList<String> organIds = new ArrayList<String>();
                for (i = 1; i < organConditions.length; i += 2) {
                    organIds.add(organConditions[i]);
                }
                for (i = 0; i < organIds.size(); ++i) {
                    List addOrgans = (List)maps.get(organIds.get(i));
                    if (addOrgans == null) continue;
                    organIds.addAll(addOrgans);
                }
                organIds = new ArrayList(new HashSet(organIds));
                StringBuilder stringBuilder = new StringBuilder();
                boolean isConditionNotIn = organCondition.contains("NOT CONTAINSCHILD");
                if (isConditionNotIn) {
                    stringBuilder.append("O.PARENT_ID NOT IN (");
                } else {
                    stringBuilder.append("O.PARENT_ID IN (");
                }
                for (String s : organIds) {
                    stringBuilder.append("'").append(s).append("',");
                }
                stringBuilder.append("'')");
                String replactCondition = stringBuilder.toString();
                while (replactCondition.contains(",''")) {
                    replactCondition = replactCondition.replace(",''", "");
                }
                while (replactCondition.contains("'',")) {
                    replactCondition = replactCondition.replace("'',", "");
                }
                if (replactCondition.contains("('')")) {
                    replactCondition = isConditionNotIn ? "1=1" : "1!=1";
                }
                realCondition = realCondition.replace(organCondition, replactCondition);
            }
        }
        return realCondition;
    }

    private String getRoleResultCondition(String condition) {
        String realCondition = condition;
        if (realCondition.contains("R.GRANTED_ROLE")) {
            Matcher matcher = RoleRegex.matcher(realCondition);
            String roles = "";
            ArrayList<String> replaceCondition = new ArrayList<String>();
            while (matcher.find()) {
                replaceCondition.add(matcher.group());
                roles = roles + "," + matcher.group().substring(matcher.group().indexOf("(") + 1, matcher.group().length() - 1);
            }
            List<Map<String, String>> userRoleMap = this.assigneeChooseMapper.getUserRole(roles.substring(1));
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map<String, String> roleMap : userRoleMap) {
                String user = (String)map.get(String.valueOf(roleMap.get("ROLE")));
                user = user != null ? user + "','" + String.valueOf(roleMap.get("USERID")) : String.valueOf(roleMap.get("USERID"));
                map.put(String.valueOf(roleMap.get("ROLE")), user);
            }
            Iterator<Map<String, String>> iterator = replaceCondition.iterator();
            while (iterator.hasNext()) {
                String oldCondition;
                String newCondition = oldCondition = (String)((Object)iterator.next());
                String role = (newCondition = newCondition.replace("R.GRANTED_ROLE", "O.ORGAN_ID")).substring(newCondition.indexOf("(") + 2, newCondition.length() - 2);
                if (!"".equals(role)) {
                    if (role.contains(",")) {
                        role = role.replace("'", "");
                        String newRole = "";
                        for (String str : role.split(",")) {
                            newRole = newRole + "','" + (map.get(str) == null ? "" : (String)map.get(str));
                        }
                        newCondition = newCondition.replace(role, newRole.substring(3));
                    } else {
                        newCondition = newCondition.replace(role, map.get(role) == null ? "" : (CharSequence)map.get(role));
                    }
                }
                realCondition = realCondition.replace(oldCondition, newCondition);
            }
            return realCondition;
        }
        return realCondition;
    }

    private List<BpmTreeModel> queryAllTreeByChildrenNode(List<BpmTreeModel> childrenNode, Integer type) {
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        List<BpmTreeModel> allDept = type == 0 ? this.assigneeChooseMapper.getAllDept() : this.assigneeChooseMapper.getAllRole();
        HashMap<String, BpmTreeModel> deptMap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptMap.put(dept.getId(), dept);
        }
        block1: for (BpmTreeModel bpmTreeModel : childrenNode) {
            BpmTreeModel children = bpmTreeModel;
            if (deptMap.containsKey(children.getId())) {
                children = (BpmTreeModel)deptMap.get(children.getId());
            }
            while (true) {
                if (!deptMap.containsKey(children.getParentId())) {
                    int i;
                    for (BpmTreeModel rootNode : result) {
                        if (!rootNode.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < result.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)result.get(i)).getType())) {
                                result.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < result.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)result.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    }
                    result.add(children);
                    continue block1;
                }
                BpmTreeModel parent = (BpmTreeModel)deptMap.get(children.getParentId());
                ArrayList<BpmTreeModel> childrenList = parent.getChildrenList();
                if (!HussarUtils.isEmpty((Object)childrenList)) {
                    int i;
                    for (BpmTreeModel parentChildrenList : childrenList) {
                        if (!parentChildrenList.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)childrenList.get(i)).getType())) {
                                childrenList.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)childrenList.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    }
                    childrenList.add(children);
                    continue block1;
                }
                childrenList = new ArrayList<BpmTreeModel>();
                childrenList.add(children);
                parent.setChildrenList(childrenList);
                children = parent;
            }
        }
        return result;
    }

    private List<List<Long>> getInListSqlCondition(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }
}

