/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.common.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.dao.SysActExtendPropertiesMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class SysActExtendPropertiesServiceImpl
extends HussarServiceImpl<SysActExtendPropertiesMapper, SysActExtendProperties>
implements ISysActExtendPropertiesService {
    @Resource
    SysActExtendPropertiesMapper sysActExtendPropertiesMapper;

    public SysActExtendProperties queryList(String taskDefKey, String processDefId) {
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(SysActExtendProperties::getTaskDefKey, (Object)taskDefKey);
        ew.eq(SysActExtendProperties::getProcDefId, (Object)processDefId);
        SysActExtendProperties sysActExtendProperties = (SysActExtendProperties)this.sysActExtendPropertiesMapper.selectOne((Wrapper)ew);
        return sysActExtendProperties;
    }

    @Cacheable(value={"form_detail_key"}, key="'form_detail_key:'+#processDefinitionId+'-'+#taskDefinitionKey", unless="#result == null || #result == ''")
    public String getFormDetailKey(String processDefinitionId, String taskDefinitionKey) {
        String formDetailKey = null;
        LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)processDefinitionId)).eq(SysActExtendProperties::getTaskDefKey, (Object)taskDefinitionKey);
        SysActExtendProperties extendProperties = (SysActExtendProperties)this.sysActExtendPropertiesMapper.selectOne((Wrapper)extendPropertiesWrapper);
        if (ToolUtil.isNotEmpty((Object)extendProperties)) {
            formDetailKey = String.valueOf(extendProperties.getFormDetailKey());
        }
        return formDetailKey;
    }

    public boolean insertBatch(List<SysActExtendProperties> list) {
        return this.sysActExtendPropertiesMapper.insertBatch(list);
    }

    public BpmResponseResult actExtendPropertiesImport(List<SysActExtendProperties> list) {
        for (SysActExtendProperties sysActExtendProperties : list) {
            this.saveOrUpdate((BaseEntity)sysActExtendProperties);
        }
        return InstallResult.success();
    }

    public BpmResponseResult actExtendPropertiesExportData(String processKey, Integer version) {
        String procDefId = processKey + ":" + version;
        ArrayList list = new ArrayList();
        List sysActExtendProperties = new SysActExtendProperties().selectList((Wrapper)new LambdaQueryWrapper().like(SysActExtendProperties::getProcDefId, (Object)procDefId));
        if (HussarUtils.isNotEmpty((Object)sysActExtendProperties)) {
            list.addAll(sysActExtendProperties);
        }
        return InstallResult.success(list);
    }
}

