/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateuser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ExtendDataDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extenddata.service.WorkflowExtendDataService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class StartAndCompleteBatchCmd
extends AddAttributeCmd<ProcessInstance> {
    private WorkflowExtendDataService workflowExtendDataService = (WorkflowExtendDataService)BpmSpringContextHolder.getBean(WorkflowExtendDataService.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)BpmSpringContextHolder.getBean(ISysActCcTaskService.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)BpmSpringContextHolder.getBean(BpmConstantProperties.class);
    protected DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);
    private ICandidateUserService candidateUserService = (ICandidateUserService)BpmSpringContextHolder.getBean(ICandidateUserService.class);
    private String processDefinitionId;
    private String businessKey;
    private String comment;
    private String userId;
    private String processTitle;
    private String dataDetail;
    private Map<String, Object> variables;
    private Map<String, Object> paramMap;

    public StartAndCompleteBatchCmd(String processDefinitionId, String businessKey, String comment, String userId, String processTitle, String dataDetail, Map<String, Object> variables, Map<String, Object> paramMap) {
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.comment = comment;
        this.userId = userId;
        this.processTitle = processTitle;
        this.dataDetail = dataDetail;
        this.variables = variables;
        this.paramMap = paramMap;
    }

    public ProcessInstance execute(CommandContext commandContext) {
        commandContext.addAttribute("no_data_push_handle_flag", (Object)"true");
        commandContext.addAttribute("ACTIVITI_START_AND_COMPLETE_TAG", (Object)"true");
        this.addAttribute(commandContext);
        commandContext.addAttribute("handleType", (Object)"start");
        ExecutionEntity processInstance = this.start(commandContext);
        List tasks = processInstance.getTasks();
        if (HussarUtils.isEmpty((Object)tasks)) {
            tasks = commandContext.getDbSqlSession().findInCache(TaskEntity.class);
        }
        TaskEntity taskEntity = (TaskEntity)tasks.get(0);
        if (tasks.size() > 1) {
            boolean isDellaySetAssignee = ((TaskEntity)tasks.get(0)).getIdentityLinks().isEmpty();
            if (isDellaySetAssignee) {
                List taskIds = tasks.stream().map(TaskEntity::getLongId).collect(Collectors.toList());
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.in(CandidateUser::getTaskId, taskIds);
                List list = this.candidateUserService.list((Wrapper)lambdaQueryWrapper);
                Map<String, CandidateUser> candidateUserMap = WorkflowBpmUtil.getMap(list, CandidateUser::getTaskId, null);
                for (TaskEntity task : tasks) {
                    CandidateUser candidateUser = candidateUserMap.get(task.getId());
                    if (!this.userId.equals(candidateUser.getAssignee())) continue;
                    taskEntity = task;
                    this.candidateUserService.removeById((Serializable)candidateUser.getId());
                    break;
                }
            } else {
                for (TaskEntity task : tasks) {
                    List identityLinkEntities = task.getIdentityLinks();
                    if (!HussarUtils.isNotEmpty((Object)identityLinkEntities)) continue;
                    if (this.userId.equals(((IdentityLinkEntity)task.getIdentityLinks().get(0)).getUserId()) && ((IdentityLinkEntity)task.getIdentityLinks().get(0)).getMandator() == null) {
                        taskEntity = task;
                    } else {
                        if (!this.userId.equals(((IdentityLinkEntity)task.getIdentityLinks().get(0)).getMandator())) continue;
                        taskEntity = task;
                    }
                    break;
                }
            }
        } else if (taskEntity.getIdentityLinks().isEmpty()) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CandidateUser::getTaskId, (Object)taskEntity.getLongId());
            this.candidateUserService.remove((Wrapper)lambdaQueryWrapper);
        }
        taskEntity.setAssignee(this.userId, true, true);
        if (HussarUtils.isNotEmpty(this.paramMap) && this.workflowExtendDataService != null) {
            ExtendDataDto extendDataDto = new ExtendDataDto();
            extendDataDto.setTaskId(taskEntity.getId());
            extendDataDto.setExtendData(this.paramMap);
            extendDataDto.setProcessKey(taskEntity.getProcessKey());
            extendDataDto.setProcessInsId(taskEntity.getProcessInstanceId());
            this.workflowExtendDataService.addExtendData(extendDataDto);
        }
        this.addExecutionAttribute(processInstance);
        processInstance.addTempVariable("taskSourceFlag", (Object)"complete");
        this.complete(commandContext, taskEntity);
        return processInstance;
    }

    private ExecutionEntity start(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
        }
        if (processDefinition.isSuspended()) {
            throw new ActivitiException(processDefinition.getName() + "\u5df2\u6302\u8d77");
        }
        String organId = processDefinition.getProcessTag();
        String processKey = this.processDefinitionId.split(":")[0];
        if (modelService.getProcessModelStatus(processKey, organId)) {
            throw new ActivitiException(processDefinition.getName() + "\u5df2\u6302\u8d77");
        }
        processDefinition.setProcessTitle(this.processTitle);
        processDefinition.setDataDetail(this.dataDetail);
        ExecutionEntity processInstance = processDefinition.createEmulationProcessInstance(this.businessKey, null);
        processInstance.recoredTasksNewArrayList();
        this.addExecutionAttribute(processInstance);
        Object securityLevel = this.variables.remove("security_level");
        if (securityLevel != null) {
            if (securityLevel instanceof Integer) {
                commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstance.getId()).setSecurityLevel((Integer)securityLevel);
            } else {
                throw new BpmException(bpmConstantProperties.getErrorSecretLevelType());
            }
        }
        this.initializeVariables(processInstance);
        processInstance.fireEventExecution("beforeStart");
        processInstance.start();
        return processInstance;
    }

    private void complete(CommandContext commandContext, TaskEntity taskEntity) {
        Object isPushMobileMessage;
        if (HussarUtils.isNotEmpty(this.paramMap) && HussarUtils.isNotEmpty((Object)(isPushMobileMessage = this.paramMap.get("isPushMobileMessage")))) {
            commandContext.addAttribute("isPushMobileMessage", (Object)Boolean.valueOf(isPushMobileMessage.toString()));
        }
        if (HussarUtils.isNotEmpty((Object)this.comment)) {
            CommentEntity commentEntity = new CommentEntity();
            commentEntity.setUserId(this.userId);
            commentEntity.setType("complete");
            commentEntity.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
            commentEntity.setTaskId(taskEntity.getId());
            commentEntity.setProcessInstanceId(null);
            commentEntity.setAction("AddComment");
            String eventMessage = this.comment.replaceAll("\\s+", " ");
            if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
                eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
            }
            commentEntity.setMessage(eventMessage);
            commentEntity.setFullMessage(this.comment);
            commandContext.getCommentEntityManager().insert((PersistentObject)commentEntity);
        }
        commandContext.addAttribute("bpm_submit_source", (Object)taskEntity.getTaskDefinitionKey());
        taskEntity.getExecution().setAllPrevNode(taskEntity.getTaskDefinitionKey());
        if (taskEntity.getDelegationState() != null) {
            taskEntity.resolve();
        }
        taskEntity.fireEvent("beforeComplete");
        if (taskEntity.getExecutionId() != null) {
            taskEntity.setExecutionVariables(this.variables);
        } else {
            taskEntity.setVariables(this.variables);
        }
        ParamModel paramModel = this.getParamModel(taskEntity, this.variables);
        Context.getCommandContext().addAttribute("listenerParam", (Object)paramModel);
        taskEntity.complete(this.variables, false, null);
        if (HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(taskEntity.getId());
        }
        List ccTaskEntityList = Context.getCommandContext().getCcTaskEntityManager().getCcTaskByProcessInsIdAndTaskDefKey(taskEntity.getTaskDefinitionKey(), Long.valueOf(Long.parseLong(taskEntity.getProcessInstanceId())));
        ArrayList<CcTaskEntity> privateCcTaskEntityList = new ArrayList<CcTaskEntity>();
        List<Object> userList = new ArrayList();
        userList = Arrays.asList(this.userId.split(","));
        for (CcTaskEntity ccTaskEntity : ccTaskEntityList) {
            if (!userList.contains(ccTaskEntity.getReceiveUser()) || !"0".equals(ccTaskEntity.getTaskState())) continue;
            privateCcTaskEntityList.add(ccTaskEntity);
        }
        if (HussarUtils.isNotEmpty(privateCcTaskEntityList)) {
            Date date = new Date();
            Timestamp endTime = new Timestamp(date.getTime());
            for (CcTaskEntity sysActCcTask : privateCcTaskEntityList) {
                sysActCcTask.setTaskState("1");
                sysActCcTask.setEndTime(endTime);
                String version = sysActCcTask.getProcDefId().split(":")[1];
                Map<String, JSONObject> pageTypeMap = CommonCodeUtil.getPageTypeByTaskType(sysActCcTask.getProcDefKey(), Integer.valueOf(version), taskEntity.getTaskDefinitionKey(), "ccDone");
                sysActCcTask.setPageType(JSON.toJSONString(pageTypeMap));
                sysActCcTask.updateCcTask();
                if (!this.dataPushService.isDataPush(sysActCcTask.getProcDefId())) continue;
                DataPush dataPush = new DataPush();
                dataPush.setUserId(sysActCcTask.getReceiveUser());
                dataPush.setTaskId(String.valueOf(sysActCcTask.getTaskId()));
                dataPush.setEndDate((Date)sysActCcTask.getEndTime());
                dataPush.setCcMoment(sysActCcTask.getCcMoment() == null ? "0" : sysActCcTask.getCcMoment());
                dataPush.setProcessInsId(String.valueOf(sysActCcTask.getProcessInsId()));
                this.dataPushService.readCcTask(dataPush);
            }
        }
    }

    protected void initializeVariables(ExecutionEntity processInstance) {
        if (this.variables != null) {
            processInstance.setVariables(this.variables);
        }
    }

    public ParamModel getParamModel(TaskEntity task, Map<String, Object> variables) {
        ParamModel paramModel = new ParamModel();
        paramModel.mappingCompleteType(BpmAttribute.getTaskSourceFlag(task));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        paramModel.setEndTime(simpleDateFormat.format(new Date()));
        paramModel.setCreateTime(simpleDateFormat.format(task.getCreateTime()));
        paramModel.setHandler(this.userId);
        paramModel.setLastNodeId(task.getTaskDefinitionKey());
        paramModel.setLastTaskId(task.getId());
        paramModel.setLastNodeName(task.getName());
        paramModel.mappingLastCompleteType(BpmAttribute.getTaskSourceFlag(task));
        paramModel.setLastNodeHandler(this.userId);
        paramModel.setSendUser(this.userId);
        paramModel.setCreateReason("completeCreate");
        return paramModel;
    }
}

