/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.general.calendar.service.ISysCalendarRefService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeSaveTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;

public class MultiInstanceAddAssigneeCmd
implements Command<Map<String, String>> {
    protected String executionId;
    protected List<String> assigneeList;
    private Map<String, Object> variableMap;
    private String userId;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getBean(ActivityRedisTimerService.class);
    private static ISysCalendarRefService sysCalendarRefService = (ISysCalendarRefService)BpmSpringContextHolder.getSpringContext().getBean(ISysCalendarRefService.class);
    private ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getSpringContext().getBean(ProcessEngine.class);

    public MultiInstanceAddAssigneeCmd(String executionId, List<String> assigneeList, Map<String, Object> variableMap) {
        this.executionId = executionId;
        this.assigneeList = assigneeList;
        this.variableMap = variableMap;
    }

    public MultiInstanceAddAssigneeCmd(String executionId, List<String> assigneeList, String userId, Map<String, Object> variableMap) {
        this.executionId = executionId;
        this.assigneeList = assigneeList;
        this.userId = userId;
        this.variableMap = variableMap;
    }

    public Map<String, String> execute(CommandContext commandContext) {
        if (this.assigneeList == null || this.assigneeList.isEmpty()) {
            return null;
        }
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        TaskService taskService = pec.getTaskService();
        IdGenerator idGenerator = pec.getIdGenerator();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        ExecutionEntity parent = ee.getParent();
        Task newTask = (Task)((TaskQuery)taskService.createTaskQuery().executionId(this.executionId)).singleResult();
        BpmnModel bm = commandContext.getProcessEngineConfiguration().getDeploymentManager().getBpmnModelById(newTask.getProcessDefinitionId());
        FlowElement element = bm.getFlowElement(newTask.getTaskDefinitionKey());
        TimeOutConfig timeOutConfig = TimeOutConfig.build(element);
        HashMap<String, String> newTaskIdMap = new HashMap<String, String>();
        ArrayList<TimeOutModel> timeOutModelList = new ArrayList<TimeOutModel>();
        for (String user : this.assigneeList) {
            TaskEntity t = (TaskEntity)newTask;
            ExecutionEntity newExecution = parent.createExecution();
            newExecution.setActive(true);
            newExecution.setConcurrent(true);
            newExecution.setScope(false);
            TaskEntity taskEntity = new TaskEntity();
            taskEntity.setNewTask(true);
            taskEntity.setVariableInstances();
            taskEntity.copyTaskProperty((TaskInfo)t);
            taskEntity.setCreateTime(new Date());
            taskEntity.setTaskDefinition(t.getTaskDefinition());
            taskEntity.setProcessDefinitionId(t.getProcessDefinitionId());
            taskEntity.setTaskDefinitionKey(t.getTaskDefinitionKey());
            taskEntity.setFormKey(t.getFormKey());
            taskEntity.setFormId(t.getFormId());
            taskEntity.setProcessInstanceId(t.getProcessInstanceId());
            taskEntity.setExecutionId(newExecution.getId());
            taskEntity.setNameTranslateKey(newTask.getNameTranslateKey());
            String taskId = idGenerator.getNextId();
            taskEntity.setId(taskId);
            taskEntity.setExecution(newExecution);
            taskEntity.addCandidateUser(user, null, null, null, this.userId);
            taskEntity.setAddAssigneeOperator(this.userId);
            taskEntity.setSendUser(t.getSendUser());
            taskEntity.setCompleteType(t.getCompleteType());
            taskEntity.setJumpInfo(t.getJumpInfo());
            taskEntity.setSubProcessKey(t.getSubProcessKey());
            taskEntity.setCycleCount(t.getCycleCount());
            taskEntity.setProcessCycleCount(t.getProcessCycleCount());
            taskEntity.setSubmitToRejectNode(t.getSubmitToRejectNode());
            String version = t.getProcessDefinitionId().split(":")[1];
            Map<String, JSONObject> pageTypeMap = CommonCodeUtil.getPageTypeByTaskType(t.getProcessKey(), Integer.valueOf(version), t.getTaskDefinitionKey(), "todo");
            taskEntity.setPageType(JSON.toJSONString(pageTypeMap));
            newTaskIdMap.put(user, taskId);
            MultiInstanceAddAssigneeCmd.setDueDate(taskEntity, timeOutConfig, ee, newTask);
            MultiInstanceAddAssigneeCmd.setWarningDate(taskEntity, timeOutConfig, ee, newTask);
            List<TimeOutModel> timeOutModels = timeOutConfig.buildTimeOutModel(taskEntity, Collections.singleton(user), null);
            if (timeOutModels != null) {
                timeOutModelList.addAll(timeOutModels);
            }
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeSaveTaskCmd((Task)taskEntity, (Execution)taskEntity.getExecution()));
            taskService.setVariablesLocal(taskEntity.getId(), this.variableMap);
            int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(newExecution, "nrOfInstances");
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(newExecution, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(newExecution, "nrOfInstances", nrOfInstances + 1);
            MultiInstancePercentUtils.setLoopVariable(newExecution, "nrOfActiveInstances", nrOfActiveInstances + 1);
        }
        this.activityRedisTimerService.addTimeOutModels(timeOutModelList);
        return newTaskIdMap;
    }

    private static void setWarningDate(TaskEntity taskEntity, TimeOutConfig timeOutConfig, ExecutionEntity ee, Task copy) {
        String warningDateConfig = timeOutConfig.getWarningDate();
        if (HussarUtils.isNotEmpty((Object)warningDateConfig) && HussarUtils.isNotEmpty((Object)taskEntity.getDueDate())) {
            String warningDateType = timeOutConfig.getWarningDateType();
            if ("workingDay".equals(warningDateType)) {
                Date date = taskEntity.getDueDate();
                Instant instant = date.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getBeginDateDefult(localDateTime, warningDateConfig, true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                Date warningDate = Date.from(instant2);
                taskEntity.setWarningDate(warningDate);
            } else {
                Date warningDate = TimeOutConfig.getWarningDate((ActivityExecution)ee, warningDateConfig, taskEntity.getDueDate());
                taskEntity.setWarningDate(warningDate);
            }
        }
    }

    private static void setDueDate(TaskEntity taskEntity, TimeOutConfig timeOutConfig, ExecutionEntity ee, Task copy) {
        Expression activeDueDateExpression = taskEntity.getTaskDefinition().getDueDateExpression();
        if (activeDueDateExpression != null) {
            String chosenDay = timeOutConfig.getChosenDay();
            if ("workingDay".equals(chosenDay)) {
                Date date = new Date();
                Instant instant = date.toInstant();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                LocalDateTime dueTime = sysCalendarRefService.getDueDateDefult(localDateTime, String.valueOf(activeDueDateExpression), true);
                ZonedDateTime zonedDateTime = dueTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                Date dueDate = Date.from(instant2);
                taskEntity.setDueDate(dueDate);
            } else {
                Object dueDate = activeDueDateExpression.getValue((VariableScope)ee);
                if (dueDate != null) {
                    if (dueDate instanceof Date) {
                        taskEntity.setDueDate((Date)dueDate);
                    } else if (dueDate instanceof String) {
                        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(taskEntity.getTaskDefinition().getBusinessCalendarNameExpression().getValue((VariableScope)ee).toString());
                        taskEntity.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
                    } else {
                        throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
                    }
                }
            }
        }
    }
}

