/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskQuery;

public class CompleteReturnValueCmd
implements Command<JSONArray> {
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)BpmSpringContextHolder.getBean(TaskEngineMapper.class);
    private ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getBean(ProcessEngine.class);
    private String processInsId;
    private String processDefId;
    private String taskDefinitionKey;
    private String subProcessKey;
    private Map<String, Object> variables;
    private boolean returnValueInMergeCmd;

    public CompleteReturnValueCmd(String processInsId, String processDefId, String taskDefinitionKey, String subProcessKey, Map<String, Object> variables) {
        this.processInsId = processInsId;
        this.processDefId = processDefId;
        this.taskDefinitionKey = taskDefinitionKey;
        this.subProcessKey = subProcessKey;
        this.variables = variables;
    }

    public CompleteReturnValueCmd(String processInsId, String processDefId, boolean returnValueInMergeCmd) {
        this.processInsId = processInsId;
        this.processDefId = processDefId;
        this.returnValueInMergeCmd = returnValueInMergeCmd;
    }

    public JSONArray execute(CommandContext commandContext) {
        JSONObject object;
        HistoricActivityInstance hi;
        Iterator iterator;
        Object historicActivityInstances;
        boolean isContainReceive;
        HistoricProcessInstanceEntity historicProcessInstance = null;
        if (this.processDefId == null) {
            historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.processInsId);
            this.processDefId = historicProcessInstance.getProcessDefinitionId();
        }
        BpmnModel bpmnModel = this.processEngine.getRepositoryService().getBpmnModel(this.processDefId);
        boolean containsCallActivity = false;
        boolean containsReceiveTask = false;
        for (FlowElement flowElement : bpmnModel.getMainProcess().getFlowElements()) {
            if (!containsCallActivity && flowElement instanceof CallActivity) {
                containsCallActivity = true;
                continue;
            }
            if (containsReceiveTask || !(flowElement instanceof ReceiveTask)) continue;
            containsReceiveTask = true;
        }
        JSONArray json = new JSONArray();
        List<Object> callActivityInstIds = new ArrayList<String>();
        if (containsCallActivity) {
            callActivityInstIds = this.taskEngineMapper.getCallActivityInstId(Long.parseLong(this.processInsId));
        }
        TaskQuery taskQuery = this.processEngine.getTaskService().createTaskQuery();
        callActivityInstIds.add(this.processInsId);
        if (callActivityInstIds.size() == 1) {
            taskQuery.processInstanceId(this.processInsId);
        } else {
            taskQuery.processInstanceIdIn(callActivityInstIds);
        }
        taskQuery.list();
        List tasks = commandContext.getDbSqlSession().findAliveEntityInCache(TaskEntity.class);
        List<Object> mainCallActivityInstIds = new ArrayList();
        boolean bl = isContainReceive = containsReceiveTask && !this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(this.processInsId).activityType("receiveTask").unfinished().list().isEmpty();
        if (isContainReceive) {
            historicActivityInstances = this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(this.processInsId).activityType("receiveTask").unfinished().list();
            iterator = historicActivityInstances.iterator();
            while (iterator.hasNext()) {
                hi = (HistoricActivityInstance)iterator.next();
                object = new JSONObject();
                object.put("processInsId", (Object)hi.getProcessInstanceId());
                object.put("executionId", (Object)hi.getExecutionId());
                object.put("type", (Object)"receiveTask");
                object.put("taskDefinitionKey", (Object)hi.getActivityId());
                object.put("taskDefinitionName", (Object)hi.getActivityName());
                object.put("sub_process_key", (Object)hi.getSubProcessKey());
                object.put("taskDefinitionNameTranslateTag", (Object)hi.getActivityNameTranslateKey());
                json.add((Object)object);
            }
        }
        if (HussarUtils.isEmpty((Object)tasks) && !isContainReceive) {
            if (historicProcessInstance == null) {
                historicProcessInstance = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.processInsId);
            }
            if (HussarUtils.isNotEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                String superProcessInstanceId = historicProcessInstance.getSuperProcessInstanceId();
                mainCallActivityInstIds = this.taskEngineMapper.getCallActivityInstId(Long.parseLong(superProcessInstanceId));
                mainCallActivityInstIds.add(superProcessInstanceId);
                tasks = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceIdIn(mainCallActivityInstIds)).list();
                boolean bl2 = isContainReceive = !this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(superProcessInstanceId).activityType("receiveTask").unfinished().list().isEmpty();
                if (isContainReceive) {
                    historicActivityInstances = this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(superProcessInstanceId).activityType("receiveTask").unfinished().list();
                    iterator = historicActivityInstances.iterator();
                    while (iterator.hasNext()) {
                        hi = (HistoricActivityInstance)iterator.next();
                        object = new JSONObject();
                        object.put("processInsId", (Object)hi.getProcessInstanceId());
                        object.put("executionId", (Object)hi.getExecutionId());
                        object.put("type", (Object)"receiveTask");
                        object.put("taskDefinitionKey", (Object)hi.getActivityName());
                        object.put("taskDefinitionName", (Object)hi.getActivityId());
                        object.put("sub_process_key", (Object)hi.getSubProcessKey());
                        object.put("taskDefinitionNameTranslateTag", (Object)hi.getActivityNameTranslateKey());
                        json.add((Object)object);
                    }
                }
            }
        }
        if (tasks != null && !tasks.isEmpty()) {
            for (TaskEntity task : tasks) {
                HashSet<String> users = new HashSet<String>();
                if (task.getAssignee() != null) {
                    users.add(task.getAssignee());
                } else {
                    List identityLinkList = task.getIdentityLinks();
                    if (identityLinkList != null && !identityLinkList.isEmpty()) {
                        for (IdentityLink identityLink : identityLinkList) {
                            users.add(identityLink.getUserId());
                        }
                    }
                }
                object = new JSONObject();
                object.put("processInsId", (Object)task.getProcessInstanceId());
                object.put("taskId", (Object)task.getId());
                object.put("userId", users);
                object.put("startTime", (Object)task.getCreateTime());
                object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)task.getName());
                object.put("formKey", (Object)task.getFormKey());
                object.put("taskDefinitionNameTranslateTag", (Object)task.getNameTranslateKey());
                object.put("sub_process_key", (Object)task.getSubProcessKey());
                json.add((Object)object);
            }
        } else if (!isContainReceive) {
            JSONObject object2 = new JSONObject();
            object2.put("taskDefinitionName", BpmConstant.END_NAME);
            object2.put("endTime", (Object)new Date());
            json.add((Object)object2);
        }
        new ProcessActionCmd(this.processInsId, this.processDefId).execute(commandContext);
        new ProcessNodeCmd(this.processInsId).execute(commandContext);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)json, JSONObject.class).translate(e -> e.getString("taskDefinitionNameTranslateTag"), (e, s) -> e.put("taskDefinitionName", s)).execute();
        return json;
    }
}

