/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.UserTaskMultiInstanceBatchDelCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendParallelMultiInstanceBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;

public class MultiInstanceDelAssigneeCmd
implements Command<Void> {
    protected String executionId;
    protected String taskId;
    private List<String> assignees;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)BpmSpringContextHolder.getSpringContext().getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getSpringContext().getBean(DataPushService.class);

    public MultiInstanceDelAssigneeCmd(String executionId, String taskId, List<String> assignees) {
        this.executionId = executionId;
        this.taskId = taskId;
        this.assignees = assignees;
    }

    public Void execute(CommandContext commandContext) {
        int num;
        int nrOfInstances;
        ExecutionEntity ee;
        block13: {
            block15: {
                block14: {
                    String processDefinitionId;
                    String processKey;
                    Execution execution;
                    block12: {
                        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
                        RuntimeService runtimeService = pec.getRuntimeService();
                        execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
                        ee = (ExecutionEntity)execution;
                        nrOfInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfInstances");
                        num = 1;
                        if (nrOfInstances == 1) {
                            throw new BpmException(BpmExceptionCodeEnum.THE_ONLY_ASSIGNEE_IN_MULTI);
                        }
                        processKey = ee.getProcessDefinitionKey();
                        processDefinitionId = ee.getProcessDefinitionId();
                        if (this.assignees == null || this.assignees.isEmpty()) break block12;
                        num = new UserTaskMultiInstanceBatchDelCmd(ee.getParent(), this.assignees, null, false).execute(commandContext);
                        if (num == 0) {
                            return null;
                        }
                        break block13;
                    }
                    HistoricTaskInstanceEntity historicTaskInstanceEntity = commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(this.taskId);
                    if (historicTaskInstanceEntity.getParentTaskId() == null && historicTaskInstanceEntity.getDueDate() != null) {
                        this.activityRedisTimerService.delTimeOutModel(historicTaskInstanceEntity.getId());
                    }
                    commandContext.getHistoricTaskInstanceEntityManager().deleteHistoricTaskInstanceById(this.taskId);
                    HashSet<String> processDefinitionIdList = new HashSet<String>();
                    processDefinitionIdList.add(processDefinitionId);
                    if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                        DataPush dataPush = new DataPush();
                        dataPush.setProcessKey(processKey);
                        dataPush.setProcessDefinitionId(processDefinitionId);
                        dataPush.setTaskIds(new ArrayList<String>(Collections.singletonList(this.taskId)));
                        dataPush.setProcessInsId(execution.getProcessInstanceId());
                        this.dataPushService.deleteMultiTask(dataPush);
                    }
                    List executionEntities = ee.getParent().getExecutions();
                    String unDelTaskId = null;
                    block0: for (Object entity : executionEntities) {
                        if (!HussarUtils.isNotEmpty((Object)entity.getTasks())) continue;
                        for (TaskEntity task : entity.getTasks()) {
                            if (task.getParentTaskId() != null || this.taskId.equals(task.getId())) continue;
                            unDelTaskId = task.getId();
                            break block0;
                        }
                    }
                    if (!HussarUtils.isNotEmpty(unDelTaskId)) break block14;
                    List ccTasks = Context.getCommandContext().getCcTaskEntityManager().getCcTaskByProcessInsIdAndTaskDefKey(ee.getCurrentActivityId(), Long.valueOf(ee.getProcessInstanceId()));
                    if (!HussarUtils.isNotEmpty((Object)ccTasks)) break block15;
                    for (Object ccTask : ccTasks) {
                        if (!ccTask.getTaskId().equals(Long.parseLong(this.taskId))) continue;
                        ccTask.setTaskId(Long.valueOf(unDelTaskId));
                        ccTask.setUpdateTaskId(true);
                        ccTask.updateCcTask();
                    }
                    if (!this.dataPushService.isDataPush(processDefinitionIdList)) break block15;
                    ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
                    for (CcTaskEntity ccTask : ccTasks) {
                        DataPush dataPush = new DataPush();
                        dataPush.setUserId(ccTask.getReceiveUser());
                        dataPush.setTaskId(unDelTaskId);
                        dataPush.setStartDate((Date)ccTask.getSendTime());
                        dataPush.setEndDate((Date)ccTask.getEndTime());
                        dataPush.setCcMoment(ccTask.getCcMoment() == null ? "0" : ccTask.getCcMoment());
                        dataPush.setProcessInsId(String.valueOf(ccTask.getProcessInsId()));
                        dataPush.setProcessKey(ccTask.getProcDefKey());
                        dataPushList.add(dataPush);
                    }
                    this.dataPushService.addCcTask(dataPushList);
                    break block15;
                }
                List ccTaskEntityList = Context.getCommandContext().getCcTaskEntityManager().getCcTaskByProcessInsIdAndTaskDefKey(ee.getCurrentActivityId(), Long.valueOf(ee.getProcessInstanceId()));
                if (HussarUtils.isNotEmpty((Object)ccTaskEntityList)) {
                    for (CcTaskEntity ccTaskEntity : ccTaskEntityList) {
                        if (!Long.valueOf(this.taskId).equals(ccTaskEntity.getTaskId())) continue;
                        ccTaskEntity.deleteCcTask();
                    }
                }
            }
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfCompletedInstances");
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfInstances", nrOfInstances - num);
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        if (num > 1) {
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(ee, "nrOfActiveInstances", nrOfActiveInstances - num + 1);
        }
        ee.addTempVariable("taskSourceFlag", (Object)"complete");
        ActivityBehavior activityBehavior = ee.getActivity().getActivityBehavior();
        if (activityBehavior instanceof ExtendParallelMultiInstanceBehavior) {
            ((ExtendParallelMultiInstanceBehavior)activityBehavior).leave((ActivityExecution)ee);
        }
        return null;
    }
}

