/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.customsql.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.customsql.service.ICustomSqlService;
import com.jxdinfo.hussar.workflow.engine.bpm.customsql.service.IDbCustomSqlService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.customsql.service.CustomSqlOutSideService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomSqlServiceImpl
implements ICustomSqlService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private IDbCustomSqlService dbCustomSqlService;
    private static Logger logger = LogManager.getLogger(CustomSqlServiceImpl.class);
    private static final String MICRO = "micro";
    private static final String SINGLE = "single";
    private static final Pattern SQL_REGEX = Pattern.compile("\\@Sql\\{([^@]|[^}]\\@)*\\}\\@");
    private static final Pattern UPDATE_SQL_REGEX = Pattern.compile("[^'\"]\\b(CREATE|INSERT|DELETE|UPDATE|DROP|ALTER)\\b[^'\"]");

    public String getCustomSqlCondition(String realCondition, String serviceName) {
        if (realCondition.contains("@Sql{")) {
            Matcher matcher = SQL_REGEX.matcher(realCondition);
            while (matcher.find()) {
                Map sqlMap = (Map)JSON.parseObject((String)matcher.group().substring(5, matcher.group().length() - 2), Map.class);
                boolean isLegalSql = this.checkSql(sqlMap);
                if (!isLegalSql) {
                    return null;
                }
                String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
                List userList = new ArrayList();
                block4 : switch (deploymentModel) {
                    case "single": {
                        switch ((String)sqlMap.get("resultType")) {
                            case "List<String>": {
                                userList = this.dbCustomSqlService.getListStringSqlResult(sqlMap, (String)sqlMap.get("dataBaseName"));
                                break block4;
                            }
                        }
                        throw new BpmException("\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL\u8fd4\u56de\u503c\u7c7b\u578b");
                    }
                    case "micro": {
                        switch ((String)sqlMap.get("resultType")) {
                            case "List<String>": {
                                CustomSqlOutSideService customSqlOutSideService = (CustomSqlOutSideService)BpmSpringContextHolder.getBean(CustomSqlOutSideService.class);
                                userList = customSqlOutSideService.getListStringSqlResult(sqlMap, (String)sqlMap.get("dataBaseName"), serviceName);
                                break block4;
                            }
                        }
                        throw new BpmException("\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL\u8fd4\u56de\u503c\u7c7b\u578b");
                    }
                    default: {
                        throw new BpmException("\u5f53\u524d\u90e8\u7f72\u6a21\u5f0f\u4e0b\u4e0d\u652f\u6301\u4f7f\u7528\u8be5\u529f\u80fd");
                    }
                }
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    public boolean checkSql(Map<String, String> sqlMap) {
        boolean isSqlError;
        if (HussarUtils.isEmpty((Object)sqlMap.get("columnName")) || HussarUtils.isEmpty((Object)sqlMap.get("tableName")) || HussarUtils.isEmpty((Object)"conditionValue") || HussarUtils.isEmpty((Object)sqlMap.get("dataBaseName")) || HussarUtils.isEmpty((Object)sqlMap.get("resultType"))) {
            logger.error("\u81ea\u5b9a\u4e49SQL\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
            return false;
        }
        String sql = sqlMap.get("columnName") + sqlMap.get("tableName") + sqlMap.get("conditionValue");
        Matcher updateMatcher = UPDATE_SQL_REGEX.matcher(" " + sql.toUpperCase() + " ");
        boolean bl = isSqlError = updateMatcher.find() || sql.contains(";");
        if (isSqlError) {
            logger.error("\u81ea\u5b9a\u4e49SQL\u5305\u542b\u975e\u67e5\u8be2\u7c7b\u8bed\u53e5\u6216\u5206\u53f7\uff0c\u4e0d\u4e88\u6267\u884c");
            return false;
        }
        return true;
    }
}

