/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.bpm.customform.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomCategory;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.service.ICustomCategoryService;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.vo.CustomCategoryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8868\u5355\u5206\u7c7b"})
@RequestMapping(value={"/bpm/category"})
public class CustomCategoryController {
    @Autowired
    private ICustomCategoryService customCategoryService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u5206\u7c7b", notes="\u65b0\u589e\u5206\u7c7b")
    @AuditLog(moduleName="", eventDesc="", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    @CheckPermission(value={"bpm:category:add"})
    public ApiResponse<String> add(@RequestBody CustomCategory customCategory) {
        return ApiResponse.status((boolean)this.customCategoryService.add(customCategory));
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u5206\u7c7b", notes="\u4fee\u6539\u5206\u7c7b")
    @AuditLog(moduleName="", eventDesc="", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    @CheckPermission(value={"bpm:category:update"})
    public ApiResponse<String> update(@RequestBody CustomCategory customCategory) {
        return ApiResponse.status((boolean)this.customCategoryService.update(customCategory));
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u5206\u7c7b", notes="\u5220\u9664\u5206\u7c7b")
    @AuditLog(moduleName="", eventDesc="", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    @CheckPermission(value={"bpm:category:delete"})
    public ApiResponse<String> update(@RequestBody Long categoryId) {
        return ApiResponse.status((boolean)this.customCategoryService.delete(categoryId));
    }

    @GetMapping(value={"/categoryTree"})
    @ApiOperation(value="\u5206\u7c7b\u6811\u67e5\u8be2", notes="\u5206\u7c7b\u6811\u67e5\u8be2")
    @AuditLog(moduleName="", eventDesc="", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"bpm:category:categoryTree"})
    public ApiResponse<List<CustomCategory>> categoryTree(Long parentId, Long id) {
        return ApiResponse.success((Object)this.customCategoryService.categoryTree(parentId, id));
    }

    @GetMapping(value={"/queryCategoryTreeByName"})
    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2", notes="\u6a21\u7cca\u67e5\u8be2")
    @AuditLog(moduleName="", eventDesc="", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<CustomCategoryVo>> queryCategoryTreeByName(Page<CustomCategory> page, String name) {
        return ApiResponse.success((Object)this.customCategoryService.queryCategoryTreeByName(page, name));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5206\u7c7b\u67e5\u8be2", notes="\u5206\u7c7b\u67e5\u8be2")
    @AuditLog(moduleName="", eventDesc="", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CustomCategory>> list() {
        return ApiResponse.success((Object)this.customCategoryService.list());
    }
}

