/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.customsql.service.impl;

import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.formdesign.file.fileoperate.vo.DataSetTierTable;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.godaxe.customsql.GodAxeCustomSqlService;
import com.jxdinfo.hussar.workflow.godaxe.service.GodAxeCustomSqlApiService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.customsql.service.GodAxeCustomSqlOutSideService;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GodAxeCustomSqlApiServiceImpl
implements GodAxeCustomSqlApiService {
    @Value(value="${hussar.core.tenant.type:url}")
    private String tenantType;
    @Value(value="${hussar-remote-server.hussar.web.name:hussar-web}")
    private String SERVICE_NAME_HUSSAR_WEB;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private GodAxeCustomSqlService godAxeCustomSqlService;
    @Autowired
    private ModelMapper modelMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    private static final Pattern UPDATE_SQL_REGEX = Pattern.compile("[^'\"]\\b(CREATE|INSERT|DELETE|UPDATE|DROP|ALTER)\\b[^'\"]");
    private static final Logger logger = LogManager.getLogger(GodAxeCustomSqlApiServiceImpl.class);

    public ApiResponse<List<DataSetTierTable>> sqlList(Long id, String type, String processKey) throws Exception {
        String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "micro": {
                    WorkFlow workFlow;
                    GodAxeCustomSqlOutSideService godAxeCustomSqlOutSideService = (GodAxeCustomSqlOutSideService)BpmSpringContextHolder.getSpringContext().getBean(GodAxeCustomSqlOutSideService.class);
                    String serviceName = this.modelMapper.getServiceName(processKey);
                    if (HussarUtils.isEmpty((Object)serviceName) && HussarUtils.isNotEmpty((Object)(workFlow = this.sysActProcessFileService.getFileByProcessKey(processKey, null)))) {
                        serviceName = workFlow.getCategory();
                    }
                    if ("onsystem".equals(this.tenantType)) {
                        serviceName = this.SERVICE_NAME_HUSSAR_WEB;
                    }
                    return godAxeCustomSqlOutSideService.sqlList(id, type, serviceName);
                }
            }
            return this.godAxeCustomSqlService.sqlList(id, type);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(e.getMessage());
        }
    }

    public ApiResponse<String> checkSql(String sql) {
        String tableSection;
        Pattern fromPattern;
        Matcher fromMatcher;
        Pattern pattern;
        Matcher matcher;
        boolean isSqlError;
        String upperSql = sql.toUpperCase();
        Matcher updateMatcher = UPDATE_SQL_REGEX.matcher(" " + upperSql + " ");
        boolean bl = isSqlError = updateMatcher.find() || sql.contains(";");
        if (isSqlError) {
            return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u7981\u6b62\u4f7f\u7528\u975e\u67e5\u8be2\u7c7b\u8bed\u53e5\u6216\u5206\u53f7");
        }
        if (HussarUtils.isNotEmpty((Object)sql)) {
            if (!(upperSql.contains("SELECT") && upperSql.contains("FROM") && upperSql.contains("WHERE"))) {
                return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u7f3a\u5c11\u5fc5\u8981\u7684\u5173\u952e\u5b57");
            }
            if (upperSql.contains("@") || upperSql.contains(" AS ")) {
                return ApiResponse.fail((String)"\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL");
            }
        }
        if ((matcher = (pattern = Pattern.compile("SELECT(.*?)FROM")).matcher(upperSql)).find()) {
            String columnsSection = matcher.group(1).trim();
            if (columnsSection.contains("*")) {
                return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u7981\u6b62\u4f7f\u7528 *");
            }
            if (columnsSection.contains(",") || columnsSection.contains("\uff0c")) {
                return ApiResponse.fail((String)"\u81ea\u5b9a\u4e49SQL\u7981\u6b62\u6267\u884c\u67e5\u8be2\u591a\u5217\u7684SQL\u8bed\u53e5");
            }
            if (columnsSection.contains("$")) {
                return ApiResponse.fail((String)"\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL");
            }
        }
        if ((fromMatcher = (fromPattern = Pattern.compile("FROM(.*?)WHERE")).matcher(upperSql)).find() && (tableSection = fromMatcher.group(1).trim()).contains("$")) {
            return ApiResponse.fail((String)"\u975e\u6cd5\u7684\u81ea\u5b9a\u4e49SQL");
        }
        return ApiResponse.success();
    }

    public ApiResponse<List<SysDataSource>> getAllDataSource(String processKey) {
        String deploymentModel = this.lcdpBpmProperties.getDeploymentModel();
        try {
            switch (deploymentModel) {
                case "micro": {
                    WorkFlow workFlow;
                    GodAxeCustomSqlOutSideService godAxeCustomSqlOutSideService = (GodAxeCustomSqlOutSideService)BpmSpringContextHolder.getSpringContext().getBean(GodAxeCustomSqlOutSideService.class);
                    String serviceName = this.modelMapper.getServiceName(processKey);
                    if (HussarUtils.isEmpty((Object)serviceName) && HussarUtils.isNotEmpty((Object)(workFlow = this.sysActProcessFileService.getFileByProcessKey(processKey, null)))) {
                        serviceName = workFlow.getCategory();
                    }
                    if ("onsystem".equals(this.tenantType)) {
                        serviceName = this.SERVICE_NAME_HUSSAR_WEB;
                    }
                    return godAxeCustomSqlOutSideService.getAllDataSource(serviceName);
                }
            }
            return this.godAxeCustomSqlService.getAllDataSource();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(e.getMessage());
        }
    }
}

