/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.model.BpmConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.integrationPlatform.IntegrationPlatformInfoUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GetTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(GetTokenUtil.class);
    private static final String INTEGRATION_PLATFORM_CLIENT_TOKEN_API = "/oauth2/client_token";
    private static final String T_CODE = "tcode";
    private final IBpmConfigService bpmConfigService;
    private static final ConcurrentHashMap<String, HashMap<String, Object>> TOKEN_CACHE = new ConcurrentHashMap(16);

    public GetTokenUtil(IBpmConfigService bpmConfigService) {
        this.bpmConfigService = bpmConfigService;
    }

    public static Map<String, String> buildHeaderMap(String clientToken, String tcode, String clientId) {
        HashMap<String, String> headerMap = new HashMap<String, String>(4);
        headerMap.put("Authorization", clientToken);
        if (tcode != null) {
            headerMap.put(T_CODE, tcode);
        }
        if (HussarUtils.isEmpty((Object)clientId)) {
            clientId = GetTokenUtil.getClientId();
        }
        if (clientId != null) {
            headerMap.put("client-id", clientId);
        }
        return headerMap;
    }

    private static HashMap<String, Object> buildTokenRequestParams(String scope) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("grant_type", "client_credentials");
        params.put("scope", scope);
        return params;
    }

    public String getTenantCode() {
        BpmConfig bpmConfig = (BpmConfig)this.bpmConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(BpmConfig::getConfigKey, (Object)T_CODE));
        if (HussarUtils.isNotEmpty((Object)bpmConfig)) {
            return bpmConfig.getConfigValue();
        }
        return null;
    }

    public static String getToken() {
        Map<String, String> map = IntegrationPlatformInfoUtil.getIntegrationPlatformInfo();
        if (HussarUtils.isEmpty(map)) {
            return null;
        }
        String server = map.get("integrationPlatformCallAddress");
        String clientId = map.get("integrationPlatformApplicationClientId");
        String clientSecret = map.get("integrationPlatformApplicationClientSecret");
        return GetTokenUtil.requestToken(server, "", clientId, clientSecret);
    }

    public static String getUnifiedToken(String server, String scope, String clientId, String clientSecret) {
        return GetTokenUtil.requestToken(server, scope, clientId, clientSecret);
    }

    public static String getClientId() {
        Map<String, String> map = IntegrationPlatformInfoUtil.getIntegrationPlatformInfo();
        if (HussarUtils.isEmpty(map)) {
            return null;
        }
        return map.get("integrationPlatformApplicationClientId");
    }

    private static String getIfValidCache(String cacheKey) {
        if (HussarUtils.isEmpty((Object)cacheKey)) {
            return null;
        }
        String token = null;
        HashMap<String, Object> cacheToken = TOKEN_CACHE.get(cacheKey);
        if (cacheToken != null) {
            String validTime = (String)cacheToken.get("validTime");
            Calendar calendar = Calendar.getInstance();
            long timeInMillis = TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis());
            if (validTime != null && timeInMillis < Long.parseLong(validTime) - 60L) {
                token = (String)cacheToken.get("client-token");
            }
        }
        return token;
    }

    private static synchronized String requestToken(String server, String scope, String clientId, String clientSecret) {
        String token = GetTokenUtil.getIfValidCache(scope);
        if (token != null) {
            return token;
        }
        logger.info("requestToken\u65b9\u6cd5\u4e2d\u4e8c\u6b21\u5224\u65ad token\u4e3a\u7a7a\uff0c\u9700\u8981\u91cd\u65b0\u83b7\u53d6");
        HashMap<String, String> headerMap = new HashMap<String, String>(4);
        headerMap.put("client-id", clientId);
        headerMap.put("client-secret", clientSecret);
        HashMap<String, Object> params = GetTokenUtil.buildTokenRequestParams(scope);
        StringBuilder param = new StringBuilder();
        if (HussarUtils.isNotEmpty(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (param.toString().isEmpty()) {
                    param.append(entry.getKey()).append("=").append(entry.getValue());
                    continue;
                }
                param.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        server = server + INTEGRATION_PLATFORM_CLIENT_TOKEN_API;
        server = param.toString().isEmpty() ? server : server + "?" + param;
        String result = HttpClient.doGet((String)server, null, headerMap);
        if (result == null || result.isEmpty()) {
            throw new BpmException("\u83b7\u53d6token\u5f02\u5e38: \u54cd\u5e94\u4e3a\u7a7a url: " + server);
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        String data = jsonObject.getString("data");
        HashMap cacheToken = (HashMap)JSON.parseObject((String)data, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
        token = (String)cacheToken.get("client-token");
        if (token == null || token.isEmpty()) {
            throw new BpmException("\u83b7\u53d6token\u5f02\u5e38: " + jsonObject.getString("msg"));
        }
        Calendar calendar = Calendar.getInstance();
        String timeInMillis = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(calendar.getTimeInMillis()) + Long.parseLong(cacheToken.get("expires-in").toString()));
        cacheToken.put("validTime", timeInMillis);
        if (HussarUtils.isNotEmpty((Object)scope)) {
            TOKEN_CACHE.put(scope, cacheToken);
        }
        return token;
    }
}

