/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.integrationPlatform;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntegrationPlatformInfoUtil {
    private static LcdpBpmProperties lcdpBpmProperties;
    public static final String addressIsNull = "\u878d\u5408\u96c6\u6210\u5e73\u53f0\u672a\u5f00\u542f\u6216\u76f8\u5173\u914d\u7f6e\u672a\u4fee\u6539";
    public static final String integrationPlatformCallAddress = "/eai/applicationLogs/resourceUsage/getApiListByClientIdSecret";

    @Autowired
    public void lcdpBpmProperties(LcdpBpmProperties lcdpBpmProperties) {
        IntegrationPlatformInfoUtil.lcdpBpmProperties = lcdpBpmProperties;
    }

    public static Map<String, String> getIntegrationPlatformInfo() {
        String useIntegrationPlatform = lcdpBpmProperties.useIntegrationPlatform();
        if (HussarUtils.isEmpty((Object)useIntegrationPlatform)) {
            String useIntegrationPlatformYml = lcdpBpmProperties.getUseIntegrationPlatform();
            try {
                if (Boolean.parseBoolean(useIntegrationPlatformYml)) {
                    return lcdpBpmProperties.getIntegrationPlatformInfoYml();
                }
                return null;
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (Boolean.parseBoolean(useIntegrationPlatform)) {
            return lcdpBpmProperties.getIntegrationPlatformInfo();
        }
        return null;
    }

    public static String getIntegrationPlatformAddress() {
        Map<String, String> info = IntegrationPlatformInfoUtil.getIntegrationPlatformInfo();
        if (info == null || HussarUtils.isEmpty(info)) {
            throw new BpmException(addressIsNull);
        }
        return info.get("integrationPlatformCallAddress");
    }

    public static boolean isUseIntegrationPlatform() {
        String useIntegrationPlatform = lcdpBpmProperties.useIntegrationPlatform();
        if (HussarUtils.isEmpty((Object)useIntegrationPlatform)) {
            String useIntegrationPlatformYml = lcdpBpmProperties.getUseIntegrationPlatform();
            try {
                return Boolean.parseBoolean(useIntegrationPlatformYml);
            }
            catch (Exception ignored) {
                return false;
            }
        }
        try {
            return Boolean.parseBoolean(useIntegrationPlatform);
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

