/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicSecurityService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActRuMultUser;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActRuMultUserService;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.UserSecurityVo;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.model.ConfigUser;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.GetVariableCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.Annotation;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.ISysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.task.Task;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class AnalyticalModelUtil {
    private static ProcessEngine processEngine = (ProcessEngine)BpmSpringContextHolder.getBean(ProcessEngine.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
    private static IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)BpmSpringContextHolder.getBean(IAssigneeChooseService.class);
    private static ISysActEntrustService sysActEntrustService = (ISysActEntrustService)BpmSpringContextHolder.getBean(ISysActEntrustService.class);
    private static HistoryService historyService = (HistoryService)BpmSpringContextHolder.getBean(HistoryService.class);
    private static SysActAssigneeService sysActAssigneeService = (SysActAssigneeService)BpmSpringContextHolder.getBean(SysActAssigneeService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);
    private static ISysDicSecurityService sysDicSecurityService = (ISysDicSecurityService)SpringContextHolder.getBean(ISysDicSecurityService.class);
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private static IBpmActRuMultUserService bpmActRuMultUserService = (IBpmActRuMultUserService)BpmSpringContextHolder.getBean(IBpmActRuMultUserService.class);
    private static final String ASSIGNEE = "assignee";
    private static final String PROCESS_KEY = "processKey";
    private static final Pattern REGEX = Pattern.compile("\\$\\{([^}])*\\}");

    public static List<ConfigUser> getEntrustCandidateUser(BpmnModel bm, String taskDefinitionKey, ActivityExecution execution, boolean flag, Set<String> set, List<String> messageType) {
        List<ConfigUser> users = AnalyticalModelUtil.getConfigUser(bm, execution, flag, messageType);
        Process process = bm.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement;
            break;
        }
        List sequenceFlowList = startEvent.getOutgoingFlows();
        String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
        FlowElement flowElement = bm.getFlowElement(targetRef);
        ArrayList<String> firstTaskDefinitionKey = new ArrayList<String>();
        if (flowElement instanceof UserTask) {
            firstTaskDefinitionKey.add(flowElement.getId());
        }
        if (flowElement instanceof ParallelGateway) {
            ParallelGateway parallelGateway = (ParallelGateway)flowElement;
            List outgoingFlows = parallelGateway.getOutgoingFlows();
            for (SequenceFlow sequenceFlow : outgoingFlows) {
                String targetNode = sequenceFlow.getTargetRef();
                firstTaskDefinitionKey.add(targetNode);
            }
        }
        boolean isStartProcess = "start".equals(Context.getCommandContext().getAttribute("handleType"));
        if (HussarUtils.isEmpty(users) && isStartProcess && execution.getProcessInstance().getSuperExecutionId() == null && firstTaskDefinitionKey.contains(taskDefinitionKey)) {
            String startUserId = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstance().getId()).getStartUserId();
            users = ConfigUser.buildConfigUser(Collections.singletonList(startUserId), null);
        }
        if (HussarUtils.isEmpty(users)) {
            return new ArrayList<ConfigUser>();
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        Map userMap = sysActEntrustService.queryByUsers(ConfigUser.getAllUserId(users), processKey, taskDefinitionKey, 0);
        ConfigUser.recursionUser(configUser -> {
            String entrustUser = (String)userMap.get(configUser.getUserId());
            if (HussarUtils.isNotEmpty((Object)entrustUser)) {
                configUser.entrust(entrustUser);
                if (set != null) {
                    set.add(entrustUser);
                }
            } else if (set != null) {
                set.add(configUser.getUserId());
            }
        }, users);
        return users;
    }

    public static List<ConfigUser> getConfigUser(BpmnModel bm, ActivityExecution execution, boolean flag, List<String> messageType) {
        JSONObject inExpressions;
        String defaultAssign;
        Map<String, String> modelAssignee;
        boolean flowStarter;
        String activityId = execution.getActivity().getId();
        List<String> users = new ArrayList<String>();
        ArrayList<Object> userList = new ArrayList();
        Map extensionElementsNode = bm.getFlowElement(activityId).getExtensionElements();
        String allowSetParticipantRepetition = "";
        if (extensionElementsNode.get("allowSetParticipant") != null) {
            List list = (List)((ExtensionElement)((List)extensionElementsNode.get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant");
            String string = allowSetParticipantRepetition = HussarUtils.isNotEmpty((Object)list) ? ((ExtensionAttribute)list.get(0)).getValue() : "true";
        }
        if (!"false".equals(allowSetParticipantRepetition)) {
            Map subProcessAppoint;
            Map map = (Map)BpmAttribute.getExecutionAttribute(execution, "appoint_assignee");
            if (execution.getSubProcessKey() != null && (subProcessAppoint = (Map)BpmAttribute.getExecutionLocalAttribute(execution, "appoint_assignee")) != null) {
                map = subProcessAppoint;
            }
            if (map != null) {
                List<String> appointAssignees = (List<String>)map.get(activityId);
                if (HussarUtils.isEmpty((Object)appointAssignees)) {
                    appointAssignees = (List)map.get("static_appoint_assignee");
                }
                if (HussarUtils.isNotEmpty(appointAssignees = AnalyticalModelUtil.checkAssigneeSecurity(appointAssignees, execution.getProcessInstanceId()))) {
                    for (String appointAssignee : appointAssignees) {
                        if (!appointAssignee.contains(",")) continue;
                        return ConfigUser.buildGroupMultiConfigUser(appointAssignees);
                    }
                    Object isNotAdd = Context.getCommandContext().getAttribute("isNotAdd");
                    if (HussarUtils.isEmpty((Object)isNotAdd) || ((Boolean)isNotAdd).booleanValue()) {
                        return AnalyticalModelUtil.getAppointConfigUser(appointAssignees);
                    }
                    userList = new ArrayList<String>(appointAssignees);
                }
            }
        }
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        if (!(bm.getFlowElement(activityId) instanceof SubProcess) && (flowStarter = Boolean.parseBoolean(((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("flowStarter")).get(0)).getAttributes().get("flowStarter")).get(0)).getValue()))) {
            users.add(userId);
            return AnalyticalModelUtil.getAppointConfigUser(users);
        }
        String processDefinitionId = execution.getProcessDefinitionId();
        int version = Integer.valueOf(processDefinitionId.split(":")[1]);
        if (version <= 0) {
            version = Integer.parseInt(modelService.getRealVersion(processDefinitionId));
        }
        if (HussarUtils.isNotEmpty(modelAssignee = AnalyticalModelUtil.getAssignee(processDefinitionId.split(":")[0], activityId, 0, messageType, version))) {
            defaultAssign = modelAssignee.get("defaultAssign");
            inExpressions = (JSONObject)JSON.parse((String)modelAssignee.get("conditionAssign"), (Feature[])new Feature[]{Feature.OrderedField});
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
            inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
        }
        users = AnalyticalModelUtil.getAssigneeByConfiguration(execution, userId, defaultAssign, inExpressions, bm);
        AtomicInteger appointNum = new AtomicInteger(userList.size());
        userList.addAll(users);
        return ConfigUser.buildConfigUser(userList, configUser -> {
            Boolean isStartProcessAppointAssignee;
            if (appointNum.getAndDecrement() > 0 && ((isStartProcessAppointAssignee = (Boolean)Context.getCommandContext().getAttribute("is_start_process_appoint_assignee")) == null || isStartProcessAppointAssignee.booleanValue())) {
                configUser.setType(1);
            }
        });
    }

    private static List<String> checkAssigneeSecurity(List<String> appointAssignees, String procInstId) {
        if (HussarUtils.isNotEmpty(appointAssignees)) {
            ArrayList<String> newAppointAssignees = new ArrayList<String>();
            ArrayList<String> assignees = new ArrayList<String>();
            for (String appointAssignee : appointAssignees) {
                if (appointAssignee.contains(",")) {
                    List<String> assigneeList = Arrays.asList(appointAssignee.split(","));
                    for (String assignee : assigneeList) {
                        assignees.add(assignee);
                    }
                    continue;
                }
                assignees.add(appointAssignee);
            }
            Object historicProcessInstance = null;
            CommandContext commandContext = Context.getCommandContext();
            historicProcessInstance = commandContext != null ? commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(procInstId) : (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstId).singleResult();
            if (HussarUtils.isEmpty((Object)historicProcessInstance)) {
                return appointAssignees;
            }
            Integer securityLevel = historicProcessInstance.getSecurityLevel();
            List userSecurity = iAssigneeChooseService.getUserSecurity(assignees, securityLevel);
            List isSecurityUsers = userSecurity.stream().map(UserSecurityVo::getUserId).collect(Collectors.toList());
            for (String appointAssignee : appointAssignees) {
                if (appointAssignee.contains(",")) {
                    List<String> assigneeList = Arrays.asList(appointAssignee.split(","));
                    ArrayList<String> newAssignee = new ArrayList<String>();
                    for (String assignee : assigneeList) {
                        if (!isSecurityUsers.contains(assignee)) continue;
                        newAssignee.add(assignee);
                    }
                    if (!HussarUtils.isNotEmpty(newAssignee)) continue;
                    newAppointAssignees.add(String.join((CharSequence)",", newAssignee));
                    continue;
                }
                if (!isSecurityUsers.contains(appointAssignee)) continue;
                newAppointAssignees.add(appointAssignee);
            }
            return newAppointAssignees;
        }
        return null;
    }

    private static List<ConfigUser> getAppointConfigUser(List<String> appointAssignees) {
        return ConfigUser.buildConfigUser(appointAssignees, configUser -> {
            Boolean isStartProcessAppointAssignee = (Boolean)Context.getCommandContext().getAttribute("is_start_process_appoint_assignee");
            if (isStartProcessAppointAssignee == null || isStartProcessAppointAssignee.booleanValue()) {
                configUser.setType(1);
            }
        });
    }

    private static Set<String> getVariableNameList(String defaultAssign, JSONObject inExpressions) {
        HashSet<String> variableNameList = new HashSet<String>();
        if (HussarUtils.isNotEmpty((Object)defaultAssign)) {
            Matcher matcher = REGEX.matcher(defaultAssign);
            while (matcher.find()) {
                String variableName = matcher.group();
                variableNameList.add(variableName.substring(2, variableName.length() - 1));
            }
        }
        if (HussarUtils.isNotEmpty((Object)inExpressions)) {
            for (Object conditionAssign : inExpressions.values()) {
                if (!HussarUtils.isNotEmpty(conditionAssign)) continue;
                Matcher matcher = REGEX.matcher((String)conditionAssign);
                while (matcher.find()) {
                    String variableName = matcher.group();
                    variableNameList.add(variableName.substring(2, variableName.length() - 1));
                }
            }
        }
        return variableNameList;
    }

    private static Map<String, Object> getAssignmentNodeMap(Set<String> variableNameList, BpmnModel bm, String processInsId, String sendUser, String subProcessKey) {
        ArrayList<String> nodeIdList = new ArrayList<String>();
        for (String variableName : variableNameList) {
            if (bm.getFlowElement(variableName) == null) continue;
            nodeIdList.add(variableName);
        }
        HashMap<String, Object> assignmentNodeMap = new HashMap<String, Object>();
        if (!nodeIdList.isEmpty()) {
            List<HistoricTaskInstanceEntity> hisTaskList = new ArrayList();
            String node = null;
            if (nodeIdList.size() == 1) {
                node = (String)nodeIdList.get(0);
            }
            if (processInsId != null) {
                if (Context.getCommandContext() != null) {
                    if (Context.getCommandContext().getAttribute("ACTIVITI_START_AND_COMPLETE_TAG") != null) {
                        List allHisTaskList = Context.getCommandContext().getDbSqlSession().findInCache(HistoricTaskInstanceEntity.class);
                        hisTaskList = new ArrayList();
                        for (HistoricTaskInstanceEntity historicTaskInstanceEntity : allHisTaskList) {
                            if (!historicTaskInstanceEntity.getTaskDefinitionKey().equals(node) || subProcessKey != null && !historicTaskInstanceEntity.getSubProcessKey().equals(subProcessKey)) continue;
                            hisTaskList.add(historicTaskInstanceEntity);
                        }
                    } else {
                        hisTaskList = Context.getCommandContext().getTaskEntityManager().findAllHistoricTask(processInsId, node, subProcessKey);
                    }
                } else {
                    hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(node)).subProcessKey(subProcessKey)).list();
                }
            }
            for (String nodeId : nodeIdList) {
                List hisTaskEntityList = hisTaskList.stream().filter(hi -> hi.getTaskDefinitionKey().equals(nodeId)).collect(Collectors.toList());
                hisTaskEntityList.sort((o1, o2) -> {
                    if (o2.getEndTime() == null) {
                        return 1;
                    }
                    if (o1.getEndTime() == null) {
                        return -1;
                    }
                    return o2.getEndTime().compareTo(o1.getEndTime());
                });
                HashSet<Object> assignee = new HashSet<Object>();
                if (hisTaskEntityList != null && !hisTaskEntityList.isEmpty()) {
                    boolean isUnfinished;
                    HistoricTaskInstanceEntity lastTask = (HistoricTaskInstanceEntity)hisTaskEntityList.get(0);
                    boolean bl = isUnfinished = lastTask.getEndTime() == null;
                    if (lastTask.getMultiId() != null) {
                        if (lastTask.getSeqMultiCount() != null) {
                            if (isUnfinished) {
                                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                                queryWrapper.eq(BpmActRuMultUser::getMultiId, (Object)lastTask.getMultiId());
                                List list = bpmActRuMultUserService.list((Wrapper)queryWrapper);
                                list.forEach(o -> assignee.add(o.getUserId()));
                            } else {
                                HashMap<Integer, String> userMap = new HashMap<Integer, String>();
                                for (HistoricTaskInstanceEntity historicTaskInstanceEntity : hisTaskEntityList) {
                                    if (!lastTask.getMultiId().equals(historicTaskInstanceEntity.getMultiId())) continue;
                                    userMap.put(historicTaskInstanceEntity.getSeqMultiCount(), historicTaskInstanceEntity.getOriginalAssignee());
                                }
                                for (int i = 0; i < userMap.size(); ++i) {
                                    if (!HussarUtils.isNotEmpty(userMap.get(i))) continue;
                                    assignee.add(userMap.get(i));
                                }
                            }
                        } else {
                            for (HistoricTaskInstanceEntity task : hisTaskEntityList) {
                                if (task.getEndTime() == null || TaskType.isRevoked((String)task.getTaskType()) || TaskSourceFlag.isRevoke((String)task.getTaskSourceFlag()) || !lastTask.getMultiId().equals(task.getMultiId())) continue;
                                assignee.add(task.getOriginalAssignee());
                            }
                            if (isUnfinished && sendUser != null) {
                                assignee.add(sendUser);
                            }
                        }
                    } else if (isUnfinished) {
                        if (sendUser != null) {
                            assignee.add(sendUser);
                        }
                    } else {
                        assignee.add(lastTask.getOriginalAssignee());
                    }
                }
                if (HussarUtils.isNotEmpty(assignee)) {
                    assignmentNodeMap.put(nodeId, String.join((CharSequence)",", assignee));
                    continue;
                }
                String firstNodeId = null;
                ArrayList flowElements = new ArrayList(bm.getMainProcess().getFlowElements());
                for (FlowElement flowElement : flowElements) {
                    if (!(flowElement instanceof StartEvent)) continue;
                    firstNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
                }
                if (processInsId == null && HussarUtils.isNotEmpty(firstNodeId) && firstNodeId.equals(nodeId)) {
                    assignmentNodeMap.put(nodeId, sendUser);
                    continue;
                }
                assignmentNodeMap.put(nodeId, "");
            }
        }
        return assignmentNodeMap;
    }

    private static JSONObject getConditionAssign(BpmnModel bm, String activityId, String type) {
        JSONObject inExpressions = new JSONObject(true);
        FlowElement flowElement = bm.getFlowElement(activityId);
        if (flowElement instanceof SubProcess) {
            List extensionElements = (List)flowElement.getExtensionElements().get(type);
            if (extensionElements != null) {
                return JSON.parseObject((String)((ExtensionElement)extensionElements.get(0)).getAttributeValue(null, type));
            }
            return null;
        }
        Map extensionAttribute = flowElement.getAttributes();
        List inCandidate = (List)extensionAttribute.get(type);
        if (inCandidate != null && !inCandidate.isEmpty()) {
            inExpressions = ((ExtensionAttribute)inCandidate.get(0)).getValue() == null ? null : JSON.parseObject((String)((ExtensionAttribute)inCandidate.get(0)).getValue());
        }
        return inExpressions;
    }

    private static String getDefaultAssign(BpmnModel bm, String activityId, String type) {
        String defaultAssign = "";
        FlowElement flowElement = bm.getFlowElement(activityId);
        if (flowElement instanceof SubProcess) {
            List extensionElements = (List)flowElement.getExtensionElements().get(type);
            if (extensionElements != null) {
                return ((ExtensionElement)extensionElements.get(0)).getAttributeValue(null, type);
            }
            return "";
        }
        Map extensionAttribute = flowElement.getAttributes();
        List defaultCandidate = (List)extensionAttribute.get(type);
        if (defaultCandidate != null && !defaultCandidate.isEmpty()) {
            defaultAssign = ((ExtensionAttribute)defaultCandidate.get(0)).getValue() == null ? "" : ((ExtensionAttribute)defaultCandidate.get(0)).getValue();
        }
        return defaultAssign;
    }

    private static String getCallMessage(BpmnModel bm, String activityId, String name) {
        Map extensionElementsNode = bm.getFlowElement(activityId).getExtensionElements();
        if (HussarUtils.isNotEmpty((Object)extensionElementsNode) && extensionElementsNode.get(name) != null && HussarUtils.isNotEmpty((Object)((ExtensionElement)((List)extensionElementsNode.get(name)).get(0)).getAttributes())) {
            return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get(name)).get(0)).getAttributes().get(name)).get(0)).getValue();
        }
        return "";
    }

    private static String getFlowStarter(ActivityExecution execution) {
        String userId = "";
        Object historicProcessInstance = Context.getCommandContext() != null ? Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstanceId()) : (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(execution.getProcessInstanceId()).singleResult();
        if (HussarUtils.isNotEmpty((Object)historicProcessInstance) && HussarUtils.isNotEmpty((Object)historicProcessInstance.getStartUserId())) {
            userId = historicProcessInstance.getStartUserId();
        }
        if (HussarUtils.isEmpty((Object)userId)) {
            userId = AnalyticalModelUtil.getSendUser();
        }
        return userId;
    }

    private static String getSendUser() {
        String sendUser = (String)BpmAttribute.getContextAttribute("sendUser");
        return sendUser == null ? "" : sendUser;
    }

    public static Map<String, Object> getCcUser(BpmnModel bm, ActivityExecution execution) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> ccUsers = execution.getVariable("cc_user") == null ? new ArrayList() : JSON.parseArray((String)execution.getVariable("cc_user").toString(), String.class);
        String sendUserId = AnalyticalModelUtil.getSendUser();
        if (ccUsers != null && !ccUsers.isEmpty()) {
            execution.removeVariable("cc_user");
        } else {
            JSONObject inExpressions;
            String defaultAssign;
            Map<String, String> modelAssignee;
            String activityId = execution.getActivity().getId();
            String userId = AnalyticalModelUtil.getFlowStarter(execution);
            String processDefinitionId = execution.getProcessDefinitionId();
            int version = Integer.valueOf(processDefinitionId.split(":")[1]);
            if (version <= 0) {
                version = Integer.parseInt(modelService.getRealVersion(processDefinitionId));
            }
            if (HussarUtils.isNotEmpty(modelAssignee = AnalyticalModelUtil.getAssignee(processDefinitionId.split(":")[0], activityId, 1, null, version))) {
                defaultAssign = modelAssignee.get("defaultCcAssign");
                inExpressions = (JSONObject)JSON.parse((String)modelAssignee.get("conditionCcAssign"), (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultCcAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionCcAssign");
            }
            ccUsers = AnalyticalModelUtil.getAssigneeByConfiguration(execution, userId, defaultAssign, inExpressions, bm);
        }
        if (HussarUtils.isNotEmpty(ccUsers)) {
            ccUsers = ccUsers.stream().distinct().collect(Collectors.toList());
        }
        map.put("ccUser", ccUsers);
        map.put("ccSendUser", sendUserId);
        return map;
    }

    public static Map<String, Object> getCcEndUser(BpmnModel bm, ActivityExecution execution) {
        JSONObject inExpressions;
        String defaultAssign;
        Map<String, String> modelAssignee;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Object> ccUsers = new ArrayList();
        String sendUserId = AnalyticalModelUtil.getSendUser();
        String activityId = execution.getActivity().getId();
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        String procDefKey = execution.getProcessDefinitionId().split(":")[0];
        int version = Integer.valueOf(execution.getProcessDefinitionId().split(":")[1]);
        if (version <= 0) {
            version = Integer.parseInt(modelService.getRealVersion(execution.getProcessDefinitionId()));
        }
        if (HussarUtils.isNotEmpty(modelAssignee = AnalyticalModelUtil.getAssignee(procDefKey, activityId, 3, null, version))) {
            defaultAssign = modelAssignee.get("defaultCcEndAssign");
            inExpressions = (JSONObject)JSON.parse((String)modelAssignee.get("conditionCcEndAssign"), (Feature[])new Feature[]{Feature.OrderedField});
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultCcEndAssign");
            inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionCcEndAssign");
        }
        ccUsers = AnalyticalModelUtil.getAssigneeByConfiguration(execution, userId, defaultAssign, inExpressions, bm);
        if (HussarUtils.isNotEmpty(ccUsers)) {
            ccUsers = ccUsers.stream().distinct().collect(Collectors.toList());
        }
        map.put("ccUser", ccUsers);
        map.put("ccSendUser", sendUserId);
        return map;
    }

    private static List<String> getAssigneeByConfiguration(ActivityExecution execution, String userId, String defaultAssign, JSONObject conditionAssign, BpmnModel bm) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, conditionAssign})) {
            return new ArrayList<String>();
        }
        HashMap<String, Object> formData = (HashMap<String, Object>)execution.getTempVariable("processVariables");
        if (formData == null) {
            formData = new HashMap<String, Object>();
        }
        formData.putAll(execution.getVariables());
        Map sendUserMap = (Map)Context.getCommandContext().getAttribute("sendUserMap");
        if (sendUserMap != null) {
            formData.put("sendUser", sendUserMap.get(execution.getCurrentActivityId()));
        }
        Set<String> variableNameList = AnalyticalModelUtil.getVariableNameList(defaultAssign, conditionAssign);
        Map<Object, Object> assignmentNodeMap = new HashMap();
        String subProcessKey = execution.getSubProcessKey();
        if (!variableNameList.isEmpty()) {
            String sendUser = AnalyticalModelUtil.getSendUser();
            assignmentNodeMap = AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, execution.getProcessInstanceId(), sendUser, subProcessKey);
        }
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            formData.put("sub_process_separate_variable", subProcessKey.split(":")[1]);
        }
        if (formData != null && !formData.isEmpty()) {
            formData.putAll(assignmentNodeMap);
        } else {
            formData = assignmentNodeMap;
        }
        String processKey = ((ExecutionEntity)execution).getProcessDefinitionKey();
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = Context.getCommandContext().getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity processInstanceEntity = historicProcessInstanceEntityManager.findHistoricProcessInstance(execution.getProcessInstanceId());
        formData.put("BPM_WORKFLOW_PROCESS_ORGAN_ID", processInstanceEntity.getOrganId());
        return AnalyticalModelUtil.getNextAssigneeByConfiguration(processKey, userId, defaultAssign, conditionAssign, variableNameList, AnalyticalModelUtil.getSecurityLevel(execution.getProcessInstanceId()), formData, AnalyticalModelUtil.getProcessInfo(execution));
    }

    public static Map<String, String> getCallActivityAssignee(BpmnModel bm, ActivityExecution execution, Map<String, Object> map) {
        String userId = AnalyticalModelUtil.getFlowStarter(execution);
        String activityId = execution.getCurrentActivityId();
        int version = Integer.valueOf(execution.getProcessDefinitionId().split(":")[1]);
        if (version <= 0) {
            version = Integer.parseInt(modelService.getRealVersion(execution.getProcessDefinitionId()));
        }
        Map<String, String> modelAssignee = AnalyticalModelUtil.getAssignee(execution.getProcessDefinitionId().split(":")[0], activityId, 2, null, version);
        String callAssignee = null;
        String callProcessKey = null;
        JSONObject conditionCallAssignee = null;
        JSONObject conditionCallProcessKey = null;
        String defaultCallAssignee = null;
        String defaultCallProcessKey = null;
        if (HussarUtils.isNotEmpty(modelAssignee)) {
            callAssignee = modelAssignee.get("conditionCallAssign");
            callProcessKey = modelAssignee.get("conditionCallProcessKey");
            conditionCallAssignee = JSON.parseObject((String)callAssignee, (Feature[])new Feature[]{Feature.OrderedField});
            conditionCallProcessKey = JSON.parseObject((String)callProcessKey, (Feature[])new Feature[]{Feature.OrderedField});
            defaultCallAssignee = modelAssignee.get("defaultCallAssignee");
            defaultCallProcessKey = modelAssignee.get("defaultCallProcessKey");
        } else {
            callAssignee = AnalyticalModelUtil.getCallMessage(bm, activityId, "conditionCallAssign");
            callProcessKey = AnalyticalModelUtil.getCallMessage(bm, activityId, "conditionCallProcessKey");
            conditionCallAssignee = JSON.parseObject((String)callAssignee, (Feature[])new Feature[]{Feature.OrderedField});
            conditionCallProcessKey = JSON.parseObject((String)callProcessKey, (Feature[])new Feature[]{Feature.OrderedField});
            defaultCallAssignee = AnalyticalModelUtil.getCallMessage(bm, activityId, "defaultCallAssignee");
            defaultCallProcessKey = AnalyticalModelUtil.getCallMessage(bm, activityId, "defaultCallProcessKey");
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{defaultCallAssignee, conditionCallAssignee})) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(ASSIGNEE, "");
            result.put(PROCESS_KEY, defaultCallProcessKey);
        }
        Set<String> variableNameList = AnalyticalModelUtil.getVariableNameList(defaultCallAssignee, conditionCallAssignee);
        String subProcessKey = execution.getSubProcessKey();
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{defaultCallAssignee, conditionCallAssignee})) {
            String sendUser = AnalyticalModelUtil.getSendUser();
            Map sendUserMap = (Map)Context.getCommandContext().getAttribute("sendUserMap");
            if (sendUserMap != null) {
                sendUser = (String)sendUserMap.get(execution.getCurrentActivityId());
            }
            map.putAll(AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, execution.getProcessInstanceId(), sendUser, subProcessKey));
        }
        if (HussarUtils.isNotEmpty((Object)subProcessKey)) {
            map.put("sub_process_separate_variable", subProcessKey.split(":")[1]);
        }
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = Context.getCommandContext().getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity processInstanceEntity = historicProcessInstanceEntityManager.findHistoricProcessInstance(execution.getProcessInstanceId());
        map.put("BPM_WORKFLOW_PROCESS_ORGAN_ID", processInstanceEntity.getOrganId());
        AnalyticalModelUtil.setBpmWorkflowVariable(userId, variableNameList, map);
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionCallAssignee != null && !conditionCallAssignee.isEmpty()) {
            for (Object k : conditionCallAssignee.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE, map);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                HashMap<String, String> result = new HashMap<String, String>();
                if (HussarUtils.isNotEmpty((Object)conditionCallAssignee.get(k))) {
                    List users = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable((String)conditionCallAssignee.get(k), userId, map), execution.getProcessDefinitionId().split(":")[0], AnalyticalModelUtil.getSecurityLevel(execution.getProcessInstanceId()), AnalyticalModelUtil.getProcessInfo(execution));
                    result.put(ASSIGNEE, String.join((CharSequence)",", users));
                }
                result.put(PROCESS_KEY, (String)conditionCallProcessKey.get(k));
                return result;
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)defaultCallAssignee)) {
            List users = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable(defaultCallAssignee, userId, map), execution.getProcessDefinitionId().split(":")[0], AnalyticalModelUtil.getSecurityLevel(execution.getProcessInstanceId()), AnalyticalModelUtil.getProcessInfo(execution));
            result.put(ASSIGNEE, String.join((CharSequence)",", users));
        }
        result.put(PROCESS_KEY, defaultCallProcessKey);
        return result;
    }

    public static Integer getSecurityLevel(String procInstId) {
        if (procInstId == null) {
            return null;
        }
        CommandContext commandContext = Context.getCommandContext();
        Object historicProcessInstance = commandContext != null ? commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(procInstId) : (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(procInstId).singleResult();
        return historicProcessInstance == null ? null : historicProcessInstance.getSecurityLevel();
    }

    public static String getToDoConfiguration(String processDefinitionId, String taskDefinitionKey) {
        String todo = null;
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        if (HussarUtils.isNotEmpty((Object)taskDefinitionKey)) {
            Map extensionElementsNode = bm.getFlowElement(taskDefinitionKey).getExtensionElements();
            todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue();
        }
        Map extensionElements = ((Process)bm.getProcesses().get(0)).getExtensionElements();
        if (HussarUtils.isEmpty(todo) && HussarUtils.isEmpty((Object)(todo = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElements.get("todoConfiguration")).get(0)).getAttributes().get("todoConfiguration")).get(0)).getValue()))) {
            todo = null;
        }
        return todo;
    }

    public static String getTodo(Map<String, Object> variables, String todoConfig) {
        if (HussarUtils.isEmpty((Object)todoConfig)) {
            return null;
        }
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        newVariables.putAll(variables);
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        if (lcdpBpmProperties.isUseSecurityLevel()) {
            Object mjFields;
            ArrayList mjList = new ArrayList();
            if (newVariables.containsKey("security_level_attribute")) {
                mjFields = Arrays.asList(newVariables.get("security_level_attribute").toString().split(","));
                for (Object k : newVariables.keySet()) {
                    if (!mjFields.contains(k)) continue;
                    mjList.add(k.toString());
                }
            }
            if (HussarUtils.isNotEmpty((Object)mjList)) {
                mjFields = mjList.iterator();
                while (mjFields.hasNext()) {
                    String mj = (String)mjFields.next();
                    if (!HussarUtils.isNotEmpty(newVariables.get(mj))) continue;
                    newVariables.put(mj, sysDicSecurityService.selectValueByKey(newVariables.get(mj).toString()));
                }
            }
        }
        for (String key : newVariables.keySet()) {
            Object variable = newVariables.get(key);
            if (variable instanceof Date) {
                newVariables.put(key, DateUtil.getTime((Date)((Date)variable)));
                continue;
            }
            if (!(variable instanceof LocalDateTime)) continue;
            newVariables.put(key, Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)((LocalDateTime)variable)));
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newVariables);
        ValueExpression valueExpression = factory.createValueExpression((ELContext)context, todoConfig, String.class, newVariables);
        return valueExpression.getValue((ELContext)context) == null ? "" : valueExpression.getValue((ELContext)context).toString();
    }

    private static void setBpmWorkflowVariable(String userId, Set<String> variableNameList, Map<String, Object> map) {
        if (!map.containsKey("sendUser") && Context.getCommandContext() != null) {
            map.put("sendUser", AnalyticalModelUtil.getSendUser());
        }
        String startOrganId = (String)map.get("BPM_WORKFLOW_PROCESS_ORGAN_ID");
        if (variableNameList.contains("flow_starter_dept")) {
            if (HussarUtils.isNotEmpty((Object)startOrganId)) {
                map.put("flow_starter_dept", startOrganId);
            } else {
                map.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId));
            }
        }
        if (variableNameList.contains("flow_sameLevel_dept")) {
            if (HussarUtils.isNotEmpty((Object)startOrganId)) {
                map.put("flow_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByOrganId(startOrganId));
            } else {
                map.put("flow_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByUserId(userId));
            }
        }
        if (variableNameList.contains("flow_parent_dept")) {
            if (HussarUtils.isNotEmpty((Object)startOrganId)) {
                map.put("flow_parent_dept", iAssigneeChooseService.getDeptIdByUserIds(startOrganId));
            } else {
                map.put("flow_parent_dept", iAssigneeChooseService.getParentDeptIdByUserId(userId));
            }
        }
        if (variableNameList.contains("flow_submiter_dept")) {
            map.put("flow_submiter_dept", iAssigneeChooseService.getDeptIdByUserIds(map.get("sendUser").toString()));
        }
        if (variableNameList.contains("flow_submiter_sameLevel_dept")) {
            map.put("flow_submiter_sameLevel_dept", iAssigneeChooseService.getSameLevelDeptIdByUserIds(map.get("sendUser").toString()));
        }
        if (variableNameList.contains("flow_submiter_parent_dept")) {
            map.put("flow_submiter_parent_dept", iAssigneeChooseService.getParentDeptIdByUserIds(map.get("sendUser").toString()));
        }
    }

    private static List<String> getNextAssigneeByConfiguration(String processKey, String userId, String defaultAssign, JSONObject conditionAssign, Set<String> variableNameList, Integer securityLevel, Map<String, Object> map, Map<String, String> processInfo) {
        String realSql;
        List<String> users = new ArrayList<String>();
        boolean condition = false;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        StringBuilder sql = new StringBuilder();
        AnalyticalModelUtil.setBpmWorkflowVariable(userId, variableNameList, map);
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE, map);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (HussarUtils.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return users;
            }
        }
        if (HussarUtils.isEmpty((Object)(realSql = sql.toString())) || "null".equals(realSql)) {
            return users;
        }
        processInfo.put("workflowStarterUserId", userId);
        List list = iAssigneeChooseService.getCandidateUser(AnalyticalModelUtil.replaceNextBuiltinVariable(realSql, userId, map), processKey, securityLevel, processInfo);
        if (list == null || list.isEmpty()) {
            return users;
        }
        users = list.stream().distinct().collect(Collectors.toList());
        return users;
    }

    private static List<BpmTreeModel> getNextAssigneeByConfigurationWithParent(String processKey, String userId, String defaultAssign, JSONObject conditionAssign, Set<String> variableNameList, Integer securityLevel, Map<String, Object> map, Map<String, String> processInfo) {
        String realSql;
        List<Object> users = new ArrayList<BpmTreeModel>();
        boolean condition = false;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        StringBuilder sql = new StringBuilder();
        AnalyticalModelUtil.setBpmWorkflowVariable(userId, variableNameList, map);
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (conditionAssign != null && !conditionAssign.isEmpty()) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE, map);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (HussarUtils.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return users;
            }
        }
        if (HussarUtils.isEmpty((Object)(realSql = sql.toString())) || "null".equals(realSql)) {
            return users;
        }
        List list = iAssigneeChooseService.getCandidateUserWithParent(AnalyticalModelUtil.replaceNextBuiltinVariable(realSql, userId, map), processKey, securityLevel, processInfo);
        if (list == null || list.isEmpty()) {
            return users;
        }
        users = list.stream().distinct().collect(Collectors.toList());
        return users;
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (!map.containsKey("bpm_submit_source")) {
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext == null) {
                map.put("bpm_submit_source", "");
            } else {
                String submitSource = (String)BpmAttribute.getContextAttribute("bpm_submit_source");
                map.put("bpm_submit_source", submitSource == null ? "" : submitSource);
            }
        }
        for (String k : map.keySet()) {
            if (map.get(k.toString()) != null) {
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
                continue;
            }
            context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), Object.class));
        }
        return context;
    }

    private static String replaceNextBuiltinVariable(String sql, String starterUserId, Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            for (Map.Entry<String, Object> key : map.entrySet()) {
                if (sql.contains("(${" + key.getKey() + "})") && key.getValue() == null) {
                    newMap.put(key.getKey(), "null");
                    continue;
                }
                if (sql.contains("('${" + key.getKey() + "}')")) {
                    newMap.put(key.getKey(), String.valueOf(key.getValue()).replace(",", "','"));
                    continue;
                }
                newMap.put(key.getKey(), key.getValue());
            }
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newMap);
        ValueExpression e = factory.createValueExpression((ELContext)context, sql, String.class, newMap);
        String finalSql = e.getValue((ELContext)context).toString();
        finalSql = finalSql.replace("'null'", "''");
        return "and (" + finalSql.replaceFirst("and", "") + ")";
    }

    public static String queryFirstNodeAssigneeConfig(String userId, String processDefinitionId, String businessId, Map<String, Object> variables, List<String> firstNodeIds) {
        JSONObject conditionAssign;
        String defaultAssign;
        Map<String, String> modelAssignee;
        List sequenceFlowList;
        String targetRef;
        FlowElement flowElement;
        StringBuilder sql = new StringBuilder();
        String taskDefinitionKey = "";
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        boolean condition = false;
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        Process process = bm.getMainProcess();
        Collection flowElements = process.getFlowElements();
        StartEvent startEvent = new StartEvent();
        for (FlowElement flowElement2 : flowElements) {
            if (!(flowElement2 instanceof StartEvent)) continue;
            startEvent = (StartEvent)flowElement2;
            break;
        }
        if ((flowElement = bm.getFlowElement(targetRef = ((SequenceFlow)(sequenceFlowList = startEvent.getOutgoingFlows()).get(0)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = flowElement.getId();
        }
        if (flowElement instanceof ExclusiveGateway) {
            taskDefinitionKey = AnalyticalModelUtil.getFirstNode(flowElement, process, variables);
        }
        if (HussarUtils.isEmpty((Object)taskDefinitionKey)) {
            return "";
        }
        firstNodeIds.add(taskDefinitionKey);
        int version = Integer.valueOf(processDefinitionId.split(":")[1]);
        if (version <= 0) {
            version = Integer.parseInt(modelService.getRealVersion(processDefinitionId));
        }
        if (HussarUtils.isNotEmpty(modelAssignee = AnalyticalModelUtil.getAssignee(processDefinitionId.split(":")[0], taskDefinitionKey, 0, null, version))) {
            defaultAssign = modelAssignee.get("defaultAssign");
            conditionAssign = (JSONObject)JSON.parse((String)modelAssignee.get("conditionAssign"), (Feature[])new Feature[]{Feature.OrderedField});
        } else {
            defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, taskDefinitionKey, "defaultAssign");
            conditionAssign = AnalyticalModelUtil.getConditionAssign(bm, taskDefinitionKey, "conditionAssign");
        }
        if (HussarUtils.isEmpty((Object)defaultAssign) && HussarUtils.isEmpty((Object)conditionAssign)) {
            return "";
        }
        boolean isGetFlowStarterDept = false;
        boolean isRequestVisit = false;
        if (defaultAssign.contains("$")) {
            isRequestVisit = true;
        }
        if (defaultAssign.contains("flow_starter_dept")) {
            isGetFlowStarterDept = true;
        }
        if (HussarUtils.isNotEmpty((Object)conditionAssign)) {
            for (Object k : conditionAssign.keySet()) {
                if (isGetFlowStarterDept && isRequestVisit) break;
                if (!isRequestVisit && (k.toString().contains("$") || ((String)conditionAssign.get((Object)k.toString())).contains("$"))) {
                    isRequestVisit = true;
                }
                if (isGetFlowStarterDept || !k.toString().contains("flow_starter_dept") && !((String)conditionAssign.get((Object)k.toString())).contains("flow_starter_dept")) continue;
                isGetFlowStarterDept = true;
            }
        }
        HashMap<String, Object> newVariables = variables == null ? new HashMap<String, Object>() : variables;
        Set<String> variableNameList = AnalyticalModelUtil.getVariableNameList(defaultAssign, conditionAssign);
        if (!variableNameList.isEmpty()) {
            Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, null, null, null);
            newVariables.putAll(nodeMap);
        }
        if (isRequestVisit) {
            Map tempMap = (Map)processEngine.getManagementService().executeCommand((Command)new GetVariableCmd(CommonCodeUtil.getVisitorNodeId(taskDefinitionKey, bm), businessId, processDefinitionId, null, bm));
            newVariables.putAll(tempMap);
            Map<String, Object> result = CommonCodeUtil.getGodAxeResult(taskDefinitionKey, businessId, processDefinitionId);
            if (HussarUtils.isNotEmpty((Object)result)) {
                newVariables.putAll(result);
            }
        }
        if (isGetFlowStarterDept) {
            newVariables.put("flow_starter_dept", iAssigneeChooseService.getStarterDept(userId));
        }
        SimpleContext context = AnalyticalModelUtil.getVariables(newVariables);
        if (HussarUtils.isNotEmpty((Object)conditionAssign)) {
            for (Object k : conditionAssign.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE, newVariables);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                condition = true;
                String con = (String)conditionAssign.get((Object)k.toString());
                sql.append(con);
                break;
            }
        }
        if (!condition) {
            if (HussarUtils.isNotEmpty((Object)defaultAssign) && !"null".equals(defaultAssign)) {
                sql.append(defaultAssign);
            } else {
                return "";
            }
        }
        String finalSql = "";
        if (HussarUtils.isNotEmpty((Object)sql)) {
            finalSql = AnalyticalModelUtil.replaceNextBuiltinVariable(sql.toString(), userId, newVariables);
        }
        return finalSql;
    }

    private static boolean getResultByElAndFormData(String el, Map<String, Object> formData) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        for (Map.Entry<String, Object> k : formData.entrySet()) {
            if (k.getValue() != null) {
                context.setVariable(k.getKey(), factory.createValueExpression(k.getValue(), k.getValue().getClass()));
                continue;
            }
            context.setVariable(k.toString(), factory.createValueExpression(k.getValue(), Object.class));
        }
        ValueExpression e = factory.createValueExpression((ELContext)context, el, Boolean.TYPE, formData);
        return (Boolean)e.getValue((ELContext)context);
    }

    private static String getFirstNode(FlowElement flowElement, Process process, Map<String, Object> variables) {
        SequenceFlow sequenceFlow;
        String targetRef;
        FlowElement fe;
        String taskDefinitionKey = "";
        ExclusiveGateway exclusiveGateway = (ExclusiveGateway)flowElement;
        String flow = exclusiveGateway.getDefaultFlow();
        List sf = exclusiveGateway.getOutgoingFlows();
        for (SequenceFlow s : sf) {
            String ce = s.getConditionExpression();
            if (!HussarUtils.isNotEmpty((Object)ce) || !AnalyticalModelUtil.getResultByElAndFormData(ce, variables)) continue;
            flow = s.getId();
            break;
        }
        if (HussarUtils.isNotEmpty((Object)flow) && (fe = process.getFlowElement(targetRef = (sequenceFlow = (SequenceFlow)process.getFlowElement(flow)).getTargetRef())) instanceof UserTask) {
            taskDefinitionKey = fe.getId();
        }
        return taskDefinitionKey;
    }

    public static List<String> getNextCandidateUser(String processInsId, String processDefinitionId, BpmnModel bm, String activityId, String subProcessKey, Map<String, Object> map, Task task) {
        List instanceModeNode;
        String instanceMode;
        String processKey = processDefinitionId.split(":")[0];
        Map<String, Object> newMap = task == null ? new HashMap() : task.getProcessVariables();
        List<String> users = new ArrayList<String>();
        FlowElement flowElement = bm.getFlowElement(activityId);
        if (flowElement == null) {
            throw new BpmException(BpmExceptionCodeEnum.NODE_NOT_FOUND);
        }
        if (flowElement instanceof ReceiveTask || flowElement instanceof ServiceTask) {
            return users;
        }
        if (flowElement instanceof SubProcess && !(instanceMode = ((ExtensionAttribute)((List)((ExtensionElement)(instanceModeNode = (List)flowElement.getExtensionElements().get("instanceMode")).get(0)).getAttributes().get("instanceMode")).get(0)).getValue()).equals(ASSIGNEE)) {
            return users;
        }
        Map extensionElementsNode = flowElement.getExtensionElements();
        if (!extensionElementsNode.isEmpty()) {
            JSONObject inExpressions;
            String defaultAssign;
            Map<String, String> modelAssignee;
            int version = Integer.valueOf(processDefinitionId.split(":")[1]);
            if (version <= 0) {
                version = Integer.parseInt(modelService.getRealVersion(processDefinitionId));
            }
            if (HussarUtils.isNotEmpty(modelAssignee = AnalyticalModelUtil.getAssignee(processKey, activityId, 0, null, version))) {
                defaultAssign = modelAssignee.get("defaultAssign");
                inExpressions = (JSONObject)JSON.parse((String)modelAssignee.get("conditionAssign"), (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
            }
            if (HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
                return users;
            }
            String businessId = null;
            String startUserId = "";
            String sendUserId = startUserId = HussarUtils.isEmpty((Object)map.get("bpm_workflow_user_id")) ? "" : (String)map.get("bpm_workflow_user_id");
            newMap.put("sendUser", startUserId);
            if (subProcessKey != null && !"".equals(subProcessKey)) {
                newMap.put("sub_process_separate_variable", subProcessKey.split(":")[1]);
            }
            Integer securityLevel = null;
            if (processInsId != null) {
                Object hpi = null;
                CommandContext commandContext = Context.getCommandContext();
                hpi = commandContext != null ? commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInsId) : (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
                businessId = hpi.getBusinessKey();
                startUserId = hpi.getStartUserId();
                securityLevel = hpi.getSecurityLevel();
                newMap.put("BPM_WORKFLOW_PROCESS_ORGAN_ID", hpi.getOrganId());
            } else if (HussarUtils.isNotEmpty((Object)map.get("security_level"))) {
                securityLevel = Integer.parseInt(String.valueOf(map.get("security_level")));
            }
            Set<String> variableNameList = AnalyticalModelUtil.getVariableNameList(defaultAssign, inExpressions);
            if (!variableNameList.isEmpty()) {
                Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, processInsId, sendUserId, subProcessKey);
                newMap.putAll(nodeMap);
            }
            if (AnalyticalModelUtil.isGetVisitor(defaultAssign, inExpressions)) {
                Map tempMap = (Map)processEngine.getManagementService().executeCommand((Command)new GetVariableCmd(activityId, businessId, processDefinitionId, sendUserId, bm));
                newMap.putAll(tempMap);
                Map<String, Object> result = CommonCodeUtil.getGodAxeResult(activityId, businessId, processDefinitionId);
                if (HussarUtils.isNotEmpty(result)) {
                    newMap.putAll(result);
                }
            }
            if (map != null) {
                newMap.putAll(map);
            }
            users = AnalyticalModelUtil.getNextAssigneeByConfiguration(processKey, startUserId, defaultAssign, inExpressions, variableNameList, securityLevel, newMap, AnalyticalModelUtil.getProcessInfo(task, flowElement, processDefinitionId));
        }
        return users;
    }

    public static List<BpmTreeModel> getNextCandidateUserWithParent(String processInsId, String processDefinitionId, BpmnModel bm, String activityId, String subProcessKey, Map<String, Object> map, Task task) {
        List instanceModeNode;
        String instanceMode;
        String processKey = processDefinitionId.split(":")[0];
        Map<String, Object> newMap = task == null ? new HashMap() : task.getProcessVariables();
        List<BpmTreeModel> users = new ArrayList<BpmTreeModel>();
        FlowElement flowElement = bm.getFlowElement(activityId);
        if (flowElement == null) {
            throw new BpmException(BpmExceptionCodeEnum.NODE_NOT_FOUND);
        }
        if (flowElement instanceof ReceiveTask || flowElement instanceof ServiceTask) {
            return users;
        }
        if (flowElement instanceof SubProcess && !(instanceMode = ((ExtensionAttribute)((List)((ExtensionElement)(instanceModeNode = (List)flowElement.getExtensionElements().get("instanceMode")).get(0)).getAttributes().get("instanceMode")).get(0)).getValue()).equals(ASSIGNEE)) {
            return users;
        }
        Map extensionElementsNode = flowElement.getExtensionElements();
        if (!extensionElementsNode.isEmpty()) {
            JSONObject inExpressions;
            String defaultAssign;
            Map<String, String> modelAssignee;
            int version = Integer.valueOf(processDefinitionId.split(":")[1]);
            if (version <= 0) {
                version = Integer.parseInt(modelService.getRealVersion(processDefinitionId));
            }
            if (HussarUtils.isNotEmpty(modelAssignee = AnalyticalModelUtil.getAssignee(processKey, activityId, 0, null, version))) {
                defaultAssign = modelAssignee.get("defaultAssign");
                inExpressions = (JSONObject)JSON.parse((String)modelAssignee.get("conditionAssign"), (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                defaultAssign = AnalyticalModelUtil.getDefaultAssign(bm, activityId, "defaultAssign");
                inExpressions = AnalyticalModelUtil.getConditionAssign(bm, activityId, "conditionAssign");
            }
            if (HussarUtils.isAllEmpty((Object[])new Object[]{defaultAssign, inExpressions})) {
                return users;
            }
            String businessId = null;
            String startUserId = "";
            String sendUser = HussarUtils.isEmpty((Object)map.get("bpm_workflow_user_id")) ? "" : (String)map.get("bpm_workflow_user_id");
            newMap.put("sendUser", sendUser);
            if (subProcessKey != null && !"".equals(subProcessKey)) {
                newMap.put("sub_process_separate_variable", subProcessKey.split(":")[1]);
            }
            Integer securityLevel = null;
            if (processInsId != null) {
                Object hpi = null;
                CommandContext commandContext = Context.getCommandContext();
                hpi = commandContext != null ? commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInsId) : (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
                businessId = hpi.getBusinessKey();
                startUserId = hpi.getStartUserId();
                securityLevel = hpi.getSecurityLevel();
                newMap.put("BPM_WORKFLOW_PROCESS_ORGAN_ID", hpi.getOrganId());
            } else {
                startUserId = sendUser;
                if (HussarUtils.isNotEmpty((Object)map.get("security_level"))) {
                    securityLevel = Integer.valueOf(String.valueOf(map.get("security_level")));
                }
            }
            Set<String> variableNameList = AnalyticalModelUtil.getVariableNameList(defaultAssign, inExpressions);
            if (!variableNameList.isEmpty()) {
                Map<String, Object> nodeMap = AnalyticalModelUtil.getAssignmentNodeMap(variableNameList, bm, processInsId, sendUser, subProcessKey);
                newMap.putAll(nodeMap);
            }
            if (AnalyticalModelUtil.isGetVisitor(defaultAssign, inExpressions)) {
                Map tempMap = (Map)processEngine.getManagementService().executeCommand((Command)new GetVariableCmd(CommonCodeUtil.getVisitorNodeId(activityId, bm), businessId, processDefinitionId, sendUser, bm));
                newMap.putAll(tempMap);
                Map<String, Object> result = CommonCodeUtil.getGodAxeResult(activityId, businessId, processDefinitionId);
                if (HussarUtils.isNotEmpty(result)) {
                    newMap.putAll(result);
                }
            }
            if (map != null) {
                newMap.putAll(map);
            }
            users = AnalyticalModelUtil.getNextAssigneeByConfigurationWithParent(processKey, startUserId, defaultAssign, inExpressions, variableNameList, securityLevel, newMap, AnalyticalModelUtil.getProcessInfo(task, flowElement, processDefinitionId));
        }
        return users;
    }

    private static Map<String, String> getProcessInfo(Task task, FlowElement flowElement, String processDefId) {
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowTaskDefinitionKey", flowElement.getId());
        processInfo.put("workflowTaskDefinitionName", flowElement.getName());
        if (task != null) {
            processInfo.put("workflowProcessKey", task.getProcessDefinitionId().split(":")[0]);
            processInfo.put("workflowProcessInsId", task.getProcessInstanceId());
            processInfo.put("workflowProcessDefinitionId", task.getProcessDefinitionId());
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            processInfo.put("workflowProcessStartUserId", historicProcessInstance.getStartUserId());
            processInfo.put("workflowProcessStartUserOrganId", historicProcessInstance.getOrganId());
            processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
        } else if (processDefId != null) {
            processInfo.put("workflowProcessDefinitionId", processDefId);
            processInfo.put("workflowProcessKey", processDefId.split(":")[0]);
        }
        return processInfo;
    }

    private static Map<String, String> getProcessInfo(ActivityExecution execution) {
        HashMap<String, String> processInfo = new HashMap<String, String>();
        processInfo.put("workflowProcessKey", execution.getProcessDefinitionId().split(":")[0]);
        processInfo.put("workflowProcessInsId", execution.getProcessInstanceId());
        processInfo.put("workflowProcessDefinitionId", execution.getProcessDefinitionId());
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            HistoricProcessInstanceEntity historicProcessInstanceEntity = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstanceId());
            processInfo.put("workflowProcessStartUserId", historicProcessInstanceEntity.getStartUserId());
            processInfo.put("workflowProcessStartUserOrganId", historicProcessInstanceEntity.getOrganId());
        }
        processInfo.put("workflowBusinessId", execution.getProcessBusinessKey());
        processInfo.put("workflowTaskDefinitionKey", execution.getCurrentActivityId());
        processInfo.put("workflowTaskDefinitionName", execution.getCurrentActivityName());
        return processInfo;
    }

    private static boolean isGetVisitor(String defaultAssign, JSONObject conditionAssign) {
        if (defaultAssign.contains("$")) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)conditionAssign)) {
            for (Object k : conditionAssign.keySet()) {
                if (!k.toString().contains("$") && !((String)conditionAssign.get((Object)k.toString())).contains("$")) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getMultiInstanceUser(List<HistoricTaskInstanceEntity> hisTaskList) {
        return CommonCodeUtil.getLastCompleted(hisTaskList, new ArrayList());
    }

    private static Map<String, String> getAssignee(String procDefKey, String taskDefKey, int type, List<String> messageType, int version) {
        HashMap<String, String> map = new HashMap<String, String>();
        List result = sysActAssigneeService.getAssignee(procDefKey, taskDefKey, type, version);
        if (type == 0 && messageType != null && HussarUtils.isNotEmpty((Object)result)) {
            for (SysActAssignee sysActAssignee : result) {
                if (!HussarUtils.isNotEmpty((Object)sysActAssignee.getMessageType())) continue;
                messageType.add(sysActAssignee.getMessageType());
            }
        }
        for (SysActAssignee modelAssignee : result) {
            map.put(modelAssignee.getContentType(), modelAssignee.getContent() == null ? "" : new String(modelAssignee.getContent(), StandardCharsets.UTF_8));
        }
        return map;
    }

    public static Map<String, String> getAllCallActivityProcessKey(BpmnModel bm, String currenActivityId, Map<String, Object> map) {
        String callProcessKey = null;
        JSONObject conditionCallProcessKey = null;
        String defaultCallProcessKey = null;
        callProcessKey = AnalyticalModelUtil.getCallMessage(bm, currenActivityId, "conditionCallProcessKey");
        conditionCallProcessKey = JSON.parseObject((String)callProcessKey, (Feature[])new Feature[]{Feature.OrderedField});
        defaultCallProcessKey = AnalyticalModelUtil.getCallMessage(bm, currenActivityId, "defaultCallProcessKey");
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        String allProcessKey = defaultCallProcessKey;
        if (HussarUtils.isNotEmpty((Object)conditionCallProcessKey)) {
            for (Object k : conditionCallProcessKey.keySet()) {
                allProcessKey = allProcessKey + "," + (String)conditionCallProcessKey.get(k);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(PROCESS_KEY, allProcessKey);
        return result;
    }

    public static List<String> getCallActivityNodeVariables(BpmnModel bm, String currenActivityId, Map<String, Object> map) {
        String activityId = currenActivityId;
        String callAssignee = null;
        JSONObject conditionCallAssignee = null;
        String defaultCallAssignee = null;
        String regex = "\\$\\{hussar_(ext_)?[0-9]+\\}";
        callAssignee = AnalyticalModelUtil.getCallMessage(bm, activityId, "conditionCallAssign");
        conditionCallAssignee = JSON.parseObject((String)callAssignee, (Feature[])new Feature[]{Feature.OrderedField});
        defaultCallAssignee = AnalyticalModelUtil.getCallMessage(bm, activityId, "defaultCallAssignee");
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = AnalyticalModelUtil.getVariables(map);
        if (HussarUtils.isNotEmpty((Object)conditionCallAssignee)) {
            for (Object k : conditionCallAssignee.keySet()) {
                ValueExpression e = factory.createValueExpression((ELContext)context, k.toString(), Boolean.TYPE, map);
                if (!((Boolean)e.getValue((ELContext)context)).booleanValue()) continue;
                ArrayList<String> result = new ArrayList<String>();
                String assigneeCondition = (String)conditionCallAssignee.get(k);
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(assigneeCondition);
                while (matcher.find()) {
                    int strLength = matcher.group().length();
                    String nodeVariable = matcher.group().substring(2, strLength - 1);
                    result.add(nodeVariable);
                }
                return result;
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(defaultCallAssignee);
        while (matcher.find()) {
            int strLength = matcher.group().length();
            String nodeVariable = matcher.group().substring(2, strLength - 1);
            result.add(nodeVariable);
        }
        return result;
    }

    public static List<Annotation> getAnnotationContent(Map<String, Object> map, String processDefinitionId, String taskDefinitionKey) {
        Map extensionElementsNode;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        BpmnModel bm = repositoryService.getBpmnModel(processDefinitionId);
        if (ToolUtil.isNotEmpty((Object)taskDefinitionKey) && ToolUtil.isNotEmpty((extensionElementsNode = ((Process)bm.getProcesses().get(0)).getExtensionElements()).get("extentAnnotation"))) {
            ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
            SimpleContext context = new SimpleContext();
            if (map != null && map.size() > 0) {
                if (lcdpBpmProperties.isUseSecurityLevel()) {
                    ArrayList<String> mjList = new ArrayList<String>();
                    if (map.containsKey("security_level_attribute")) {
                        List<String> list = Arrays.asList(map.get("security_level_attribute").toString().split(","));
                        for (String k : map.keySet()) {
                            if (!list.contains(k)) continue;
                            mjList.add(k.toString());
                        }
                    }
                    if (HussarUtils.isNotEmpty(mjList)) {
                        for (String mj : mjList) {
                            if (!HussarUtils.isNotEmpty((Object)map.get(mj))) continue;
                            map.put(mj, sysDicSecurityService.selectValueByKey(map.get(mj).toString()));
                        }
                    }
                }
                for (Object object : map.keySet()) {
                    if (map.get(object.toString()) != null) {
                        if (map.get(object.toString()) instanceof ArrayList) {
                            map.put(object.toString(), JSON.toJSONString((Object)map.get(object.toString())));
                        }
                        context.setVariable(object.toString(), factory.createValueExpression(map.get(object.toString()), map.get(object.toString()).getClass()));
                        continue;
                    }
                    context.setVariable(object.toString(), factory.createValueExpression(map.get(object.toString()), Object.class));
                }
            }
            for (ExtensionElement extensionElement : (List)extensionElementsNode.get("extentAnnotation")) {
                Annotation annotation = new Annotation();
                annotation.setId(((ExtensionAttribute)((List)extensionElement.getAttributes().get("annotationKey")).get(0)).getValue());
                annotation.setX(((ExtensionAttribute)((List)extensionElement.getAttributes().get("annotationX")).get(0)).getValue());
                annotation.setY(((ExtensionAttribute)((List)extensionElement.getAttributes().get("annotationY")).get(0)).getValue());
                annotation.setWidth(((ExtensionAttribute)((List)extensionElement.getAttributes().get("annotationWidth")).get(0)).getValue());
                annotation.setHeight(((ExtensionAttribute)((List)extensionElement.getAttributes().get("annotationHeight")).get(0)).getValue());
                String content = ((ExtensionAttribute)((List)extensionElement.getAttributes().get("annotationContent")).get(0)).getValue();
                if (ToolUtil.isNotEmpty((Object)content)) {
                    ValueExpression valueExpression = factory.createValueExpression((ELContext)context, content, String.class);
                    content = valueExpression.getValue((ELContext)context) == null ? "" : valueExpression.getValue((ELContext)context).toString();
                }
                annotation.setContent(content);
                annotations.add(annotation);
            }
        }
        return annotations;
    }

    private AnalyticalModelUtil() {
    }
}

