/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.check.model.ProcessCheckResult;
import com.jxdinfo.hussar.workflow.engine.bpm.check.service.ProcessCheckService;
import com.jxdinfo.hussar.workflow.engine.bpm.check.util.ParallelRelationshipCheckUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmFormdesignProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendActivitiListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.ExtendFieldExtension;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowPageMsg;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.flowmodel.OriginalTaskListener;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.Execution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class ProcessCheckServiceImpl
implements ProcessCheckService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private HistoryService historyService;
    @Autowired
    private BpmFormdesignProperties bpmFormdesignProperties;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ModelService modelService;
    private static final List<String> CHECK_VARIABLE_NODE_TYPE_LIST = new ArrayList<String>();
    private static final List<String> CHECK_CHANGE_NODE_TYPE_LIST = new ArrayList<String>();
    public static final String GOD_AXE_CHECK = "0";
    public static final String BPM_DESIGNER_CHECK = "1";
    public static final String NO_CODE_CHECK = "2";
    public static final String IMPORT_CHECK = "3";
    private static final Map<String, Set<String>> CHECK_MAP = new HashMap<String, Set<String>>();
    private static final String VARIABLE_CHECK = "VARIABLE_CHECK";
    private static final String BPM_DESIGN_VARIABLE_CHECK = "BPM_DESIGN_VARIABLE_CHECK";
    private static final String PARALLEL_RELATIONSHIP_CHECK = "PARALLEL_RELATIONSHIP_CHECK";
    private static final String RUNNING_TASK_CHANGE_CHECK = "RUNNING_TASK_CHANGE_CHECK";
    private static final String ERROR_MSG_PREFIX = "\u5f53\u524d\u6d41\u7a0b\u4e0d\u7b26\u5408\u6807\u51c6\u6d41\u7a0b\u7684\u89c4\u8303\u8981\u6c42\uff0c\u5b58\u5728\u4ee5\u4e0b\u95ee\u9898\uff1a";
    private static final String ERROR_MSG_SUFIX = "\u8bf7\u56de\u9000\u4fee\u6539\u6216\u4ece\u6807\u51c6\u5e94\u7528\u4e2d\u53d1\u5e03\u6807\u51c6\u7248\u672c\u3002";
    private static final String CHARACTER_SEPARATOR = "\u3002";
    private static final String SEQ_MULTI_SETTING_CHANGE = "%s.%s\u8282\u70b9\u4f1a\u7b7e\u914d\u7f6e\u53d1\u751f\u53d8\u5316;";
    private static final String LISTENER_SETTING_CHANGE = "%s.%s\u8282\u70b9%s\u76d1\u542c\u5668\u53d1\u751f\u53d8\u5316;";

    public ApiResponse<String> checkWorkflow(WorkFlow workFlow, WorkFlow oldWorkFlow, String checkType) {
        ApiResponse<String> response;
        if (this.runtimeService.createProcessInstanceQuery().processDefinitionId(oldWorkFlow.getProcDefId()).count() == 0L && !"listener".equals(this.lcdpBpmProperties.visitorGenerateType())) {
            ProcessCheckResult processCheckResult;
            if ((CHECK_MAP.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK) && "base".equals(this.lcdpBpmProperties.getTenantType()) || CHECK_MAP.get(checkType).contains(VARIABLE_CHECK)) && (processCheckResult = this.getProcessCheckResult(workFlow, oldWorkFlow, null, checkType)).isUserNewVariable()) {
                return ApiResponse.fail((int)BpmExceptionCodeEnum.UPDATE_PROCESS_WITH_VARIABLES.getCode(), (String)BpmExceptionCodeEnum.UPDATE_PROCESS_WITH_VARIABLES.getMessage());
            }
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        Map<String, Set<String>> runningNodeProcessCountMsg = null;
        if (CHECK_MAP.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK)) {
            runningNodeProcessCountMsg = this.getRunningNodeProcessCountMsg(oldWorkFlow.getProcDefId());
        }
        if (CHECK_MAP.get(checkType).contains(PARALLEL_RELATIONSHIP_CHECK) && !(response = this.checkPrallelRelationShip(workFlow, oldWorkFlow)).isSuccess()) {
            return response;
        }
        if (CHECK_MAP.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK) || CHECK_MAP.get(checkType).contains(VARIABLE_CHECK) || CHECK_MAP.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK)) {
            ProcessCheckResult processCheckResult = this.getProcessCheckResult(workFlow, oldWorkFlow, runningNodeProcessCountMsg, checkType);
            if (processCheckResult.getErrorProcessInstance() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder chageAndDeleteStringBuilder = new StringBuilder();
                Map errorNodeNameMap = processCheckResult.getErrorNodeNameMap();
                Map deleteNodeMap = processCheckResult.getDeleteNodeMap();
                Integer errorProcessInstance = processCheckResult.getErrorProcessInstance();
                for (Object key : deleteNodeMap.keySet()) {
                    chageAndDeleteStringBuilder.append(String.format(this.bpmConstantProperties.getDeleteNodeAffectProcess(), HussarUtils.isNotEmpty(errorNodeNameMap.get(key)) ? errorNodeNameMap.get(key) : key, errorProcessInstance));
                }
                Map changeNodeMap = processCheckResult.getChangeNodeMap();
                for (String key : changeNodeMap.keySet()) {
                    chageAndDeleteStringBuilder.append(String.format(this.bpmConstantProperties.getChangeNodeAffectProcess(), HussarUtils.isNotEmpty(errorNodeNameMap.get(key)) ? errorNodeNameMap.get(key) : key, errorProcessInstance));
                }
                if (IMPORT_CHECK.equals(checkType)) {
                    stringBuilder.append(String.format(this.bpmConstantProperties.getImportAffectedProcess(), errorProcessInstance));
                }
                stringBuilder.append((CharSequence)chageAndDeleteStringBuilder);
                String str = stringBuilder.toString();
                str = str.substring(0, str.length() - 1) + CHARACTER_SEPARATOR;
                return ApiResponse.fail((String)str);
            }
            if (!"listener".equals(this.lcdpBpmProperties.visitorGenerateType()) && processCheckResult.isUserNewVariable()) {
                return ApiResponse.fail((int)BpmExceptionCodeEnum.UPDATE_PROCESS_WITH_VARIABLES.getCode(), (String)BpmExceptionCodeEnum.UPDATE_PROCESS_WITH_VARIABLES.getMessage());
            }
        }
        return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
    }

    private ApiResponse<String> checkPrallelRelationShip(WorkFlow workFlow, WorkFlow oldWorkFlow) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        ApiResponse<String> response = ParallelRelationshipCheckUtil.checkWorkflowNodes(flowModel.getSlots(), oldFlowModel.getSlots());
        if (!response.isSuccess()) {
            return response;
        }
        for (FlowObject flowObject : flowModel.getSlots().getElement()) {
            if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
            FlowObject oldSubProcess = null;
            for (FlowObject object : oldFlowModel.getSlots().getElement()) {
                if (!flowObject.getId().equals(object.getId())) continue;
                oldSubProcess = object;
                break;
            }
            if (oldSubProcess == null || (response = ParallelRelationshipCheckUtil.checkWorkflowNodes(flowObject.getSlots(), oldSubProcess.getSlots())).isSuccess()) continue;
            return response;
        }
        return response;
    }

    private ProcessCheckResult getProcessCheckResult(WorkFlow workFlow, WorkFlow oldWorkFlow, Map<String, Set<String>> runningNodeProcessCountMsg, String checkType) {
        ProcessCheckResult result = new ProcessCheckResult();
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        FlowModel oldFlowModel = (FlowModel)JSON.parseObject((String)oldWorkFlow.getData(), FlowModel.class);
        HashMap<String, FlowObject> nodeMap = new HashMap<String, FlowObject>();
        List elements = flowModel.getSlots().getElement();
        for (FlowObject flowObject : elements) {
            nodeMap.put(flowObject.getId(), flowObject);
            if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
            List subProcessNodeList = flowObject.getSlots().getElement();
            Iterator iterator = subProcessNodeList.iterator();
            while (iterator.hasNext()) {
                FlowObject subProcessNode = (FlowObject)iterator.next();
                nodeMap.put(subProcessNode.getId(), subProcessNode);
            }
        }
        HashMap<String, FlowObject> oldNodeMap = new HashMap<String, FlowObject>();
        List oldElements = oldFlowModel.getSlots().getElement();
        for (FlowObject flowObject : oldElements) {
            oldNodeMap.put(flowObject.getId(), flowObject);
            if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
            List subProcessNodeList = flowObject.getSlots().getElement();
            for (FlowObject flowObject2 : subProcessNodeList) {
                oldNodeMap.put(flowObject2.getId(), flowObject2);
            }
        }
        if (CHECK_MAP.get(checkType).contains(RUNNING_TASK_CHANGE_CHECK) && runningNodeProcessCountMsg != null) {
            HashSet<String> errorProcessInstance = new HashSet<String>();
            HashSet<String> translateIds = new HashSet<String>();
            boolean needTranslate = BpmWorkflowTranslateUtil.getIsEnable();
            for (String string : runningNodeProcessCountMsg.keySet()) {
                Set<String> errorProcessInsIds;
                FlowObject oldFlowObject = (FlowObject)oldNodeMap.get(string);
                FlowObject newFlowObject = (FlowObject)nodeMap.get(string);
                if (oldFlowObject == null) continue;
                if (newFlowObject == null) {
                    errorProcessInsIds = runningNodeProcessCountMsg.get(oldFlowObject.getId());
                    errorProcessInstance.addAll(errorProcessInsIds);
                    result.getDeleteNodeMap().put(oldFlowObject.getId(), errorProcessInsIds.size());
                    if (needTranslate && HussarUtils.isNotEmpty((Object)oldFlowObject.getProps().getNodeNameTranslateId())) {
                        translateIds.add(oldFlowObject.getProps().getNodeNameTranslateId());
                        result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getNodeNameTranslateId());
                        continue;
                    }
                    result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getFlowName());
                    continue;
                }
                if (oldFlowObject.getProps().getFlowCountersign() == null) continue;
                if (oldFlowObject.getProps().getFlowCountersign().isCountersign() != newFlowObject.getProps().getFlowCountersign().isCountersign()) {
                    errorProcessInsIds = runningNodeProcessCountMsg.get(oldFlowObject.getId());
                    errorProcessInstance.addAll(errorProcessInsIds);
                    result.getChangeNodeMap().put(oldFlowObject.getId(), errorProcessInsIds.size());
                    if (needTranslate && HussarUtils.isNotEmpty((Object)oldFlowObject.getProps().getNodeNameTranslateId())) {
                        translateIds.add(oldFlowObject.getProps().getNodeNameTranslateId());
                        result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getNodeNameTranslateId());
                        continue;
                    }
                    result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getFlowName());
                    continue;
                }
                if (!newFlowObject.getProps().getFlowCountersign().isCountersign() || newFlowObject.getProps().getFlowCountersign().getSequential() == null || newFlowObject.getProps().getFlowCountersign().getSequential().equals(oldFlowObject.getProps().getFlowCountersign().getSequential())) continue;
                errorProcessInsIds = runningNodeProcessCountMsg.get(oldFlowObject.getId());
                errorProcessInstance.addAll(errorProcessInsIds);
                result.getChangeNodeMap().put(oldFlowObject.getId(), errorProcessInsIds.size());
                result.getErrorNodeNameMap().put(oldFlowObject.getId(), oldFlowObject.getProps().getFlowName());
            }
            if (needTranslate && !translateIds.isEmpty()) {
                Map translateMap = BpmWorkflowTranslateUtil.getTranslateNameMap(new ArrayList(translateIds));
                for (Object nodeId : result.getErrorNodeNameMap().keySet()) {
                    if (translateMap.get(result.getErrorNodeNameMap().get(nodeId)) == null) continue;
                    result.getErrorNodeNameMap().put(nodeId, translateMap.get(result.getErrorNodeNameMap().get(nodeId)));
                }
            }
            result.setErrorProcessInstance(Integer.valueOf(errorProcessInstance.size()));
        }
        if (CHECK_MAP.get(checkType).contains(BPM_DESIGN_VARIABLE_CHECK) && "base".equals(this.lcdpBpmProperties.getTenantType()) || CHECK_MAP.get(checkType).contains(VARIABLE_CHECK)) {
            Set<String> nodeVariableNames;
            String newTableName = null;
            HashSet<String> processVariableNames = new HashSet<String>();
            HashMap nodeVariableMap = new HashMap();
            HashMap<String, String> callActivityTables = new HashMap<String, String>();
            List list = flowModel.getProps().getUseVariables();
            if (list != null) {
                for (FlowVariables flowVariables : list) {
                    processVariableNames.add(flowVariables.getVariable());
                    if (newTableName != null || flowVariables.getTable() == null) continue;
                    newTableName = flowVariables.getTable();
                }
            }
            for (FlowObject flowObject : nodeMap.values()) {
                if (!CHECK_VARIABLE_NODE_TYPE_LIST.contains(flowObject.getName())) continue;
                HashSet<String> nodeVariableNames2 = new HashSet<String>();
                ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
                FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
                ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList<FlowVariables>();
                }
                nodeVariables.addAll(functionUserVariables);
                for (FlowVariables flowVariables : nodeVariables) {
                    nodeVariableNames2.add(flowVariables.getVariable());
                    if (newTableName != null || flowVariables.getTable() == null) continue;
                    newTableName = flowVariables.getTable();
                }
                nodeVariableNames2.addAll(processVariableNames);
                if (!nodeVariableNames2.isEmpty()) {
                    nodeVariableMap.put(flowObject.getId(), nodeVariableNames2);
                }
                if (!BpmNodeTypeUtil.isCallActivity((String)flowObject.getName())) continue;
                callActivityTables.put(flowObject.getId(), flowObject.getProps().getCallActivityTable() != null ? flowObject.getProps().getCallActivityTable().getTableId() : "");
            }
            String oldTableName = null;
            HashSet<String> oldProcessVariableNames = new HashSet<String>();
            HashMap<String, Set<String>> oldNodeVariableMap = new HashMap<String, Set<String>>();
            HashMap<String, String> oldCallActivityTables = new HashMap<String, String>();
            List oldProcessVariables = oldFlowModel.getProps().getUseVariables();
            if (oldProcessVariables != null) {
                for (FlowVariables flowVariables : oldProcessVariables) {
                    oldProcessVariableNames.add(flowVariables.getVariable());
                    if (oldTableName != null || flowVariables.getTable() == null) continue;
                    oldTableName = flowVariables.getTable();
                }
            }
            for (FlowObject flowObject : oldNodeMap.values()) {
                if (!CHECK_VARIABLE_NODE_TYPE_LIST.contains(flowObject.getName())) continue;
                nodeVariableNames = new HashSet();
                ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
                FormBpmnUtil.getFunctionMessage(flowObject.getProps(), new HashMap<String, String>(), functionUserVariables);
                ArrayList<FlowVariables> nodeVariables = flowObject.getProps().getUseVariables();
                if (nodeVariables == null) {
                    nodeVariables = new ArrayList<FlowVariables>();
                }
                nodeVariables.addAll(functionUserVariables);
                for (FlowVariables flowVariables : nodeVariables) {
                    nodeVariableNames.add(flowVariables.getVariable());
                    if (oldTableName != null || flowVariables.getTable() == null) continue;
                    oldTableName = flowVariables.getTable();
                }
                nodeVariableNames.addAll(oldProcessVariableNames);
                if (!nodeVariableNames.isEmpty()) {
                    oldNodeVariableMap.put(flowObject.getId(), nodeVariableNames);
                }
                if (!BpmNodeTypeUtil.isCallActivity((String)flowObject.getName())) continue;
                oldCallActivityTables.put(flowObject.getId(), flowObject.getProps().getCallActivityTable() != null ? flowObject.getProps().getCallActivityTable().getTableId() : "");
            }
            if (newTableName != null && !newTableName.equals(oldTableName)) {
                result.setUserNewVariable(true);
                return result;
            }
            if (CHECK_MAP.get(checkType).contains(VARIABLE_CHECK)) {
                for (String nodeId : callActivityTables.keySet()) {
                    if (((String)callActivityTables.get(nodeId)).equals(oldCallActivityTables.get(nodeId))) continue;
                    result.setUserNewVariable(true);
                    return result;
                }
            }
            for (String nodeId : nodeVariableMap.keySet()) {
                if (this.bpmFormdesignProperties.getOfflineLr().booleanValue()) {
                    if (oldNodeVariableMap.get(nodeId) != null) continue;
                    result.setUserNewVariable(true);
                    return result;
                }
                nodeVariableNames = (Set)nodeVariableMap.get(nodeId);
                nodeVariableNames.removeAll(oldNodeVariableMap.get(nodeId) != null ? (Collection)oldNodeVariableMap.get(nodeId) : new HashSet());
                if (nodeVariableNames.isEmpty()) continue;
                result.setUserNewVariable(true);
                return result;
            }
        }
        return result;
    }

    private Map<String, Set<String>> getRunningNodeProcessCountMsg(String procDefId) {
        List list = this.runtimeService.createExecutionQuery().processDefinitionId(procDefId).list();
        HashMap<String, Set<String>> runningNodeProcessCountMsg = new HashMap<String, Set<String>>();
        List historicList = this.historyService.createHistoricProcessInstanceQuery().isEmulation(BPM_DESIGNER_CHECK).processDefinitionId(procDefId).list();
        HashSet<String> executionIdsToRemove = new HashSet<String>();
        block0: for (Execution execution2 : list) {
            for (HistoricProcessInstance historicProcessInstance : historicList) {
                if (!historicProcessInstance.getId().equals(execution2.getProcessInstanceId())) continue;
                executionIdsToRemove.add(execution2.getId());
                continue block0;
            }
        }
        list.removeIf(execution -> executionIdsToRemove.contains(execution.getId()));
        for (Execution execution2 : list) {
            if (execution2.getActivityId() == null) continue;
            runningNodeProcessCountMsg.computeIfAbsent(execution2.getActivityId(), k -> new HashSet()).add(execution2.getProcessInstanceId());
        }
        return runningNodeProcessCountMsg;
    }

    public ApiResponse<List<String>> checkForStandardWorkflow(WorkFlow workflow) {
        WorkFlow standardWorkflow = this.modelService.getStandardWorkflowByKey(workflow.getIdentity(), workflow.getProcessTag());
        if (HussarUtils.isEmpty((Object)standardWorkflow)) {
            return ApiResponse.success();
        }
        FlowModel templateModel = (FlowModel)JSON.parseObject((String)standardWorkflow.getData(), FlowModel.class);
        List templateFlowObjects = templateModel.getSlots().getElement();
        List lockFlowObjects = templateFlowObjects.stream().filter(FlowObject::getInsEditorLocked).collect(Collectors.toList());
        FlowModel newModel = (FlowModel)JSON.parseObject((String)workflow.getData(), FlowModel.class);
        List newFlowObject = newModel.getSlots().getElement();
        Map newFlowObjectMap = newFlowObject.stream().collect(Collectors.toMap(FlowObject::getId, Function.identity()));
        ArrayList<String> errorMsgList = new ArrayList<String>();
        int num = 1;
        for (FlowObject templateObject : lockFlowObjects) {
            FlowObject newObject = (FlowObject)newFlowObjectMap.get(templateObject.getId());
            if (HussarUtils.isEmpty((Object)newObject)) {
                errorMsgList.add(String.format("%s.\u8282\u70b9%s\u7f3a\u5931;", num, templateObject.getAlias()));
                ++num;
                continue;
            }
            num = this.compareFlowObject(templateObject, newObject, errorMsgList, num);
        }
        errorMsgList.removeIf(HussarUtils::isEmpty);
        if (HussarUtils.isNotEmpty(errorMsgList)) {
            String lastErrorMsg = (String)errorMsgList.get(errorMsgList.size() - 1);
            lastErrorMsg = lastErrorMsg.substring(0, lastErrorMsg.length() - 1) + CHARACTER_SEPARATOR;
            errorMsgList.set(errorMsgList.size() - 1, lastErrorMsg);
            errorMsgList.get(errorMsgList.size() - 1);
            errorMsgList.add(0, ERROR_MSG_PREFIX);
            errorMsgList.add(ERROR_MSG_SUFIX);
            return ApiResponse.success(errorMsgList);
        }
        return ApiResponse.success();
    }

    private int compareFlowObject(FlowObject templateObject, FlowObject newObject, List<String> errorMsgList, int num) {
        ArrayList<String> newMessageTypeList;
        ArrayList<String> newSkipRepetition;
        String newNodeName = newObject.getProps().getFlowName();
        String nodeName = templateObject.getProps().getFlowName();
        BpmNodeTypeEnum nodeType = BpmNodeTypeEnum.getNodeTypeByStyleAndTypeName((String)templateObject.getName());
        BpmNodeTypeEnum newNodeType = BpmNodeTypeEnum.getNodeTypeByStyleAndTypeName((String)newObject.getName());
        if (!nodeType.getType().equals(newNodeType.getType())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u7c7b\u578b\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        if (!nodeName.equals(newNodeName)) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u540d\u79f0\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        num = this.compareFormAddress(templateObject, newObject, errorMsgList, num);
        if (!templateObject.getProps().getDescription().equals(newObject.getProps().getDescription())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u63cf\u8ff0\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        if (!this.eq(templateObject.getProps().getDueDate(), newObject.getProps().getDueDate())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u8d85\u65f6\u65f6\u95f4\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        if (!this.eq(templateObject.getProps().getChosenDay(), newObject.getProps().getChosenDay())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u8d85\u65f6\u65f6\u95f4\u7c7b\u578b\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        if (!this.eq(templateObject.getProps().getDelayToAssign(), newObject.getProps().getDelayToAssign())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u89e6\u53d1\u542f\u52a8\u914d\u7f6e\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        if (!this.eq(templateObject.getProps().getAllowSetParticipant(), newObject.getProps().getAllowSetParticipant())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u662f\u5426\u5141\u8bb8\u6307\u5b9a\u53c2\u4e0e\u8005\u914d\u7f6e\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        ArrayList<String> skipRepetition = HussarUtils.isEmpty((Object)templateObject.getProps().getFlowSkipRepetition()) ? new ArrayList<String>() : Arrays.asList(String.join((CharSequence)templateObject.getProps().getFlowSkipRepetition(), ","));
        List<String> list = newSkipRepetition = HussarUtils.isEmpty((Object)newObject.getProps().getFlowSkipRepetition()) ? new ArrayList<String>() : Arrays.asList(String.join((CharSequence)newObject.getProps().getFlowSkipRepetition(), ","));
        if (!this.eqList(skipRepetition, newSkipRepetition)) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u662f\u8df3\u8fc7\u914d\u7f6e\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        if (!this.eq(templateObject.getProps().getFlowSkipRepetition(), newObject.getProps().getFlowSkipRepetition())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u662f\u5426\u5141\u8bb8\u8df3\u8fc7\u914d\u7f6e\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        OriginalTaskListener originalTaskListener = templateObject.getProps().getOriginalTaskListener();
        OriginalTaskListener newOriginalTaskListener = templateObject.getProps().getOriginalTaskListener();
        num = this.compareListener(originalTaskListener, newOriginalTaskListener, nodeName, num, errorMsgList, "\u4efb\u52a1");
        OriginalTaskListener originalActivityListener = templateObject.getProps().getOriginalTaskListener();
        OriginalTaskListener newOriginalActivityListener = templateObject.getProps().getOriginalTaskListener();
        num = this.compareListener(originalActivityListener, newOriginalActivityListener, nodeName, num, errorMsgList, "\u6267\u884c");
        num = this.compareCountersign(templateObject, newObject, errorMsgList, num, nodeName);
        ArrayList<String> messageTypeList = HussarUtils.isEmpty((Object)templateObject.getProps().getMessageType()) ? new ArrayList<String>() : Arrays.asList(String.join((CharSequence)templateObject.getProps().getMessageType(), ","));
        List<String> list2 = newMessageTypeList = HussarUtils.isEmpty((Object)newObject.getProps().getMessageType()) ? new ArrayList<String>() : Arrays.asList(String.join((CharSequence)newObject.getProps().getMessageType(), ","));
        if (!this.eqList(messageTypeList, newMessageTypeList)) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u6d88\u606f\u63d0\u9192\u914d\u7f6e\u53d1\u751f\u53d8\u5316;", num, nodeName));
            ++num;
        }
        return num;
    }

    private int compareCountersign(FlowObject templateObject, FlowObject newObject, List<String> errorMsgList, int num, String nodeName) {
        if (!HussarUtils.isAllEmpty((Object[])new Object[]{templateObject.getProps().getFlowCountersign(), newObject.getProps().getFlowCountersign()})) {
            if (HussarUtils.isEmpty((Object)templateObject.getProps().getFlowCountersign()) || HussarUtils.isEmpty((Object)newObject.getProps().getFlowCountersign())) {
                errorMsgList.add(String.format(SEQ_MULTI_SETTING_CHANGE, num, nodeName));
                ++num;
            } else {
                MultiUser multiUser = templateObject.getProps().getFlowCountersign();
                MultiUser newMultiUser = newObject.getProps().getFlowCountersign();
                if (newMultiUser.isCountersign() != multiUser.isCountersign()) {
                    errorMsgList.add(String.format(SEQ_MULTI_SETTING_CHANGE, num, nodeName));
                    ++num;
                } else if (multiUser.getCountersignNumByCount() != newMultiUser.getCountersignNumByCount()) {
                    errorMsgList.add(String.format(SEQ_MULTI_SETTING_CHANGE, num, nodeName));
                    ++num;
                } else if (Double.compare(multiUser.getCountersignNumByRatio(), newMultiUser.getCountersignNumByRatio()) != 0) {
                    errorMsgList.add(String.format(SEQ_MULTI_SETTING_CHANGE, num, nodeName));
                    ++num;
                } else if (!this.eq(multiUser.getCountersignType(), newMultiUser.getCountersignType())) {
                    errorMsgList.add(String.format(SEQ_MULTI_SETTING_CHANGE, num, nodeName));
                    ++num;
                }
            }
        }
        return num;
    }

    private boolean eq(String a, String b) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{a, b})) {
            return true;
        }
        if (HussarUtils.isEmpty((Object)a) || HussarUtils.isEmpty((Object)b)) {
            return false;
        }
        return a.equals(b);
    }

    private boolean eqList(List<String> a, List<String> b) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{a, b})) {
            return true;
        }
        if (HussarUtils.isEmpty(a) || HussarUtils.isEmpty(b)) {
            return false;
        }
        return new HashSet<String>(a).equals(new HashSet<String>(b));
    }

    private int compareListener(OriginalTaskListener originalTaskListener, OriginalTaskListener newOriginalTaskListener, String nodeName, int num, List<String> errorMsgList, String listenerType) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{originalTaskListener, newOriginalTaskListener})) {
            return num;
        }
        if (HussarUtils.isEmpty((Object)originalTaskListener) || HussarUtils.isEmpty((Object)newOriginalTaskListener)) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9%s\u76d1\u542c\u5668\u914d\u7f6e\u53d1\u751f\u53d8\u5316;", num, nodeName, listenerType));
            return num + 1;
        }
        if (!this.eq(originalTaskListener.getListenerNum(), newOriginalTaskListener.getListenerNum())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9%s\u76d1\u542c\u5668\u6570\u91cf\u53d1\u751f\u53d8\u5316;", num, nodeName, listenerType));
            return num + 1;
        }
        List taskListenerList = "\u4efb\u52a1".equals(listenerType) ? originalTaskListener.getTaskListener() : originalTaskListener.getActivityListener();
        List newTaskListenerList = "\u4efb\u52a1".equals(listenerType) ? newOriginalTaskListener.getTaskListener() : originalTaskListener.getActivityListener();
        Map taskListenerMap = taskListenerList.stream().collect(Collectors.toMap(ExtendActivitiListener::getImplementation, Function.identity()));
        Map newTaskListenerMap = newTaskListenerList.stream().collect(Collectors.toMap(ExtendActivitiListener::getImplementation, Function.identity()));
        for (String key : taskListenerMap.keySet()) {
            if (HussarUtils.isEmpty(newTaskListenerMap.get(key))) {
                errorMsgList.add(String.format(LISTENER_SETTING_CHANGE, num, nodeName, listenerType));
                return num + 1;
            }
            ExtendActivitiListener taskListener = (ExtendActivitiListener)taskListenerMap.get(key);
            ExtendActivitiListener newTaskListener = (ExtendActivitiListener)taskListenerMap.get(key);
            if (!taskListener.getEvent().equals(newTaskListener.getEvent()) || !taskListener.getImplementationType().equals(newTaskListener.getImplementationType())) {
                errorMsgList.add(String.format(LISTENER_SETTING_CHANGE, num, nodeName, listenerType));
                return num + 1;
            }
            Map fieldExtensions = taskListener.getFieldExtensions().stream().collect(Collectors.toMap(ExtendFieldExtension::getFieldName, Function.identity(), (oldValue, newValue) -> newValue));
            Map newFieldExtensions = newTaskListener.getFieldExtensions().stream().collect(Collectors.toMap(ExtendFieldExtension::getFieldName, Function.identity(), (oldValue, newValue) -> newValue));
            for (String fieldName : fieldExtensions.keySet()) {
                if (HussarUtils.isEmpty(newFieldExtensions.get(fieldName))) {
                    errorMsgList.add(String.format(LISTENER_SETTING_CHANGE, num, nodeName, listenerType));
                    return num + 1;
                }
                if (this.eq(((ExtendFieldExtension)fieldExtensions.get(fieldName)).getStringValue(), ((ExtendFieldExtension)newFieldExtensions.get(fieldName)).getStringValue())) {
                    errorMsgList.add(String.format(LISTENER_SETTING_CHANGE, num, nodeName, listenerType));
                    return num + 1;
                }
                if (!this.eq(((ExtendFieldExtension)fieldExtensions.get(fieldName)).getExpression(), ((ExtendFieldExtension)newFieldExtensions.get(fieldName)).getExpression())) continue;
                errorMsgList.add(String.format(LISTENER_SETTING_CHANGE, num, nodeName, listenerType));
                return num + 1;
            }
        }
        return num;
    }

    private int compareFormAddress(FlowObject templateObject, FlowObject newObject, List<String> errorMsgList, int num) {
        if (!this.checkAddress(templateObject.getProps().getFormAddress(), newObject.getProps().getFormAddress())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u5f85\u529e\u8868\u5355\u5730\u5740\u6216\u6743\u9650\u53d1\u751f\u53d8\u5316;", num, newObject.getAlias()));
            ++num;
        }
        if (!this.checkAddress(templateObject.getProps().getFormDetailAddress(), newObject.getProps().getFormDetailAddress())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u5df2\u529e\u8868\u5355\u5730\u5740\u6216\u6743\u9650\u53d1\u751f\u53d8\u5316;", num, newObject.getAlias()));
            ++num;
        }
        if (!this.checkAddress(templateObject.getProps().getCcFormAddress(), newObject.getProps().getCcFormAddress())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u4f20\u9605\u5f85\u529e\u8868\u5355\u5730\u5740\u6216\u6743\u9650\u53d1\u751f\u53d8\u5316;", num, newObject.getAlias()));
            ++num;
        }
        if (!this.checkAddress(templateObject.getProps().getCcFormDetailAddress(), newObject.getProps().getCcFormDetailAddress())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u4f20\u9605\u5df2\u529e\u8868\u5355\u5730\u5740\u6216\u6743\u9650\u53d1\u751f\u53d8\u5316;", num, newObject.getAlias()));
            ++num;
        }
        if (!this.checkAddress(templateObject.getProps().getAssistFormAddress(), newObject.getProps().getAssistFormAddress())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u534f\u529e\u5f85\u529e\u8868\u5355\u5730\u5740\u6216\u6743\u9650\u53d1\u751f\u53d8\u5316;", num, newObject.getAlias()));
            ++num;
        }
        if (!this.checkAddress(templateObject.getProps().getAssistFormDetailAddress(), newObject.getProps().getAssistFormDetailAddress())) {
            errorMsgList.add(String.format("%s.%s\u8282\u70b9\u534f\u529e\u5df2\u529e\u8868\u5355\u5730\u5740\u6216\u6743\u9650\u53d1\u751f\u53d8\u5316;", num, newObject.getAlias()));
            ++num;
        }
        return num;
    }

    private boolean checkAddress(Map<String, FlowPageMsg> templateMsgMap, Map<String, FlowPageMsg> newPageMsgMap) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{templateMsgMap, newPageMsgMap})) {
            return true;
        }
        if (HussarUtils.isEmpty(templateMsgMap) || HussarUtils.isEmpty(newPageMsgMap)) {
            return false;
        }
        for (String formAddress : templateMsgMap.keySet()) {
            FlowPageMsg newPageMsg;
            FlowPageMsg templateMsg = templateMsgMap.get(formAddress);
            if (templateMsg.isEquals(newPageMsg = newPageMsgMap.get(formAddress))) continue;
            return false;
        }
        return true;
    }

    static {
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getVisitType());
        CHECK_VARIABLE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_ANNOTATION.getVisitType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_USER.getVisitType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getVisitType());
        CHECK_CHANGE_NODE_TYPE_LIST.add(BpmNodeTypeEnum.BPM_SUB_PROCESS.getVisitType());
        HashSet<String> godAxeCheck = new HashSet<String>();
        godAxeCheck.add(VARIABLE_CHECK);
        godAxeCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        godAxeCheck.add(RUNNING_TASK_CHANGE_CHECK);
        CHECK_MAP.put(GOD_AXE_CHECK, godAxeCheck);
        HashSet<String> bpmDesignCheck = new HashSet<String>();
        bpmDesignCheck.add(BPM_DESIGN_VARIABLE_CHECK);
        bpmDesignCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        bpmDesignCheck.add(RUNNING_TASK_CHANGE_CHECK);
        CHECK_MAP.put(BPM_DESIGNER_CHECK, bpmDesignCheck);
        HashSet<String> noCodeCheck = new HashSet<String>();
        noCodeCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        noCodeCheck.add(RUNNING_TASK_CHANGE_CHECK);
        CHECK_MAP.put(NO_CODE_CHECK, noCodeCheck);
        HashSet<String> importCheck = new HashSet<String>();
        importCheck.add(PARALLEL_RELATIONSHIP_CHECK);
        importCheck.add(RUNNING_TASK_CHANGE_CHECK);
        CHECK_MAP.put(IMPORT_CHECK, importCheck);
    }
}

