/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtest.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.vo.ProcessInstVo;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.dao.ProcessBetaMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.dao.ProcessTestMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ProcessListDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.ProcessInstModel;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.SysActTestDetail;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.SysActTestLog;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.ProcessBetaService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.ProcessDiagramTestService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.TestLogDetailService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.TestLogService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.VariableService;
import com.jxdinfo.hussar.workflow.manage.engine.InstanceEngineService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessBetaServiceImpl
implements ProcessBetaService {
    @Resource
    private ProcessBetaMapper processBetaMapper;
    @Autowired
    private ProcessDiagramTestService processDiagramTestService;
    @Autowired
    private ProcessInstService processInstService;
    @Autowired
    private VariableService variableService;
    @Resource
    private ProcessTestMapper processTestMapper;
    @Autowired
    private TestLogDetailService testLogDetailService;
    @Autowired
    private TestLogService testLogService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    public Page<ProcessInstModel> getProcessBetaList(Page<ProcessInstModel> page, ProcessListDto processListDto) {
        if (HussarUtils.isNotEmpty((Object)processListDto.getStartTimeEnd())) {
            Date endTime = new Date(processListDto.getStartTimeEnd().getTime() + 999L);
            processListDto.setStartTimeEnd(endTime);
        }
        List<ProcessInstModel> instList = this.processBetaMapper.getListMySql(page, processListDto);
        HashSet<Long> procInstIds = new HashSet<Long>();
        for (ProcessInstModel processInst : instList) {
            procInstIds.add(Long.parseLong(processInst.getProcessInsId()));
        }
        if (!instList.isEmpty()) {
            List<ProcessInstVo> nodeList = this.processBetaMapper.getNodeNames(procInstIds);
            HashMap<Long, Set> nodeMap = new HashMap<Long, Set>();
            for (ProcessInstVo node : nodeList) {
                Long procInstId = 0L;
                procInstId = node.getProcessInsId();
                Set set = (Set)nodeMap.get(procInstId);
                set = set == null ? new HashSet() : set;
                set.add(node.getActName());
                nodeMap.put(procInstId, set);
            }
            for (ProcessInstModel processInst : instList) {
                Set nodeNames = (Set)nodeMap.get(Long.parseLong(processInst.getProcessInsId()));
                if (nodeNames != null && !nodeNames.isEmpty()) {
                    processInst.setNames(String.join((CharSequence)",", nodeNames));
                }
                if (HussarUtils.isNotEmpty((Object)processInst.getInstanceFlag())) {
                    processInst.setInstanceFlag("1");
                    continue;
                }
                processInst.setInstanceFlag("0");
            }
        }
        page.setRecords(instList);
        return page;
    }

    public Map<String, Object> list(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        Map result = this.processDiagramTestService.list(processInsId, businessId, subProcessKey, cycleCount);
        JSONArray jsonArray = (JSONArray)result.get("data");
        for (Object json : jsonArray) {
            JSONArray nodeArray = (JSONArray)((JSONObject)json).get((Object)"subProcessTask");
            String activityId = (String)((JSONObject)json).get((Object)"activityId");
            if (nodeArray == null) continue;
            JSONObject instanceObject = new JSONObject();
            JSONArray newInstanceArray = new JSONArray();
            instanceObject.put("activityId", (Object)activityId);
            instanceObject.put("activityName", (Object)this.bpmConstantProperties.getSimulationInstance1());
            instanceObject.put("subProcessTask", (Object)nodeArray);
            newInstanceArray.add((Object)instanceObject);
            ((JSONObject)json).put("subProcessTask", (Object)newInstanceArray);
        }
        return result;
    }

    public ApiResponse<JSONObject> getProcessInfoForProcessTesting(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processDiagramTestService.getProcessInfoForProcessTesting(processInsId, businessId, subProcessKey, cycleCount);
    }

    public JSONObject getProcessInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processDiagramTestService.getProcessInfo(processInsId, businessId, subProcessKey, cycleCount);
    }

    public JSONArray getProcessCompleteInfo(String processInsId, String businessId, String subProcessKey, Integer cycleCount) {
        return this.processDiagramTestService.getProcessCompleteInfo(processInsId, businessId, subProcessKey, cycleCount);
    }

    public ApiResponse<JSONObject> getSubProcessRunningInfoForProcessTesting(String processInsId, String businessId) {
        return this.processDiagramTestService.getSubProcessRunningInfoForProcessTesting(processInsId, businessId);
    }

    public JSONObject getSubProcessRunningInfo(String processInsId, String businessId) {
        return this.processDiagramTestService.getSubProcessRunningInfo(processInsId, businessId);
    }

    public Map<String, Object> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        return this.processDiagramTestService.subProcessList(supProcessInsId, businessId, taskDefinitionKey, page, size);
    }

    public ApiResponse<String> deleteFinishedProcessInstance(String processInstCode) {
        this.variableService.removeById((Serializable)Long.valueOf(processInstCode));
        this.testLogDetailService.deleteWorkflowLog(processInstCode, null);
        return this.processInstService.deleteFinishedProcessInstance(processInstCode);
    }

    public ApiResponse<String> deleteProcessInstance(List<String> processInsId) {
        List<String> allProcesInsId = this.getAllProcInsId(processInsId);
        ArrayList<Long> longAllProcInsId = new ArrayList<Long>();
        for (String insId : allProcesInsId) {
            longAllProcInsId.add(Long.parseLong(insId));
        }
        String businessId = this.getBusinessIdListByProcInsIds(longAllProcInsId);
        this.variableService.removeByIds(longAllProcInsId);
        BpmResponseResult result = InstanceEngineService.deleteProcessInstanceByBusinessKeyList((String)businessId, (boolean)false);
        LambdaQueryWrapper detailWrapper = new LambdaQueryWrapper();
        detailWrapper.in(SysActTestDetail::getProcInstId, longAllProcInsId);
        this.testLogDetailService.remove((Wrapper)detailWrapper);
        LambdaQueryWrapper logWrapper = new LambdaQueryWrapper();
        logWrapper.in(SysActTestLog::getProcInstId, longAllProcInsId);
        this.testLogService.remove((Wrapper)logWrapper);
        return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
    }

    private List<String> getAllProcInsId(List<String> procInsId) {
        List<Long> subProcessInsId;
        ArrayList<Long> longProcInsId = new ArrayList<Long>();
        for (String insId : procInsId) {
            longProcInsId.add(Long.parseLong(insId));
        }
        List<Long> parentProcessInsId = new ArrayList<Long>();
        parentProcessInsId.addAll(longProcInsId);
        while (HussarUtils.isNotEmpty(subProcessInsId = this.processTestMapper.getSubProcInsId(parentProcessInsId))) {
            longProcInsId.addAll(subProcessInsId);
            parentProcessInsId = subProcessInsId;
        }
        ArrayList<String> finalProcInsId = new ArrayList<String>();
        for (Long insId : longProcInsId) {
            finalProcInsId.add(String.valueOf(insId));
        }
        return finalProcInsId;
    }

    private String getBusinessIdListByProcInsIds(List<Long> procInsId) {
        List<Object> businessIdList = new ArrayList();
        businessIdList = this.processTestMapper.getBusinessIdListByProcInsIds(procInsId);
        String busienssId = businessIdList.stream().collect(Collectors.joining(","));
        return busienssId;
    }
}

