/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.dao.SysActUrgeTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskCompleteListener
implements ActivitiEventListener {
    @Resource
    private SysActUrgeTaskMapper sysActUrgeTaskMapper;
    @Autowired
    private DataPushService dataPushService;
    private static Logger logger = LogManager.getLogger(TaskCompleteListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        if (!taskEntity.isDeleted()) {
            HistoricTaskInstanceEntity historicTaskInstanceEntity;
            String assignee = taskEntity.getAssignee();
            if (HussarUtils.isEmpty((Object)taskEntity.getTaskSourceFlag())) {
                taskEntity.setTaskSourceFlag(BpmAttribute.getTaskSourceFlag((ActivityExecution)taskEntity.getProcessInstance()));
            }
            String processKey = taskEntity.getProcessDefinitionId().split(":")[0];
            String version = taskEntity.getProcessDefinitionId().split(":")[1];
            Map<String, JSONObject> pageTypeMap = CommonCodeUtil.getPageTypeByTaskType(processKey, Integer.valueOf(version), taskEntity.getTaskDefinitionKey(), "done");
            taskEntity.setPageType(JSON.toJSONString(pageTypeMap));
            if (assignee == null && (historicTaskInstanceEntity = Context.getCommandContext().getHistoricTaskInstanceEntityManager().findHistoricTaskInstanceById(taskEntity.getId())) != null) {
                assignee = historicTaskInstanceEntity.getAssignee();
            }
            List ccEntities = Context.getCommandContext().getCcTaskEntityManager().getCcTaskByProcessInsIdAndTaskDefKey(taskEntity.getTaskDefinitionKey(), Long.valueOf(taskEntity.getProcessInstanceId()));
            CcTaskEntity ccTask = null;
            for (CcTaskEntity ccTaskEntity : ccEntities) {
                if (assignee == null || !assignee.equals(ccTaskEntity.getReceiveUser())) continue;
                ccTask = ccTaskEntity;
            }
            if (ccTask != null) {
                ccTask.setTaskState("1");
                ccTask.setEndTime(new Timestamp(System.currentTimeMillis()));
                Map<String, JSONObject> ccDonePageTypeMap = CommonCodeUtil.getPageTypeByTaskType(ccTask.getProcDefKey(), Integer.valueOf(version), ccTask.getTaskDefKey(), "ccDone");
                ccTask.setPageType(JSON.toJSONString(ccDonePageTypeMap));
                ccTask.updateCcTask();
                HashSet<String> processDefinitionIdList = new HashSet<String>();
                processDefinitionIdList.add(taskEntity.getProcessDefinitionId());
                if (this.dataPushService.isDataPush(processDefinitionIdList)) {
                    DataPush dataPush = new DataPush();
                    dataPush.setUserId(assignee);
                    dataPush.setTaskId(String.valueOf(ccTask.getTaskId()));
                    dataPush.setEndDate((Date)ccTask.getEndTime());
                    dataPush.setProcessInsId(String.valueOf(ccTask.getProcessInsId()));
                    dataPush.setProcessKey(ccTask.getProcDefKey());
                    this.dataPushService.readCcTask(dataPush);
                }
            }
        }
        if ("1".equals(taskEntity.getUrgeState())) {
            this.sysActUrgeTaskMapper.deleteByTaskId(Long.parseLong(taskEntity.getId()));
        }
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u5b8c\u6210\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

