/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAttributeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.ProcessDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CcTaskEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricScopeInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class CompleteFinalPushCmd
extends AddAttributeCmd<Void> {
    private DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    private IFlowTaskService flowTaskService = (IFlowTaskService)BpmSpringContextHolder.getBean(IFlowTaskService.class);
    private String userId;
    private String comment;
    private String processState;
    private String processInsId;
    private static final String CC_ADD = "ccAdd";

    public CompleteFinalPushCmd(String processInsId, String userId, String comment, String processState) {
        this.processInsId = processInsId;
        this.userId = userId;
        this.comment = comment;
        this.processState = processState;
    }

    public Void execute(CommandContext commandContext) {
        List list = commandContext.getDbSqlSession().findInCache(HistoricProcessInstanceEntity.class);
        List executionEntities = commandContext.getDbSqlSession().findInCache(ExecutionEntity.class);
        Set<String> processInstanceIds = executionEntities.stream().map(ExecutionEntity::getProcessInstanceId).collect(Collectors.toSet());
        Set listIds = list.stream().map(HistoricScopeInstanceEntity::getProcessInstanceId).collect(Collectors.toSet());
        processInstanceIds.removeAll(listIds);
        if (!processInstanceIds.isEmpty()) {
            processInstanceIds.forEach(id -> commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(id));
            list = commandContext.getDbSqlSession().findInCache(HistoricProcessInstanceEntity.class);
        }
        if (list.isEmpty() && this.processInsId != null) {
            list.add(commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(this.processInsId));
        }
        for (HistoricProcessInstanceEntity historicProcessInstanceEntity : list) {
            this.processChangeDataPush(commandContext, historicProcessInstanceEntity.getId());
        }
        return null;
    }

    private void processChangeDataPush(CommandContext commandContext, String processInsId) {
        HistoricTaskInstanceEntity historicTaskInstanceEntity;
        DataPush taskDataPush;
        List ccFormKeyList;
        Map ccFormKeyMap;
        String formKey;
        List ccElement;
        String ccUrl;
        CcTaskEntity cc;
        ArrayList<ProcessNode> processNodes;
        ExecutionEntity executionEntity = commandContext.getExecutionEntityManager().findExecutionById(processInsId);
        if (executionEntity == null || !this.dataPushService.isDataPush(executionEntity.getProcessDefinitionId())) {
            return;
        }
        HistoricProcessInstanceEntity historicProcessInstanceEntity = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInsId);
        HistoricTaskInstanceQueryImpl historicTaskInstanceQuery = new HistoricTaskInstanceQueryImpl();
        historicTaskInstanceQuery.processInstanceId(processInsId);
        commandContext.getHistoricTaskInstanceEntityManager().findHistoricTaskInstancesByQueryCriteria(historicTaskInstanceQuery);
        HistoricActivityInstanceQueryImpl historicActivityInstanceQuery = new HistoricActivityInstanceQueryImpl();
        historicActivityInstanceQuery.processInstanceId(processInsId).isUnfinished();
        commandContext.getHistoricActivityInstanceEntityManager().findHistoricActivityInstancesByQueryCriteria(historicActivityInstanceQuery, null);
        DataPush dataPush = new DataPush();
        dataPush.setBusinessKey(historicProcessInstanceEntity.getBusinessKey());
        dataPush.setProcessKey(historicProcessInstanceEntity.getProcessDefinitionKey());
        dataPush.setProcessInsId(historicProcessInstanceEntity.getProcessInstanceId());
        dataPush.setProcessName(executionEntity.getProcessDefinition().getName());
        dataPush.setProcessDefinitionId(historicProcessInstanceEntity.getProcessDefinitionId());
        dataPush.setProcessStartTime(historicProcessInstanceEntity.getStartTime());
        if (historicProcessInstanceEntity.getEndTime() != null) {
            dataPush.setProcessState("completeProcess");
        } else {
            dataPush.setProcessState(this.processState);
        }
        dataPush.setStartUserId(this.userId);
        dataPush.setStartOrganId(historicProcessInstanceEntity.getOrganId());
        dataPush.setDescription((String)executionEntity.getVariableLocal("todoConfiguration"));
        String processTitle = executionEntity.getProcessTitle();
        String dataDetail = executionEntity.getDataDetail();
        dataPush.setProcessTitle(processTitle);
        dataPush.setDataDetail(dataDetail);
        BpmnModel bpmnModel = Context.getCommandContext().getProcessEngineConfiguration().getRepositoryService().getBpmnModel(executionEntity.getProcessDefinitionId());
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        String targetNodeId = null;
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            targetNodeId = ((SequenceFlow)((StartEvent)flowElement).getOutgoingFlows().get(0)).getTargetRef();
            break;
        }
        dataPush.setTaskDefinitionKey(targetNodeId);
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask) || !targetNodeId.equals(flowElement.getId())) continue;
            String formKey2 = ((UserTask)flowElement).getFormKey();
            dataPush.setUrl(formKey2);
            break;
        }
        dataPush.setAppId(this.flowTaskService.getProcessAppId(executionEntity.getProcessDefinitionKey()));
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        List aliveList = commandContext.getDbSqlSession().findAliveEntityInCache(HistoricTaskInstanceEntity.class);
        aliveList.removeIf(e -> !processInsId.equals(e.getProcessInstanceId()));
        if (historicProcessInstanceEntity.getEndTime() != null) {
            String endActId = historicProcessInstanceEntity.getEndActivityId();
            if (HussarUtils.isEmpty((Object)endActId)) {
                dataPush.setProcessState("deleteProcess");
            } else {
                String endName = bpmnModel.getFlowElement(endActId).getName();
                processNodes = new ArrayList<ProcessNode>();
                ProcessNode end = new ProcessNode();
                end.setTaskDefinitionName(endName);
                end.setTaskDefinitionKey(endActId);
                processNodes.add(end);
                dataPush.setProcessNodeList(processNodes);
                dataPush.setProcessEndTime(historicProcessInstanceEntity.getEndTime());
                dataPush.setProcessNode(endName);
            }
        } else {
            ProcessNode processNode;
            HashMap processNodeMap = new HashMap();
            List activityInstanceEntities = commandContext.getDbSqlSession().findAliveEntityInCache(HistoricActivityInstanceEntity.class);
            activityInstanceEntities.removeIf(e -> !processInsId.equals(e.getProcessInstanceId()));
            processNodes = new ArrayList();
            HashSet<String> runningNodeIdList = new HashSet<String>();
            HashMap subRunningNodeIdListMap = new HashMap();
            for (HistoricActivityInstanceEntity activityInstanceEntity : activityInstanceEntities) {
                String activityType;
                if (activityInstanceEntity.getEndTime() != null || !"receiveTask".equals(activityType = activityInstanceEntity.getActivityType()) && !"callActivity".equals(activityType)) continue;
                String subProcessKey = activityInstanceEntity.getSubProcessKey();
                if (subProcessKey != null) {
                    ProcessNode subProcessNode = null;
                    if (processNodeMap.containsKey(subProcessKey)) {
                        subProcessNode = (ProcessNode)processNodeMap.get(subProcessKey);
                    } else {
                        String nodeId = subProcessKey.split(":")[0];
                        subProcessNode = new ProcessNode();
                        subProcessNode.setTaskDefinitionKey(nodeId);
                        subProcessNode.setTaskDefinitionName(bpmnModel.getFlowElement(nodeId).getName());
                        subProcessNode.setChildrenList(new ArrayList());
                        processNodes.add(subProcessNode);
                        subRunningNodeIdListMap.put(subProcessKey, new HashSet());
                    }
                    if (!((Set)subRunningNodeIdListMap.get(subProcessKey)).add(activityInstanceEntity.getActivityId())) continue;
                    ProcessNode processNode2 = new ProcessNode();
                    processNode2.setTaskDefinitionKey(activityInstanceEntity.getActivityId());
                    processNode2.setTaskDefinitionName(activityInstanceEntity.getActivityName());
                    subProcessNode.getChildrenList().add(processNode2);
                    continue;
                }
                if (!runningNodeIdList.add(activityInstanceEntity.getActivityId())) continue;
                processNode = new ProcessNode();
                processNode.setTaskDefinitionKey(activityInstanceEntity.getActivityId());
                processNode.setTaskDefinitionName(activityInstanceEntity.getActivityName());
                processNodes.add(processNode);
            }
            for (HistoricTaskInstanceEntity historicTask : aliveList) {
                if (historicTask.getEndTime() != null) continue;
                String subProcessKey = historicTask.getSubProcessKey();
                if (subProcessKey != null) {
                    ProcessNode subProcessNode = null;
                    if (processNodeMap.containsKey(subProcessKey)) {
                        subProcessNode = (ProcessNode)processNodeMap.get(subProcessKey);
                    } else {
                        String nodeId = subProcessKey.split(":")[0];
                        subProcessNode = new ProcessNode();
                        subProcessNode.setTaskDefinitionKey(nodeId);
                        subProcessNode.setTaskDefinitionName(bpmnModel.getFlowElement(nodeId).getName());
                        subProcessNode.setChildrenList(new ArrayList());
                        processNodes.add(subProcessNode);
                        subRunningNodeIdListMap.put(subProcessKey, new HashSet());
                    }
                    if (!((Set)subRunningNodeIdListMap.get(subProcessKey)).add(historicTask.getTaskDefinitionKey())) continue;
                    processNode = new ProcessNode();
                    processNode.setTaskDefinitionKey(historicTask.getTaskDefinitionKey());
                    processNode.setTaskDefinitionName(historicTask.getName());
                    subProcessNode.getChildrenList().add(processNode);
                    continue;
                }
                if (!runningNodeIdList.add(historicTask.getTaskDefinitionKey())) continue;
                ProcessNode processNode3 = new ProcessNode();
                processNode3.setTaskDefinitionKey(historicTask.getTaskDefinitionKey());
                processNode3.setTaskDefinitionName(historicTask.getName());
                processNodes.add(processNode3);
            }
            dataPush.setProcessNodeList(processNodes);
            dataPush.setProcessNode(String.join((CharSequence)",", processNodes.stream().map(ProcessNode::getTaskDefinitionName).collect(Collectors.toSet())));
        }
        List addList = dbSqlSession.findAddEntityInCache(HistoricTaskInstanceEntity.class);
        List updateList = dbSqlSession.findUpdateEntityInCache(HistoricTaskInstanceEntity.class);
        List removeList = dbSqlSession.findRemoveEntityInCache(HistoricTaskInstanceEntity.class);
        List updateIdentityLinkTaskList = dbSqlSession.findUpdateIdentityLinkTaskEntityInCache(HistoricTaskInstanceEntity.class);
        updateIdentityLinkTaskList.removeAll(addList);
        updateIdentityLinkTaskList.removeAll(updateList);
        updateIdentityLinkTaskList.removeAll(removeList);
        updateList.addAll(updateIdentityLinkTaskList);
        addList.removeIf(e -> !processInsId.equals(e.getProcessInstanceId()));
        updateList.removeIf(e -> !processInsId.equals(e.getProcessInstanceId()));
        removeList.removeIf(e -> !processInsId.equals(e.getProcessInstanceId()));
        List ccAddList = dbSqlSession.findAddEntityInCache(CcTaskEntity.class);
        List ccUpdateList = dbSqlSession.findUpdateEntityInCache(CcTaskEntity.class);
        List ccRemoveList = dbSqlSession.findRemoveEntityInCache(CcTaskEntity.class);
        ccAddList.removeIf(e -> !processInsId.equals(String.valueOf(e.getProcessInsId())));
        ccUpdateList.removeIf(e -> !processInsId.equals(String.valueOf(e.getProcessInsId())));
        ccRemoveList.removeIf(e -> !processInsId.equals(String.valueOf(e.getProcessInsId())));
        Map<String, List<CcTaskEntity>> ccAddMap = WorkflowBpmUtil.getListMap(ccAddList, CcTaskEntity::getTaskId, null);
        Map<String, List<CcTaskEntity>> ccRemoveMap = WorkflowBpmUtil.getListMap(ccRemoveList, CcTaskEntity::getProcessInsId, null);
        List ccAllList = dbSqlSession.findInCache(CcTaskEntity.class);
        Map<String, CcTaskEntity> ccMap = WorkflowBpmUtil.getMap(ccAllList, CcTaskEntity::getTaskId, null);
        List list = commandContext.getDbSqlSession().findInCache(HistoricTaskInstanceEntity.class);
        Map<String, HistoricTaskInstanceEntity> taskMap = WorkflowBpmUtil.getMap(list, HistoricScopeInstanceEntity::getId, null);
        ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
        for (HistoricTaskInstanceEntity historicTaskInstanceEntity2 : addList) {
            cc = ccMap.get(historicTaskInstanceEntity2.getId());
            ccUrl = null;
            if (HussarUtils.isNotEmpty((Object)cc)) {
                ccUrl = cc.getFormKey();
            } else {
                ccElement = (List)bpmnModel.getFlowElement(historicTaskInstanceEntity2.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
                formKey = null;
                if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                    formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
                }
                ccUrl = formKey;
            }
            taskDataPush = this.dataPush(historicTaskInstanceEntity2, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl);
            if (historicTaskInstanceEntity2.getEndTime() != null) {
                taskDataPush.setType("addComplete");
                taskDataPush.setUserId(historicTaskInstanceEntity2.getAssignee());
                taskDataPush.setComment(this.comment);
            } else {
                taskDataPush.setType("add");
            }
            dataPushList.add(taskDataPush);
        }
        for (HistoricTaskInstanceEntity historicTaskInstanceEntity3 : updateList) {
            cc = ccMap.get(historicTaskInstanceEntity3.getId());
            ccUrl = null;
            if (HussarUtils.isNotEmpty((Object)cc)) {
                ccUrl = cc.getFormKey();
            } else {
                ccElement = (List)bpmnModel.getFlowElement(historicTaskInstanceEntity3.getTaskDefinitionKey()).getExtensionElements().get("ccFormKey");
                formKey = null;
                if (ccElement != null && !ccElement.isEmpty() && (ccFormKeyMap = ((ExtensionElement)ccElement.get(0)).getAttributes()) != null && (ccFormKeyList = (List)ccFormKeyMap.get("ccFormKey")) != null && !ccFormKeyList.isEmpty()) {
                    formKey = ((ExtensionAttribute)ccFormKeyList.get(0)).getValue();
                }
                ccUrl = formKey;
            }
            taskDataPush = this.dataPush(historicTaskInstanceEntity3, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl);
            taskDataPush.setType("complete");
            taskDataPush.setUserId(historicTaskInstanceEntity3.getAssignee());
            taskDataPush.setComment(this.comment);
            dataPushList.add(taskDataPush);
        }
        for (HistoricTaskInstanceEntity historicTaskInstanceEntity4 : removeList) {
            DataPush taskDataPush2 = this.dataPush(historicTaskInstanceEntity4, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, null);
            taskDataPush2.setType("delete");
            taskDataPush2.setUserId(historicTaskInstanceEntity4.getAssignee());
            HashMap<String, String> businessMap = new HashMap<String, String>();
            businessMap.put(historicTaskInstanceEntity4.getProcessDefinitionId(), historicProcessInstanceEntity.getBusinessKey());
            taskDataPush2.setBusinessMap(businessMap);
            taskDataPush2.setComment(this.comment);
            HashMap<String, List> processKeyInstanceMap = new HashMap<String, List>();
            processKeyInstanceMap.computeIfAbsent(historicTaskInstanceEntity4.getProcessKey(), k -> new ArrayList()).add(historicTaskInstanceEntity4.getProcessInstanceId());
            taskDataPush2.setProcessKeyInstanceMap(processKeyInstanceMap);
            dataPushList.add(taskDataPush2);
        }
        for (Map.Entry entry : ccAddMap.entrySet()) {
            DataPush ccDataPush;
            historicTaskInstanceEntity = taskMap.get(entry.getKey());
            List ccList = (List)entry.getValue();
            String ccUrl2 = ((CcTaskEntity)ccList.get(0)).getFormKey();
            ArrayList<String> startReadUser = new ArrayList<String>();
            ArrayList<String> startUnReadUser = new ArrayList<String>();
            ArrayList<String> endReadUser = new ArrayList<String>();
            ArrayList<String> endUnReadUser = new ArrayList<String>();
            for (CcTaskEntity cc2 : ccList) {
                if ("0".equals(cc2.getCcMoment())) {
                    if ("1".equals(cc2.getTaskState())) {
                        startReadUser.add(cc2.getReceiveUser());
                        continue;
                    }
                    startUnReadUser.add(cc2.getReceiveUser());
                    continue;
                }
                if ("1".equals(cc2.getTaskState())) {
                    endReadUser.add(cc2.getReceiveUser());
                    continue;
                }
                endUnReadUser.add(cc2.getReceiveUser());
            }
            if (!startReadUser.isEmpty()) {
                ccDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl2);
                ccDataPush.setCcMoment("0");
                ccDataPush.setTaskState("1");
                ccDataPush.setUserId(String.join((CharSequence)",", startReadUser));
                ccDataPush.setStartDate((Date)((CcTaskEntity)ccList.get(0)).getSendTime());
                ccDataPush.setType(CC_ADD);
                dataPushList.add(ccDataPush);
            }
            if (!startUnReadUser.isEmpty()) {
                ccDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl2);
                ccDataPush.setCcMoment("0");
                ccDataPush.setTaskState("0");
                ccDataPush.setUserId(String.join((CharSequence)",", startUnReadUser));
                ccDataPush.setStartDate((Date)((CcTaskEntity)ccList.get(0)).getSendTime());
                ccDataPush.setType(CC_ADD);
                dataPushList.add(ccDataPush);
            }
            if (!endReadUser.isEmpty()) {
                ccDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl2);
                ccDataPush.setCcMoment("1");
                ccDataPush.setTaskState("1");
                ccDataPush.setUserId(String.join((CharSequence)",", endReadUser));
                ccDataPush.setStartDate((Date)((CcTaskEntity)ccList.get(0)).getSendTime());
                ccDataPush.setType(CC_ADD);
                dataPushList.add(ccDataPush);
            }
            if (endUnReadUser.isEmpty()) continue;
            ccDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccUrl2);
            ccDataPush.setCcMoment("1");
            ccDataPush.setTaskState("0");
            ccDataPush.setUserId(String.join((CharSequence)",", endUnReadUser));
            ccDataPush.setStartDate((Date)((CcTaskEntity)ccList.get(0)).getSendTime());
            ccDataPush.setType(CC_ADD);
            dataPushList.add(ccDataPush);
        }
        for (CcTaskEntity ccTaskEntity : ccUpdateList) {
            historicTaskInstanceEntity = taskMap.get(String.valueOf(ccTaskEntity.getTaskId()));
            DataPush ccDataPush = this.dataPush(historicTaskInstanceEntity, executionEntity, (HistoricProcessInstance)historicProcessInstanceEntity, ccTaskEntity.getFormKey());
            ccDataPush.setCcMoment(ccTaskEntity.getCcMoment());
            ccDataPush.setTaskState(ccTaskEntity.getTaskState());
            ccDataPush.setUserId(ccTaskEntity.getReceiveUser());
            ccDataPush.setStartDate((Date)ccTaskEntity.getSendTime());
            if (ccTaskEntity.isUpdateTaskId()) {
                ccDataPush.setType(CC_ADD);
            } else {
                ccDataPush.setType("ccRead");
            }
            dataPushList.add(ccDataPush);
        }
        for (Map.Entry entry : ccRemoveMap.entrySet()) {
            DataPush ccDataPush;
            ArrayList<String> ccStartIds = new ArrayList<String>();
            ArrayList<String> ccEndIds = new ArrayList<String>();
            for (CcTaskEntity cc4 : (List)entry.getValue()) {
                if ("0".equals(cc4.getCcMoment())) {
                    ccStartIds.add(String.valueOf(cc4.getTaskId()));
                    continue;
                }
                ccEndIds.add(String.valueOf(cc4.getTaskId()));
            }
            if (!ccStartIds.isEmpty()) {
                ccDataPush = new DataPush();
                ccDataPush.setCcMoment("0");
                ccDataPush.setTaskIds(ccStartIds);
                ccDataPush.setProcessInsId((String)entry.getKey());
                ccDataPush.setType("ccRemove");
                dataPushList.add(ccDataPush);
            }
            if (ccEndIds.isEmpty()) continue;
            ccDataPush = new DataPush();
            ccDataPush.setCcMoment("1");
            ccDataPush.setTaskIds(ccEndIds);
            ccDataPush.setProcessInsId((String)entry.getKey());
            ccDataPush.setType("ccRemove");
            dataPushList.add(ccDataPush);
        }
        ProcessDataPush processDataPush = new ProcessDataPush();
        processDataPush.setDataPush(dataPush);
        processDataPush.setTaskDataPush(dataPushList);
        this.dataPushService.processChange(processDataPush);
    }

    private DataPush dataPush(HistoricTaskInstanceEntity task, ExecutionEntity processInstance, HistoricProcessInstance historicProcessInstance, String ccUrl) {
        String processInstanceId = task.getProcessInstanceId();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        if (historicProcessInstance != null) {
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setStartOrganId(historicProcessInstance.getOrganId());
        } else {
            dataPush.setBusinessKey(processInstance.getBusinessKey());
            dataPush.setStartUserId(task.getSendUser());
        }
        String processDefinitionId = task.getProcessDefinitionId();
        String processKey = processDefinitionId.split(":")[0];
        String processVersion = processDefinitionId.split(":")[1];
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(processDefinitionId);
        dataPush.setProcessKey(processKey);
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setSendUser(task.getSendUser());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(task.getEndTime());
        dataPush.setTaskDueTime(task.getDueDate());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        String processTitle = null;
        processTitle = HussarUtils.isEmpty((Object)historicProcessInstance) ? processInstance.getProcessTitle() : historicProcessInstance.getProcessTitle();
        String dataDetail = null;
        dataDetail = HussarUtils.isEmpty((Object)historicProcessInstance) ? processInstance.getDataDetail() : historicProcessInstance.getDataDetail();
        dataPush.setProcessTitle(processTitle);
        dataPush.setDataDetail(dataDetail);
        dataPush.setProcessName(processInstance.getProcessDefinition().getName());
        dataPush.setProcessInsId(processInstanceId);
        dataPush.setTaskType(task.getTaskType());
        dataPush.setProcessVersion(processVersion);
        String processDefKey = null;
        processDefKey = HussarUtils.isEmpty((Object)historicProcessInstance) ? processInstance.getProcessDefinitionKey() : historicProcessInstance.getProcessDefinitionKey();
        dataPush.setAppId(this.flowTaskService.getProcessAppId(processDefKey));
        dataPush.setFormId(task.getFormId());
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(task.getId());
        if (HussarUtils.isNotEmpty((Object)taskEntity)) {
            dataPush.setUserId(this.getAssigneeByTaskId(taskEntity));
            List<Map<String, String>> taskAssigneeMap = this.getAssigneeMapByTaskId(taskEntity);
            if (taskAssigneeMap.isEmpty() && HussarUtils.isNotEmpty((Object)historicProcessInstance) && task.getTaskDefinitionKey().equals(historicProcessInstance.getFirstUserTaskActivityId()) && historicProcessInstance.getSuperProcessInstanceId() == null) {
                HashMap<String, String> assigneeMap = new HashMap<String, String>();
                assigneeMap.put("userId", this.userId);
                taskAssigneeMap.add(assigneeMap);
            }
            dataPush.setUserMaps(taskAssigneeMap);
        }
        dataPush.setTaskType(task.getTaskType());
        dataPush.setCcUrl(ccUrl);
        return dataPush;
    }

    private String getAssigneeByTaskId(TaskEntity taskEntity) {
        HashSet<String> users = new HashSet<String>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                users.add(identityLink.getUserId());
            }
        }
        if (taskEntity.getAssignee() != null) {
            users.add(taskEntity.getAssignee());
        }
        return String.join((CharSequence)",", users);
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity) {
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        List identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && !identityLinks.isEmpty()) {
            for (IdentityLink identityLink : identityLinks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                    map.put("mandator", identityLink.getMandator());
                    map.put("taskState", identityLink.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }
}

