/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ParamModel;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.WorkflowListenerUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.BusinessRuleException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.repository.Model;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BusinessTaskListener
implements TaskListener {
    private Logger logger = LogManager.getLogger(BusinessTaskListener.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
    private static SysActProcessFileService sysActProcessFileService = (SysActProcessFileService)BpmSpringContextHolder.getBean(SysActProcessFileService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);

    public void notify(DelegateTask delegateTask) {
        Model model;
        this.logger.info("\u8fdb\u5165\u4e1a\u52a1\u89c4\u5219\u4efb\u52a1\u76d1\u542c\u5668");
        BpmnModel bm = repositoryService.getBpmnModel(delegateTask.getProcessDefinitionId());
        FlowElement flowElement = bm.getFlowElement(delegateTask.getTaskDefinitionKey());
        String processDefinitionId = delegateTask.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        String businessId = ((TaskEntity)delegateTask).getProcessInstance().getBusinessKey();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeId", delegateTask.getTaskDefinitionKey());
        map.put("nodeName", flowElement.getName());
        map.put("businessId", businessId);
        map.put("processInsId", delegateTask.getProcessInstanceId());
        map.put("processDefinitionId", delegateTask.getProcessDefinitionId());
        map.put("processKey", delegateTask.getProcessDefinitionId().split(":")[0]);
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(delegateTask.getProcessInstanceId());
        if (historicProcessInstance != null) {
            map.put("starter", historicProcessInstance.getStartUserId());
        }
        String eventName = delegateTask.getEventName();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("processName", ((ExecutionEntity)delegateTask.getExecution()).getProcessDefinition().getName());
        map.put("taskId", delegateTask.getId());
        String taskId = (String)Context.getCommandContext().getAttribute("taskId");
        if (HussarUtils.isNotEmpty((Object)taskId) && !taskId.equals(delegateTask.getId())) {
            return;
        }
        Object info = Context.getCommandContext().getAttribute("listenerParam");
        ParamModel paramModel = (ParamModel)info;
        String tasksourceFlag = BpmAttribute.getTaskSourceFlag((ActivityExecution)((TaskEntity)delegateTask).getExecution());
        if (HussarUtils.isNotEmpty((Object)paramModel)) {
            map.put("completeType", paramModel.getCompleteType());
            map.put("deleteType", paramModel.getDeleteType());
            map.put("createTime", simpleDateFormat.format(delegateTask.getCreateTime()));
            map.put("endTime", paramModel.getEndTime());
            map.put("sourcesTaskDefinitionIds", paramModel.getFrom());
            map.put("targetIds", paramModel.getTo());
            map.put("targetNodeAssignee", paramModel.getTargetAssignee());
            map.put("affectedNodeId", paramModel.getAffectedNodeId());
            map.put("assignee", paramModel.getHandler());
            if (("revoke".equals(tasksourceFlag) || "revoke".equals(paramModel.getCompleteType())) && delegateTask.getTaskDefinitionKey().equals(paramModel.getFrom())) {
                return;
            }
        } else {
            map.put("completeType", tasksourceFlag == null ? null : tasksourceFlag.toString());
            map.put("assignee", delegateTask.getAssignee());
            paramModel = new ParamModel();
            String completeType = ((TaskEntity)delegateTask).getCompleteType();
            if (HussarUtils.isEmpty((Object)completeType)) {
                completeType = "transfer";
            }
            paramModel.setCompleteType(completeType);
        }
        if (HussarUtils.isNotEmpty((Object)tasksourceFlag)) {
            if (TaskSourceFlag.isReject((String)String.valueOf(tasksourceFlag))) {
                tasksourceFlag = "reject";
            } else if (TaskSourceFlag.isComplete((String)String.valueOf(tasksourceFlag))) {
                tasksourceFlag = "complete";
            }
        }
        if (HussarUtils.isNotEmpty((Object)(model = (Model)repositoryService.createModelQuery().modelKey(((TaskEntity)delegateTask).getProcessKey()).singleResult()).getAppId())) {
            String formId = ((TaskEntity)delegateTask).getFormId();
            map.put("appId", model.getAppId().toString());
            WorkFlow workFlow = sysActProcessFileService.getFileByProcessDefId(delegateTask.getProcessDefinitionId());
            JSONObject workflowData = JSON.parseObject((String)workFlow.getData());
            JSONArray businessRule = new JSONArray();
            JSONObject slots = workflowData.getJSONObject("slots");
            JSONArray nodes = slots.getJSONArray("default");
            for (int i = 0; i < nodes.size(); ++i) {
                JSONObject node = nodes.getJSONObject(i);
                if (!BpmNodeTypeUtil.isUserTask((String)node.getString("name")) || !delegateTask.getTaskDefinitionKey().equals(node.getString("instanceKey"))) continue;
                JSONObject nodeProps = node.getJSONObject("props");
                JSONObject formAddress = nodeProps.getJSONObject("formAddress");
                JSONObject webForm = formAddress.getJSONObject("web");
                formId = webForm.getString("id");
                JSONArray oriBusinessRules = nodeProps.getJSONArray("businessRules");
                if (!HussarUtils.isNotEmpty((Object)oriBusinessRules)) break;
                for (int j = 0; j < oriBusinessRules.size(); ++j) {
                    JSONObject oriBusinessRule = oriBusinessRules.getJSONObject(j);
                    JSONArray jsonArray = oriBusinessRule.getJSONArray("triggerAction");
                    if (!oriBusinessRule.getBoolean("isEnable").booleanValue() || !jsonArray.contains((Object)paramModel.getCompleteType()) && !jsonArray.contains((Object)TaskSourceFlag.mappingToSimple((String)String.valueOf(tasksourceFlag)))) continue;
                    businessRule.add((Object)oriBusinessRule);
                }
                break;
            }
            map.put("formId", formId);
            if (HussarUtils.isEmpty((Object)businessRule)) {
                return;
            }
            this.logger.info("\u4e1a\u52a1\u89c4\u5219\u4efb\u52a1\u76d1\u542c\u5668\u83b7\u53d6\u5230\u7684\u4e1a\u52a1\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)businessRule));
            map.put("ruleInfoWithDetailsJson", businessRule);
        }
        String serviceName = String.valueOf(modelService.getServiceName(processDefinitionKey));
        try {
            WorkflowListenerUtils.executionBusinessRuleListener("local", "POST", "HussarWorkflowBusinessRuleListenerImpl", map, serviceName);
        }
        catch (Exception e) {
            this.logger.error("\u8bbf\u95ee\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u76d1\u542c\u5668\u5931\u8d25", (Throwable)e);
            throw new BusinessRuleException("\u8bbf\u95ee\u4e1a\u52a1\u89c4\u5219\u4efb\u52a1\u76d1\u542c\u5668\u5931\u8d25");
        }
    }
}

