/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtest.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowOrganProcessUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.VariableHandler;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.dao.TestVariableMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.service.NodeServiceImpl;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowElements;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredInstanceVariableDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredInstanceVariableQueryDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.ConfiguredVariableDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.dto.NodeDto;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.TestVariable;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.VariableService;
import com.jxdinfo.hussar.workflow.godaxe.processtest.vo.AllVariablesConfiguredInProcessVo;
import com.jxdinfo.hussar.workflow.godaxe.processtest.vo.NodeVo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableTestServiceImpl
extends HussarServiceImpl<TestVariableMapper, TestVariable>
implements VariableService {
    private static final Logger logger = LoggerFactory.getLogger(VariableTestServiceImpl.class);
    private static final char MAIN_PROCESS_TAG = '1';
    private static final char INTERNAL_SUB_PROCESS_TAG = '2';
    private static final char EXTERNAL_SUB_PROCESS_TAG = '2';
    private List<NodeVo> processNodes;
    private Map<String, Map<String, List<NodeDto>>> mappingFromProcessOnlyIdToNodeMapping;
    private Map<String, List<String>> mappingFromNodeOnlyIdToAssignee;
    private Map<String, List<NodeDto>> mappingFromProcessOnlyIdToNodes;
    private Map<String, List<String>> visitedAssigneeMap = new HashMap<String, List<String>>();
    @Autowired
    private VariableHandler variableHandler;
    @Autowired
    private SysActProcessFileService processFileService;
    @Autowired
    ProcessDefinitionsService processDefinitionsService;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private SeqBuilder seqBuilder;
    @Autowired
    SysActAssigneeService sysActAssigneeService;
    @Autowired
    NodeServiceImpl nodeService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    public void saveVariable(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String procInstId) {
        TestVariable testVariable = new TestVariable();
        testVariable.setId(Long.valueOf(procInstId).longValue());
        testVariable.setProcessKey(allVariablesConfiguredInProcess.getProcessKey());
        testVariable.setVariable(JSON.toJSONString((Object)allVariablesConfiguredInProcess, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        this.saveOrUpdate((BaseEntity)testVariable);
    }

    public ApiResponse<AllVariablesConfiguredInProcessVo> getAllVariablesConfiguredInMainProcess(String processKey, String processVersion, String organId) {
        ApiResponse apiResponse;
        try {
            String latestTestProcessDefinitionId = WorkflowOrganProcessUtil.getStartOrganProcessId(processKey, processVersion, null, organId, false);
            AllVariablesConfiguredInProcessVo allVariablesConfiguredInMainProcess = this.getAllVariablesConfiguredInProcess(latestTestProcessDefinitionId);
            this.markAllVariablesConfiguredInProcessAsMainProcessVariable(allVariablesConfiguredInMainProcess);
            this.bindMainAndSubProcessParentId(allVariablesConfiguredInMainProcess);
            this.checkProcessCallLoop(latestTestProcessDefinitionId);
            this.addAllCallActivityVariables(allVariablesConfiguredInMainProcess);
            this.markAllSubProcessNode(allVariablesConfiguredInMainProcess);
            this.checkAndAddSubProcessNode(allVariablesConfiguredInMainProcess);
            apiResponse = ApiResponse.success((Object)allVariablesConfiguredInMainProcess);
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            apiResponse = ApiResponse.fail((String)e.getMessage());
        }
        return apiResponse;
    }

    private ApiResponse<AllVariablesConfiguredInProcessVo> getVariablesConfiguredInMainProcess(String processKey) {
        ApiResponse apiResponse;
        try {
            String latestTestProcessDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(processKey);
            AllVariablesConfiguredInProcessVo allVariablesConfiguredInMainProcess = this.getAllVariablesConfiguredInProcess(latestTestProcessDefinitionId);
            this.markAllVariablesConfiguredInProcessAsMainProcessVariable(allVariablesConfiguredInMainProcess);
            this.bindMainAndSubProcessParentId(allVariablesConfiguredInMainProcess);
            this.checkProcessCallLoop(latestTestProcessDefinitionId);
            this.addAllCallActivityVariables(allVariablesConfiguredInMainProcess);
            this.markAllSubProcessNode(allVariablesConfiguredInMainProcess);
            this.checkAndAddSubProcessNode(allVariablesConfiguredInMainProcess);
            apiResponse = ApiResponse.success((Object)allVariablesConfiguredInMainProcess);
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            apiResponse = ApiResponse.fail((String)e.getMessage());
        }
        return apiResponse;
    }

    private void markAllSubProcessNode(AllVariablesConfiguredInProcessVo allVariablesConfiguredInMainProcess) {
        List configuredInstanceVariableDtos = allVariablesConfiguredInMainProcess.getConfiguredInstanceVariables();
        for (ConfiguredInstanceVariableDto configuredInstanceVariableDto : configuredInstanceVariableDtos) {
            if (!BpmNodeTypeUtil.isSubProcess((String)configuredInstanceVariableDto.getType())) continue;
            String subProcessMark = configuredInstanceVariableDto.getProcessKey() + ":" + configuredInstanceVariableDto.getInstanceKey();
            configuredInstanceVariableDto.setSubProcessMark(subProcessMark);
        }
    }

    private void checkAndAddSubProcessNode(AllVariablesConfiguredInProcessVo allVariablesConfiguredInMainProcess) {
        List configuredInstanceVariables = allVariablesConfiguredInMainProcess.getConfiguredInstanceVariables();
        HashSet<String> subProcessNodeVariableMark = new HashSet<String>();
        for (ConfiguredInstanceVariableDto configuredInstanceVariableDto : configuredInstanceVariables) {
            if (!HussarUtils.isNotEmpty((Object)configuredInstanceVariableDto.getParentProcessMark())) continue;
            subProcessNodeVariableMark.add(configuredInstanceVariableDto.getParentProcessMark());
        }
        for (ConfiguredInstanceVariableDto configuredInstanceVariableDto : configuredInstanceVariables) {
            if (!HussarUtils.isNotEmpty((Object)configuredInstanceVariableDto.getSubProcessMark()) || !subProcessNodeVariableMark.contains(configuredInstanceVariableDto.getSubProcessMark())) continue;
            subProcessNodeVariableMark.remove(configuredInstanceVariableDto.getSubProcessMark());
        }
        for (String mark : subProcessNodeVariableMark) {
            String processKey = mark.split(":")[0];
            String processDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(processKey);
            FlowModel flowModel = this.getTestFlowModel(processDefinitionId);
            List nodes = flowModel.getSlots().getElement();
            String nodeId = mark.split(":")[1];
            for (FlowObject flowObject : nodes) {
                if (!flowObject.getInstanceKey().equals(nodeId)) continue;
                ConfiguredInstanceVariableDto configuredInstanceVariableDto = new ConfiguredInstanceVariableDto();
                configuredInstanceVariableDto.setInstanceName(HussarUtils.isEmpty((Object)flowObject.getProps().getFlowName()) ? this.bpmConstantProperties.getSimulationNode() + "\uff08" + flowObject.getInstanceKey() + ")" : flowObject.getProps().getFlowName() + "\uff08" + flowObject.getInstanceKey() + ")");
                configuredInstanceVariableDto.setInstanceKey(processKey);
                configuredInstanceVariableDto.setSubProcessMark(mark);
                configuredInstanceVariableDto.setType(flowObject.getName());
                configuredInstanceVariables.add(configuredInstanceVariableDto);
            }
        }
        allVariablesConfiguredInMainProcess.setConfiguredInstanceVariables(configuredInstanceVariables);
    }

    public AllVariablesConfiguredInProcessVo getAllVariablesConfiguredInSubProcess(String processKey) throws BpmException {
        String latestTestProcessDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(processKey);
        AllVariablesConfiguredInProcessVo allVariablesConfiguredInSubProcess = this.getAllVariablesConfiguredInProcess(latestTestProcessDefinitionId);
        this.markAllVariablesConfiguredInProcessAsSubProcessVariable(allVariablesConfiguredInSubProcess);
        this.bindMainAndSubProcessParentId(allVariablesConfiguredInSubProcess);
        return allVariablesConfiguredInSubProcess;
    }

    private AllVariablesConfiguredInProcessVo getAllVariablesConfiguredInProcess(String processDefinitionId) throws BpmException {
        AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess = new AllVariablesConfiguredInProcessVo();
        String processKey = processDefinitionId.split(":")[0];
        allVariablesConfiguredInProcess.setOnlyId(this.generateOnlyId());
        allVariablesConfiguredInProcess.setProcessKey(processKey);
        allVariablesConfiguredInProcess.setProcessDefinitionId(processDefinitionId);
        FlowModel testFlowModel = this.getTestFlowModel(processDefinitionId);
        allVariablesConfiguredInProcess.setProcessName(testFlowModel.getProps().getFlowName());
        allVariablesConfiguredInProcess.setConfiguredInstanceVariables(this.listConfiguredInstanceVariable(testFlowModel));
        return allVariablesConfiguredInProcess;
    }

    private String generateOnlyId() {
        Sequence sequence = this.seqBuilder.build();
        return String.valueOf(sequence.nextValue());
    }

    public List<ConfiguredInstanceVariableDto> listConfiguredInstanceVariable(String processDefinitionId) throws BpmException {
        ArrayList<ConfiguredInstanceVariableDto> configuredInstanceVariables = new ArrayList<ConfiguredInstanceVariableDto>();
        FlowModel testFlowModel = this.getTestFlowModel(processDefinitionId);
        configuredInstanceVariables.addAll(this.listConfiguredInstanceVariable(testFlowModel));
        return configuredInstanceVariables;
    }

    private FlowModel getTestFlowModel(String processDefinitionId) throws BpmException {
        WorkFlow workFlow = this.processFileService.getFileByProcessDefId(processDefinitionId, null, null);
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workFlow.getData(), FlowModel.class);
        flowModel.setFlowIdentity(workFlow.getIdentity());
        return flowModel;
    }

    public List<ConfiguredInstanceVariableDto> listConfiguredInstanceVariable(FlowModel flowModel) throws BpmException {
        ArrayList<ConfiguredInstanceVariableDto> configuredMainProcessInstanceVariables = new ArrayList<ConfiguredInstanceVariableDto>();
        ArrayList<ConfiguredInstanceVariableDto> configuredInternalSubProcessInstanceVariables = new ArrayList<ConfiguredInstanceVariableDto>();
        configuredMainProcessInstanceVariables.addAll(this.parse(flowModel));
        this.markAsMainProcessInstanceVariable(configuredMainProcessInstanceVariables);
        List<FlowModel> internalSubProcessFlowModels = this.buildInternalSubProcessFlowModel(flowModel);
        for (FlowModel internalSubProcessFlowModel : internalSubProcessFlowModels) {
            configuredInternalSubProcessInstanceVariables.addAll(this.parse(internalSubProcessFlowModel));
            this.markSubProcessChildNode(internalSubProcessFlowModel, configuredInternalSubProcessInstanceVariables);
        }
        this.markAsInternalSubProcessInstanceVariable(configuredInternalSubProcessInstanceVariables);
        configuredMainProcessInstanceVariables.addAll(configuredInternalSubProcessInstanceVariables);
        return configuredMainProcessInstanceVariables;
    }

    private void markSubProcessChildNode(FlowModel flowModel, List<ConfiguredInstanceVariableDto> list) {
        String parentProcessMark = flowModel.getFlowIdentity() + ":" + flowModel.getInstanceKey();
        for (ConfiguredInstanceVariableDto configuredInstanceVariableDto : list) {
            configuredInstanceVariableDto.setParentProcessMark(parentProcessMark);
        }
    }

    private List<ConfiguredInstanceVariableDto> parse(FlowModel flowModel) throws BpmException {
        ArrayList<ConfiguredInstanceVariableDto> configuredInstanceVariables = new ArrayList<ConfiguredInstanceVariableDto>();
        ConfiguredInstanceVariableDto processVariable = this.getProcessVariable(flowModel);
        if (HussarUtils.isNotEmpty((Object)processVariable)) {
            processVariable.setOnlyId(this.generateOnlyId());
            processVariable.setProcessKey(flowModel.getFlowIdentity());
            processVariable.setProcessName(flowModel.getProps().getFlowName());
            configuredInstanceVariables.add(processVariable);
        }
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        for (FlowObject processElement : processElements) {
            ConfiguredInstanceVariableDto elementVariable = this.getElementVariable(processElement, flowModel);
            if (HussarUtils.isNotEmpty((Object)elementVariable)) {
                elementVariable.setOnlyId(this.generateOnlyId());
                elementVariable.setProcessKey(flowModel.getFlowIdentity());
                elementVariable.setProcessName(flowModel.getProps().getFlowName());
                elementVariable.setInstanceKey(processElement.getInstanceKey());
                elementVariable.setType(processElement.getName());
                elementVariable.setInstanceName(HussarUtils.isEmpty((Object)processElement.getProps().getFlowName()) ? this.bpmConstantProperties.getSimulationNode() + "\uff08" + processElement.getInstanceKey() + ")" : processElement.getProps().getFlowName() + "\uff08" + processElement.getInstanceKey() + ")");
                configuredInstanceVariables.add(elementVariable);
                continue;
            }
            if (!BpmNodeTypeUtil.isCallActivity((String)processElement.getName()) || !HussarUtils.isEmpty((Object)elementVariable)) continue;
            elementVariable = new ConfiguredInstanceVariableDto();
            elementVariable.setOnlyId(this.generateOnlyId());
            elementVariable.setProcessKey(flowModel.getFlowIdentity());
            elementVariable.setProcessName(flowModel.getProps().getFlowName());
            elementVariable.setInstanceKey(processElement.getInstanceKey());
            elementVariable.setType(processElement.getName());
            elementVariable.setConfiguredVariables(new ArrayList());
            elementVariable.setInstanceName(HussarUtils.isEmpty((Object)processElement.getProps().getFlowName()) ? this.bpmConstantProperties.getSimulationNode() + "\uff08" + processElement.getInstanceKey() + ")" : processElement.getProps().getFlowName() + "\uff08" + processElement.getInstanceKey() + ")");
            configuredInstanceVariables.add(elementVariable);
        }
        List processPaths = processSlots.getPath();
        Map<String, List<FlowObject>> mappingFromElementKeyToElement = this.groupElementByElementKey(processElements);
        for (FlowSequence processPath : processPaths) {
            String startNodeKey = processPath.getStart().getKey();
            List gangedInstance = mappingFromElementKeyToElement.get(startNodeKey).get(0).getGoOutPathes();
            ConfiguredInstanceVariableDto pathVariable = this.getPathVariable(processPath);
            if (!HussarUtils.isNotEmpty((Object)pathVariable)) continue;
            pathVariable.setOnlyId(this.generateOnlyId());
            pathVariable.setProcessKey(flowModel.getFlowIdentity());
            pathVariable.setProcessName(flowModel.getProps().getFlowName());
            pathVariable.setInstanceKey(processPath.getInstanceKey());
            pathVariable.setType(processPath.getName());
            pathVariable.setGangedInstance(gangedInstance);
            pathVariable.setInstanceName(HussarUtils.isEmpty((Object)processPath.getProps().getFlowName()) ? this.bpmConstantProperties.getSimulationLine() + "\uff08" + processPath.getInstanceKey() + ")" : processPath.getProps().getFlowName() + "\uff08" + processPath.getInstanceKey() + ")");
            configuredInstanceVariables.add(pathVariable);
        }
        return configuredInstanceVariables;
    }

    private ConfiguredInstanceVariableDto getProcessVariable(FlowModel flowModel) {
        ArrayList<FlowVariables> processFlowVariablesList = new ArrayList<FlowVariables>();
        processFlowVariablesList.addAll(this.listProcessFlowVariables(flowModel));
        return this.wrapFlowVariables(processFlowVariablesList);
    }

    private List<FlowVariables> listProcessFlowVariables(FlowModel flowModel) {
        FlowProps processProps;
        ArrayList<FlowVariables> processFlowVariablesList = new ArrayList<FlowVariables>();
        if (HussarUtils.isNotEmpty((Object)flowModel.getProps()) && HussarUtils.isNotEmpty((Object)(processProps = flowModel.getProps()).getUseVariables())) {
            processFlowVariablesList.addAll(processProps.getUseVariables());
        }
        return processFlowVariablesList;
    }

    private ConfiguredInstanceVariableDto getElementVariable(FlowObject element, FlowModel flowModel) throws BpmException {
        ArrayList<FlowVariables> elementFlowVariablesList = new ArrayList<FlowVariables>();
        elementFlowVariablesList.addAll(this.listElementFlowVariables(element, flowModel));
        ConfiguredInstanceVariableDto originalElementVariable = this.wrapFlowVariables(elementFlowVariablesList);
        ConfiguredInstanceVariableDto finalElementVariable = this.removePathVariableAndCarbonCopyVariableFormElementVariable(originalElementVariable);
        return finalElementVariable;
    }

    private List<FlowVariables> listElementFlowVariables(FlowObject element, FlowModel flowModel) throws BpmException {
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        List processPaths = processSlots.getPath();
        ArrayList<String> elementKeysWhereYouHaveToAddNextNodeVariables = new ArrayList<String>();
        elementKeysWhereYouHaveToAddNextNodeVariables.addAll(this.findElementKeysWhereYouHaveToAddNextNodeVariables(processPaths, processElements, flowModel));
        ArrayList<FlowVariables> elementFlowVariables = new ArrayList<FlowVariables>();
        if (HussarUtils.isNotEmpty((Object)element.getProps())) {
            FlowProps elementProps = element.getProps();
            if (HussarUtils.isNotEmpty((Object)elementProps.getUseVariables())) {
                elementFlowVariables.addAll(elementProps.getUseVariables());
            }
            if (HussarUtils.isNotEmpty((Object)elementProps.getFlowFunctionConfig())) {
                for (FlowFunctionConfig flowFunctionConfig : elementProps.getFlowFunctionConfig()) {
                    if (!this.whetherFunctionAreConfigured(elementProps, flowFunctionConfig) || !HussarUtils.isNotEmpty((Object)flowFunctionConfig.getUseVariables())) continue;
                    elementFlowVariables.addAll(flowFunctionConfig.getUseVariables());
                }
            }
        }
        if (elementKeysWhereYouHaveToAddNextNodeVariables.contains(element.getInstanceKey())) {
            FlowVariables flowVariables = new FlowVariables();
            flowVariables.setVariable("bpm_next_node");
            flowVariables.setVarType("String");
            flowVariables.setAnnotation(this.bpmConstantProperties.getNextNode());
            elementFlowVariables.add(flowVariables);
        }
        return elementFlowVariables;
    }

    private List<String> findElementKeysWhereYouHaveToAddNextNodeVariables(List<FlowSequence> paths, List<FlowObject> elements, FlowModel flowModel) throws BpmException {
        ArrayList<String> elementKeys = new ArrayList<String>();
        ArrayList<String> gatewayKeysIncludeNextNodeVariable = new ArrayList<String>();
        gatewayKeysIncludeNextNodeVariable.addAll(this.findGatewayKeysIncludeNextNodeVariable(paths));
        elementKeys.addAll(this.findLastUserNodeKeysBeforeGateway(gatewayKeysIncludeNextNodeVariable, paths, elements, flowModel));
        return elementKeys;
    }

    private List<String> findGatewayKeysIncludeNextNodeVariable(List<FlowSequence> paths) {
        ArrayList<FlowSequence> pathsIncludeNextNodeVariable = new ArrayList<FlowSequence>();
        ArrayList<String> gatewayKeysIncludeNextNodeVariable = new ArrayList<String>();
        for (FlowSequence path : paths) {
            if (!this.isIncludeNextNodeVariable(path)) continue;
            pathsIncludeNextNodeVariable.add(path);
        }
        for (FlowSequence pathIncludeNextNodeVariable : pathsIncludeNextNodeVariable) {
            gatewayKeysIncludeNextNodeVariable.add(pathIncludeNextNodeVariable.getStart().getKey());
        }
        return gatewayKeysIncludeNextNodeVariable;
    }

    private boolean isIncludeNextNodeVariable(FlowSequence path) {
        FlowProps pathProps;
        if (HussarUtils.isNotEmpty((Object)path.getProps()) && HussarUtils.isNotEmpty((Object)(pathProps = path.getProps()).getBackFlowCondition())) {
            String backFlowCondition = pathProps.getBackFlowCondition();
            return backFlowCondition.contains("bpm_next_node");
        }
        return false;
    }

    private List<String> findLastUserNodeKeysBeforeGateway(List<String> gatewayKeysIncludeNextNodeVariable, List<FlowSequence> paths, List<FlowObject> elements, FlowModel flowModel) throws BpmException {
        ArrayList<String> elementKeys = new ArrayList<String>();
        for (String gatewayKeyIncludeNextNodeVariable : gatewayKeysIncludeNextNodeVariable) {
            elementKeys.addAll(new HashSet<String>(this.findLastUserNodeKeysBeforeGateway(gatewayKeyIncludeNextNodeVariable, paths, elements, flowModel)));
        }
        return elementKeys;
    }

    private List<String> findLastUserNodeKeysBeforeGateway(String gatewayKey, List<FlowSequence> paths, List<FlowObject> elements, FlowModel flowModel) throws BpmException {
        Map<String, List<String>> mappingFromEndNodeKeyToStarNodeKeys = this.groupStarNodeKeysByEndNodeKey(paths);
        Map<String, List<FlowObject>> mappingFromElementKeyToElement = this.groupElementByElementKey(elements);
        ArrayList<String> lastUserNodeKeys = new ArrayList<String>();
        Stack<String> elementKeyStack = new Stack<String>();
        ArrayList<String> beingVisited = new ArrayList<String>();
        ArrayList<String> hasBeenVisited = new ArrayList<String>();
        String currentElement = gatewayKey;
        elementKeyStack.push(currentElement);
        while (!elementKeyStack.isEmpty()) {
            currentElement = (String)elementKeyStack.peek();
            FlowObject element = mappingFromElementKeyToElement.get(currentElement).get(0);
            String elementType = element.getName();
            if (BpmNodeTypeUtil.isUserTask((String)elementType) || BpmNodeTypeUtil.isCallActivity((String)elementType)) {
                lastUserNodeKeys.add(currentElement);
                beingVisited.remove(currentElement);
                hasBeenVisited.add(currentElement);
                elementKeyStack.pop();
                continue;
            }
            if (!beingVisited.contains(currentElement) && !hasBeenVisited.contains(currentElement)) {
                beingVisited.add(currentElement);
                continue;
            }
            if (!beingVisited.contains(currentElement)) continue;
            ArrayList neighborElementKeys = new ArrayList();
            ArrayList<String> hasBeenVisitedNeighbor = new ArrayList<String>();
            if (HussarUtils.isNotEmpty(mappingFromEndNodeKeyToStarNodeKeys.get(currentElement))) {
                neighborElementKeys.addAll(mappingFromEndNodeKeyToStarNodeKeys.get(currentElement));
            }
            for (String neighborElementKey : neighborElementKeys) {
                if (hasBeenVisited.contains(neighborElementKey)) {
                    hasBeenVisitedNeighbor.add(neighborElementKey);
                    continue;
                }
                if (beingVisited.contains(neighborElementKey)) {
                    logger.error(this.bpmConstantProperties.getCircleProcess());
                    throw new BpmException(this.bpmConstantProperties.getCircleProcess());
                }
                elementKeyStack.push(neighborElementKey);
                break;
            }
            if (hasBeenVisitedNeighbor.size() != neighborElementKeys.size()) continue;
            beingVisited.remove(currentElement);
            hasBeenVisited.add(currentElement);
            elementKeyStack.pop();
        }
        return lastUserNodeKeys;
    }

    private Map<String, List<String>> groupStarNodeKeysByEndNodeKey(List<FlowSequence> paths) {
        HashMap<String, List<String>> mappingFromEndNodeKeyToStarNodeKeys = new HashMap<String, List<String>>();
        mappingFromEndNodeKeyToStarNodeKeys.putAll(paths.stream().collect(Collectors.groupingBy(path -> path.getEnd().getKey(), Collectors.mapping(path -> path.getStart().getKey(), Collectors.toList()))));
        return mappingFromEndNodeKeyToStarNodeKeys;
    }

    private Map<String, List<FlowObject>> groupElementByElementKey(List<FlowObject> elements) {
        HashMap<String, List<FlowObject>> mappingFromElementKeyToElement = new HashMap<String, List<FlowObject>>();
        mappingFromElementKeyToElement.putAll(elements.stream().collect(Collectors.groupingBy(element -> element.getInstanceKey(), Collectors.toList())));
        return mappingFromElementKeyToElement;
    }

    private boolean whetherFunctionAreConfigured(FlowProps elementProps, FlowFunctionConfig flowFunctionConfig) {
        boolean tag = false;
        if (HussarUtils.isNotEmpty((Object)elementProps.getFlowAssignment()) && HussarUtils.isNotEmpty((Object)elementProps.getFlowAssignment().getDefaultBackCondtion()) && elementProps.getFlowAssignment().getDefaultBackCondtion().contains(flowFunctionConfig.getId())) {
            tag = true;
        }
        if (HussarUtils.isNotEmpty((Object)elementProps.getFlowAssignment()) && HussarUtils.isNotEmpty((Object)elementProps.getFlowAssignment().getJudgeBackCondition())) {
            for (JudgeBackCondition judgeBackCondition : elementProps.getFlowAssignment().getJudgeBackCondition()) {
                String judgeSpellCondition = judgeBackCondition.getJudgeSpellCondition();
                if (!judgeSpellCondition.contains(flowFunctionConfig.getId())) continue;
                tag = true;
                break;
            }
        }
        return tag;
    }

    private ConfiguredInstanceVariableDto removePathVariableAndCarbonCopyVariableFormElementVariable(ConfiguredInstanceVariableDto elementVariable) {
        if (HussarUtils.isNotEmpty((Object)elementVariable)) {
            List originalConfiguredVariables = elementVariable.getConfiguredVariables();
            HashSet nestPathKeys = new HashSet();
            List finalConfiguredVariables = originalConfiguredVariables.stream().filter(o -> {
                if (HussarUtils.isNotEmpty((Object)o.getSource())) {
                    if (o.getSource().contains("hussar_path")) {
                        nestPathKeys.add(o.getSource());
                    }
                    return !o.getSource().contains("hussar_path");
                }
                return true;
            }).collect(Collectors.toList());
            ConfiguredInstanceVariableDto finalElementVariable = new ConfiguredInstanceVariableDto();
            finalElementVariable.setOnlyId(elementVariable.getOnlyId());
            finalElementVariable.setProcessKey(elementVariable.getProcessKey());
            finalElementVariable.setProcessName(elementVariable.getProcessName());
            finalElementVariable.setInstanceKey(elementVariable.getInstanceKey());
            finalElementVariable.setInstanceName(elementVariable.getInstanceName());
            finalElementVariable.setInstanceType(elementVariable.getInstanceType());
            finalElementVariable.setType(elementVariable.getType());
            finalElementVariable.setNextPathKeys(new ArrayList(nestPathKeys));
            finalElementVariable.setConfiguredVariables(finalConfiguredVariables);
            return finalElementVariable;
        }
        return null;
    }

    private ConfiguredInstanceVariableDto getPathVariable(FlowSequence path) {
        ArrayList<FlowVariables> pathFlowVariablesList = new ArrayList<FlowVariables>();
        pathFlowVariablesList.addAll(this.listPathFlowVariables(path));
        if (HussarUtils.isNotEmpty(pathFlowVariablesList)) {
            return this.wrapFlowVariables(pathFlowVariablesList);
        }
        return null;
    }

    private List<FlowVariables> listPathFlowVariables(FlowSequence path) {
        FlowProps pathProps;
        ArrayList<FlowVariables> pathFlowVariablesList = new ArrayList<FlowVariables>();
        if (HussarUtils.isNotEmpty((Object)path.getProps()) && HussarUtils.isNotEmpty((Object)(pathProps = path.getProps()).getUseVariables())) {
            pathFlowVariablesList.addAll(pathProps.getUseVariables());
        }
        return pathFlowVariablesList;
    }

    private ConfiguredInstanceVariableDto wrapFlowVariables(List<FlowVariables> flowVariablesList) {
        ConfiguredInstanceVariableDto configuredInstanceInstanceVariable = new ConfiguredInstanceVariableDto();
        ArrayList<ConfiguredVariableDto> configuredVariables = new ArrayList<ConfiguredVariableDto>();
        for (FlowVariables flowVariables : flowVariablesList) {
            ConfiguredVariableDto configuredVariable = new ConfiguredVariableDto();
            configuredVariable.setOnlyId(this.generateOnlyId());
            configuredVariable.setName(flowVariables.getVariable());
            configuredVariable.setType(flowVariables.getVarType());
            configuredVariable.setSource(flowVariables.getAction());
            configuredVariable.setAnnotation(flowVariables.getAnnotation());
            configuredVariable.setVarLimit(flowVariables.getVarLimit());
            configuredVariable.setGroupedType("general");
            if (HussarUtils.isNotEmpty((Object)flowVariables.getSlaveTableName())) {
                configuredVariable.setGroupedType("sublist");
            }
            if ("bpm_next_node".equals(flowVariables.getVariable())) {
                configuredVariable.setGroupedType("bpmNextNode");
            }
            configuredVariables.add(configuredVariable);
        }
        if (HussarUtils.isNotEmpty(configuredVariables)) {
            configuredInstanceInstanceVariable.setConfiguredVariables(configuredVariables);
            return configuredInstanceInstanceVariable;
        }
        return null;
    }

    private void markAsInternalSubProcessInstanceVariable(List<ConfiguredInstanceVariableDto> configuredInternalVariables) {
        for (ConfiguredInstanceVariableDto configuredInternalVariable : configuredInternalVariables) {
            configuredInternalVariable.setInstanceType('2');
        }
    }

    private void markAsMainProcessInstanceVariable(List<ConfiguredInstanceVariableDto> configuredInstanceVariables) {
        for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
            configuredInstanceVariable.setInstanceType('1');
        }
    }

    private List<FlowModel> buildInternalSubProcessFlowModel(FlowModel flowModel) {
        ArrayList<FlowModel> internalSubProcessFlowModels = new ArrayList<FlowModel>();
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        for (FlowObject processElement : processElements) {
            String name = processElement.getName();
            if (!BpmNodeTypeUtil.isSubProcess((String)name)) continue;
            FlowModel internalSubProcessFlowModel = new FlowModel();
            internalSubProcessFlowModel.setFlowIdentity(flowModel.getFlowIdentity());
            internalSubProcessFlowModel.setInstanceKey(processElement.getInstanceKey());
            FlowProps props = new FlowProps();
            props.setFlowName(flowModel.getProps().getFlowName());
            internalSubProcessFlowModel.setProps(props);
            FlowElements internalSubProcessSlots = processElement.getSlots();
            internalSubProcessFlowModel.setSlots(internalSubProcessSlots);
            internalSubProcessFlowModels.add(internalSubProcessFlowModel);
        }
        return internalSubProcessFlowModels;
    }

    private void markAllVariablesConfiguredInProcessAsMainProcessVariable(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        allVariablesConfiguredInProcess.setProcessType('1');
    }

    private void markAllVariablesConfiguredInProcessAsSubProcessVariable(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        allVariablesConfiguredInProcess.setProcessType('2');
    }

    private void bindMainAndSubProcessParentId(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        List configuredInstanceVariables = allVariablesConfiguredInProcess.getConfiguredInstanceVariables();
        String parentId = allVariablesConfiguredInProcess.getOnlyId();
        configuredInstanceVariables.forEach(configuredInstanceVariable -> configuredInstanceVariable.setParentId(parentId));
    }

    private void checkProcessCallLoop(String processDefinitionId) throws BpmException {
        HashSet<String> beingVisitedProcessKeys = new HashSet<String>();
        HashSet<String> hasBeenVisitedProcessKeys = new HashSet<String>();
        Stack<String> processDefIdStack = new Stack<String>();
        processDefIdStack.push(processDefinitionId);
        while (!processDefIdStack.isEmpty()) {
            processDefinitionId = (String)processDefIdStack.peek();
            String processKey = processDefinitionId.split(":")[0];
            if (!beingVisitedProcessKeys.contains(processKey) && !hasBeenVisitedProcessKeys.contains(processKey)) {
                beingVisitedProcessKeys.add(processKey);
                continue;
            }
            if (!beingVisitedProcessKeys.contains(processKey)) continue;
            HashSet<String> neighborProcessDefIds = new HashSet<String>();
            HashSet<String> hasBeenVisitedNeighborProcessKeys = new HashSet<String>();
            FlowModel flowModel = this.getTestFlowModel(processDefinitionId);
            neighborProcessDefIds.addAll(this.listExternalSubProcessDefId(flowModel));
            for (String neighborProcessDefId : neighborProcessDefIds) {
                String neighborProcessKey = neighborProcessDefId.split(":")[0];
                if (hasBeenVisitedProcessKeys.contains(neighborProcessKey)) {
                    hasBeenVisitedNeighborProcessKeys.add(neighborProcessKey);
                    continue;
                }
                if (beingVisitedProcessKeys.contains(neighborProcessKey)) {
                    logger.error(this.bpmConstantProperties.getCircleProcess());
                    throw new BpmException(this.bpmConstantProperties.getCircleProcess());
                }
                processDefIdStack.push(neighborProcessDefId);
                break;
            }
            if (hasBeenVisitedNeighborProcessKeys.size() != neighborProcessDefIds.size()) continue;
            beingVisitedProcessKeys.remove(processKey);
            hasBeenVisitedProcessKeys.add(processKey);
            processDefIdStack.pop();
        }
    }

    private List<String> listExternalSubProcessDefId(FlowModel flowModel) throws BpmException {
        ArrayList<String> externalSubProcessDefIds = new ArrayList<String>();
        FlowElements processSlots = flowModel.getSlots();
        List processElements = processSlots.getElement();
        for (FlowObject processElement : processElements) {
            List judgeBackConditions;
            String name = processElement.getName();
            if (!BpmNodeTypeUtil.isCallActivity((String)name)) continue;
            FlowProps elementProps = processElement.getProps();
            String defaultProcessKey = elementProps.getFlowSelector().getDefaultProcessKey();
            String defaultTestProcessDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(defaultProcessKey);
            externalSubProcessDefIds.add(defaultTestProcessDefinitionId);
            if (!HussarUtils.isNotEmpty((Object)elementProps.getFlowSelector().getJudgeBackCondition()) || !HussarUtils.isNotEmpty((Object)(judgeBackConditions = elementProps.getFlowSelector().getJudgeBackCondition()))) continue;
            for (JudgeBackCondition judgeBackCondition : judgeBackConditions) {
                String conditionProcessKey = judgeBackCondition.getConditionProcessKey();
                String conditionTestProcessDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(conditionProcessKey);
                externalSubProcessDefIds.add(conditionTestProcessDefinitionId);
            }
        }
        return externalSubProcessDefIds;
    }

    private void assembleDefaultSubProcess(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) throws BpmException {
        ArrayDeque<Object> allVariablesConfiguredInProcessQueue = new ArrayDeque<Object>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            AllVariablesConfiguredInProcessVo currentProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            List configuredInstanceVariables = currentProcess.getConfiguredInstanceVariables();
            for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
                if (!BpmNodeTypeUtil.isCallActivity((String)configuredInstanceVariable.getType())) continue;
                ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery = new ConfiguredInstanceVariableQueryDto();
                configuredInstanceVariableQuery.setConfiguredInstanceVariable(configuredInstanceVariable);
                configuredInstanceVariableQuery.setProcessDefinitionId(currentProcess.getProcessDefinitionId());
                ApiResponse<JSONObject> apiResponse = this.getAllVariablesConfiguredInSubProcessAndBindingInfo(configuredInstanceVariableQuery);
                if (!HussarUtils.isNotEmpty((Object)apiResponse.getData())) continue;
                List subProcess = JSONArray.parseArray((String)JSONArray.toJSONString((Object)((JSONObject)apiResponse.getData()).get((Object)"allVariablesConfiguredInSubProcessList"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).stream().map(v -> (AllVariablesConfiguredInProcessVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)v, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), AllVariablesConfiguredInProcessVo.class)).collect(Collectors.toList());
                List bindingInfos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)((JSONObject)apiResponse.getData()).get((Object)"bindingSubProcessOnlyIds"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})).stream().map(v -> (String)JSONObject.parseObject((String)JSONObject.toJSONString((Object)v, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), String.class)).collect(Collectors.toList());
                if (configuredInstanceVariable.getBindingSubProcessOnlyIds() == null) {
                    configuredInstanceVariable.setBindingSubProcessOnlyIds(new ArrayList());
                }
                configuredInstanceVariable.getBindingSubProcessOnlyIds().addAll(bindingInfos);
                if (currentProcess.getAllVariablesConfiguredInExternalSubProcesses() == null) {
                    currentProcess.setAllVariablesConfiguredInExternalSubProcesses(new ArrayList());
                }
                currentProcess.getAllVariablesConfiguredInExternalSubProcesses().addAll(subProcess);
                allVariablesConfiguredInProcessQueue.addAll(subProcess);
            }
        }
    }

    public ApiResponse<JSONObject> getAllVariablesConfiguredInSubProcessAndBindingInfo(ConfiguredInstanceVariableQueryDto configuredInstanceVariableQuery) {
        ApiResponse apiResponse;
        try {
            ConfiguredInstanceVariableDto configuredInstanceVariable = configuredInstanceVariableQuery.getConfiguredInstanceVariable();
            String processDefinitionId = configuredInstanceVariableQuery.getProcessDefinitionId();
            String nodeKey = configuredInstanceVariable.getInstanceKey();
            String nodeName = configuredInstanceVariable.getInstanceName();
            String configuredInstanceVariableOnlyId = configuredInstanceVariable.getOnlyId();
            List<Map<String, Object>> variables = this.findExternalSubProcessNodeVariableBy(configuredInstanceVariable);
            ArrayList<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInSubProcessList = new ArrayList<AllVariablesConfiguredInProcessVo>();
            HashSet<String> bindingSubProcessOnlyIds = new HashSet<String>();
            for (Map<String, Object> variable : variables) {
                BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
                Map<String, String> processMessage = AnalyticalModelUtil.getAllCallActivityProcessKey(bm, nodeKey, variable);
                List<String> nodeVariables = AnalyticalModelUtil.getCallActivityNodeVariables(bm, nodeKey, variable);
                String externalSubProcessKey = processMessage.get("processKey");
                List<String> subProcessKeyList = Arrays.asList(externalSubProcessKey.split(","));
                if (!HussarUtils.isNotEmpty((Object)externalSubProcessKey)) continue;
                for (String subProcessKey : subProcessKeyList) {
                    AllVariablesConfiguredInProcessVo allVariablesConfiguredInSubProcess = this.getAllVariablesConfiguredInSubProcess(subProcessKey);
                    allVariablesConfiguredInSubProcess.setBindingVariablesFromMainProcess(variable);
                    allVariablesConfiguredInSubProcess.setBindingConfiguredInstanceVariableOnlyIdFromMainProcess(configuredInstanceVariableOnlyId);
                    allVariablesConfiguredInSubProcess.setBindingConfiguredInstanceVariableKeyFromMainProcess(nodeKey);
                    allVariablesConfiguredInSubProcess.setBindingNodeVariablesFromMainProcess(nodeVariables);
                    allVariablesConfiguredInSubProcess.setBindingMainProcessDefinitionId(processDefinitionId);
                    allVariablesConfiguredInSubProcess.setBindingMainProcessOnlyId(configuredInstanceVariable.getParentId());
                    String processName = allVariablesConfiguredInSubProcess.getProcessName();
                    allVariablesConfiguredInSubProcess.setProcessName(processName + "\uff08" + nodeName.split("\uff08")[0] + "\uff09");
                    allVariablesConfiguredInSubProcessList.add(allVariablesConfiguredInSubProcess);
                    bindingSubProcessOnlyIds.add(allVariablesConfiguredInSubProcess.getOnlyId());
                }
            }
            JSONObject result = new JSONObject();
            result.put("allVariablesConfiguredInSubProcessList", allVariablesConfiguredInSubProcessList);
            result.put("bindingSubProcessOnlyIds", bindingSubProcessOnlyIds);
            apiResponse = ApiResponse.success((Object)result);
        }
        catch (BpmException e) {
            logger.error(e.getMessage());
            apiResponse = ApiResponse.fail((String)e.getMessage());
        }
        return apiResponse;
    }

    public List<Map<String, Object>> findExternalSubProcessNodeVariableBy(ConfiguredInstanceVariableDto configuredInstanceVariable) {
        int numberOfProcessStarts = configuredInstanceVariable.getNumberOfProcessStarts();
        List configuredVariables = configuredInstanceVariable.getConfiguredVariables();
        ArrayList<Map<String, Object>> variables = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < numberOfProcessStarts; ++i) {
            HashMap<String, Object> variable = new HashMap<String, Object>();
            for (ConfiguredVariableDto configuredVariable : configuredVariables) {
                String name = null;
                Object value = null;
                if ("sublist".equals(configuredVariable.getGroupedType())) {
                    name = String.valueOf(configuredVariable.getName());
                    int arrayLength = String.valueOf(configuredVariable.getValue()).split(",").length;
                    value = i < arrayLength ? String.valueOf(configuredVariable.getValue()).split(",")[i] : "";
                } else {
                    name = String.valueOf(configuredVariable.getName());
                    value = configuredVariable.getValue();
                }
                if ("".equals(value) && !"bpm_next_node".equals(name)) {
                    if ("Boolean".equals(configuredVariable.getType())) {
                        variable.put(name, false);
                        continue;
                    }
                    variable.put(name, null);
                    continue;
                }
                variable.put(name, value);
            }
            variables.add(variable);
        }
        return variables;
    }

    public Map<String, Map<String, List<ConfiguredVariableDto>>> parse(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        return new HashMap<String, Map<String, List<ConfiguredVariableDto>>>(this.levelOrderTraversalAllVariablesConfiguredInProcess(allVariablesConfiguredInProcess));
    }

    private Map<String, Map<String, List<ConfiguredVariableDto>>> levelOrderTraversalAllVariablesConfiguredInProcess(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        HashMap<String, Map<String, List<ConfiguredVariableDto>>> mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable = new HashMap<String, Map<String, List<ConfiguredVariableDto>>>();
        ArrayDeque<Object> allVariablesConfiguredInProcessQueue = new ArrayDeque<Object>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            allVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            List configuredInstanceVariables = allVariablesConfiguredInProcess.getConfiguredInstanceVariables();
            if (HussarUtils.isNotEmpty((Object)configuredInstanceVariables)) {
                HashMap<String, List> mappingFromInstanceKeyToConfiguredVariables = new HashMap<String, List>();
                for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
                    List configuredVariables;
                    if (!configuredInstanceVariable.isProcessVariable()) {
                        String instanceKey = configuredInstanceVariable.getInstanceKey();
                        configuredVariables = configuredInstanceVariable.getConfiguredVariables();
                        if (mappingFromInstanceKeyToConfiguredVariables.get(instanceKey) == null) {
                            mappingFromInstanceKeyToConfiguredVariables.put(instanceKey, configuredVariables);
                            continue;
                        }
                        ((List)mappingFromInstanceKeyToConfiguredVariables.get(instanceKey)).addAll(configuredVariables);
                        continue;
                    }
                    String processKey = configuredInstanceVariable.getProcessKey();
                    configuredVariables = configuredInstanceVariable.getConfiguredVariables();
                    if (mappingFromInstanceKeyToConfiguredVariables.get(processKey) == null) {
                        mappingFromInstanceKeyToConfiguredVariables.put(processKey, configuredVariables);
                        continue;
                    }
                    ((List)mappingFromInstanceKeyToConfiguredVariables.get(processKey)).addAll(configuredVariables);
                }
                mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.put(allVariablesConfiguredInProcess.getOnlyId(), mappingFromInstanceKeyToConfiguredVariables);
            }
            if (HussarUtils.isEmpty((Object)allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses())) {
                allVariablesConfiguredInProcessQueue.addAll(new ArrayList());
                continue;
            }
            allVariablesConfiguredInProcessQueue.addAll(allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses());
        }
        return mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable;
    }

    public Map<String, AllVariablesConfiguredInProcessVo> groupAllVariablesConfiguredInProcessByProcessOnlyId(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        HashMap<String, AllVariablesConfiguredInProcessVo> mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess = new HashMap<String, AllVariablesConfiguredInProcessVo>();
        mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess.put(allVariablesConfiguredInProcess.getOnlyId(), allVariablesConfiguredInProcess);
        ArrayDeque<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcessQueue = new ArrayDeque<AllVariablesConfiguredInProcessVo>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            allVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            List allVariablesConfiguredInExternalSubProcesses = allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses();
            if (allVariablesConfiguredInExternalSubProcesses == null) continue;
            allVariablesConfiguredInExternalSubProcesses.forEach(p -> mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess.put(p.getOnlyId(), (AllVariablesConfiguredInProcessVo)p));
            allVariablesConfiguredInProcessQueue.addAll(allVariablesConfiguredInExternalSubProcesses);
        }
        return mappingFromProcessOnlyIdToAllVariablesConfiguredInProcess;
    }

    public Map<String, ConfiguredInstanceVariableDto> groupConfiguredInstanceVariableByInstanceKey(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String processKey) {
        HashMap<String, ConfiguredInstanceVariableDto> mappingFromInstanceKeyToConfiguredInstanceVariable = new HashMap<String, ConfiguredInstanceVariableDto>();
        ArrayDeque<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcessQueue = new ArrayDeque<AllVariablesConfiguredInProcessVo>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            allVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            if (allVariablesConfiguredInProcess.getProcessKey().equals(processKey)) {
                List configuredInstanceVariables = allVariablesConfiguredInProcess.getConfiguredInstanceVariables();
                if (!HussarUtils.isNotEmpty((Object)configuredInstanceVariables)) break;
                for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
                    mappingFromInstanceKeyToConfiguredInstanceVariable.put(configuredInstanceVariable.getInstanceKey(), configuredInstanceVariable);
                }
                break;
            }
            allVariablesConfiguredInProcessQueue.addAll(allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses());
        }
        return mappingFromInstanceKeyToConfiguredInstanceVariable;
    }

    public List<Map<String, String>> findExternalSubProcessDefIdsAndOnlyIdsFrom(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        ArrayList<Map<String, String>> externalSubProcessDefIdAndOnlyIds = new ArrayList<Map<String, String>>();
        ArrayDeque<AllVariablesConfiguredInProcessVo> allVariablesConfiguredInProcessQueue = new ArrayDeque<AllVariablesConfiguredInProcessVo>();
        allVariablesConfiguredInProcessQueue.add(allVariablesConfiguredInProcess);
        while (!allVariablesConfiguredInProcessQueue.isEmpty()) {
            allVariablesConfiguredInProcess = (AllVariablesConfiguredInProcessVo)allVariablesConfiguredInProcessQueue.poll();
            List allVariablesConfiguredInExternalSubProcesses = allVariablesConfiguredInProcess.getAllVariablesConfiguredInExternalSubProcesses();
            if (!HussarUtils.isNotEmpty((Object)allVariablesConfiguredInExternalSubProcesses)) continue;
            for (AllVariablesConfiguredInProcessVo allVariablesConfiguredInExternalSubProcesse : allVariablesConfiguredInExternalSubProcesses) {
                HashMap<String, String> processInfos = new HashMap<String, String>();
                processInfos.put("processDefinitionId", allVariablesConfiguredInExternalSubProcesse.getProcessDefinitionId());
                processInfos.put("processOnlyId", allVariablesConfiguredInExternalSubProcesse.getOnlyId());
                externalSubProcessDefIdAndOnlyIds.add(processInfos);
            }
            allVariablesConfiguredInProcessQueue.addAll(allVariablesConfiguredInExternalSubProcesses);
        }
        return externalSubProcessDefIdAndOnlyIds;
    }

    public Map<String, Object> findVariablesBy(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess, String processKey, String processOnlyId, String nodeId) {
        HashMap<String, Map<String, List<ConfiguredVariableDto>>> mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable = new HashMap<String, Map<String, List<ConfiguredVariableDto>>>();
        HashMap configuredProcessVariableAndInstanceVariable = new HashMap();
        ArrayList configuredVariable = new ArrayList();
        HashMap<String, Object> variable = new HashMap<String, Object>();
        mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.putAll(this.parse(allVariablesConfiguredInProcess));
        if (HussarUtils.isNotEmpty(mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.get(processOnlyId))) {
            configuredProcessVariableAndInstanceVariable.putAll((Map)mappingFromProcessOnlyIdToConfiguredProcessVariableAndInstanceVariable.get(processOnlyId));
        }
        if (processKey != null && HussarUtils.isNotEmpty(configuredProcessVariableAndInstanceVariable.get(processKey))) {
            configuredVariable.addAll((Collection)configuredProcessVariableAndInstanceVariable.get(processKey));
        }
        if (nodeId != null && HussarUtils.isNotEmpty(configuredProcessVariableAndInstanceVariable.get(nodeId))) {
            configuredVariable.addAll((Collection)configuredProcessVariableAndInstanceVariable.get(nodeId));
        }
        configuredVariable.forEach(v -> {
            if ("".equals(v.getValue()) && !"bpm_next_node".equals(v.getName())) {
                if ("Boolean".equals(v.getType())) {
                    variable.put(v.getName(), false);
                } else {
                    variable.put(v.getName(), null);
                }
            } else {
                variable.put(v.getName(), v.getValue());
            }
        });
        return variable;
    }

    public ConfiguredInstanceVariableDto findConfiguredInstanceVariableByNodeId(List<ConfiguredInstanceVariableDto> configuredInstanceVariables, String nodeKey) {
        for (ConfiguredInstanceVariableDto configuredInstanceVariable : configuredInstanceVariables) {
            if (!nodeKey.equals(configuredInstanceVariable.getInstanceKey())) continue;
            return configuredInstanceVariable;
        }
        return null;
    }

    public ApiResponse<AllVariablesConfiguredInProcessVo> findVariableById(String processInsId) {
        TestVariable variable = (TestVariable)this.getById(Long.valueOf(processInsId));
        AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcessVo = new AllVariablesConfiguredInProcessVo();
        if (variable != null && HussarUtils.isNotEmpty((Object)variable.getVariable())) {
            allVariablesConfiguredInProcessVo = (AllVariablesConfiguredInProcessVo)JSONObject.parseObject((String)variable.getVariable(), AllVariablesConfiguredInProcessVo.class);
        }
        return ApiResponse.success((Object)allVariablesConfiguredInProcessVo);
    }

    private void addAllCallActivityVariables(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcessVo) {
        String processDefinitionId = allVariablesConfiguredInProcessVo.getProcessDefinitionId();
        String processVersion = processDefinitionId.split(":")[1];
        String processDefKey = processDefinitionId.split(":")[0];
        FlowModel flowModel = this.getTestFlowModel(processDefinitionId);
        List flowObject = flowModel.getSlots().getElement();
        for (FlowObject object : flowObject) {
            if (!BpmNodeTypeUtil.isCallActivity((String)object.getName())) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActAssignee::getProcessVersion, (Object)Integer.valueOf(processVersion));
            queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)processDefKey);
            queryWrapper.eq(SysActAssignee::getContentType, (Object)"assign_model");
            ArrayList<String> allCallActivityProcessOnlyId = new ArrayList<String>();
            String taskDefinitionKey = object.getNodeId();
            queryWrapper.eq(SysActAssignee::getTaskDefKey, (Object)taskDefinitionKey);
            SysActAssignee sysActAssignee = (SysActAssignee)this.sysActAssigneeService.getOne((Wrapper)queryWrapper);
            JSONObject jsonObject = (JSONObject)JSONObject.parseObject((byte[])sysActAssignee.getContent(), JSONObject.class, (Feature[])new Feature[0]);
            String processKey = String.valueOf(jsonObject.get((Object)"defaultProcessKey"));
            AllVariablesConfiguredInProcessVo variablesConfiguredInProcessVo = (AllVariablesConfiguredInProcessVo)this.getVariablesConfiguredInMainProcess(processKey).getData();
            if (HussarUtils.isEmpty((Object)allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses())) {
                allVariablesConfiguredInProcessVo.setAllVariablesConfiguredInExternalSubProcesses(new ArrayList());
            }
            this.bindMainAndSubProcessParentId(variablesConfiguredInProcessVo);
            allCallActivityProcessOnlyId.add(variablesConfiguredInProcessVo.getOnlyId());
            allVariablesConfiguredInProcessVo.getAllVariablesConfiguredInExternalSubProcesses().add(variablesConfiguredInProcessVo);
            List configuredInstanceVariableDtos = allVariablesConfiguredInProcessVo.getConfiguredInstanceVariables();
            for (ConfiguredInstanceVariableDto configuredInstanceVariableDto : configuredInstanceVariableDtos) {
                if (!taskDefinitionKey.equals(configuredInstanceVariableDto.getInstanceKey())) continue;
                if (HussarUtils.isEmpty((Object)configuredInstanceVariableDto.getBindingSubProcessOnlyIds())) {
                    configuredInstanceVariableDto.setBindingSubProcessOnlyIds(new ArrayList());
                }
                configuredInstanceVariableDto.getBindingSubProcessOnlyIds().addAll(allCallActivityProcessOnlyId);
            }
        }
    }

    private void neatenNodes(List<NodeVo> processNodes) {
        this.processNodes = processNodes;
        this.mappingFromProcessOnlyIdToNodes = this.nodeService.parse(processNodes);
    }

    private void generateNodeAndAssigneeMapping(AllVariablesConfiguredInProcessVo allVariablesConfiguredInProcess) {
        List<String> processOnlyIds = this.findProcessOnlyIds();
        this.mappingFromProcessOnlyIdToNodeMapping = new HashMap<String, Map<String, List<NodeDto>>>();
        this.mappingFromNodeOnlyIdToAssignee = new HashMap<String, List<String>>();
        for (String processOnlyId : processOnlyIds) {
            this.generateNodeMapping(processOnlyId);
        }
    }

    private List<String> findProcessOnlyIds() {
        ArrayList<String> processOnlyIds = new ArrayList<String>();
        this.processNodes.forEach(processNode -> processOnlyIds.add(processNode.getOnlyId()));
        return processOnlyIds;
    }

    private void generateNodeMapping(String processOnlyId) {
        List<NodeDto> nodes = this.mappingFromProcessOnlyIdToNodes.get(processOnlyId);
        Map<String, List<NodeDto>> mappingFromNodeKeyToNodes = this.nodeService.groupNodeByKey(nodes);
        this.mappingFromProcessOnlyIdToNodeMapping.put(processOnlyId, mappingFromNodeKeyToNodes);
    }
}

