/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.workflow.engine.bpm.common.service.WorkflowCommonCacheService;
import com.jxdinfo.hussar.workflow.engine.bpm.listener.WorkflowListenerUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.BpmExceptionPushUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionMessageParam;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="DefaultCloudServiceTaskListener")
public class DefaultServiceTaskListener
implements JavaDelegate {
    private Logger logger = LogManager.getLogger(DefaultServiceTaskListener.class);
    private static WorkflowCommonCacheService workflowCommonCacheService = (WorkflowCommonCacheService)BpmSpringContextHolder.getBean(WorkflowCommonCacheService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);

    private <T> T getTempVar(DelegateExecution execution, String varName) {
        return (T)((ExecutionEntity)execution).getLocalTempVariable(varName);
    }

    public void execute(DelegateExecution delegateExecution) throws Exception {
        String beanId = (String)this.getTempVar(delegateExecution, "beanId");
        String listenerModel = (String)this.getTempVar(delegateExecution, "listenerModel");
        String requestMethod = (String)this.getTempVar(delegateExecution, "requestMethod");
        String processDefinitionId = delegateExecution.getProcessDefinitionId();
        String processDefinitionKey = processDefinitionId.split(":")[0];
        HashMap<String, Object> map = new HashMap<String, Object>();
        ExecutionEntity entity = (ExecutionEntity)delegateExecution;
        map.put("nodeId", delegateExecution.getCurrentActivityId());
        map.put("nodeName", delegateExecution.getCurrentActivityName());
        map.put("businessId", delegateExecution.getProcessBusinessKey());
        map.put("processInsId", delegateExecution.getProcessInstanceId());
        map.put("processDefinitionId", delegateExecution.getProcessDefinitionId());
        map.put("processKey", entity.getProcessDefinitionKey());
        map.put("appId", modelService.getAppId(entity.getProcessDefinitionKey()));
        map.put("appCode", modelService.getAppCode(entity.getProcessDefinitionKey()));
        HistoricProcessInstanceEntity historicProcessInstance = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(delegateExecution.getProcessInstanceId());
        if (historicProcessInstance != null) {
            map.put("starter", historicProcessInstance.getStartUserId());
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("createTime", simpleDateFormat.format(new Date()));
        map.put("processName", ((ExecutionEntity)delegateExecution).getProcessDefinition().getName());
        if (beanId != null) {
            String serviceName = String.valueOf(workflowCommonCacheService.getServiceName(processDefinitionKey));
            try {
                WorkflowListenerUtils.executionListener(listenerModel, requestMethod, beanId, map, serviceName);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                BpmException bpmException = new BpmException(BpmExceptionCodeEnum.ERROR_ACCESS_SERVICE_LISTENER, this.buildMessageParam(delegateExecution));
                BpmExceptionPushUtil.pushExceptionMessage(bpmException);
                throw bpmException;
            }
        }
    }

    private BpmExceptionMessageParam buildMessageParam(DelegateExecution delegateExecution) {
        ExecutionEntity execution = (ExecutionEntity)delegateExecution;
        BpmExceptionMessageParam bpmExceptionMessageParam = new BpmExceptionMessageParam();
        bpmExceptionMessageParam.setProcessKey(execution.getProcessDefinition().getKey());
        bpmExceptionMessageParam.setProcessName(execution.getProcessDefinition().getName());
        bpmExceptionMessageParam.setProcessNameTranslateKey(execution.getProcessDefinition().getNameTranslateKey());
        bpmExceptionMessageParam.setProcessDefinitionId(execution.getProcessDefinition().getId());
        bpmExceptionMessageParam.setTaskDefinitionKey(execution.getActivity().getId());
        bpmExceptionMessageParam.setTaskDefinitionName((String)execution.getActivity().getProperties().get("name"));
        bpmExceptionMessageParam.setNodeNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)bpmExceptionMessageParam.getProcessDefinitionId(), (String)execution.getActivity().getId()));
        String startUserId = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstanceId()).getStartUserId();
        bpmExceptionMessageParam.setStartUserId(startUserId);
        return bpmExceptionMessageParam;
    }
}

