/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.jxdinfo.hussar.workflow.engine.bsp.exception.BpmExceptionPushUtil;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionMessageParam;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.message.ExceptionMessageParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendInclusiveGatewayActivityBehavior
extends InclusiveGatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger((String)InclusiveGatewayActivityBehavior.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public void execute(ActivityExecution execution) throws Exception {
        execution.inactivate();
        this.lockConcurrentRoot(execution);
        PvmActivity activity = execution.getActivity();
        if (this.activeConcurrentExecutionsExist(execution)) {
            if (!log.isDebugEnabled()) return;
            log.debug("Inclusive gateway '{}' does not activate", (Object)activity.getId());
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("inclusive gateway '{}' activates", (Object)activity.getId());
        }
        List joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
        for (PvmTransition outgoingTransition : execution.getActivity().getOutgoingTransitions()) {
            Expression skipExpression = outgoingTransition.getSkipExpression();
            if (!SkipExpressionUtil.isSkipExpressionEnabled((ActivityExecution)execution, (Expression)skipExpression)) {
                Condition condition;
                if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && !condition.evaluate(outgoingTransition.getId(), (DelegateExecution)execution)) continue;
                transitionsToTake.add(outgoingTransition);
                continue;
            }
            if (!SkipExpressionUtil.shouldSkipFlowElement((ActivityExecution)execution, (Expression)skipExpression)) continue;
            transitionsToTake.add(outgoingTransition);
        }
        if (!transitionsToTake.isEmpty()) {
            execution.takeAll(transitionsToTake, joinedExecutions);
            return;
        }
        if (defaultSequenceFlow != null) {
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw new ActivitiException("Default sequence flow '" + defaultSequenceFlow + "' could not be not found");
            transitionsToTake.add(defaultTransition);
            execution.takeAll(transitionsToTake, joinedExecutions);
            return;
        }
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ExceptionMessageParam messageParam = new ExceptionMessageParam();
        messageParam.setProcessKey(executionEntity.getProcessDefinitionKey());
        messageParam.setProcessName(executionEntity.getProcessDefinition().getName());
        messageParam.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
        messageParam.setProcessNameTranslateKey(executionEntity.getProcessDefinition().getNameTranslateKey());
        messageParam.setTaskDefinitionKey(execution.getActivity().getId());
        messageParam.setTaskDefinitionName("\u591a\u8def\u7f51\u5173");
        messageParam.setNodeNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)messageParam.getProcessDefinitionId(), (String)messageParam.getTaskDefinitionKey()));
        String startUserId = Context.getCommandContext().getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(execution.getProcessInstanceId()).getStartUserId();
        messageParam.setStartUserId(startUserId);
        BpmExceptionMessageParam bpmExceptionMessageParam = BpmExceptionMessageParam.convertExceptionMessageParam((ExceptionMessageParam)messageParam);
        BpmException bpmException = new BpmException(BpmExceptionCodeEnum.NO_OUT_GOING_SEQUENCE, bpmExceptionMessageParam);
        BpmExceptionPushUtil.pushExceptionMessage(bpmException);
        throw bpmException;
    }

    List<? extends ActivityExecution> getLeaveExecutionsExtend(ActivityExecution parent) {
        ArrayList<Object> executionlist = new ArrayList<Object>();
        List subExecutions = parent.getExecutions();
        if (subExecutions.isEmpty()) {
            executionlist.add(parent);
        } else {
            for (ActivityExecution concurrentExecution : subExecutions) {
                executionlist.addAll(this.getLeaveExecutionsExtend(concurrentExecution));
            }
        }
        return executionlist;
    }

    public boolean activeConcurrentExecutionsExist(ActivityExecution execution) {
        PvmActivity activity = execution.getActivity();
        if (execution.isConcurrent()) {
            for (ActivityExecution activityExecution : this.getLeaveExecutionsExtend(execution.getParent())) {
                if (!activityExecution.isActive() || activityExecution.getId().equals(execution.getId())) continue;
                boolean reachable = false;
                TransitionImpl pvmTransition = ((ExecutionEntity)activityExecution).getTransitionBeingTaken();
                reachable = pvmTransition != null ? this.isReachable(pvmTransition.getDestination(), activity, new HashSet<PvmActivity>()) : this.isReachable(activityExecution.getActivity(), activity, new HashSet<PvmActivity>());
                if (!reachable) continue;
                if (log.isDebugEnabled()) {
                    log.debug("an active concurrent execution found: '{}'", (Object)activityExecution.getActivity());
                }
                return true;
            }
        } else if (execution.isActive()) {
            if (log.isDebugEnabled()) {
                log.debug("an active concurrent execution found: '{}'", (Object)execution.getActivity());
            }
            return true;
        }
        return false;
    }

    protected boolean isReachable(PvmActivity srcActivity, PvmActivity targetActivity, Set<PvmActivity> visitedActivities) {
        if (srcActivity.getOutgoingTransitions().isEmpty()) {
            visitedActivities.add(srcActivity);
            if (!(srcActivity.getParent() instanceof PvmActivity)) {
                return false;
            }
            srcActivity = (PvmActivity)srcActivity.getParent();
        }
        if (srcActivity.getId().equals(targetActivity.getId())) {
            return true;
        }
        visitedActivities.add(srcActivity);
        List transitionList = srcActivity.getOutgoingTransitions();
        if (transitionList != null && !transitionList.isEmpty()) {
            for (PvmTransition pvmTransition : transitionList) {
                boolean reachable;
                PvmActivity destinationActivity = pvmTransition.getDestination();
                if (destinationActivity == null || visitedActivities.contains(destinationActivity) || !(reachable = this.isReachable(destinationActivity, targetActivity, visitedActivities))) continue;
                return true;
            }
        }
        return false;
    }
}

