/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigBoService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.config.BpmConfigExtendConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.dao.BpmConfigMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.model.BpmConfig;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.model.BpmConfigOption;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class BpmConfigServiceImpl
extends HussarServiceImpl<BpmConfigMapper, BpmConfig>
implements IBpmConfigService {
    private final Logger logger = LogManager.getLogger(BpmConfigServiceImpl.class);
    private final BpmConfigMapper bpmConfigMapper;
    private final BpmConfigExtendConfig bpmConfigExtendConfig;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired(required=false)
    private ISysBaseConfigBoService sysBaseConfigService;
    private static final String BPM_CONFIG_CACHE_NAME = "bpmConfigCache";
    private static final String BPM_CONFIG_CACHE_NAME_NULL_TAG = "bpmConfigCacheNameNullTag";
    private static final List<String> BPM_EXTEND_CONFIG = new ArrayList<String>();

    public BpmConfigServiceImpl(BpmConfigMapper bpmConfigMapper, BpmConfigExtendConfig bpmConfigExtendConfig) {
        this.bpmConfigMapper = bpmConfigMapper;
        this.bpmConfigExtendConfig = bpmConfigExtendConfig;
    }

    public String getStringByKeyUseCache(String key) {
        if (this.sysBaseConfigService != null && "use_security_level".equals(key)) {
            String currentDatasourceName = this.dynamicDatasourceService.getCurrentDatasourceName();
            SysBaseConfig sysBaseConfig = this.sysBaseConfigService.getSysBaseConfig(currentDatasourceName, "protection_status");
            if ("3".equals(sysBaseConfig.getConfigValue())) {
                return "true";
            }
            return null;
        }
        String value = (String)HussarCacheUtil.get((String)BPM_CONFIG_CACHE_NAME, (Object)key, String.class);
        if (value == null) {
            BpmConfig bpmConfig = this.bpmConfigMapper.getValueByKey(key);
            if (HussarUtils.isNotEmpty((Object)bpmConfig)) {
                HussarCacheUtil.put((String)BPM_CONFIG_CACHE_NAME, (Object)key, (Object)(bpmConfig.getConfigValue() == null ? "" : bpmConfig.getConfigValue()));
                value = bpmConfig.getConfigValue();
            } else {
                if (BPM_EXTEND_CONFIG.contains(key)) {
                    HussarCacheUtil.put((String)BPM_CONFIG_CACHE_NAME, (Object)key, (Object)BPM_CONFIG_CACHE_NAME_NULL_TAG);
                    return null;
                }
                this.logger.error("\u672a\u83b7\u53d6\u5230\u914d\u7f6e\u9879 {} ", (Object)key);
            }
        } else if (BPM_CONFIG_CACHE_NAME_NULL_TAG.equals(value) && BPM_EXTEND_CONFIG.contains(key)) {
            return null;
        }
        return value;
    }

    public boolean getBooleanByKeyUseCache(String key) {
        return Boolean.parseBoolean(this.getStringByKeyUseCache(key));
    }

    public long getLongByKeyUseCache(String key) {
        return Long.parseLong(this.getStringByKeyUseCache(key));
    }

    public ApiResponse<Object> getList(Page<BpmConfig> page) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmConfig::getParentId, (Object)1);
        this.page((IPage)page, (Wrapper)queryWrapper);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)page.getRecords(), BpmConfig.class).translate(e -> "bpm_config_name_" + e.getConfigKey(), BpmConfig::setName).translate(e -> "bpm_config_description_" + e.getConfigKey(), BpmConfig::setDescription).translate(e -> "bpm_config_option_" + e.getConfigKey(), BpmConfig::setTranslateOptionValue).execute();
        return ApiResponse.success(page);
    }

    public ApiResponse<Object> configList(Long configId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BpmConfig::getParentId, (Object)configId);
        queryWrapper.orderByAsc(BpmConfig::getConfigId);
        List list = this.list((Wrapper)queryWrapper);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)list, BpmConfig.class).translate(e -> "bpm_config_name_" + e.getConfigKey(), BpmConfig::setName).translate(e -> "bpm_config_description_" + e.getConfigKey(), BpmConfig::setDescription).translate(e -> "bpm_config_option_" + e.getConfigKey(), BpmConfig::setTranslateOptionValue).execute();
        for (BpmConfig bpmConfig : list) {
            String callBackAddress;
            String cacheValue = (String)HussarCacheUtil.get((String)BPM_CONFIG_CACHE_NAME, (Object)bpmConfig.getConfigKey(), String.class);
            if (cacheValue != null) {
                bpmConfig.setConfigValue(cacheValue);
            }
            if ("checkOption".equals(bpmConfig.getConfigRule())) {
                Object[] optionValue = bpmConfig.getOptionValue();
                if (HussarUtils.isNotEmpty((Object[])optionValue)) {
                    ArrayList<BpmConfigOption> options = new ArrayList<BpmConfigOption>();
                    for (Object s : optionValue) {
                        options.add(new BpmConfigOption(((String)s).split(":")[0], ((String)s).split(":")[1]));
                    }
                    bpmConfig.setValueOptions(options);
                }
                if (HussarUtils.isEmpty((Object)bpmConfig.getValueOptions())) {
                    List valueOptions = this.bpmConfigExtendConfig.getValueOptions(bpmConfig.getConfigKey());
                    bpmConfig.setValueOptions(valueOptions);
                }
            }
            if (!"checkCallBack".equals(bpmConfig.getConfigRule()) || !HussarUtils.isNotEmpty((Object)(callBackAddress = this.bpmConfigExtendConfig.getCallBackAddress(bpmConfig.getConfigKey())))) continue;
            bpmConfig.setCallBackAddress(callBackAddress);
        }
        return ApiResponse.success((Object)list);
    }

    public ApiResponse<Object> update(List<BpmConfig> bpmConfigList) {
        String lastEditorId = null;
        if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            lastEditorId = BaseSecurityUtil.getUser().getId().toString();
        }
        Date lastTime = new Date();
        for (BpmConfig bpmConfig : bpmConfigList) {
            bpmConfig.setLastTime(lastTime);
            bpmConfig.setLastEditor(lastEditorId);
        }
        this.updateBatchById(bpmConfigList);
        List ids = bpmConfigList.stream().map(BpmConfig::getConfigId).collect(Collectors.toList());
        List newBpmConfigList = this.listByIds(ids);
        for (BpmConfig bpmConfig : newBpmConfigList) {
            if (bpmConfig.getConfigValue() == null) continue;
            HussarCacheUtil.put((String)BPM_CONFIG_CACHE_NAME, (Object)bpmConfig.getConfigKey(), (Object)bpmConfig.getConfigValue());
        }
        return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
    }

    static {
        BPM_EXTEND_CONFIG.add("use_security_level");
    }
}

