/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processtest.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.bpm.processtest.dao.SysActProcessFileTestMapper;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.godaxe.processtest.model.SysActProcessFileModel;
import com.jxdinfo.hussar.workflow.godaxe.processtest.service.SysActProcessFileService;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActProcessFileTestServiceImpl
extends ServiceImpl<SysActProcessFileTestMapper, SysActProcessFileModel>
implements SysActProcessFileService {
    @Autowired
    ProcessDefinitionsService processDefinitionsService;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Resource
    SysActProcessFileTestMapper sysActProcessFileTestMapper;

    public WorkFlow getFileByProcessDefId(String processDefId, String processKey, String version) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (processDefId != null && !"".equals(processDefId)) {
            queryWrapper.eq(SysActProcessFileModel::getProcessId, (Object)processDefId);
        } else {
            String processId = null;
            if (HussarUtils.isNotEmpty((Object)version)) {
                processId = this.processDefinitionsMapper.selectProcessIdByProcessKeyAndVersion(processKey, Long.parseLong(version));
            } else {
                DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey, null);
                processId = definitionModel.getId();
            }
            queryWrapper.eq(SysActProcessFileModel::getProcessId, (Object)processId);
        }
        List list = this.sysActProcessFileTestMapper.selectList((Wrapper)queryWrapper);
        SysActProcessFileModel wfdFile = new SysActProcessFileModel();
        SysActProcessFileModel metaFile = new SysActProcessFileModel();
        for (SysActProcessFileModel sysActProcessFileModel : list) {
            if (HussarUtils.equals((Object)"wfd", (Object)sysActProcessFileModel.getType())) {
                wfdFile = sysActProcessFileModel;
                continue;
            }
            if (!HussarUtils.equals((Object)"meta", (Object)sysActProcessFileModel.getType())) continue;
            metaFile = sysActProcessFileModel;
        }
        String wfdInfo = null;
        if (HussarUtils.isNotEmpty((Object)wfdFile)) {
            wfdInfo = wfdFile.getContent() == null ? null : new String(wfdFile.getContent(), StandardCharsets.UTF_8);
        }
        String metaInfo = null;
        if (HussarUtils.isNotEmpty((Object)metaFile)) {
            String string = metaInfo = metaFile.getContent() == null ? null : new String(metaFile.getContent(), StandardCharsets.UTF_8);
        }
        if (HussarUtils.isNotEmpty(metaInfo)) {
            WorkFlow workFlow = (WorkFlow)JSON.parseObject((String)metaInfo, WorkFlow.class);
            workFlow.setData(wfdInfo);
            return workFlow;
        }
        return null;
    }

    public WorkFlow getLatestTestProcessFile(String processKey) throws BpmException {
        String latestTestProcessDefinitionId = this.processDefinitionsService.getLastProcessDefinitionId(processKey);
        WorkFlow workFlow = this.getFileByProcessDefId(latestTestProcessDefinitionId, null, null);
        return workFlow;
    }
}

