/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.util;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.WorkflowBpmUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SysActExtendPropertiesCacheUtil {
    private static ISysActExtendPropertiesService sysActExtendPropertiesService = (ISysActExtendPropertiesService)BpmSpringContextHolder.getBean(ISysActExtendPropertiesService.class);

    public static void clearExtendPropertiesCacheByProcessDefinitionId(String processDefinitionId) {
        HussarCacheUtil.evictKeysRightLike((String)"workflow_extend_properties", (String)(processDefinitionId + ":"));
    }

    public static Map<String, SysActExtendProperties> getExtendPropertiesMapWithCache(String processDefinitionId, Set<String> taskDefinitionKeySet) {
        HashMap<String, SysActExtendProperties> extendPropertiesMap = new HashMap<String, SysActExtendProperties>();
        ArrayList<String> queryTaskDefinitionKeyList = new ArrayList<String>();
        for (String taskDefinitionKey : taskDefinitionKeySet) {
            String key = processDefinitionId + ":" + taskDefinitionKey;
            String sysActExtendProperties = (String)HussarCacheUtil.get((String)"workflow_extend_properties", (Object)key);
            if (sysActExtendProperties != null) {
                if ("".equals(sysActExtendProperties)) continue;
                extendPropertiesMap.put(processDefinitionId, (SysActExtendProperties)JSON.parseObject((String)sysActExtendProperties, SysActExtendProperties.class));
                continue;
            }
            queryTaskDefinitionKeyList.add(taskDefinitionKey);
        }
        if (!queryTaskDefinitionKeyList.isEmpty()) {
            LambdaQueryWrapper extendPropertiesWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)extendPropertiesWrapper.eq(SysActExtendProperties::getProcDefId, (Object)processDefinitionId)).in(SysActExtendProperties::getTaskDefKey, queryTaskDefinitionKeyList);
            List extendPropertiesList = sysActExtendPropertiesService.list((Wrapper)extendPropertiesWrapper);
            Map<String, SysActExtendProperties> queryExtendPropertiesMap = WorkflowBpmUtil.getMap(extendPropertiesList, SysActExtendProperties::getTaskDefKey, null);
            for (String taskDefinitionKey : queryTaskDefinitionKeyList) {
                String key = processDefinitionId + ":" + taskDefinitionKey;
                SysActExtendProperties sysActExtendProperties = queryExtendPropertiesMap.get(taskDefinitionKey);
                if (sysActExtendProperties == null) {
                    HussarCacheUtil.put((String)"workflow_extend_properties", (Object)key, (Object)"");
                    continue;
                }
                HussarCacheUtil.put((String)"workflow_extend_properties", (Object)key, (Object)JSON.toJSONString((Object)sysActExtendProperties));
            }
            extendPropertiesMap.putAll(queryExtendPropertiesMap);
        }
        return extendPropertiesMap;
    }
}

