/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.message.push.config;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class PushMsgExecutorConfig {
    private static final Logger logger = LoggerFactory.getLogger(PushMsgExecutorConfig.class);
    private static final int CORE_POOL_SIZE = 50;
    private static final int MAX_POOL_SIZE = 100;
    private static final int QUEUE_CAPACITY = 1000;
    private static final int KEEP_ALIVE_SECONDS = 60;
    private static final String PREFIX = "workflow-msg-";

    @Bean
    public Executor pushMsgExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(50);
        executor.setMaxPoolSize(100);
        executor.setQueueCapacity(1000);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix(PREFIX);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new PushMsgAbortPolicy());
        executor.initialize();
        return executor;
    }

    public static class PushMsgAbortPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor threadPoolExecutor) {
            FutureTask task = (FutureTask)r;
            try {
                Object[] objs;
                Object callable = PushMsgAbortPolicy.getFiled(task, "callable");
                ReflectiveMethodInvocation method = (ReflectiveMethodInvocation)PushMsgAbortPolicy.getFiled(callable, "arg$2");
                if (HussarUtils.isNotEmpty((Object)method) && (objs = method.getArguments()).length > 0) {
                    for (BpmActMsgDetail bpmActMsgDetail : (ArrayList)objs[0]) {
                        logger.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff01\u6d41\u7a0b[{}], \u6d88\u606f\u7c7b\u578b[{}], \u6d88\u606f\u63d0\u9192\u65b9\u5f0f[{}], \u63a8\u9001\u5931\u8d25\uff01", new Object[]{bpmActMsgDetail.getProcessKey(), bpmActMsgDetail.getSceneCode(), bpmActMsgDetail.getChannelType()});
                    }
                }
            }
            catch (IllegalAccessException e) {
                logger.error("\u53cd\u5c04\u5904\u7406\u9519\u8bef\uff1a", (Throwable)e);
            }
            logger.error("Task " + r.toString() + " rejected from " + threadPoolExecutor.toString());
        }

        private static Object getFiled(Object c, String name) throws IllegalAccessException {
            while (c != null) {
                try {
                    Field field = c.getClass().getDeclaredField(name);
                    field.setAccessible(true);
                    return field.get(c);
                }
                catch (NoSuchFieldException e) {
                    c = c.getClass().getSuperclass();
                }
            }
            return null;
        }
    }
}

