/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.activiti.model.BpmActReProcdef;
import com.jxdinfo.hussar.workflow.activiti.service.IBpmActReProcdefService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.organ.dto.OrganProcessModelQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.organ.vo.OrganProcessModelQueryVo;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;

public class WorkflowOrganProcessUtil {
    private static IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)BpmSpringContextHolder.getBean(IAssigneeChooseService.class);
    private static ProcessDefinitionsService processDefinitionsService = (ProcessDefinitionsService)BpmSpringContextHolder.getBean(ProcessDefinitionsService.class);
    private static ModelService modelService = (ModelService)BpmSpringContextHolder.getBean(ModelService.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
    private static IBpmActReProcdefService iBpmActReProcdefService = (IBpmActReProcdefService)BpmSpringContextHolder.getBean(IBpmActReProcdefService.class);
    private static LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)BpmSpringContextHolder.getBean(LcdpBpmProperties.class);

    public static List<String> getAllParentIds(String userId, String organId) {
        ArrayList organIds = iAssigneeChooseService.getAllParentOrganId(userId, organId);
        if (organIds == null) {
            organIds = new ArrayList();
        }
        return organIds;
    }

    public static List<String> getAllOrganProcessModel(String processKey) {
        return modelService.getProcessModelAllOrgan(processKey, null);
    }

    public static String getStartOrganProcessId(String processKey, String version, String userId, String organId, boolean isGetMainOrNew) {
        return WorkflowOrganProcessUtil.getStartOrganProcessId(processKey, version, userId, organId, isGetMainOrNew, "1");
    }

    public static String getStartOrganProcessId(String processKey, String version, String userId, String organId, boolean isGetMainOrNew, String modelStatus) {
        if (HussarUtils.isNotEmpty((Object)version)) {
            return processDefinitionsService.getStartProcessDefinitionId(processKey, version);
        }
        if (!lcdpBpmProperties.isUseOrganProcess()) {
            if (isGetMainOrNew) {
                return processDefinitionsService.getStartProcessDefinitionId(processKey, version);
            }
            return processDefinitionsService.getLastProcessDefinitionId(processKey);
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{userId, organId})) {
            if (isGetMainOrNew) {
                return processDefinitionsService.getStartProcessDefinitionId(processKey, version);
            }
            return processDefinitionsService.getLastProcessDefinitionId(processKey);
        }
        List organIds = modelService.getProcessModelAllOrgan(processKey, modelStatus);
        if (HussarUtils.isEmpty((Object)organIds)) {
            if (isGetMainOrNew) {
                return processDefinitionsService.getStartProcessDefinitionId(processKey, version);
            }
            return processDefinitionsService.getLastProcessDefinitionId(processKey);
        }
        List<String> parentIds = WorkflowOrganProcessUtil.getAllParentIds(userId, organId);
        String processOrganId = null;
        for (String parentId : parentIds) {
            if (!organIds.contains(parentId)) continue;
            processOrganId = parentId;
            break;
        }
        if (isGetMainOrNew) {
            return processDefinitionsService.getStartProcessDefinitionId(processKey, version, processOrganId);
        }
        return processDefinitionsService.getLastProcessDefinitionId(processKey, processOrganId);
    }

    public static OrganProcessModelQueryVo getStartOrganProcessModelMessage(OrganProcessModelQueryDto organProcessModelQueryDto) {
        String procDefId;
        String processKey = organProcessModelQueryDto.getProcessKey();
        String version = organProcessModelQueryDto.getVersion();
        String userId = organProcessModelQueryDto.getUserId();
        String organId = organProcessModelQueryDto.getOrganId();
        boolean isGetMainOrNew = organProcessModelQueryDto.isGetMainOrNew();
        OrganProcessModelQueryVo organProcessModelQueryVo = new OrganProcessModelQueryVo();
        String processOrganId = null;
        boolean needQueryProcessOrganId = false;
        if (HussarUtils.isNotEmpty((Object)version)) {
            needQueryProcessOrganId = true;
            procDefId = processDefinitionsService.getStartProcessDefinitionId(processKey, version);
        } else if (!lcdpBpmProperties.isUseOrganProcess()) {
            procDefId = isGetMainOrNew ? processDefinitionsService.getStartProcessDefinitionId(processKey, null) : processDefinitionsService.getLastProcessDefinitionId(processKey);
        } else if (HussarUtils.isAllEmpty((Object[])new Object[]{userId, organId})) {
            procDefId = isGetMainOrNew ? processDefinitionsService.getStartProcessDefinitionId(processKey, null) : processDefinitionsService.getLastProcessDefinitionId(processKey);
        } else {
            List organIds = modelService.getProcessModelAllOrgan(processKey, "1");
            if (HussarUtils.isEmpty((Object)organIds)) {
                procDefId = isGetMainOrNew ? processDefinitionsService.getStartProcessDefinitionId(processKey, null) : processDefinitionsService.getLastProcessDefinitionId(processKey);
            } else {
                List<String> parentIds = WorkflowOrganProcessUtil.getAllParentIds(userId, organId);
                if (HussarUtils.isEmpty((Object)organId) && HussarUtils.isNotEmpty(parentIds)) {
                    organId = parentIds.get(0);
                }
                processOrganId = null;
                for (String parentId : parentIds) {
                    if (!organIds.contains(parentId)) continue;
                    processOrganId = parentId;
                    break;
                }
                procDefId = isGetMainOrNew ? processDefinitionsService.getStartProcessDefinitionId(processKey, version, processOrganId) : processDefinitionsService.getLastProcessDefinitionId(processKey, processOrganId);
            }
        }
        organProcessModelQueryVo.setOrganId(organId);
        organProcessModelQueryVo.setProcessKey(processKey);
        organProcessModelQueryVo.setVersion(procDefId.split(":")[1]);
        organProcessModelQueryVo.setProcessDefId(procDefId);
        ProcessDefinition processDefinition = repositoryService.getProcessDefinition(procDefId);
        if (needQueryProcessOrganId && processOrganId == null && lcdpBpmProperties.isUseOrganProcess()) {
            processOrganId = ((BpmActReProcdef)iBpmActReProcdefService.getById((Serializable)((Object)procDefId))).getOrganId();
        }
        organProcessModelQueryVo.setProcessOrganId(processOrganId);
        organProcessModelQueryVo.setProcessName(processDefinition.getName());
        BpmnModel bpmnModel = repositoryService.getBpmnModel(procDefId);
        Collection list = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : list) {
            if (!(flowElement instanceof StartEvent)) continue;
            organProcessModelQueryVo.setStartNodeFormKey(((StartEvent)flowElement).getFormKey());
            break;
        }
        return organProcessModelQueryVo;
    }
}

