/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.CallActivityTable;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowSequence;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowVariables;
import com.jxdinfo.hussar.workflow.engine.flowmodel.MultiUser;
import com.jxdinfo.hussar.workflow.engine.flowmodel.SubProps;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.IOParameter;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.CallActivity")
public class CallActivityVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, FlowElementsContainer process, FlowModel flowModel, FlowObject processModel) {
        List output;
        CallActivity callActivity = new CallActivity();
        FlowProps flowProps = flowObject.getProps();
        callActivity.setId(flowObject.getId());
        callActivity.setName(flowObject.getProps().getFlowName());
        callActivity.setDocumentation(flowObject.getProps().getFlowDescription());
        callActivity.setCalledElement(flowObject.getProps().getFlowSelectorStr());
        List input = flowObject.getProps().getInput();
        if (HussarUtils.isNotEmpty((Object)input)) {
            ArrayList<IOParameter> inList = new ArrayList<IOParameter>();
            for (Object subProps : input) {
                IOParameter ioParameter = new IOParameter();
                ioParameter.setSource(subProps.getResource());
                ioParameter.setTarget(subProps.getTarget());
                ioParameter.setSourceExpression(subProps.getResourceExpression());
                inList.add(ioParameter);
            }
            callActivity.setInParameters(inList);
        }
        if (HussarUtils.isNotEmpty((Object)(output = flowObject.getProps().getOutput()))) {
            ArrayList<IOParameter> outList = new ArrayList<IOParameter>();
            for (SubProps subProps : output) {
                IOParameter ioParameter = new IOParameter();
                ioParameter.setSource(subProps.getResource());
                ioParameter.setTarget(subProps.getTarget());
                ioParameter.setSourceExpression(subProps.getResourceExpression());
                outList.add(ioParameter);
            }
            callActivity.setOutParameters(outList);
        }
        if (HussarUtils.isNotEmpty((Object)flowObject.getProps().getFlowCountersign())) {
            this.counterSign(flowObject, callActivity);
        }
        callActivity.setInheritVariables(true);
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<FlowVariables> functionUserVariables = new ArrayList<FlowVariables>();
        FormBpmnUtil.getFunctionMessage(flowObject.getProps(), map, functionUserVariables);
        FormBpmnUtil.callActivityAssigneeInstall(flowObject, callActivity, map);
        ArrayList<String> pathIds = new ArrayList<String>();
        List flowSequences = processModel.getSlots().getPath();
        for (FlowSequence flowSequence : flowSequences) {
            pathIds.add(flowSequence.getId());
        }
        ArrayList<FlowVariables> useVariables = flowObject.getProps().getUseVariables();
        if (useVariables == null) {
            useVariables = functionUserVariables;
        } else {
            useVariables.addAll(functionUserVariables);
        }
        CallActivityTable callActivityTable = flowObject.getProps().getCallActivityTable();
        boolean needGetVariable = false;
        if (callActivityTable != null) {
            needGetVariable = HussarUtils.isNotEmpty((Object)callActivityTable.getTableId());
        }
        if (HussarUtils.isNotEmpty(useVariables) || needGetVariable) {
            FormBpmnUtil.addExeListener((FlowElement)callActivity, useVariables, pathIds, needGetVariable);
        }
        FormBpmnUtil.addExecutionListener((Activity)callActivity, flowObject);
        FormBpmnUtil.commonExtendHandle(flowObject, (FlowElement)callActivity);
        process.addFlowElement((FlowElement)callActivity);
    }

    private void counterSign(FlowObject flowObject, CallActivity callActivity) {
        MultiUser multiUser = flowObject.getProps().getFlowCountersign();
        if (multiUser.isCountersign()) {
            MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
            multiInstanceLoopCharacteristics.setSequential(false);
            multiInstanceLoopCharacteristics.setInputDataItem("multi");
            if ("radio".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances/nrOfInstances >= " + multiUser.getCountersignNumByRatio() / 100.0 + " }");
            }
            if ("count".equals(multiUser.getCountersignType())) {
                multiInstanceLoopCharacteristics.setCompletionCondition("${nrOfCompletedInstances == " + multiUser.getCountersignNumByCount() + " }");
            }
            callActivity.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        }
    }
}

