/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.Timestamp;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiSequenceFlowTakenEventImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricLineEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class SequenceFlowTakeListener
implements ActivitiEventListener {
    private static Logger logger = LogManager.getLogger(SequenceFlowTakeListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        if (!activitiEvent.getType().equals((Object)ActivitiEventType.SEQUENCEFLOW_TAKEN)) {
            return;
        }
        ActivitiSequenceFlowTakenEventImpl sequenceFlowTakenEvent = (ActivitiSequenceFlowTakenEventImpl)activitiEvent;
        HistoricLineEntity historicLineEntity = new HistoricLineEntity();
        historicLineEntity.setProcInstId(Long.valueOf(Long.parseLong(sequenceFlowTakenEvent.getProcessInstanceId())));
        historicLineEntity.setProcDefId(sequenceFlowTakenEvent.getProcessDefinitionId());
        historicLineEntity.setLineId(sequenceFlowTakenEvent.getId());
        historicLineEntity.setCompleteTime(new Timestamp(System.currentTimeMillis()));
        historicLineEntity.setOutNode(sequenceFlowTakenEvent.getSourceActivityId());
        historicLineEntity.setOutNodeName(sequenceFlowTakenEvent.getSourceActivityName());
        historicLineEntity.setInNode(sequenceFlowTakenEvent.getTargetActivityId());
        historicLineEntity.setInNodeName(sequenceFlowTakenEvent.getTargetActivityName());
        ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(activitiEvent.getExecutionId());
        String separatedVariable = execution.getSubProcessKey();
        if (HussarUtils.isNotEmpty((Object)separatedVariable)) {
            historicLineEntity.setSubProcessKey(separatedVariable);
            Integer cycleCount = execution.getCycleCount();
            historicLineEntity.setCycleCount(cycleCount);
        }
        historicLineEntity.insertHistoricLine();
    }

    public boolean isFailOnException() {
        logger.error("\u4fdd\u5b58\u7ebf\u7684\u529e\u7406\u5386\u53f2\u51fa\u9519");
        return false;
    }
}

