/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonPrepareCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessActionCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ProcessNodeCmd;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;

public class PreemptTaskCmd
extends CommonPrepareCmd {
    protected static DataPushService dataPushService = (DataPushService)BpmSpringContextHolder.getBean(DataPushService.class);
    protected static TaskEngineMapper taskEngineMapper = (TaskEngineMapper)BpmSpringContextHolder.getBean(TaskEngineMapper.class);
    private HistoryService historyService = (HistoryService)BpmSpringContextHolder.getBean(HistoryService.class);
    public static final String PREEMPT = "1";

    @Override
    protected void follow(CommandContext commandContext, TaskEntity task) {
        task.setPreempted(PREEMPT);
        List identityLinkEntityList = task.getCandidates();
        Set users = identityLinkEntityList.stream().filter(identityLink -> !TaskStateType.isEntrust((IdentityLink)identityLink)).map(IdentityLinkEntity::getUserId).collect(Collectors.toSet());
        users.remove(this.userId);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (dataPushService.isDataPush(processDefinitionIdList) && identityLinkEntityList.size() > 1) {
            HashSet<String> deleteUsers = new HashSet<String>();
            ArrayList<Map<String, String>> deleteUserMaps = new ArrayList<Map<String, String>>();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
                if (!identityLinkEntity.getUserId().equals(this.userId)) {
                    deleteUsers.add(identityLinkEntity.getUserId());
                }
                if (Objects.equals(identityLinkEntity.getUserId(), this.userId) && Objects.equals(identityLinkEntity.getMandator(), this.mandator)) continue;
                HashMap<String, String> deleteUserMap = new HashMap<String, String>();
                deleteUserMap.put("userId", identityLinkEntity.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLinkEntity)) {
                    deleteUserMap.put("mandator", identityLinkEntity.getMandator());
                    deleteUserMap.put("taskState", identityLinkEntity.getTaskState());
                }
                deleteUserMaps.add(deleteUserMap);
            }
            dataPushService.entrustDataPush(this.preemptDataPush(task, deleteUsers, deleteUserMaps));
        }
        if (!users.isEmpty()) {
            taskEngineMapper.unPreemptDeduplication(users, Long.parseLong(this.taskId));
        }
        taskEngineMapper.preemptTask(Long.parseLong(this.taskId), this.userId, this.mandator);
        new ProcessActionCmd(task.getProcessInstanceId(), task.getProcessDefinitionId()).execute(commandContext);
        new ProcessNodeCmd(task.getProcessInstanceId()).execute(commandContext);
    }

    public PreemptTaskCmd(String taskId, String userId) {
        super(taskId, userId);
    }

    public PreemptTaskCmd(String taskId, String userId, String mandator) {
        super(taskId, userId, mandator);
    }

    public PreemptTaskCmd(String taskId, String userId, String mandator, boolean isAuditAuthority) {
        super(taskId, userId, mandator, isAuditAuthority);
    }

    private DataPush preemptDataPush(TaskEntity task, Set<String> deleteUsers, List<Map<String, String>> deleteUserMaps) {
        DataPush dataPush = new DataPush();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String deleteUser = String.join((CharSequence)",", deleteUsers);
        dataPush.setConsignor(deleteUser.length() != 0 ? deleteUser : null);
        dataPush.setConsignorMaps(deleteUserMaps);
        dataPush.setTaskId(task.getId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessInsId(historicProcessInstance.getId());
        dataPush.setBusinessKey(task.getProcessInstance().getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
        dataPush.setUrl(task.getFormKey());
        dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
        dataPush.setTaskType(task.getTaskType());
        List<Map<String, String>> userMapList = this.getAssigneeMapByTaskId(task, new ArrayList<String>(deleteUsers));
        dataPush.setUserMapList(userMapList);
        return dataPush;
    }

    private List<Map<String, String>> getAssigneeMapByTaskId(TaskEntity taskEntity, List<String> users) {
        List identityLinkList = taskEntity.getCandidates();
        if (HussarUtils.isNotEmpty(users)) {
            identityLinkList.removeIf(identityLink -> users.contains(identityLink.getUserId()));
        }
        ArrayList<Map<String, String>> userMaps = new ArrayList<Map<String, String>>();
        if (identityLinkList != null && !identityLinkList.isEmpty()) {
            for (IdentityLink identityLink2 : identityLinkList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", identityLink2.getUserId());
                if (TaskStateType.isEntrust((IdentityLink)identityLink2)) {
                    map.put("mandator", identityLink2.getMandator());
                    map.put("taskState", identityLink2.getTaskState());
                }
                userMaps.add(map);
            }
        }
        return userMaps;
    }
}

