/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.dto.QueryAssigneeDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganUserTree;
import com.jxdinfo.hussar.workflow.assignee.model.UserSecurityVo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.AssigneeQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.assigneemode.service.IAssigneeModeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.function.service.ISysActFunctionService;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.model.SysUser;
import com.jxdinfo.hussar.workflow.engine.bpm.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.outside.assignee.service.AssigneeChooseService;
import com.jxdinfo.hussar.workflow.outside.assigneefunction.service.AssigneeFunctionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.TaskStateType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private IAssigneeModeChooseService assigneeModeChooseService;
    @Autowired
    private ISysActFunctionService sysActFunctionService;
    @Lazy
    @Resource
    private HistoryService historyService;
    @Resource
    private ModelMapper modelMapper;
    @Lazy
    @Autowired
    private ModelService modelService;
    @Autowired
    IWorkflowAssigneeChooseService workflowAssigneeChooseService;
    @Autowired
    private ISysUserService sysUserService;
    private final IBpmConfigService bpmConfigService;
    private static Logger logger = LogManager.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final Pattern ROLE_NOT_CONTAINS_REGEX = Pattern.compile("R.GRANTED_ROLE NOT IN \\('([^)])*\\)");
    private static final String MICRO = "micro";
    private static final String WORKFLOW_PLATFORM = "workflow-platform";
    private static final String SINGLE = "single";
    private static final String TABLE_PREFIX = "table_prefix";
    public static final BpmTreeModel USER_NODE = new BpmTreeModel("999", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u7528\u6237", "organ", false, false, "9999", null, null);
    public static final BpmTreeModel LEAF_USER_NODE = new BpmTreeModel("999", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u7528\u6237", "organ", true, false, "9999", null, null);
    public static final BpmTreeModel LEAF_POST_NODE = new BpmTreeModel("1000", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u5c97\u4f4d", "organ", true, false, "10000", null, null);
    private static final List<String> CHECK_DEFAULT_FUNCTION_LIST = new ArrayList<String>();

    public AssigneeChooseServiceImpl(IBpmConfigService bpmConfigService) {
        this.bpmConfigService = bpmConfigService;
    }

    private String getDeploymentModel() {
        return this.lcdpBpmProperties.getDeploymentModel();
    }

    private String getTablePrefix() {
        return this.bpmConfigService.getStringByKeyUseCache(TABLE_PREFIX);
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost) {
        String tablePrefix = this.getTablePrefix();
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        try {
            return this.assigneeModeChooseService.userTree(id, isMainPost, useSecurityLevel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<OrganUserTree> userTreeForUserChoose(String id, String taskId) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        Integer securityLevel = null;
        String processInstanceId = "";
        if (useSecurityLevel) {
            if (HussarUtils.isNotEmpty((Object)taskId)) {
                HistoricTaskInstance hiTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).queryChildTask()).singleResult();
                processInstanceId = hiTask.getProcessInstanceId();
            }
            String historicProcessInstance = null;
            CommandContext commandContext = Context.getCommandContext();
            historicProcessInstance = commandContext != null ? commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId) : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (historicProcessInstance != null) {
                securityLevel = historicProcessInstance.getSecurityLevel();
            }
        }
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userTreeForUserChoose(id, securityLevel, useSecurityLevel, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.userTreeForUserChoose(id, securityLevel, useSecurityLevel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryUserTreeForUserChoose(QueryAssigneeDto queryAssigneeDto) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        String processInstanceId = "";
        Integer securityLevel = null;
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        if (useSecurityLevel) {
            if (HussarUtils.isNotEmpty((Object)queryAssigneeDto.getSecurityLevel())) {
                securityLevel = queryAssigneeDto.getSecurityLevel();
            } else {
                if (HussarUtils.isNotEmpty((Object)queryAssigneeDto.getProcessInstanceId())) {
                    processInstanceId = queryAssigneeDto.getProcessInstanceId();
                } else if (HussarUtils.isNotEmpty((Object)queryAssigneeDto.getTaskId())) {
                    HistoricTaskInstance hiTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(queryAssigneeDto.getTaskId())).queryChildTask()).singleResult();
                    processInstanceId = hiTask.getProcessInstanceId();
                }
                String historicProcessInstance = null;
                CommandContext commandContext = Context.getCommandContext();
                historicProcessInstance = commandContext != null ? commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId) : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                if (historicProcessInstance != null) {
                    securityLevel = historicProcessInstance.getSecurityLevel();
                }
            }
        }
        queryAssigneeDto.setSecurityLevel(securityLevel);
        queryAssigneeDto.setUseSecurityLevel(useSecurityLevel);
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTreeForUserChoose(queryAssigneeDto, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryUserTreeForUserChoose(queryAssigneeDto, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryDeptUserForUserChoose(List<String> organIds, List<String> userIds) {
        if (HussarUtils.isAllEmpty((Object[])new Object[]{organIds, userIds})) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptUserForUserChoose(organIds, userIds, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryDeptUserForUserChoose(organIds, userIds, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> postTree(String id, String postId, boolean isMainPost) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.postTree(id, postId, isMainPost, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.postTree(id, postId, isMainPost, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> deptTree(String id, String organId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.deptTree(id, organId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.deptTree(id, organId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.roleTree(tablePrefix);
                }
            }
            return this.assigneeModeChooseService.roleTree(tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> roleTree(String id, String roleId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.roleTree(id, roleId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.roleTree(id, roleId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userDetail(userIds, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.userDetail(userIds, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    private List<BpmTreeModel> userDeptDetail(String userId, boolean isInterface) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userDeptDetail(userId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.userDeptDetail(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getUserNames(List<String> userIds) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        if ((list == null || list.size() < userIds.size()) && WORKFLOW_PLATFORM.equals(this.getDeploymentModel())) {
            HashMap<String, String> map = new HashMap<String, String>();
            List users = this.sysUserService.getSysUser();
            for (SysUser sysUser : users) {
                map.put(sysUser.getUserId(), sysUser.getUserName());
            }
            for (String userId : userIds) {
                String name = (String)map.get(userId);
                if (name == null) continue;
                if (list == null) {
                    result.append(name);
                    continue;
                }
                result.append(",").append(name);
            }
        }
        return result.toString();
    }

    public List<String> getEntrustUserNames(List<IdentityLink> userIds) {
        ArrayList<String> users = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                users.add(identityLink.getUserId());
                users.add(identityLink.getMandator());
                continue;
            }
            users.add(identityLink.getUserId());
        }
        Map<String, String> map = this.getUserListByUserId(users);
        ArrayList<String> result = new ArrayList<String>();
        for (IdentityLink identityLink : userIds) {
            if (TaskStateType.isEntrust((IdentityLink)identityLink)) {
                result.add(map.get(identityLink.getUserId()) + "(" + map.get(identityLink.getMandator()) + ")");
                continue;
            }
            result.add(map.get(identityLink.getUserId()));
        }
        return result;
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList) {
        List<BpmTreeModel> list = this.userDetail(userList, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, false);
        if (list != null && !list.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        if ((list == null || list.size() < userIds.size()) && WORKFLOW_PLATFORM.equals(this.getDeploymentModel())) {
            List users = this.sysUserService.getSysUser();
            for (SysUser sysUser : users) {
                map.put(sysUser.getUserId(), sysUser.getUserName());
            }
        }
        return map;
    }

    public List<String> getCandidateUser(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        String appCode;
        String appId;
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        if (!useSecurityLevel) {
            securityLevel = null;
        }
        Integer version = null;
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
                version = Integer.valueOf(historicProcessInstance.getProcessDefinitionId().split(":")[1]);
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        String serviceName = null;
        String deploymentModel = this.getDeploymentModel();
        if (MICRO.equals(deploymentModel)) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        if (HussarUtils.isNotEmpty((Object)(appId = String.valueOf(this.modelService.getAppId(processKey)))) && !"null".equals(appId)) {
            processInfo.put("appId", appId);
        }
        if (HussarUtils.isNotEmpty((Object)(appCode = String.valueOf(this.modelService.getAppCode(processKey)))) && !"null".equals(appCode)) {
            processInfo.put("appCode", appCode);
        }
        String formId = this.modelService.getProcessFormId(processKey, version);
        processInfo.put("formId", formId);
        String tablePrefix = this.getTablePrefix();
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        condition = this.getRoleNotContainsCondition(condition);
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getCandidateUsers(condition, useSecurityLevel, securityLevel, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getCandidateUsers(condition, useSecurityLevel, securityLevel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> getCandidateUserWithParent(String condition, String processKey, Integer securityLevel, Map<String, String> processInfo) {
        String appId;
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        if (!useSecurityLevel) {
            securityLevel = null;
        }
        Integer version = null;
        if (!processInfo.containsKey("workflowStarterUserId") && processInfo.containsKey("workflowProcessInsId")) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInfo.get("workflowProcessInsId")).singleResult();
            if (historicProcessInstance != null) {
                processInfo.put("workflowStarterUserId", historicProcessInstance.getStartUserId());
                if (!processInfo.containsKey("workflowBusinessId")) {
                    processInfo.put("workflowBusinessId", historicProcessInstance.getBusinessKey());
                }
                version = Integer.valueOf(historicProcessInstance.getProcessDefinitionId().split(":")[1]);
            } else {
                processInfo.put("workflowStarterUserId", Authentication.getAuthenticatedUserId());
            }
        }
        String serviceName = null;
        String deploymentModel = this.getDeploymentModel();
        if (MICRO.equals(deploymentModel)) {
            serviceName = this.modelMapper.getServiceName(processKey);
        }
        if (HussarUtils.isNotEmpty((Object)(appId = String.valueOf(this.modelService.getAppId(processKey)))) && !"null".equals(appId)) {
            processInfo.put("appId", appId);
        }
        String formId = this.modelService.getProcessFormId(processKey, version);
        processInfo.put("formId", formId);
        String tablePrefix = this.getTablePrefix();
        condition = this.getFunctionCondition(condition, processInfo, serviceName);
        condition = this.getRoleNotContainsCondition(condition);
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getCandidateUsersWithParent(condition, useSecurityLevel, securityLevel, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getCandidateUsersWithParent(condition, useSecurityLevel, securityLevel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    private String getRoleNotContainsCondition(String realCondition) {
        if (realCondition.contains("R.GRANTED_ROLE NOT IN ")) {
            Matcher organMatcher = ROLE_NOT_CONTAINS_REGEX.matcher(realCondition);
            while (organMatcher.find()) {
                String organCondition = organMatcher.group();
                StringBuilder stringBuilder = new StringBuilder().append("O.ORGAN_ID NOT IN (SELECT USER_ID FROM HUSSAR_BPM_USER_ROLE_VIEW WHERE GRANTED_ROLE IN (").append(organCondition.substring(organCondition.indexOf("'"))).append(")");
                String replactCondition = stringBuilder.toString();
                realCondition = realCondition.replace(organCondition, replactCondition);
            }
        }
        return realCondition;
    }

    private String getFunctionCondition(String realCondition, Map<String, String> processInfo, String serviceName) {
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(44);
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSON.parse((String)message), processInfo, serviceName);
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && !userList.isEmpty()) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        return realCondition;
    }

    private List<String> functionUser(Map<String, Object> message, Map<String, String> processInfo, String serviceName) {
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        if (beanId == null) {
            return new ArrayList<String>();
        }
        Long appId = null;
        if (HussarUtils.isNotEmpty((Object)processInfo.get("appId")) && !"null".equals(processInfo.get("appId"))) {
            appId = Long.valueOf(processInfo.get("appId"));
        }
        String appCode = processInfo.get("appCode");
        Map map = (Map)message.get(beanId);
        map.putAll(processInfo);
        SysActFunction function = this.sysActFunctionService.getFunctionByBeanId(beanId);
        if (HussarUtils.isEmpty((Object)function)) {
            throw new BpmException(BpmExceptionCodeEnum.ERROR_NO_EXIST_FUNCTION);
        }
        String functionType = function.getFunctionType();
        String requestMethod = function.getRequestMethod();
        String deploymentModel = this.getDeploymentModel();
        if (HussarUtils.isEmpty((Object)functionType) || "local".equals(functionType)) {
            switch (deploymentModel) {
                case "single": {
                    AssigneeVisitor hussarBpmVariablesVisitor;
                    try {
                        hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean((Long)appId, (String)beanId, (String)appCode);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                    return hussarBpmVariablesVisitor.visit(map);
                }
                case "micro": {
                    try {
                        if (CHECK_DEFAULT_FUNCTION_LIST.contains(beanId)) {
                            serviceName = "hussar-web";
                        }
                        AssigneeFunctionService assigneeFunctionService = (AssigneeFunctionService)BpmSpringContextHolder.getBean(AssigneeFunctionService.class);
                        return assigneeFunctionService.executeListener(beanId, map, serviceName);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        return new ArrayList<String>();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        return new ArrayList<String>();
                    }
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
        }
        if ("remote".equals(functionType)) {
            String url = this.lcdpBpmProperties.getTenantCallAddress() + beanId;
            try {
                switch (requestMethod) {
                    case "GET": {
                        String response = HttpClient.doGet((String)url, (Map)map);
                        return JSON.parseArray((String)response, String.class);
                    }
                    case "POST": {
                        String response = HttpClient.doPost((String)url, (String)JSON.toJSONString((Object)map));
                        return JSON.parseArray((String)response, String.class);
                    }
                }
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_REQUEST_METHOD);
            }
            catch (Exception e) {
                String errorMsg = this.getErrorFunctionRequest(function.getFunctionName());
                throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCATION_REQUEST.getCode(), errorMsg);
            }
        }
        throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_TYPE);
    }

    private String getErrorFunctionRequest(String functionName) {
        String errorMsg = "\u8c03\u7528\u51fd\u6570" + functionName + "\u5931\u8d25";
        return errorMsg;
    }

    public String getSameLevelDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByUserId(userId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getSameLevelDeptIdByUserId(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getSameLevelDeptIdByOrganId(String organId) {
        if (HussarUtils.isEmpty((Object)organId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByOrganId(organId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getSameLevelDeptIdByOrganId(organId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserId(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getParentDeptIdByUserId(userId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getParentDeptIdByUserId(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getDeptIdByUserIds(userId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getSameLevelDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSameLevelDeptIdByUserIds(userId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getSameLevelDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getParentDeptIdByUserIds(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getParentDeptIdByUserIds(userId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getParentDeptIdByUserIds(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Integer getSecurityLevel(String userId, String url) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getSecurityLevel(userId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getSecurityLevel(userId, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public String getStarterDept(String userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptTreeByDeptName(organName, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryDeptTreeByDeptName(organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTreeByUserName(organName, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryUserTreeByUserName(organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryPostTreeByPostName(String postName) {
        if (HussarUtils.isEmpty((Object)postName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryPostTreeByPostName(postName, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryPostTreeByPostName(postName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserListByUserName(QueryAssigneeDto queryAssigneeDto) {
        String organName = queryAssigneeDto.getUserName();
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        Integer securityLevel = null;
        if (this.lcdpBpmProperties.isUseSecurityLevel() && HussarUtils.isNotEmpty((Object)queryAssigneeDto.getSecurityLevel())) {
            securityLevel = queryAssigneeDto.getSecurityLevel();
        }
        queryAssigneeDto.setSecurityLevel(securityLevel);
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserListByUserName(organName, securityLevel, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryUserListByUserName(organName, securityLevel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName) {
        if (HussarUtils.isEmpty((Object)roleName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryRoleTreeByRoleName(roleName, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryRoleTreeByRoleName(roleName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryUserTree(QueryAssigneeDto queryAssigneeDto) {
        String organName = queryAssigneeDto.getOrganName();
        Integer securityLevel = null;
        String processInstanceId = "";
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        if (useSecurityLevel) {
            if (HussarUtils.isNotEmpty((Object)queryAssigneeDto.getSecurityLevel())) {
                securityLevel = queryAssigneeDto.getSecurityLevel();
            } else {
                if (HussarUtils.isNotEmpty((Object)queryAssigneeDto.getProcessInstanceId())) {
                    processInstanceId = queryAssigneeDto.getProcessInstanceId();
                } else if (HussarUtils.isNotEmpty((Object)queryAssigneeDto.getTaskId())) {
                    HistoricTaskInstance hiTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(queryAssigneeDto.getTaskId())).queryChildTask()).singleResult();
                    processInstanceId = hiTask.getProcessInstanceId();
                }
                Object historicProcessInstance = null;
                CommandContext commandContext = Context.getCommandContext();
                historicProcessInstance = commandContext != null ? commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId) : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                if (historicProcessInstance != null) {
                    securityLevel = historicProcessInstance.getSecurityLevel();
                }
            }
        }
        queryAssigneeDto.setUseSecurityLevel(useSecurityLevel);
        queryAssigneeDto.setSecurityLevel(securityLevel);
        if (HussarUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTree(queryAssigneeDto, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryUserTree(queryAssigneeDto, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryUserTreeByPage(Page<BpmTreeModel> pages, String organName) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserTreeByPage(pages, organName, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryUserTreeByPage(pages, organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, NodeAssigneeQueryDto bpmAssigneeDto) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        Integer securityLevel = null;
        String processInstanceId = "";
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        if (useSecurityLevel) {
            if (HussarUtils.isNotEmpty((Object)bpmAssigneeDto.getSecurityLevel())) {
                securityLevel = bpmAssigneeDto.getSecurityLevel();
            } else {
                if (HussarUtils.isNotEmpty((Object)bpmAssigneeDto.getProcessInstanceId())) {
                    processInstanceId = bpmAssigneeDto.getProcessInstanceId();
                } else if (HussarUtils.isNotEmpty((Object)bpmAssigneeDto.getTaskId())) {
                    HistoricTaskInstance hiTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(bpmAssigneeDto.getTaskId())).queryChildTask()).singleResult();
                    processInstanceId = hiTask.getProcessInstanceId();
                }
                String historicProcessInstance = null;
                CommandContext commandContext = Context.getCommandContext();
                historicProcessInstance = commandContext != null ? commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstance(processInstanceId) : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
                if (historicProcessInstance != null) {
                    securityLevel = historicProcessInstance.getSecurityLevel();
                }
            }
        }
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryUserListByPage(pages, bpmAssigneeDto.getId(), bpmAssigneeDto.getType(), tablePrefix, useSecurityLevel, securityLevel);
                }
            }
            return this.assigneeModeChooseService.queryUserListByPage(pages, bpmAssigneeDto.getId(), bpmAssigneeDto.getType(), tablePrefix, useSecurityLevel, securityLevel);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryDeptTreeByChildren(bpmTreeModel, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryDeptTreeByChildren(bpmTreeModel, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryAssigneeAndDept(users, organName, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryAssigneeAndDept(users, organName, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        HashMap assigneeVariable = new HashMap();
        if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getAssigneeVariable())) {
            assigneeVariable = (HashMap)JSON.parseObject((String)nodeAssigneeQueryDto.getAssigneeVariable(), HashMap.class);
        }
        Integer securityLevel = null;
        if (HussarUtils.isNotEmpty(assigneeVariable.get("security_level"))) {
            securityLevel = Integer.parseInt(String.valueOf(assigneeVariable.get("security_level")));
        }
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListByPage(pages, users, organId, type, tablePrefix, securityLevel);
                }
            }
            return this.assigneeModeChooseService.queryNodeAssigneeListByPage(pages, users, organId, type, tablePrefix, securityLevel);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> users, NodeAssigneeQueryDto nodeAssigneeQueryDto, Integer securityLevel) {
        String organId = nodeAssigneeQueryDto.getId();
        String type = nodeAssigneeQueryDto.getType();
        String organName = nodeAssigneeQueryDto.getOrganName();
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type, organName, tablePrefix, useSecurityLevel, securityLevel);
                }
            }
            return this.assigneeModeChooseService.queryNodeAssigneeListWithParentByPage(pages, users, organId, type, organName, tablePrefix, useSecurityLevel, securityLevel);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public IPage<BpmTreeModel> queryNodeAssigneeListWithPage(Page<BpmTreeModel> pages, List<String> users, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        String organId = nodeAssigneeQueryDto.getId();
        String organName = nodeAssigneeQueryDto.getOrganName();
        String type = nodeAssigneeQueryDto.getType();
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        Map assigneeVariable = new HashMap();
        if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getAssigneeVariable())) {
            assigneeVariable = (Map)JSON.parseObject((String)nodeAssigneeQueryDto.getAssigneeVariable(), HashMap.class);
        }
        Integer securityLevel = null;
        boolean useSecurityLevel = this.lcdpBpmProperties.isUseSecurityLevel();
        if (useSecurityLevel) {
            if (HussarUtils.isNotEmpty(assigneeVariable.get("security_level"))) {
                securityLevel = Integer.parseInt(String.valueOf(assigneeVariable.get("security_level")));
            }
            if (HussarUtils.isEmpty(securityLevel) && HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getAssigneeVariableMap()) && HussarUtils.isNotEmpty(nodeAssigneeQueryDto.getAssigneeVariableMap().get("securityLevel"))) {
                securityLevel = Integer.parseInt(String.valueOf(nodeAssigneeQueryDto.getAssigneeVariableMap().get("securityLevel")));
            }
        }
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryNodeAssigneeListWithPage(pages, users, organId, organName, type, tablePrefix, useSecurityLevel, securityLevel);
                }
            }
            return this.assigneeModeChooseService.queryNodeAssigneeListWithPage(pages, users, organId, organName, type, tablePrefix, useSecurityLevel, securityLevel);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserAndAccountListByUserId(userIds, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getUserAndAccountListByUserId(userIds, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return new ArrayList<BpmUserInfoVo>();
        }
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserMsgByUserIds(userIds, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getUserMsgByUserIds(userIds, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.queryList(page, getListDto, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.queryList(page, getListDto, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<AssigneeManageInfoVo> queryDept(String name) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        switch (deploymentModel) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryDept(name, tablePrefix);
            }
        }
        return this.assigneeModeChooseService.queryDept(name, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryRole(String name) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        switch (deploymentModel) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryRole(name, tablePrefix);
            }
        }
        return this.assigneeModeChooseService.queryRole(name, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryPost(String name) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        switch (deploymentModel) {
            case "workflow-platform": {
                return this.assigneeModeChooseService.queryPost(name, tablePrefix);
            }
        }
        return this.assigneeModeChooseService.queryPost(name, tablePrefix);
    }

    public String queryPlatformModel() {
        String deploymentModel = this.getDeploymentModel();
        if (WORKFLOW_PLATFORM.equals(deploymentModel)) {
            return this.lcdpBpmProperties.getAssigneeMode();
        }
        return deploymentModel;
    }

    public List<String> getAllParentOrganId(String userId, String organId) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        BpmTreeModel bpmTreeModel = new BpmTreeModel();
        bpmTreeModel.setId(userId);
        bpmTreeModel.setParentId(organId);
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getAllParentOrganId(userId, organId, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.getAllParentOrganId(userId, organId, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<UserSecurityVo> getUserSecurity(List<String> userIds, Integer securityLevel) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.getUserSecurity(userIds, securityLevel, tablePrefix);
                }
                case "micro": {
                    AssigneeChooseService assigneeChooseService = (AssigneeChooseService)BpmSpringContextHolder.getBean(AssigneeChooseService.class);
                    AssigneeQueryModel assigneeQueryModel = new AssigneeQueryModel();
                    assigneeQueryModel.setTablePrefix(tablePrefix);
                    assigneeQueryModel.setUsers(userIds);
                    assigneeQueryModel.setSecurityLevel(securityLevel);
                    return assigneeChooseService.getUserSecurity(assigneeQueryModel);
                }
            }
            return this.assigneeModeChooseService.getUserSecurity(userIds, securityLevel, tablePrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    public List<BpmTreeModel> userTreeBySecurity(String id, boolean isMainPost, Integer security) {
        String deploymentModel = this.getDeploymentModel();
        String tablePrefix = this.getTablePrefix();
        try {
            switch (deploymentModel) {
                case "workflow-platform": {
                    return this.assigneeModeChooseService.userTreeBySecurity(id, isMainPost, security, tablePrefix);
                }
            }
            return this.assigneeModeChooseService.userTreeBySecurity(id, isMainPost, security, tablePrefix);
        }
        catch (Exception e) {
            logger.error(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.ERROR_GET_ASSIGNEEE);
        }
    }

    static {
        CHECK_DEFAULT_FUNCTION_LIST.add("suprDeptHeadOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("suprDeptBranchLeadersOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("suprDeptLeadersOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("deptHeadOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("branchLeadersOfStarter");
        CHECK_DEFAULT_FUNCTION_LIST.add("deptLeadersOfStarter");
    }
}

