/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.EventConfiguration;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowPageMsg;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.Map;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.Start")
public class StartVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, FlowElementsContainer process, FlowModel flowModel, FlowObject processModel) {
        EventConfiguration eventConfiguration;
        String eventSign;
        StartEvent startEvent = new StartEvent();
        startEvent.setId(flowObject.getId());
        startEvent.setName(flowObject.getProps().getFlowName());
        startEvent.setDocumentation(flowObject.getProps().getFlowDescription());
        Map jsonObject = flowObject.getProps().getFormAddress();
        if (jsonObject != null) {
            JSONObject object = new JSONObject();
            object.put("web", (Object)((FlowPageMsg)jsonObject.get("web")).getUrl());
            object.put("mobile", (Object)((FlowPageMsg)jsonObject.get("mobile")).getUrl());
            startEvent.setFormKey(JSON.toJSONString((Object)object));
        }
        if (HussarUtils.isNotEmpty((Object)(eventSign = flowObject.getProps().getEventSign()))) {
            startEvent.addExtensionElement(FormBpmnUtil.addExtensionElement("eventSign", eventSign));
            SignalEventDefinition signalEventDefinition = new SignalEventDefinition();
            signalEventDefinition.setSignalRef(eventSign);
            signalEventDefinition.setAsync(true);
            ArrayList<SignalEventDefinition> list = new ArrayList<SignalEventDefinition>();
            list.add(signalEventDefinition);
            startEvent.setEventDefinitions(list);
        }
        if (HussarUtils.isNotEmpty((Object)(eventConfiguration = flowObject.getProps().getEventConfiguration()))) {
            startEvent.addExtensionElement(FormBpmnUtil.addExtensionElement("implementation", eventConfiguration.getImplementation()));
            startEvent.addExtensionElement(FormBpmnUtil.addExtensionElement("callMethod", eventConfiguration.getCallMethod()));
        }
        FormBpmnUtil.commonExtendHandle(flowObject, (FlowElement)startEvent);
        process.addFlowElement((FlowElement)startEvent);
    }
}

