/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.IntermediateCatchEvent")
public class IntermediateCatchEventVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, FlowElementsContainer process, FlowModel flowModel, FlowObject processModel) {
        IntermediateCatchEvent intermediateCatchEvent = new IntermediateCatchEvent();
        FlowProps flowProps = flowObject.getProps();
        intermediateCatchEvent.setName(flowProps.getFlowName());
        intermediateCatchEvent.setId(flowObject.getId());
        intermediateCatchEvent.setDocumentation(flowProps.getFlowDescription());
        String eventSign = flowObject.getProps().getEventSign();
        if (HussarUtils.isNotEmpty((Object)eventSign)) {
            SignalEventDefinition signalEventDefinition = new SignalEventDefinition();
            signalEventDefinition.setSignalRef(eventSign);
            signalEventDefinition.setAsync(true);
            ArrayList<SignalEventDefinition> list = new ArrayList<SignalEventDefinition>();
            list.add(signalEventDefinition);
            intermediateCatchEvent.setEventDefinitions(list);
        }
        FormBpmnUtil.addTimeOut(intermediateCatchEvent, flowObject);
        FormBpmnUtil.addExecutionListener((FlowNode)intermediateCatchEvent, flowObject);
        String eventSkip = flowObject.getProps().getEventSkip();
        intermediateCatchEvent.addExtensionElement(FormBpmnUtil.addExtensionElement("eventSkip", eventSkip));
        FormBpmnUtil.commonExtendHandle(flowObject, (FlowElement)intermediateCatchEvent);
        process.addFlowElement((FlowElement)intermediateCatchEvent);
    }
}

