/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowProps;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util.FormBpmnUtil;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.workflow.BoundaryEvent")
public class BoundaryEventVisitor
implements FormObjectVisitor {
    @Override
    public void visit(FlowObject flowObject, FlowElementsContainer process, FlowModel flowModel, FlowObject processModel) {
        BoundaryEvent boundaryEvent = new BoundaryEvent();
        FlowProps flowProps = flowObject.getProps();
        boundaryEvent.setName(flowProps.getFlowName());
        boundaryEvent.setId(flowObject.getId());
        boundaryEvent.setDocumentation(flowProps.getFlowDescription());
        boundaryEvent.setCancelActivity(flowProps.isCancelActivity());
        boundaryEvent.setAttachedToRefId(flowProps.getAttachedToRefId());
        Collection flowElements = process.getFlowElements();
        Optional<FlowElement> flowElementOptional = flowElements.stream().filter(flowElement -> flowProps.getAttachedToRefId().equals(flowElement.getId())).findFirst();
        if (HussarUtils.isNotEmpty(flowElementOptional)) {
            Activity activity = (Activity)flowElementOptional.get();
            boundaryEvent.setAttachedToRef(activity);
        }
        String eventSign = flowProps.getEventSign();
        ArrayList<SignalEventDefinition> list = new ArrayList<SignalEventDefinition>();
        if (HussarUtils.isNotEmpty((Object)eventSign)) {
            List<String> signList = Arrays.asList(eventSign.split(","));
            for (String sign : signList) {
                SignalEventDefinition signalEventDefinition = new SignalEventDefinition();
                signalEventDefinition.setSignalRef(sign);
                signalEventDefinition.setAsync(true);
                list.add(signalEventDefinition);
            }
        }
        boundaryEvent.setEventDefinitions(list);
        FormBpmnUtil.commonExtendHandle(flowObject, (FlowElement)boundaryEvent);
        process.addFlowElement((FlowElement)boundaryEvent);
    }
}

