/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.wfdtoprocess.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.flowmodel.enums.BpmNodeTypeEnum;
import com.jxdinfo.hussar.workflow.engine.wfdtoprocess.visitor.FormObjectVisitor;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.HashMap;
import java.util.Map;

public final class FormObjectVisitorBeanUtil {
    private static final Map<String, String> FORM_OBJECT_VISITOR_MAP = new HashMap<String, String>();

    private FormObjectVisitorBeanUtil() {
    }

    public static FormObjectVisitor getVisitorBean(String classType) throws BpmException {
        String realClassType = FORM_OBJECT_VISITOR_MAP.get(classType);
        if (realClassType != null) {
            classType = realClassType;
        }
        if (HussarUtils.isEmpty((Object)classType)) {
            throw new BpmException(BpmExceptionCodeEnum.NULL_CLASS_FUND.format(new Object[]{classType}));
        }
        Object fromObj = BpmSpringContextHolder.getBean((String)classType);
        return (FormObjectVisitor)fromObj;
    }

    static {
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getVisitType(), BpmNodeTypeEnum.BPM_CALL_ACTIVITY.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_END.getVisitType(), BpmNodeTypeEnum.BPM_END.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_EXCLUSIVE_GATEWAY.getVisitType(), BpmNodeTypeEnum.BPM_EXCLUSIVE_GATEWAY.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getVisitType(), BpmNodeTypeEnum.BPM_INCLUSIVE_GATEWAY.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getVisitType(), BpmNodeTypeEnum.BPM_PARALLEL_GATEWAY.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_RECEIVE_TASK.getVisitType(), BpmNodeTypeEnum.BPM_RECEIVE_TASK.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_SERVICE_TASK.getVisitType(), BpmNodeTypeEnum.BPM_SERVICE_TASK.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_START.getVisitType(), BpmNodeTypeEnum.BPM_START.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_SUB_PROCESS.getVisitType(), BpmNodeTypeEnum.BPM_SUB_PROCESS.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_USER.getVisitType(), BpmNodeTypeEnum.BPM_USER.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_INTERMEDIATE_CATCH_EVENT.getVisitType(), BpmNodeTypeEnum.BPM_INTERMEDIATE_CATCH_EVENT.getType());
        FORM_OBJECT_VISITOR_MAP.put(BpmNodeTypeEnum.BPM_BOUNDARY_EVENT.getVisitType(), BpmNodeTypeEnum.BPM_BOUNDARY_EVENT.getType());
    }
}

