/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.datapush.service;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ProcessNode;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.ProcessDataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushListener;
import com.jxdinfo.hussar.workflow.util.ActivitiTranslateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class DataPushService {
    private static final Logger logger = LoggerFactory.getLogger(DataPushService.class);
    @Lazy
    @Resource
    private HistoryService historyService;
    private final List<DataPushListener> dataPushListeners;
    private final LcdpBpmProperties lcdpBpmProperties;

    public DataPushService(List<DataPushListener> dataPushListeners, LcdpBpmProperties lcdpBpmProperties) {
        this.dataPushListeners = dataPushListeners;
        this.lcdpBpmProperties = lcdpBpmProperties;
    }

    public boolean isDataPush(String processDefinitionId) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        if (processDefinitionId != null) {
            processDefinitionIdList.add(processDefinitionId);
        }
        return this.isDataPush(processDefinitionIdList);
    }

    public boolean isDataPush(Set<String> processDefinitionIdList) {
        if (Context.getCommandContext() != null && Context.getCommandContext().getAttribute("no_data_push_handle_flag") != null) {
            return false;
        }
        return this.lcdpBpmProperties.isUseDatapush() || this.dataPushListeners.size() > 3 || CommonCodeUtil.isBindTable(processDefinitionIdList) || CommonCodeUtil.isBackfill(processDefinitionIdList);
    }

    public boolean isExtendDataPush() {
        return this.dataPushListeners.size() > 3;
    }

    public void addDataPush(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.addTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void completeDataPush(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.completeTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteDataPush(DataPush dataPush) {
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.deleteTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void entrustDataPush(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.entrustTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void transferDataPush(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.transferUserTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void rejectDataPush(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.rejectTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void revokeDataPush(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.revokeTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void freeJumpDataPush(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.freeJumpTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void claimDataPush(DataPush dataPush) {
    }

    public void addUserDataPush(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.addUser(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteMultiTask(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.deleteMultiTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addCcTask(DataPush dataPush) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.translateProcessAndTaskName(dataPush);
        try {
            dataPush.setStartDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getStartDate())));
            if (dataPush.getEndDate() != null) {
                dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.addCcTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addCcTask(List<DataPush> dataPushList) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(dataPushList, DataPush.class).translate(DataPush::getProcessNameTranslateKey, DataPush::setProcessName).translate(DataPush::getTaskDefinitionNameTranslateKey, DataPush::setTaskDefinitionName).isDefaultLang().execute();
        try {
            for (DataPush dataPush : dataPushList) {
                dataPush.setStartDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getStartDate())));
                if (dataPush.getEndDate() == null) continue;
                dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.addCcTask(dataPushList);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void readCcTask(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dataPush.setEndDate(simpleDateFormat.parse(simpleDateFormat.format(dataPush.getEndDate())));
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.readCcTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteCcTask(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.deleteCcTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addUrgeTask(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.addUrgeTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void endProcess(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.endProcess(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void transferTask(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.transferTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void reTransferTask(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.reTransferTask(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void completeDataPush(Task task, String comment, String userId, String mandator, String taskState, String taskType) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = this.dataPush(task, comment, userId).setConsignor(mandator).setTaskState(taskState).setTaskType(taskType);
            this.completeDataPush(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, String userId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
        dataPush.setUserId(userId);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        dataPush.setSendUser(task.getSendUser());
        dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription(task.getTodoConfiguration());
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        dataPush.setProcessNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)task.getProcessDefinitionId(), (String)task.getTaskDefinitionKey()));
        if (HussarUtils.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        return dataPush;
    }

    public void entrustDataPush(Task task, String userId, String consignee, List<Map<String, String>> userMapList) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setStartOrganId(historicProcessInstance.getOrganId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription(task.getTodoConfiguration());
            dataPush.setSendUser(task.getSendUser());
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessNameTranslateKey(ActivitiTranslateUtil.getTranslateKey((String)task.getProcessDefinitionId(), (String)task.getTaskDefinitionKey()));
            dataPush.setProcessInsId(task.getProcessInstanceId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setTaskType(task.getTaskType());
            dataPush.setUserMapList(userMapList);
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
            this.entrustDataPush(dataPush);
        }
    }

    public void entrustDataPush(Task task, String userId, String consignee, List<Map<String, String>> userMapList, String owner) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setStartOrganId(historicProcessInstance.getOrganId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription(task.getTodoConfiguration());
            dataPush.setSendUser(task.getSendUser());
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            dataPush.setProcessStartTime(historicProcessInstance.getStartTime());
            dataPush.setTaskType(task.getTaskType());
            dataPush.setUserMapList(userMapList);
            dataPush.setOwner(owner);
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
            this.entrustDataPush(dataPush);
        }
    }

    public void transferDataPush(Task task, String userId, String consignee, String transferor, List<Map<String, String>> userMapList) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
            dataPush.setUserId(consignee);
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription(task.getTodoConfiguration());
            dataPush.setSendUser(task.getSendUser());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            dataPush.setUserMapList(userMapList);
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(new Date());
            }
            dataPush.setTransferor(transferor);
            this.transferDataPush(dataPush);
        }
    }

    public void addUserDataPush(Task task, String userId) {
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        processDefinitionIdList.add(task.getProcessDefinitionId());
        if (this.isDataPush(processDefinitionIdList)) {
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setTaskDefinitionNameTranslateKey(task.getNameTranslateKey());
            dataPush.setUserId(userId);
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setSendUser(task.getSendUser());
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setEndDate(new Date());
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription(task.getTodoConfiguration());
            dataPush.setProcessInsId(task.getProcessInstanceId());
            this.addUserDataPush(dataPush);
        }
    }

    public void changeProcessStateDataPush(DataPush dataPush) {
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.changeProcessState(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addStartProcess(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.addStartProcess(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateStartProcess(DataPush dataPush) {
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.updateStartProcess(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteStartProcess(DataPush dataPush) {
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.deleteStartProcess(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateBusinessInfo(DataPush dataPush) {
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.updateBusinessInfo(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void changeProcessNode(DataPush dataPush) {
        this.translateProcessAndTaskName(dataPush);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.changeProcessNode(dataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void processChange(ProcessDataPush processDataPush) {
        this.translateProcessAndTaskNameWithProcessDataPush(processDataPush);
        HashSet<String> processDefinitionIdList = new HashSet<String>();
        if (HussarUtils.isNotEmpty((Object)processDataPush.getDataPush().getProcessDefinitionId())) {
            processDefinitionIdList.add(processDataPush.getDataPush().getProcessDefinitionId());
        }
        if (HussarUtils.isNotEmpty((Object)processDataPush.getDataPush().getProcessDefinitionIdList())) {
            processDefinitionIdList.addAll(processDataPush.getDataPush().getProcessDefinitionIdList());
        }
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                if (!HussarUtils.isNotEmpty(processDefinitionIdList) || !this.isDataPush(processDefinitionIdList)) continue;
                dataPushListener.processChange(processDataPush);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void processChangeList(List<ProcessDataPush> processDataPushList) {
        this.translateProcessAndTaskNameWithProcessDataPushList(processDataPushList);
        for (DataPushListener dataPushListener : this.dataPushListeners) {
            try {
                dataPushListener.processChangeList(processDataPushList);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void translateProcessAndTaskName(DataPush dataPush) {
        ArrayList<DataPush> tempDataPushList = new ArrayList<DataPush>();
        tempDataPushList.add(dataPush);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(tempDataPushList, DataPush.class).translate(DataPush::getProcessNameTranslateKey, DataPush::setProcessName).translate(DataPush::getTaskDefinitionNameTranslateKey, DataPush::setTaskDefinitionName).translateList(o -> {
            if (HussarUtils.isNotEmpty((Object)o.getProcessNodeList())) {
                ArrayList<String> nodeNameTranslateKeyList = new ArrayList<String>();
                for (ProcessNode processNode : o.getProcessNodeList()) {
                    nodeNameTranslateKeyList.add(processNode.getTaskDefinitionNameTranslateKey());
                }
                return nodeNameTranslateKeyList;
            }
            return null;
        }, (o, e) -> {
            if (HussarUtils.isNotEmpty((Object)o.getProcessNodeList())) {
                for (ProcessNode processNode : o.getProcessNodeList()) {
                    processNode.setTaskDefinitionName((String)e.get(processNode.getTaskDefinitionNameTranslateKey()));
                }
            }
        }).isDefaultLang().execute();
        dataPush = (DataPush)tempDataPushList.get(0);
    }

    private void translateProcessAndTaskNameWithProcessDataPush(ProcessDataPush dataPush) {
        ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
        dataPushList.add(dataPush.getDataPush());
        dataPushList.addAll(dataPush.getTaskDataPush());
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(dataPushList, DataPush.class).translate(DataPush::getTaskDefinitionNameTranslateKey, DataPush::setTaskDefinitionName).translate(DataPush::getProcessNameTranslateKey, DataPush::setProcessName).translateList(o -> {
            if (HussarUtils.isNotEmpty((Object)o.getProcessNodeList())) {
                ArrayList<String> nodeNameTranslateKeyList = new ArrayList<String>();
                for (ProcessNode processNode : o.getProcessNodeList()) {
                    nodeNameTranslateKeyList.add(processNode.getTaskDefinitionNameTranslateKey());
                }
                return nodeNameTranslateKeyList;
            }
            return null;
        }, (o, e) -> {
            for (ProcessNode processNode : o.getProcessNodeList()) {
                processNode.setTaskDefinitionName((String)e.get(processNode.getTaskDefinitionNameTranslateKey()));
            }
        }).isDefaultLang().execute();
        dataPush.setDataPush((DataPush)dataPushList.get(0));
        dataPushList.remove(0);
        dataPush.setTaskDataPush(dataPushList);
    }

    private void translateProcessAndTaskNameWithProcessDataPushList(List<ProcessDataPush> processDataPushList) {
        for (ProcessDataPush dataPush : processDataPushList) {
            ArrayList<DataPush> dataPushList = new ArrayList<DataPush>();
            dataPushList.add(dataPush.getDataPush());
            dataPushList.addAll(dataPush.getTaskDataPush());
            BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(dataPushList, DataPush.class).translate(DataPush::getTaskDefinitionNameTranslateKey, DataPush::setTaskDefinitionName).translate(DataPush::getProcessNameTranslateKey, DataPush::setProcessName).translateList(o -> {
                if (HussarUtils.isNotEmpty((Object)o.getProcessNodeList())) {
                    ArrayList<String> nodeNameTranslateKeyList = new ArrayList<String>();
                    for (ProcessNode processNode : o.getProcessNodeList()) {
                        nodeNameTranslateKeyList.add(processNode.getTaskDefinitionNameTranslateKey());
                    }
                    return nodeNameTranslateKeyList;
                }
                return null;
            }, (o, e) -> {
                for (ProcessNode processNode : o.getProcessNodeList()) {
                    processNode.setTaskDefinitionName((String)e.get(processNode.getTaskDefinitionNameTranslateKey()));
                }
            }).isDefaultLang().execute();
            dataPush.setDataPush((DataPush)dataPushList.get(0));
            dataPushList.remove(0);
            dataPush.setTaskDataPush(dataPushList);
        }
    }
}

