/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.properties.HussarCacheProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.dao.ActivityRedisTimerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.util.TimeOutSetListUtil;
import com.jxdinfo.hussar.workflow.engine.core.util.BpmTenantInfoUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class TimeOutHandleUtil {
    private static Logger logger = LogManager.getLogger(TimeOutHandleUtil.class);
    public static final String BPM_ACTIVITY_TIMER_SCORE_LIST = "bpm_activity:timer:score_list";
    public static final String BPM_ACTIVITY_TIMER_TASK_MESSAGE = "bpm_activity:timer:task_Message:";
    public static final String BPM_TIMER_ACTIVITY = "bpm_timer_activity";
    public static final String PROCESS_TIMEOUT_MODEL_PREFIX = "global-";
    public static final String TASK_WARNING_PREFIX = "warning-";
    @Autowired
    private BpmTenantInfoUtils bpmTenantInfoUtils;
    @Resource
    private ActivityRedisTimerMapper activityRedisTimerMapper;
    @Autowired
    private TimeOutSetListUtil timeOutSetListUtil;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    protected static boolean getList = true;
    protected static List<Long> timeOutList = new ArrayList<Long>();
    protected static Map<Long, String> timeOutMap = new HashMap<Long, String>();
    protected static List<Long> getListTimeAddModel = new ArrayList<Long>();
    protected static List<String> getListTimeDelModel = new ArrayList<String>();
    protected static boolean useRedis;
    @Resource
    private HussarCacheProperties hussarCacheProperties;

    public void init() {
        useRedis = "redis".equals(this.hussarCacheProperties.getCacheType());
    }

    private void selectTimeOutModels() {
        if (useRedis) {
            try {
                List timeOutModels = this.activityRedisTimerMapper.selectList(null);
                for (TimeOutModel timeOutModel : timeOutModels) {
                    timeOutModel.setDataSourceName("master");
                    String id = String.valueOf(timeOutModel.getTaskId());
                    if ("1".equals(timeOutModel.getMessageType())) {
                        id = PROCESS_TIMEOUT_MODEL_PREFIX + id;
                    } else if ("2".equals(timeOutModel.getMessageType()) || "4".equals(timeOutModel.getMessageType())) {
                        id = TASK_WARNING_PREFIX + id;
                    }
                    this.redisTemplate.opsForValue().set((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + id), (Object)JSON.toJSONString((Object)timeOutModel));
                    Set oldTask = this.redisTemplate.opsForZSet().rangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (double)timeOutModel.getDueTime().getTime(), (double)timeOutModel.getDueTime().getTime());
                    if (HussarUtils.isEmpty((Object)oldTask)) {
                        this.redisTemplate.opsForZSet().add((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (Object)id, (double)timeOutModel.getDueTime().getTime());
                        continue;
                    }
                    this.redisTemplate.opsForZSet().add((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, (Object)((String)new ArrayList(oldTask).get(0) + "," + id), (double)timeOutModel.getDueTime().getTime());
                }
                this.activityRedisTimerMapper.delete(null);
            }
            catch (Exception e) {
                logger.error("redis\u50a8\u5b58\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        List timeOutModels = this.activityRedisTimerMapper.selectList(null);
        for (TimeOutModel timeOutModel : timeOutModels) {
            timeOutModel.setDataSourceName("master");
            String id = String.valueOf(timeOutModel.getTaskId());
            if ("1".equals(timeOutModel.getMessageType())) {
                id = PROCESS_TIMEOUT_MODEL_PREFIX + id;
            } else if ("2".equals(timeOutModel.getMessageType()) || "4".equals(timeOutModel.getMessageType())) {
                id = TASK_WARNING_PREFIX + id;
            }
            HussarCacheUtil.put((String)BPM_TIMER_ACTIVITY, (Object)id, (Object)timeOutModel);
            Long time = timeOutModel.getDueTime().getTime();
            timeOutList.add(time);
            timeOutMap.put(time, timeOutMap.get(time) == null ? id : timeOutMap.get(time) + "," + id);
        }
    }

    private void getList() {
        try {
            if (this.bpmTenantInfoUtils.isMultiTenant()) {
                List keyList;
                if (!"workflow-platform".equals(this.lcdpBpmProperties.getDeploymentModel())) {
                    this.selectTimeOutModels();
                }
                if ((keyList = HussarCacheUtil.getKeysLike((String)"tenant_info", (String)"?")) != null) {
                    for (String key : keyList) {
                        HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)HussarCacheUtil.get((String)"tenant_info", (Object)key);
                        if (!"1".equals(hussarTenantDefinition.getTenantStatus())) continue;
                        this.timeOutSetListUtil.setList(hussarTenantDefinition.getConnName(), hussarTenantDefinition.getTenantCode());
                    }
                }
            } else {
                this.selectTimeOutModels();
            }
            if (useRedis) {
                getList = false;
                return;
            }
            if (!getListTimeDelModel.isEmpty()) {
                HussarCacheUtil.evict((String)BPM_TIMER_ACTIVITY, getListTimeDelModel);
            }
            TimeOutHandleUtil.orderTime();
        }
        catch (Exception e) {
            logger.error("\u8d85\u65f6\u5904\u7406\u4fe1\u606f\u7f13\u5b58\u540c\u6b65\u5931\u8d25{}", (Object)e.getMessage());
        }
        getList = false;
    }

    public static void orderTime() {
        timeOutList.sort(Comparator.naturalOrder());
        while (!getListTimeAddModel.isEmpty()) {
            int index = 0;
            for (int i = 0; i < timeOutList.size() && timeOutList.get(i) < getListTimeAddModel.get(0); ++i) {
                index = i + 1;
            }
            timeOutList.add(index, getListTimeAddModel.get(0));
            getListTimeAddModel.remove(0);
        }
    }

    public void handleAllTimeOutTask(long time) {
        if (getList) {
            this.getList();
        }
        if (useRedis) {
            try {
                Set tasksList = this.redisTemplate.opsForZSet().rangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, 0.0, (double)time);
                if (HussarUtils.isNotEmpty((Object)tasksList)) {
                    for (String tasks : tasksList) {
                        for (String str : tasks.split(",")) {
                            Object model = this.redisTemplate.opsForValue().get((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + str));
                            if (HussarUtils.isNotEmpty((Object)model)) {
                                TimeOutModel timeOutModel = (TimeOutModel)JSON.parseObject((String)((String)model), TimeOutModel.class);
                                this.timeOutSetListUtil.timeOutTaskHandler(timeOutModel, false, timeOutModel.getDataSourceName());
                            }
                            this.redisTemplate.delete((Object)(BPM_ACTIVITY_TIMER_TASK_MESSAGE + str));
                        }
                    }
                    this.redisTemplate.opsForZSet().removeRangeByScore((Object)BPM_ACTIVITY_TIMER_SCORE_LIST, 0.0, (double)time);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("redis\u83b7\u53d6\u8d85\u65f6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25{}", (Object)e.toString());
            }
            return;
        }
        while (!timeOutList.isEmpty() && time > timeOutList.get(0)) {
            String[] keys;
            if (timeOutMap.get(timeOutList.get(0)) == null) {
                timeOutList.remove(0);
                continue;
            }
            for (String key : keys = timeOutMap.get(timeOutList.get(0)).split(",")) {
                TimeOutModel timeOutModel = (TimeOutModel)HussarCacheUtil.get((String)BPM_TIMER_ACTIVITY, (Object)key);
                if (timeOutModel == null) continue;
                this.timeOutSetListUtil.timeOutTaskHandler(timeOutModel, true, timeOutModel.getDataSourceName());
                HussarCacheUtil.evict((String)BPM_TIMER_ACTIVITY, (Object)key);
            }
            timeOutMap.remove(timeOutList.get(0));
            timeOutList.remove(0);
        }
    }

    public static List<Long> getTimeOutList() {
        return timeOutList;
    }

    public static Map<Long, String> getTimeOutMap() {
        return timeOutMap;
    }

    public static List<Long> getGetListTimeAddModel() {
        return getListTimeAddModel;
    }

    public static List<String> getGetListTimeDelModel() {
        return getListTimeDelModel;
    }

    public static boolean isGetList() {
        return getList;
    }

    public static boolean isUseRedis() {
        return useRedis;
    }

    public static class TimeOutModelMessageType {
        public static final String TASK_TIMEOUT_MODEL = "0";
        public static final String PROCESS_TIMEOUT_MODEL = "1";
        public static final String TASK_WARNING_MODEL = "2";
        public static final String EVENT_TIMEOUT_MODEL = "3";
        public static final String EVENT_WARNING_MODEL = "4";
    }
}

