/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.constant.BpmAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class TimeOutConfig {
    private String chosenDay;
    private String timeOutStrategy;
    private String timeOutChannalType;
    private String warningDate;
    private String warningDateType;
    private String warningChannalType;

    public static TimeOutConfig build(FlowElement element) {
        TimeOutConfig overTimeConfig = new TimeOutConfig();
        overTimeConfig.setChosenDay(TimeOutConfig.getConfig(element, "chosenDay"));
        overTimeConfig.setTimeOutStrategy(TimeOutConfig.getConfig(element, "TimeOutStrategy"));
        overTimeConfig.setTimeOutChannalType(TimeOutConfig.getConfig(element, "timeOutChannalType"));
        overTimeConfig.setWarningDate(TimeOutConfig.getConfig(element, "warningDate"));
        overTimeConfig.setWarningDateType(TimeOutConfig.getConfig(element, "warningDateType"));
        overTimeConfig.setWarningChannalType(TimeOutConfig.getConfig(element, "warningChannalType"));
        return overTimeConfig;
    }

    public List<TimeOutModel> buildTimeOutModel(TaskEntity task, Collection<String> users, Long appId) {
        StringJoiner stringJoiner;
        TimeOutModel timeOutModel;
        ArrayList<TimeOutModel> list = new ArrayList<TimeOutModel>();
        if (HussarUtils.isNotEmpty((Object)task.getDueDate()) && (HussarUtils.isNotEmpty((Object)this.timeOutStrategy) || HussarUtils.isNotEmpty((Object)this.timeOutChannalType))) {
            timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            timeOutModel.setTimeOutChanalType(this.timeOutChannalType);
            if (HussarUtils.isNotEmpty(users)) {
                stringJoiner = new StringJoiner(",");
                for (String user : users) {
                    stringJoiner.add(user);
                }
                timeOutModel.setAssignee(stringJoiner.toString());
            }
            timeOutModel.setTimeOutType(this.timeOutStrategy == null ? "unHandle" : this.timeOutStrategy);
            timeOutModel.setMessageType("0");
            timeOutModel.setMap(JSON.toJSONString(this.getExtendParam(task, appId)));
            list.add(timeOutModel);
        }
        if (HussarUtils.isNotEmpty((Object)task.getWarningDate()) && HussarUtils.isNotEmpty((Object)this.warningDate) && HussarUtils.isNotEmpty((Object)this.warningChannalType)) {
            timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(Long.valueOf(Long.parseLong(task.getId())));
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getWarningDate());
            timeOutModel.setTimeOutChanalType(this.warningChannalType);
            if (HussarUtils.isNotEmpty(users)) {
                stringJoiner = new StringJoiner(",");
                for (String user : users) {
                    stringJoiner.add(user);
                }
                timeOutModel.setAssignee(stringJoiner.toString());
            }
            timeOutModel.setTimeOutType(this.timeOutStrategy == null ? "unHandle" : this.timeOutStrategy);
            timeOutModel.setMessageType("2");
            timeOutModel.setMap(JSON.toJSONString(this.getExtendParam(task, appId)));
            list.add(timeOutModel);
        }
        return list;
    }

    public Map<String, Object> getExtendParam(TaskEntity task, Long appId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", task.getName());
        map.put("processInsId", task.getProcessInstanceId());
        map.put("processDefinitionId", task.getProcessDefinitionId());
        map.put("taskDefinitionKey", task.getTaskDefinitionKey());
        if (HussarUtils.isNotEmpty((Object)appId)) {
            HashMap<String, String> urlMap = new HashMap<String, String>();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/hussarAppFrame/?appId=").append(appId).append("#/form-detail/").append(task.getFormId()).append("?rowId=").append(task.getBusinessKey()).append("&processInstId=").append(task.getProcessInstanceId()).append("&taskId=").append(task.getId()).append("&tabType=2");
            String finalUrl = stringBuilder.toString();
            urlMap.put("web", finalUrl);
            urlMap.put("mobile", finalUrl);
            map.put("formKey", JSON.toJSONString(urlMap));
        } else {
            map.put("formKey", task.getFormKey());
        }
        map.put("businessId", task.getBusinessKey());
        map.put("processName", task.getProcessName());
        map.put("todoConfiguration", task.getTodoConfiguration());
        map.put("sendUser", task.getSendUser() == null ? BpmAttribute.getContextAttribute("sendUser") : task.getSendUser());
        Date dueDate = task.getDueDate();
        if (dueDate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            map.put("dueDate", format.format(dueDate));
        }
        return map;
    }

    static String getConfig(FlowElement element, String config) {
        List chosenDayElement = (List)element.getExtensionElements().get(config);
        if (HussarUtils.isNotEmpty((Object)chosenDayElement) && HussarUtils.isNotEmpty((Object)((ExtensionElement)chosenDayElement.get(0)).getAttributes())) {
            return ((ExtensionAttribute)((List)((ExtensionElement)chosenDayElement.get(0)).getAttributes().get(config)).get(0)).getValue();
        }
        return null;
    }

    public static Date getWarningDate(ActivityExecution execution, String warningDateConfig, Date dueDate) {
        Object warningDate;
        if (Context.getProcessEngineConfiguration() != null && execution != null) {
            Expression warningDateConfigExperssion = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(warningDateConfig);
            warningDate = warningDateConfigExperssion.getValue((VariableScope)execution);
        } else {
            warningDate = warningDateConfig;
        }
        if (warningDate != null) {
            if (warningDate instanceof Date) {
                return (Date)warningDate;
            }
            if (warningDate instanceof String) {
                String warningDateString = warningDate.toString();
                try {
                    if (warningDateString.startsWith("P")) {
                        return new DateTime((Object)dueDate).minus((ReadablePeriod)Period.parse((String)warningDateString)).toDate();
                    }
                    return DateTime.parse((String)warningDateString).toDate();
                }
                catch (Exception e) {
                    throw new ActivitiException("couldn't resolve duedate: " + e.getMessage(), (Throwable)e);
                }
            }
            throw new ActivitiIllegalArgumentException("Warning date expression does not resolve to a Date or Date string: " + warningDateConfig);
        }
        return null;
    }

    public String getChosenDay() {
        return this.chosenDay;
    }

    public void setChosenDay(String chosenDay) {
        this.chosenDay = chosenDay;
    }

    public String getTimeOutStrategy() {
        return this.timeOutStrategy;
    }

    public void setTimeOutStrategy(String timeOutStrategy) {
        this.timeOutStrategy = timeOutStrategy;
    }

    public String getTimeOutChannalType() {
        return this.timeOutChannalType;
    }

    public void setTimeOutChannalType(String timeOutChannalType) {
        this.timeOutChannalType = timeOutChannalType;
    }

    public String getWarningDate() {
        return this.warningDate;
    }

    public void setWarningDate(String warningDate) {
        this.warningDate = warningDate;
    }

    public String getWarningDateType() {
        return this.warningDateType;
    }

    public void setWarningDateType(String warningDateType) {
        this.warningDateType = warningDateType;
    }

    public String getWarningChannalType() {
        return this.warningChannalType;
    }

    public void setWarningChannalType(String warningChannalType) {
        this.warningChannalType = warningChannalType;
    }

    public List<TimeOutModel> buildTimeOutModel(ActivityExecution execution, List<String> receiverList, Date createDate, Date eventDueDate, Date warningDate, String map) {
        ActivityImpl activity;
        Object activityBehavior;
        StringJoiner stringJoiner;
        TimeOutModel timeOutModel;
        ArrayList<TimeOutModel> list = new ArrayList<TimeOutModel>();
        if (HussarUtils.isNotEmpty((Object)eventDueDate) && (HussarUtils.isNotEmpty((Object)this.timeOutStrategy) || HussarUtils.isNotEmpty((Object)this.timeOutChannalType))) {
            timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(Long.valueOf(execution.getId()));
            timeOutModel.setCreateTime(createDate);
            timeOutModel.setDueTime(eventDueDate);
            timeOutModel.setTimeOutChanalType(this.timeOutChannalType);
            if (HussarUtils.isNotEmpty(receiverList)) {
                stringJoiner = new StringJoiner(",");
                for (String user : receiverList) {
                    stringJoiner.add(user);
                }
                timeOutModel.setAssignee(stringJoiner.toString());
            }
            if ((activityBehavior = (activity = (ActivityImpl)execution.getActivity()).getActivityBehavior()) instanceof IntermediateCatchEventActivityBehavior) {
                if (this.timeOutStrategy == null || "unHandle".equals(this.timeOutStrategy)) {
                    timeOutModel.setTimeOutType(this.timeOutStrategy == null ? "unHandle" : this.timeOutStrategy);
                } else {
                    timeOutModel.setTimeOutType("event-" + this.timeOutStrategy);
                }
            } else {
                timeOutModel.setTimeOutType(this.timeOutStrategy == null ? "unHandle" : this.timeOutStrategy);
            }
            timeOutModel.setMessageType("3");
            timeOutModel.setMap(map);
            list.add(timeOutModel);
        }
        if (HussarUtils.isNotEmpty((Object)warningDate) && HussarUtils.isNotEmpty((Object)warningDate) && HussarUtils.isNotEmpty((Object)this.warningChannalType)) {
            timeOutModel = new TimeOutModel();
            timeOutModel.setTaskId(Long.valueOf(execution.getId()));
            timeOutModel.setCreateTime(createDate);
            timeOutModel.setDueTime(warningDate);
            timeOutModel.setTimeOutChanalType(this.warningChannalType);
            if (HussarUtils.isNotEmpty(receiverList)) {
                stringJoiner = new StringJoiner(",");
                activityBehavior = receiverList.iterator();
                while (activityBehavior.hasNext()) {
                    String user;
                    user = (String)activityBehavior.next();
                    stringJoiner.add(user);
                }
                timeOutModel.setAssignee(stringJoiner.toString());
            }
            if ((activityBehavior = (activity = (ActivityImpl)execution.getActivity()).getActivityBehavior()) instanceof IntermediateCatchEventActivityBehavior) {
                if (this.timeOutStrategy == null || "unHandle".equals(this.timeOutStrategy)) {
                    timeOutModel.setTimeOutType(this.timeOutStrategy == null ? "unHandle" : this.timeOutStrategy);
                } else {
                    timeOutModel.setTimeOutType("event-" + this.timeOutStrategy);
                }
            } else {
                timeOutModel.setTimeOutType(this.timeOutStrategy == null ? "unHandle" : this.timeOutStrategy);
            }
            timeOutModel.setMessageType("4");
            timeOutModel.setMap(map);
            list.add(timeOutModel);
        }
        return list;
    }
}

