/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl.AssigneeChooseServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowProcess;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.dao.SysActProcessFileMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.dao.TaskManagerMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.dto.FreeRejectDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.vo.ReceiverVo;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanager.vo.TaskVo;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.engine.constant.TaskType;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class TaskManagerServiceImpl
implements TaskManagerService {
    private static final Logger logger = LoggerFactory.getLogger(TaskManagerServiceImpl.class);
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskManagerMapper taskManagerMapper;
    @Resource
    private AssigneeChooseServiceImpl assigneeChooseService;
    @Resource
    private SysActProcessFileMapper sysActProcessFileMapper;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Resource
    private HistoryService historyService;
    @Autowired
    ITaskEngineService taskEngineService;
    @Autowired
    private IInstanceEngineService instanceEngineService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    public int count() {
        return this.taskManagerMapper.count(new Date());
    }

    /*
     * WARNING - void declaration
     */
    public List<TaskManager> getTask(Page<TaskManager> pages, GetTaskManagerDto taskManagerDto) {
        Map map;
        void var9_18;
        if (HussarUtils.isNotEmpty((Object)taskManagerDto.getProcessName())) {
            taskManagerDto.setProcessName(taskManagerDto.getProcessName().replace("%", "\\%").replace("_", "\\_"));
        }
        taskManagerDto.setDateTime(new Date());
        if (HussarUtils.isNotEmpty((Object)taskManagerDto.getEndTime())) {
            long endTime = taskManagerDto.getEndTime().getTime() + 999L;
            Date endTimeDate = new Date(endTime);
            taskManagerDto.setEndTime(endTimeDate);
        }
        List<TaskManager> list = this.taskManagerMapper.getTask(pages, taskManagerDto);
        List<Object> processList = new ArrayList();
        if (HussarUtils.isNotEmpty(list)) {
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            Object processInsIds = new ArrayList();
            for (TaskManager taskManager : list) {
                taskIdList.add(Long.valueOf(taskManager.getId()));
                processInsIds.add(Long.parseLong(taskManager.getProcessInsId()));
            }
            List<ReceiverVo> receivers = this.taskManagerMapper.getReceivers(taskIdList);
            for (TaskManager taskManager : list) {
                String taskId = taskManager.getId();
                if (HussarUtils.isEmpty((Object)taskId)) continue;
                ArrayList<ReceiverVo> receiverVoList = new ArrayList<ReceiverVo>();
                for (ReceiverVo receiverVo2 : receivers) {
                    if (!taskId.equals(receiverVo2.getTaskId())) continue;
                    receiverVoList.add(receiverVo2);
                }
                taskManager.setReceivers(receiverVoList);
            }
            processInsIds = new ArrayList<TaskManager>(new HashSet<TaskManager>((Collection<TaskManager>)processInsIds));
            processInsIds.remove(null);
            if (processInsIds.isEmpty()) {
                processInsIds = null;
            }
            processList = this.flowTaskMapper.getProcInstMsg((List<Long>)processInsIds);
        }
        HashMap<String, FlowProcess> processMap = new HashMap<String, FlowProcess>();
        for (FlowProcess flowProcess : processList) {
            processMap.put(flowProcess.getProcessInsId(), flowProcess);
        }
        for (TaskManager taskManager : list) {
            FlowProcess flowProcess = (FlowProcess)processMap.get(taskManager.getProcessInsId());
            if (HussarUtils.isEmpty((Object)taskManager.getProcessTitle())) {
                taskManager.setProcessTitle(flowProcess.getProcessTitle());
            }
            if (!HussarUtils.isEmpty((Object)taskManager.getStartUserId())) continue;
            taskManager.setStartUserId(flowProcess.getProcessStartUserId());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<Long> taskIds = new ArrayList<Long>();
        Date date = new Date();
        for (TaskManager taskManager : list) {
            try {
                Date startTimeStamp = sdf.parse(taskManager.getStartTime());
                long diff = date.getTime() - startTimeStamp.getTime();
                long days = diff / 86400000L;
                long hours = (diff - days * 86400000L) / 3600000L;
                long minutes = (diff - days * 86400000L - hours * 3600000L) / 60000L;
                long seconds = (diff - days * 86400000L - hours * 3600000L - minutes * 60000L) / 1000L;
                String dayStr = this.bpmConstantProperties.getDay();
                String hourStr = this.bpmConstantProperties.getHour();
                String minuteStr = this.bpmConstantProperties.getMinute();
                String secondStr = this.bpmConstantProperties.getSecond();
                String timesBetween = days + dayStr + hours + hourStr + minutes + minuteStr + seconds + secondStr;
                taskManager.setDuration(timesBetween);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            taskIds.add(Long.parseLong(taskManager.getId()));
        }
        ArrayList arrayList = new ArrayList();
        if (HussarUtils.isNotEmpty(list)) {
            List<Variables> list2 = this.flowTaskMapper.getAllToDoVariables(taskIds, null);
        }
        HashMap<String, Map> variableMap = new HashMap<String, Map>();
        for (Variables variables : var9_18) {
            if (!"todoConfiguration".equals(variables.getName())) continue;
            map = (Map)variableMap.get(variables.getTaskId());
            map = map == null ? new HashMap() : map;
            map.put(variables.getName(), variables.getTextValue());
            variableMap.put(variables.getTaskId(), map);
        }
        for (TaskManager taskManager : list) {
            map = (Map)variableMap.get(taskManager.getId());
            map = map == null ? new HashMap() : map;
            taskManager.setTodoConfiguration((String)map.get("todoConfiguration"));
        }
        ArrayList<String> users = new ArrayList<String>();
        for (TaskManager taskManager : list) {
            List<ReceiverVo> receiver = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)taskManager.getReceivers())) {
                receiver = taskManager.getReceivers();
            }
            if (HussarUtils.isNotEmpty((Object)taskManager.getFirstReceiver())) {
                ReceiverVo receiverVo3 = new ReceiverVo();
                receiverVo3.setUserId(taskManager.getFirstReceiver());
                receiver.add(receiverVo3);
            } else if (HussarUtils.isNotEmpty((Object)taskManager.getReceivers())) {
                taskManager.setFirstReceiver(((ReceiverVo)taskManager.getReceivers().get(0)).getUserId());
            }
            if (HussarUtils.isNotEmpty((Object)taskManager.getSendUser())) {
                users.add(taskManager.getSendUser());
            }
            receiver.forEach(receiverVo -> {
                users.add(receiverVo.getUserId());
                if (receiverVo.getMandator() != null) {
                    users.add(receiverVo.getMandator());
                }
            });
            if (!HussarUtils.isNotEmpty((Object)taskManager.getStartUserId())) continue;
            users.add(taskManager.getStartUserId());
        }
        HashSet userSet = new HashSet(users);
        userSet.remove(null);
        users.clear();
        users.addAll(userSet);
        Map<String, String> userMap = this.assigneeChooseService.getUserListByUserId(users);
        if (userMap == null) {
            userMap = new HashMap<String, String>();
        }
        for (TaskManager taskManager : list) {
            if (!HussarUtils.isNotEmpty((Object)taskManager.getReceivers())) continue;
            List receiver = taskManager.getReceivers();
            ArrayList<String> name = new ArrayList<String>();
            for (ReceiverVo receiverVo4 : receiver) {
                String userName = userMap.get(receiverVo4.getUserId());
                receiverVo4.setUserName(userName);
                if (receiverVo4.getMandator() != null && HussarUtils.isNotEmpty((Object)userMap.get(receiverVo4.getMandator()))) {
                    userName = userName + "(" + userMap.get(receiverVo4.getMandator()) + ")";
                    receiverVo4.setMandatorName(userMap.get(receiverVo4.getMandator()));
                }
                name.add(userName);
            }
            taskManager.setReceiverName(name);
            taskManager.setSendUserName(userMap.get(taskManager.getSendUser()));
            taskManager.setStartUserName(userMap.get(taskManager.getStartUserId()));
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(list, TaskManager.class).translate(TaskManager::getTaskNameTranslateKey, TaskManager::setNodeName).translate(TaskManager::getProcNameTranslateKey, TaskManager::setProcessName).execute();
        return list;
    }

    public ApiResponse<String> suspendTaskById(String processInsId) {
        try {
            this.instanceEngineService.suspendProcessInstanceById(processInsId);
            return ApiResponse.success((String)BpmExceptionCodeEnum.HANGUP_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new BpmException(e.getMessage());
        }
    }

    public ApiResponse<String> activateTaskById(String processInsId) {
        try {
            this.instanceEngineService.activateProcessInstanceById(processInsId);
            return ApiResponse.success((String)BpmExceptionCodeEnum.ACTIVE_SUCCESS.getMessage());
        }
        catch (Exception e) {
            throw new BpmException(e.getMessage());
        }
    }

    private Map<String, String> getFileByTaskId(String taskId, String processInsId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String processDefinitionId = "";
        String processInstanceId = "";
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).queryChildTask()).singleResult();
            if (historicTaskInstance == null) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_NOT_FOUND);
            }
            if (TaskType.isAssist((String)historicTaskInstance.getTaskType())) {
                throw new BpmException(BpmExceptionCodeEnum.ASSIST_TASK_WITH_ERROR_HANDLE);
            }
            processDefinitionId = historicTaskInstance.getProcessDefinitionId();
            processInstanceId = historicTaskInstance.getProcessInstanceId();
            map.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
        } else {
            processInstanceId = processInsId;
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (HussarUtils.isNotEmpty((Object)processInsId)) {
            processDefinitionId = historicProcessInstance.getProcessDefinitionId();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActProcessFile::getProcessId, (Object)processDefinitionId);
        queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
        SysActProcessFile sysActProcessFile = (SysActProcessFile)this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper).get(0);
        String file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
        map.put("main", file);
        if (historicProcessInstance.getSuperProcessInstanceId() != null) {
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(historicProcessInstance.getSuperProcessInstanceId()).callProcInstId(historicProcessInstance.getId()).listPage(0, 1).get(0);
            map.put("callTaskDefinitionKey", historicActivityInstance.getActivityId());
            String procDefId = historicActivityInstance.getProcessDefinitionId();
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysActProcessFile::getProcessId, (Object)procDefId);
            queryWrapper.eq(SysActProcessFile::getType, (Object)"wfd");
            sysActProcessFile = (SysActProcessFile)this.sysActProcessFileMapper.selectList((Wrapper)queryWrapper).get(0);
            file = sysActProcessFile == null ? null : new String(sysActProcessFile.getContent(), StandardCharsets.UTF_8);
            map.put("call", file);
        }
        return map;
    }

    public ApiResponse<IPage<TaskManager>> getTaskManager(Page<TaskManager> page, GetTaskManagerDto taskManagerDto) {
        List<TaskManager> list = this.getTask(page, taskManagerDto);
        page.setRecords(list);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<TaskVo>> getJumpTasks(String taskId, String processInsId) {
        FlowModel flowModel;
        Map<String, String> flowModelMessage = this.getFileByTaskId(taskId, processInsId);
        String taskDefinitionKey = flowModelMessage.get("taskDefinitionKey");
        String subProcessNodeId = null;
        ArrayList<Object> tasks = new ArrayList<Object>();
        if (flowModelMessage.get("main") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)flowModelMessage.get("main"), FlowModel.class);
            if (taskDefinitionKey != null) {
                FlowObject flowObject;
                Iterator iterator = flowModel.getSlots().getElement().iterator();
                while (iterator.hasNext() && !taskDefinitionKey.equals((flowObject = (FlowObject)iterator.next()).getId())) {
                    if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
                    for (FlowObject object : flowObject.getSlots().getElement()) {
                        if (!taskDefinitionKey.equals(object.getId())) continue;
                        subProcessNodeId = flowObject.getId();
                        break;
                    }
                    if (subProcessNodeId == null) continue;
                    break;
                }
            }
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                Object task;
                if (BpmNodeTypeUtil.isUserTask((String)flowObject.getName())) {
                    task = new TaskVo();
                    task.setId(flowObject.getId());
                    task.setValue(flowObject.getProps().getFlowName());
                    task.setType("User");
                    task.setNameTranslateKey(flowObject.getProps().getNodeNameTranslateId());
                    tasks.add(task);
                    continue;
                }
                if (BpmNodeTypeUtil.isCallActivity((String)flowObject.getName())) {
                    task = new TaskVo();
                    task.setId(flowObject.getId());
                    task.setValue(flowObject.getProps().getFlowName());
                    task.setType("CallActivity");
                    task.setNameTranslateKey(flowObject.getProps().getNodeNameTranslateId());
                    tasks.add(task);
                    continue;
                }
                if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
                if (subProcessNodeId != null && subProcessNodeId.equals(flowObject.getId())) {
                    for (FlowObject object : flowObject.getSlots().getElement()) {
                        TaskVo task2;
                        if (BpmNodeTypeUtil.isUserTask((String)object.getName())) {
                            task2 = new TaskVo();
                            task2.setId(object.getId());
                            task2.setValue(object.getProps().getFlowName());
                            task2.setType("User");
                            task2.setNameTranslateKey(flowObject.getProps().getNodeNameTranslateId());
                            tasks.add(task2);
                            continue;
                        }
                        if (!BpmNodeTypeUtil.isCallActivity((String)object.getName())) continue;
                        task2 = new TaskVo();
                        task2.setId(object.getId());
                        task2.setValue(object.getProps().getFlowName());
                        task2.setType("CallActivity");
                        task2.setNameTranslateKey(flowObject.getProps().getNodeNameTranslateId());
                        tasks.add(task2);
                    }
                    continue;
                }
                task = new TaskVo();
                task.setId(flowObject.getId());
                task.setValue(flowObject.getProps().getFlowName());
                task.setType("SubProcess");
                task.setNameTranslateKey(flowObject.getProps().getNodeNameTranslateId());
                tasks.add(task);
            }
        }
        if (HussarUtils.isEmpty((Object)processInsId) && flowModelMessage.get("call") != null) {
            flowModel = (FlowModel)JSON.parseObject((String)flowModelMessage.get("call"), FlowModel.class);
            String callTaskDefinitionKey = flowModelMessage.get("callTaskDefinitionKey");
            for (FlowObject flowObject : flowModel.getSlots().getElement()) {
                TaskVo task;
                if (BpmNodeTypeUtil.isUserTask((String)flowObject.getName())) {
                    task = new TaskVo();
                    task.setId("main_process_" + flowObject.getId());
                    task.setValue("\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                    task.setType("User");
                    task.setNameTranslateKey(flowObject.getProps().getNodeNameTranslateId());
                    tasks.add(task);
                    continue;
                }
                if (BpmNodeTypeUtil.isCallActivity((String)flowObject.getName())) {
                    if (callTaskDefinitionKey.equals(flowObject.getId())) continue;
                    task = new TaskVo();
                    task.setId("main_process_" + flowObject.getId());
                    task.setValue("\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                    task.setType("CallActivity");
                    task.setNameTranslateKey(flowObject.getProps().getNodeNameTranslateId());
                    tasks.add(task);
                    continue;
                }
                if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
                task = new TaskVo();
                task.setId("main_process_" + flowObject.getId());
                task.setValue("\u4e3b\u6d41\u7a0b" + flowObject.getProps().getFlowName());
                task.setType("SubProcess");
                task.setNameTranslateKey(flowObject.getProps().getNodeNameTranslateId());
                tasks.add(task);
            }
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(tasks, TaskVo.class).translate(TaskVo::getNameTranslateKey, TaskVo::setValue).execute();
        return ApiResponse.success(tasks);
    }

    public BpmResponseResult rejectToFirstTask(FreeRejectDto freeRejectDto) {
        String taskId = freeRejectDto.getTaskId();
        String userId = freeRejectDto.getUserId();
        String comment = freeRejectDto.getComment();
        boolean isSubmit = true;
        return this.taskEngineService.rejectToFirstTask(taskId, userId, comment, null, true, isSubmit, null, false);
    }

    public BpmResponseResult rejectToAnyTask(FreeRejectDto freeRejectDto) {
        String taskId = freeRejectDto.getTaskId();
        String userId = freeRejectDto.getUserId();
        String comment = freeRejectDto.getComment();
        boolean isSubmit = true;
        String backActivityId = freeRejectDto.getBackActivityId();
        return this.taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, null, null, isSubmit, null, false);
    }

    public BpmResponseResult rejectToLastTask(FreeRejectDto freeRejectDto) {
        String taskId = freeRejectDto.getTaskId();
        String userId = freeRejectDto.getUserId();
        String comment = freeRejectDto.getComment();
        boolean isSubmit = true;
        return this.taskEngineService.rejectToLastTask(taskId, userId, comment, null, true, isSubmit, null, null, false);
    }
}

